/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocalResidue;
import edu.jas.application.SolvableLocalResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalResidueSolvablePolynomialQLRTest
extends TestCase {
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> a;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> b;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> c;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> d;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> e;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> f;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> x1;
    QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational> x2;
    int rl = 4;
    int kl = 1;
    int ll = 4;
    int el = 3;
    float q = 0.2f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    QLRSolvablePolynomialRing<SolvableLocalResidue<BigRational>, BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> cring;
    SolvableLocalResidueRing<BigRational> qcring;
    SolvableIdeal<BigRational> sideal;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LocalResidueSolvablePolynomialQLRTest.suite());
        ComputerThreads.terminate();
    }

    public LocalResidueSolvablePolynomialQLRTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(LocalResidueSolvablePolynomialQLRTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        this.cring.addRelations(weylRelations);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalResidueRing<BigRational>(this.sideal);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.tord, this.vars);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        LocalResidueSolvablePolynomialQLRTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational>(this.ring);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            LocalResidueSolvablePolynomialQLRTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative: ", (boolean)this.ring.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.ring.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            LocalResidueSolvablePolynomialQLRTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            LocalResidueSolvablePolynomialQLRTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            LocalResidueSolvablePolynomialQLRTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl + 1, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocalResidue<BigRational>)((Object)this.a));
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.c = (QLRSolvablePolynomial)this.b.subtract((SolvableLocalResidue<BigRational>)((Object)this.a));
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.b));
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.c.subtract((SolvableLocalResidue<BigRational>)((Object)this.b));
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.b.sum((SolvableLocalResidue<BigRational>)((Object)this.c))));
        this.e = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.b)).sum(this.c);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.qcring.random(this.kl);
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)element, expVector);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocalResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableLocalResidue<BigRational>)element, expVector);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocalResidue<BigRational>)element, expVector);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocalResidue<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableLocalResidue<BigRational>)element, expVector);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.b = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.b.multiply((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b));
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b.multiply((SolvableLocalResidue<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b)).multiply(this.c);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MonoidElem monoidElem = ((SolvableLocalResidue)this.a.leadingBaseCoefficient()).inverse();
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)monoidElem);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((SolvableLocalResidue)this.d.leadingBaseCoefficient()).isONE());
        this.d = (QLRSolvablePolynomial)this.a.monic();
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a.monic(): ", (boolean)((SolvableLocalResidue)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testCommutative() {
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalResidueRing<BigRational>(this.sideal);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.ring);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b));
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"b*a == a*b: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)((QLRSolvablePolynomial)this.b.sum((SolvableLocalResidue<BigRational>)((Object)this.c)))));
        this.e = (QLRSolvablePolynomial)this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b)).sum(this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.c)));
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a*(b+c) = a*b+a*c", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(genSolvablePolynomialRing, arrayList);
        SolvableLocalResidueRing<BigRational> solvableLocalResidueRing = new SolvableLocalResidueRing<BigRational>(this.sideal);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)solvableLocalResidueRing.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)solvableLocalResidueRing.isAssociative());
        this.ring = new QLRSolvablePolynomialRing(solvableLocalResidueRing, this.ring);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        LocalResidueSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.polCoeff.parse("x");
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.polCoeff.parse("b x + a");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial2.leadingExpVector(), genSolvablePolynomial2);
        LocalResidueSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial3 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial3;
            this.a = new QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial4 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial4;
                this.b = new QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b));
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.parse("x^2 + a b");
        this.b = this.ring.parse("a b + a");
        this.b = (QLRSolvablePolynomial)this.b.inverse();
        this.c = this.b.multiply((SolvableLocalResidue<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocalResidue<BigRational>)((Object)this.b));
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = (QLRSolvablePolynomial)this.b.inverse();
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"b*b^-1 == 1", (boolean)this.e.multiply((SolvableLocalResidue<BigRational>)((Object)this.b)).isONE());
        this.c = this.e.multiply((SolvableLocalResidue<BigRational>)((Object)this.c));
        this.d = this.d.multiply((SolvableLocalResidue<BigRational>)((Object)this.e));
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a == b * 1/b * a", (boolean)this.a.equals(this.c));
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"a == a * 1/b * b", (boolean)this.a.equals(this.d));
    }

    public void testExtendContractWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.cring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational>)genSolvablePolynomial2));
        int n = this.rl;
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.extend(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((QLRSolvablePolynomialRing)genSolvablePolynomialRing).contract(n);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"ring == pfec", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)genSolvablePolynomial3.extend(genSolvablePolynomialRing, 0, 0L);
        Map map = qLRSolvablePolynomial.contract(genSolvablePolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenPolynomial genPolynomial2 = (GenPolynomial)arrayList.get(0);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a == aec", (Object)genSolvablePolynomial3, (Object)genPolynomial2);
    }

    public void testReverseWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.cring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((QLRSolvablePolynomial<SolvableLocalResidue<BigRational>, BigRational>)genSolvablePolynomial2));
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.reverse();
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((QLRSolvablePolynomialRing)genSolvablePolynomialRing).reverse();
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"pf == pfrr", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)genSolvablePolynomial3.reverse(genSolvablePolynomialRing);
        QLRSolvablePolynomial qLRSolvablePolynomial2 = (QLRSolvablePolynomial)qLRSolvablePolynomial.reverse(genSolvablePolynomialRing2);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"a == arr", (Object)genSolvablePolynomial3, (Object)qLRSolvablePolynomial2);
    }

    public void testRecursiveWeyl() {
        GenPolynomialRing genPolynomialRing = this.ring.recursive(2);
        GenSolvablePolynomial genSolvablePolynomial = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenSolvablePolynomial> genSolvablePolynomial3 = genSolvablePolynomial.multiply(genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial3);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.distribute(this.ring, recSolvablePolynomial3);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial4, genSolvablePolynomial3);
    }

    public void testRecursiveIteratedWeyl() {
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, stringArray);
        WeylRelationsIterated<BigRational> weylRelationsIterated = new WeylRelationsIterated<BigRational>();
        weylRelationsIterated.generate(genSolvablePolynomialRing);
        LocalResidueSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        LocalResidueSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(2);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, recSolvablePolynomial3);
        LocalResidueSolvablePolynomialQLRTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial2, genSolvablePolynomial);
    }
}

