/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RingFactoryTokenizer;
import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RingFactoryTokenizerTest
extends TestCase {
    RingFactory fac;
    GenPolynomialRing pfac;
    GenSolvablePolynomialRing spfac;
    RingFactoryTokenizer parser;
    Reader source;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RingFactoryTokenizerTest.suite());
    }

    public RingFactoryTokenizerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RingFactoryTokenizerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    protected void tearDown() {
        this.fac = null;
        this.pfac = null;
        this.parser = null;
        this.source = null;
    }

    public void testBigRational() {
        String string = "Rat(x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testBigInteger() {
        String string = "Int(x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigInteger bigInteger = new BigInteger(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigInteger>(bigInteger, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testModInteger() {
        String string = "Mod 19 (x,y,z) L ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        ModIntRing modIntRing = new ModIntRing(19);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<ModInt>(modIntRing, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
        ModLongRing modLongRing = new ModLongRing(19L);
        RingFactoryTokenizerTest.assertFalse((String)"fac != lfac", (boolean)modIntRing.equals(modLongRing));
        RingFactoryTokenizerTest.assertFalse((String)"lfac != f.coFac", (boolean)modLongRing.equals(genPolynomialRing.coFac));
    }

    public void testBigComplex() {
        String string = "Complex(x,y,z) L ( ( 1i0 ), ( 0i0 ), ( 3/4i2 - 6/8i2 ), ( 1i0 x + x^3 + 1i3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigComplex bigComplex = new BigComplex(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigComplex>(bigComplex, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testBigDecimal() {
        String string = "D(x,y,z) L ( ( 1 ), ( 0 ), ( 0.25 * 0.25 - 0.25^2 ), ( 1 x + x^3 + 0.3333333333333333333333 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigDecimal bigDecimal = new BigDecimal(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigDecimal>(bigDecimal, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testBigQuaternion() {
        String string = "Quat(x,y,z) L ( ( 1i0j0k0 ), ( 0i0j0k0 ), ( 3/4i2j1k3 - 6/8i2j1k3 ), ( 1 x + x^3 + 1i2j3k4 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigQuaternion>(bigQuaternionRing, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testRationalFunction() {
        String string = "RatFunc(x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigInteger bigInteger = new BigInteger(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigInteger>(bigInteger, n, termOrder, stringArray);
        QuotientRing quotientRing = new QuotientRing(this.pfac);
        RingFactoryTokenizerTest.assertEquals((String)"qfac == f.coFac", quotientRing, genPolynomialRing.coFac);
    }

    public void testIntegralFunction() {
        String string = "IntFunc(x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f.coFac", (Object)this.pfac, genPolynomialRing.coFac);
    }

    public void testModularFunction() {
        String string = "ModFunc 32003 (x,y,z) L ( ( 1 ), ( 0 ), ( 3/4 - 6/8 ), ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        ModIntegerRing modIntegerRing = new ModIntegerRing(32003L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<ModInteger>(modIntegerRing, n, termOrder, stringArray);
        QuotientRing quotientRing = new QuotientRing(this.pfac);
        RingFactoryTokenizerTest.assertEquals((String)"qfac == f.coFac", quotientRing, genPolynomialRing.coFac);
    }

    public void testSolvableBigRational() {
        String string = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) (  ( 1 ),  ( 0 ),  ( 3/4 - 6/8 ),  ( 1 x + x^3 + 1/3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenSolvablePolynomialRing genSolvablePolynomialRing = null;
        try {
            genSolvablePolynomialRing = this.parser.nextSolvablePolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        RingFactoryTokenizerTest.assertEquals((String)"spfac == f", (Object)this.spfac, (Object)genSolvablePolynomialRing);
    }

    public void testSolvableModInteger() {
        String string = "Mod 19 (x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) ( ( 1 ), ( 0 ), ( 3 2 - 6 + 19 ), ( 1 x + x^3 + 3 y z - x^3 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenSolvablePolynomialRing genSolvablePolynomialRing = null;
        try {
            genSolvablePolynomialRing = this.parser.nextSolvablePolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        ModIntRing modIntRing = new ModIntRing(19);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<ModInt>(modIntRing, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        RingFactoryTokenizerTest.assertEquals((String)"spfac == f", (Object)this.spfac, (Object)genSolvablePolynomialRing);
    }

    public void testBigIntegerModule() {
        String string = "Int(x,y,z) L (  (   ( 1 ),   ( 0 ),   ( 3 2 - 6 ),   ( 1 x + x^3 + 3 y z - x^3 )  ),  ( ( 1 ), ( 0 ) ) )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextSubModuleRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigInteger bigInteger = new BigInteger(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigInteger>(bigInteger, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == m.ring", (Object)this.pfac, (Object)genPolynomialRing);
    }

    public void testBigRationalSolvableModule() {
        String string = "Rat(x,y,z) L RelationTable (  ( z ), ( y ), ( y z - 1 ) ) (  (   ( 1 ),   ( 0 ),   ( 3/4 - 6/8 ),   ( 1 x + x^3 + 1/3 y z - x^3 )  ),  ( ( x ), ( 1 ), ( 0 ) )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenSolvablePolynomialRing genSolvablePolynomialRing = null;
        try {
            genSolvablePolynomialRing = this.parser.nextSolvableSubModuleRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.spfac = new GenSolvablePolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(this.spfac.parse("z"));
        arrayList.add(this.spfac.parse("y"));
        arrayList.add(this.spfac.parse("y z - 1"));
        this.spfac.addSolvRelations(arrayList);
        RingFactoryTokenizerTest.assertEquals((String)"spfac == m.ring", (Object)this.spfac, (Object)genSolvablePolynomialRing);
    }

    public void testBigRationalGeneric() {
        String string = "Rat(x,y,z) L ( ( 1^3 ), ( 0^3 ), ( { 3/4 }^2 - 6/8^2 ), ( { 1 }^2 x + x^3 + 1/3 y z - x^3 ), ( 1.0001 - 0.0001 + { 0.25 }**2 - 1/4^2 )  )";
        this.source = new StringReader(string);
        this.parser = new RingFactoryTokenizer(this.source);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = this.parser.nextPolynomialRing();
        }
        catch (IOException iOException) {
            RingFactoryTokenizerTest.fail((String)("" + iOException));
        }
        catch (ClassCastException classCastException) {
            RingFactoryTokenizerTest.fail((String)("" + classCastException));
        }
        BigRational bigRational = new BigRational(0L);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"x", "y", "z"};
        int n = stringArray.length;
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, n, termOrder, stringArray);
        RingFactoryTokenizerTest.assertEquals((String)"pfac == f", (Object)this.pfac, (Object)genPolynomialRing);
    }
}

