/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.AlgebraicRootsPrimElem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.PrimitiveElement;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.AlgebraicRoots;
import edu.jas.root.RealRootTuple;
import edu.jas.root.RootFactory;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class RootFactoryApp {
    private static final Logger logger = LogManager.getLogger(RootFactoryApp.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> boolean isRootRealCoeff(GenPolynomial<C> genPolynomial, Complex<RealAlgebraicNumber<C>> complex) {
        RingFactory ringFactory = genPolynomial.ring.coFac;
        ComplexRing complexRing = new ComplexRing(ringFactory);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing, genPolynomial);
        return RootFactoryApp.isRoot(genPolynomial2, complex);
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> genPolynomial, Complex<RealAlgebraicNumber<C>> complex) {
        GenPolynomialRing genPolynomialRing;
        GenPolynomial genPolynomial2;
        ElemFactory elemFactory = complex.factory();
        Complex<RealAlgebraicNumber<C>> complex2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2 = PolyUtilApp.convertToComplexRealCoefficients(genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory()), genPolynomial), complex);
        boolean bl = complex2.isZERO();
        if (!bl) {
            logger.info("f(r) = {}, f = {}, r  = {}", complex2, genPolynomial, complex);
            return bl;
        }
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> genPolynomial, List<Complex<RealAlgebraicNumber<C>>> list) {
        for (Complex<RealAlgebraicNumber<C>> complex : list) {
            boolean bl = RootFactoryApp.isRoot(genPolynomial, complex);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial) {
        ElemFactory elemFactory = genPolynomial.factory();
        if (((GenPolynomialRing)elemFactory).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing complexRing = (ComplexRing)((GenPolynomialRing)elemFactory).coFac;
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(complexRing);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial.monic());
        ArrayList<Complex<RealAlgebraicNumber<C>>> arrayList = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            if (genPolynomial2.isConstant() || genPolynomial2.isZERO()) continue;
            List<Complex<RealAlgebraicNumber<C>>> list = RootFactoryApp.complexAlgebraicNumbersSquarefree(genPolynomial2);
            long l = (Long)entry.getValue();
            for (long i = 0L; i < l; ++i) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersSquarefree(GenPolynomial<Complex<C>> genPolynomial) {
        ElemFactory elemFactory = genPolynomial.factory();
        if (((GenPolynomialRing)elemFactory).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing complexRing = (ComplexRing)((GenPolynomialRing)elemFactory).coFac;
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, 2, termOrder);
        GenPolynomial genPolynomial2 = genPolynomialRing.univariate(1, 1L).sum(genPolynomialRing.univariate(0, 1L).multiply(complexRing.getIMAG()));
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(complexRing.ring, genPolynomialRing);
        ArrayList<Complex<RealAlgebraicNumber<C>>> arrayList = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        GenPolynomial<Complex<C>> genPolynomial3 = genPolynomial;
        if (genPolynomial3.isConstant() || genPolynomial3.isZERO()) {
            return arrayList;
        }
        GenPolynomial genPolynomial4 = PolyUtil.substituteUnivariate(genPolynomial3, genPolynomial2);
        genPolynomial4 = genPolynomial4.monic();
        GenPolynomial genPolynomial5 = PolyUtil.realPartFromComplex(genPolynomialRing2, genPolynomial4);
        GenPolynomial genPolynomial6 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing2, genPolynomial4);
        if (debug) {
            logger.debug("rfac = {}", new Supplier[]{() -> genPolynomialRing2.toScript()});
            logger.debug("t  = {}, re = {}, im = {}", genPolynomial2, (Object)genPolynomial5.toScript(), (Object)genPolynomial6.toScript());
        }
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(genPolynomial5);
        arrayList2.add(genPolynomial6);
        Ideal ideal = new Ideal(genPolynomialRing2, arrayList2);
        List list = ideal.zeroDimRootDecomposition();
        for (IdealWithUniv idealWithUniv : list) {
            IdealWithRealAlgebraicRoots idealWithRealAlgebraicRoots = PolyUtilApp.realAlgebraicRoots(idealWithUniv);
            for (List list2 : idealWithRealAlgebraicRoots.ran) {
                RealRootTuple realRootTuple = new RealRootTuple(list2);
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(idealWithUniv, realRootTuple);
                List list3 = realAlgebraicRing.generators();
                int n = list3.size();
                RealAlgebraicNumber realAlgebraicNumber = list3.get(n - 2);
                RealAlgebraicNumber realAlgebraicNumber2 = list3.get(n - 1);
                ComplexRing complexRing2 = new ComplexRing(realAlgebraicRing);
                Complex complex = new Complex(complexRing2, realAlgebraicNumber, realAlgebraicNumber2);
                arrayList.add(complex);
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRootsPrimElem<C> rootReduce(AlgebraicRoots<C> algebraicRoots, AlgebraicRoots<C> algebraicRoots2) {
        return RootFactoryApp.rootReduce(algebraicRoots.getAlgebraicRing(), algebraicRoots2.getAlgebraicRing());
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRootsPrimElem<C> rootReduce(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        AlgebraicNumberRing<C> algebraicNumberRing = new AlgebraicNumberRing<C>(genPolynomial);
        AlgebraicNumberRing<C> algebraicNumberRing2 = new AlgebraicNumberRing<C>(genPolynomial2);
        return RootFactoryApp.rootReduce(algebraicNumberRing, algebraicNumberRing2);
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRootsPrimElem<C> rootReduce(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumberRing<C> algebraicNumberRing2) {
        PrimitiveElement<C> primitiveElement = PolyUtilApp.primitiveElement(algebraicNumberRing, algebraicNumberRing2);
        AlgebraicRoots algebraicRoots = RootFactory.algebraicRoots(primitiveElement.primitiveElem.modul);
        return new AlgebraicRootsPrimElem(algebraicRoots, primitiveElement);
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRootsPrimElem<C> rootsOfUnity(AlgebraicRootsPrimElem<C> algebraicRootsPrimElem) {
        long l;
        AlgebraicRoots<C> algebraicRoots = RootFactory.rootsOfUnity(algebraicRootsPrimElem);
        if (algebraicRootsPrimElem.pelem == null) {
            return new AlgebraicRootsPrimElem<C>(algebraicRoots, algebraicRootsPrimElem.pelem);
        }
        ArrayList arrayList = new ArrayList();
        long l2 = algebraicRootsPrimElem.pelem.primitiveElem.modul.degree();
        AlgebraicNumber algebraicNumber = algebraicRootsPrimElem.pelem.A;
        MonoidElem monoidElem = algebraicNumber.ring.getONE();
        for (l = 1L; l <= l2; ++l) {
            if (!((AlgebraicNumber)(monoidElem = ((AlgebraicNumber)monoidElem).multiply(algebraicNumber))).isRootOfUnity() || arrayList.contains(monoidElem)) continue;
            arrayList.add(monoidElem);
        }
        algebraicNumber = algebraicRootsPrimElem.pelem.B;
        monoidElem = algebraicNumber.ring.getONE();
        for (l = 1L; l <= l2; ++l) {
            if (!((AlgebraicNumber)(monoidElem = ((AlgebraicNumber)monoidElem).multiply(algebraicNumber))).isRootOfUnity() || arrayList.contains(monoidElem)) continue;
            arrayList.add(monoidElem);
        }
        return new AlgebraicRootsPrimElem<C>(algebraicRoots, algebraicRootsPrimElem.pelem, arrayList);
    }
}

