/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.GBAlgorithmBuilder;
import edu.jas.application.RingFactoryTokenizer;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseDistributedEC;
import edu.jas.gb.GroebnerBaseDistributedHybridEC;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.ReductionPar;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.util.CatReader;
import edu.jas.util.ExecutableServer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RunGB {
    static boolean doCheck = false;

    public static void main(String[] stringArray) {
        Object object;
        String string;
        int n;
        int n2;
        String[] stringArray2 = new String[]{"seq", "seq+", "par", "par+", "build=", "disthyb", "disthyb+", "cli"};
        String string2 = "Usage: RunGB [ " + RunGB.join(stringArray2, " | ") + "[port] ] <file> #procs/#threadsPerNode [machinefile] [check] ";
        if (stringArray.length < 1) {
            System.out.println("args: " + Arrays.toString(stringArray));
            System.out.println(string2);
            return;
        }
        boolean bl = false;
        String string3 = stringArray[0];
        boolean bl2 = false;
        int n3 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = RunGB.indexOf(stringArray2, stringArray[i]);
            if (n2 < 0) continue;
            bl2 = true;
            n3 = i;
            string3 = stringArray[n3];
            break;
        }
        if (!bl2) {
            System.out.println("args(sup): " + Arrays.toString(stringArray));
            System.out.println(string2);
            return;
        }
        if (string3.indexOf("+") >= 0) {
            bl = true;
        }
        System.out.println("kind: " + string3 + ", k = " + n3);
        n2 = 7114;
        if (string3.equals("cli")) {
            if (stringArray.length - n3 >= 2) {
                try {
                    n2 = Integer.parseInt(stringArray[n3 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    System.out.println("args(port): " + Arrays.toString(stringArray));
                    System.out.println(string2);
                    return;
                }
            }
            RunGB.runClient(n2);
            return;
        }
        String string4 = null;
        if (!string3.equals("cli")) {
            if (stringArray.length - n3 < 2) {
                System.out.println("args(file): " + Arrays.toString(stringArray));
                System.out.println(string2);
                return;
            }
            string4 = stringArray[n3 + 1];
        }
        if ((n = RunGB.indexOf(stringArray, "check")) >= 0) {
            doCheck = true;
        }
        int n4 = 0;
        int n5 = 1;
        if (string3.startsWith("par") || string3.startsWith("dist")) {
            if (stringArray.length - n3 < 3) {
                System.out.println("args(par|dist): " + Arrays.toString(stringArray));
                System.out.println(string2);
                return;
            }
            string = stringArray[n3 + 2];
            object = string;
            int n6 = string.indexOf("/");
            if (n6 >= 0) {
                object = string.substring(0, n6).trim();
                string = string.substring(n6 + 1).trim();
                try {
                    n5 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    System.out.println("args(threadsPerNode): " + Arrays.toString(stringArray));
                    System.out.println(string2);
                    return;
                }
            }
            try {
                n4 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                System.out.println("args(threads): " + Arrays.toString(stringArray));
                System.out.println(string2);
                return;
            }
        }
        string = null;
        if (string3.startsWith("dist")) {
            string = stringArray.length - n3 >= 4 ? stringArray[n3 + 3] : "machines";
        }
        if ((object = RunGB.getReader(string4)) == null) {
            System.out.println("args(file): " + string4);
            System.out.println("args(file): examples.jar(" + string4 + ")");
            System.out.println("args(file): " + Arrays.toString(stringArray));
            System.out.println(string2);
            return;
        }
        RingFactoryTokenizer ringFactoryTokenizer = new RingFactoryTokenizer((Reader)object);
        GenPolynomialRing genPolynomialRing = null;
        try {
            genPolynomialRing = ringFactoryTokenizer.nextPolynomialRing();
            ringFactoryTokenizer = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("pfac: " + genPolynomialRing.toScript());
        CatReader catReader = new CatReader(new StringReader("("), (Reader)object);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(genPolynomialRing, catReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = new PolynomialList(genPolynomialRing, genPolynomialTokenizer.nextPolynomialList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("input S =\n" + polynomialList);
        GroebnerBaseAbstract groebnerBaseAbstract = null;
        if (string3.startsWith("build") && (groebnerBaseAbstract = RunGB.getGBalgo(stringArray, string3, polynomialList.ring)) == null) {
            System.out.println(string2);
            return;
        }
        if (string3.startsWith("seq")) {
            RunGB.runSequential(polynomialList, bl);
        } else if (string3.startsWith("par")) {
            RunGB.runParallel(polynomialList, n4, bl);
        } else if (string3.startsWith("disthyb")) {
            RunGB.runMasterHyb(polynomialList, n4, n5, string, n2, bl);
        } else if (string3.startsWith("build")) {
            RunGB.runGB(polynomialList, groebnerBaseAbstract);
        }
        ComputerThreads.terminate();
        try {
            ((Reader)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void runMaster(PolynomialList polynomialList, int n, String string, int n2, boolean bl) {
        List list = polynomialList.list;
        List list2 = null;
        GroebnerBaseDistributedEC groebnerBaseDistributedEC = null;
        GroebnerBaseDistributedEC groebnerBaseDistributedEC2 = null;
        System.out.println("\nGroebner base distributed (" + n + ", " + string + ", " + n2 + ") ...");
        long l = System.currentTimeMillis();
        if (bl) {
            groebnerBaseDistributedEC2 = new GroebnerBaseDistributedEC(string, n, new OrderedSyzPairlist(), n2);
        } else {
            groebnerBaseDistributedEC = new GroebnerBaseDistributedEC(string, n, n2);
        }
        long l2 = System.currentTimeMillis();
        list2 = bl ? groebnerBaseDistributedEC2.GB(list) : groebnerBaseDistributedEC.GB(list);
        l2 = System.currentTimeMillis() - l2;
        if (bl) {
            groebnerBaseDistributedEC2.terminate();
        } else {
            groebnerBaseDistributedEC.terminate();
        }
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        l = System.currentTimeMillis() - l;
        if (bl) {
            System.out.print("d+ ");
        } else {
            System.out.print("d ");
        }
        System.out.println("= " + n + ", time = " + l2 + " milliseconds, " + (l - l2) + " start-up , total = " + l);
        RunGB.checkGB(polynomialList);
        System.out.println("");
    }

    static void runMasterHyb(PolynomialList polynomialList, int n, int n2, String string, int n3, boolean bl) {
        List list = polynomialList.list;
        List list2 = null;
        GroebnerBaseDistributedHybridEC groebnerBaseDistributedHybridEC = null;
        GroebnerBaseDistributedHybridEC groebnerBaseDistributedHybridEC2 = null;
        System.out.println("\nGroebner base distributed hybrid (" + n + "/" + n2 + ", " + string + ", " + n3 + ") ...");
        long l = System.currentTimeMillis();
        if (bl) {
            groebnerBaseDistributedHybridEC2 = new GroebnerBaseDistributedHybridEC(string, n, n2, new OrderedSyzPairlist(), n3);
        } else {
            groebnerBaseDistributedHybridEC = new GroebnerBaseDistributedHybridEC(string, n, n2, n3);
        }
        long l2 = System.currentTimeMillis();
        list2 = bl ? groebnerBaseDistributedHybridEC2.GB(list) : groebnerBaseDistributedHybridEC.GB(list);
        l2 = System.currentTimeMillis() - l2;
        if (bl) {
            groebnerBaseDistributedHybridEC2.terminate();
        } else {
            groebnerBaseDistributedHybridEC.terminate();
        }
        l = System.currentTimeMillis() - l;
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        if (bl) {
            System.out.print("d+ ");
        } else {
            System.out.print("d ");
        }
        System.out.println("= " + n + ", ppn = " + n2 + ", time = " + l2 + " milliseconds, " + (l - l2) + " start-up , total = " + l);
        RunGB.checkGB(polynomialList);
        System.out.println("");
    }

    static void runClient(int n) {
        System.out.println("\nGroebner base distributed client (" + n + ") ...");
        ExecutableServer executableServer = new ExecutableServer(n);
        executableServer.init();
        try {
            executableServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("runClient() done: " + executableServer);
    }

    static void runParallel(PolynomialList polynomialList, int n, boolean bl) {
        List list = polynomialList.list;
        GroebnerBaseAbstract groebnerBaseAbstract = null;
        GroebnerBaseParallel groebnerBaseParallel = null;
        if (bl) {
            groebnerBaseParallel = new GroebnerBaseParallel(n, new ReductionPar(), new OrderedSyzPairlist());
        } else {
            groebnerBaseAbstract = polynomialList.ring.coFac.isField() ? new GroebnerBaseParallel(n) : new GroebnerBasePseudoParallel(n, polynomialList.ring.coFac);
        }
        System.out.println("\nGroebner base parallel (" + n + ") ...");
        long l = System.currentTimeMillis();
        List list2 = bl ? groebnerBaseParallel.GB(list) : groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        if (bl) {
            System.out.print("p+ ");
        } else {
            System.out.print("p ");
        }
        System.out.println("= " + n + ", time = " + l + " milliseconds");
        if (bl) {
            ((GroebnerBaseAbstract)groebnerBaseParallel).terminate();
        } else {
            groebnerBaseAbstract.terminate();
        }
        RunGB.checkGB(polynomialList);
        System.out.println("");
    }

    static void runSequential(PolynomialList polynomialList, boolean bl) {
        List list = polynomialList.list;
        GroebnerBaseAbstract groebnerBaseAbstract = null;
        groebnerBaseAbstract = bl ? new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist()) : GBFactory.getImplementation(polynomialList.ring.coFac);
        System.out.println("\nGroebner base sequential ...");
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        if (bl) {
            System.out.print("seq+, ");
        } else {
            System.out.print("seq, ");
        }
        System.out.println("time = " + l + " milliseconds");
        RunGB.checkGB(polynomialList);
        System.out.println("");
    }

    static void runGB(PolynomialList polynomialList, GroebnerBaseAbstract groebnerBaseAbstract) {
        List list = polynomialList.list;
        if (groebnerBaseAbstract == null) {
            groebnerBaseAbstract = GBFactory.getImplementation(polynomialList.ring.coFac);
        }
        String string = groebnerBaseAbstract.toString().replaceAll(" ", "");
        System.out.println("\nGroebner base build=" + string + " ...");
        long l = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(list);
        l = System.currentTimeMillis() - l;
        polynomialList = new PolynomialList(polynomialList.ring, list2);
        string = groebnerBaseAbstract.toString().replaceAll(" ", "");
        System.out.println("G =\n" + polynomialList);
        System.out.println("G.size() = " + list2.size());
        System.out.print("build=" + string + ", ");
        System.out.println("time = " + l + " milliseconds");
        RunGB.checkGB(polynomialList);
        groebnerBaseAbstract.terminate();
        System.out.println("");
    }

    static void checkGB(PolynomialList polynomialList) {
        if (!doCheck) {
            return;
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(polynomialList.ring.coFac);
        long l = System.currentTimeMillis();
        boolean bl = groebnerBaseAbstract.isGB(polynomialList.list, false);
        l = System.currentTimeMillis() - l;
        System.out.println("check isGB = " + bl + " in " + l + " milliseconds");
    }

    static int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    static Reader getReader(String string) {
        Reader reader = null;
        FileNotFoundException fileNotFoundException = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(string), Charset.forName("UTF8"));
            reader = new BufferedReader(reader);
        }
        catch (FileNotFoundException fileNotFoundException2) {
            fileNotFoundException = fileNotFoundException2;
        }
        if (reader != null) {
            return reader;
        }
        String string2 = "examples.jar";
        try {
            JarFile jarFile = new JarFile(string2);
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                jarFile.close();
                fileNotFoundException.printStackTrace();
                return reader;
            }
            reader = new InputStreamReader(jarFile.getInputStream(jarEntry), Charset.forName("UTF8"));
            reader = new BufferedReader(reader);
        }
        catch (FileNotFoundException fileNotFoundException3) {
            fileNotFoundException.printStackTrace();
            fileNotFoundException3.printStackTrace();
        }
        catch (IOException iOException) {
            fileNotFoundException.printStackTrace();
            iOException.printStackTrace();
        }
        return reader;
    }

    static GroebnerBaseAbstract getGBalgo(String[] stringArray, String string, GenPolynomialRing genPolynomialRing) {
        GroebnerBaseAbstract groebnerBaseAbstract = null;
        int n = string.indexOf("=");
        if (n < 0) {
            System.out.println("args(build): " + Arrays.toString(stringArray));
            return groebnerBaseAbstract;
        }
        String string2 = string.substring(++n);
        GBAlgorithmBuilder gBAlgorithmBuilder = GBAlgorithmBuilder.polynomialRing(genPolynomialRing);
        while (!string2.isEmpty()) {
            String string3;
            int n2 = string2.indexOf(".");
            if (n2 >= 0) {
                string3 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            } else {
                string3 = string2;
                string2 = "";
            }
            if (string3.startsWith("build")) continue;
            String string4 = "";
            int n3 = string3.indexOf("()");
            if (n3 >= 0) {
                string3 = string3.substring(0, n3);
            } else {
                n3 = string3.indexOf("(");
                if (n3 >= 0) {
                    string4 = string3.substring(n3 + 1);
                    string3 = string3.substring(0, n3);
                    n3 = string4.indexOf(")");
                    string4 = string4.substring(0, n3);
                }
            }
            try {
                Method method;
                if (string4.isEmpty()) {
                    method = gBAlgorithmBuilder.getClass().getMethod(string3, null);
                    gBAlgorithmBuilder = (GBAlgorithmBuilder)method.invoke(gBAlgorithmBuilder, (Object[])null);
                    continue;
                }
                int n4 = Integer.parseInt(string4);
                method = gBAlgorithmBuilder.getClass().getMethod(string3, Integer.TYPE);
                gBAlgorithmBuilder = (GBAlgorithmBuilder)method.invoke((Object)gBAlgorithmBuilder, n4);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("args(build,method): " + Arrays.toString(stringArray));
                return groebnerBaseAbstract;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("args(build,access): " + Arrays.toString(stringArray));
                return groebnerBaseAbstract;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("args(build,invocation): " + Arrays.toString(stringArray));
                return groebnerBaseAbstract;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("args(build,number): " + Arrays.toString(stringArray));
                return groebnerBaseAbstract;
            }
        }
        groebnerBaseAbstract = gBAlgorithmBuilder.build();
        return groebnerBaseAbstract;
    }
}

