/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.WordIdeal;
import edu.jas.arith.BigRational;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class WordIdealTest
extends TestCase {
    TermOrder to;
    GenWordPolynomialRing<BigRational> fac;
    List<GenWordPolynomial<BigRational>> L;
    List<GenWordPolynomial<BigRational>> M;
    PolynomialList<BigRational> F;
    List<GenWordPolynomial<BigRational>> G;
    WordGroebnerBaseSeq<BigRational> bb;
    GenWordPolynomial<BigRational> a;
    GenWordPolynomial<BigRational> b;
    GenWordPolynomial<BigRational> c;
    GenWordPolynomial<BigRational> d;
    GenWordPolynomial<BigRational> e;
    int kl = 3;
    int ll = 5;
    int el = 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WordIdealTest.suite());
    }

    public WordIdealTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordIdealTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenWordPolynomialRing<BigRational>(bigRational, stringArray);
        this.bb = new WordGroebnerBaseSeq();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testIdealSum() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.fac.random(this.kl, this.ll, this.el);
        this.e = this.d;
        this.L.add(this.a);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        this.L = this.bb.GB(this.L);
        WordIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        String string = wordIdeal.toScript() + "\n" + wordIdeal.toString();
        WordIdealTest.assertTrue((String)("#s >= 46: " + string + ", #s = " + string.length()), (string.length() >= 46 ? 1 : 0) != 0);
        WordIdeal<BigRational> wordIdeal2 = wordIdeal.getZERO();
        WordIdealTest.assertTrue((String)("K == 0: " + wordIdeal2), (boolean)wordIdeal2.isZERO());
        wordIdeal2 = wordIdeal.getONE();
        WordIdealTest.assertTrue((String)("K == 1: " + wordIdeal2), (boolean)wordIdeal2.isONE());
        this.L.add(this.b);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdealTest.assertTrue((String)"not isZERO( I )", (!wordIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.GB(this.L);
        WordIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertTrue((String)"not isZERO( I )", (!wordIdeal.isZERO() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        WordIdeal<BigRational> wordIdeal3 = wordIdeal;
        wordIdeal2 = wordIdeal3.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal2.equals(wordIdeal));
        WordIdealTest.assertEquals((String)"compareTo( K, I )", (int)wordIdeal2.compareTo(wordIdeal), (int)0);
        wordIdeal2 = wordIdeal3.sum(wordIdeal.getList());
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal2.equals(wordIdeal));
        WordIdealTest.assertEquals((String)"compareTo( K, I )", (int)wordIdeal2.compareTo(wordIdeal), (int)0);
        wordIdeal2 = wordIdeal3.sum(wordIdeal.getList().get(0));
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal2.equals(wordIdeal));
        WordIdealTest.assertEquals((String)"compareTo( K, I )", (int)wordIdeal2.compareTo(wordIdeal), (int)0);
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.c);
        WordIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isGB(this.L));
        wordIdeal3 = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        wordIdeal2 = wordIdeal3.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"K contains(I)", (boolean)wordIdeal2.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal2.contains(wordIdeal3));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.d);
        WordIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isGB(this.L));
        wordIdeal3 = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        wordIdeal = wordIdeal2;
        wordIdeal2 = wordIdeal3.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"K contains(I)", (boolean)wordIdeal2.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal2.contains(wordIdeal3));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.e);
        WordIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isGB(this.L));
        wordIdeal3 = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        wordIdeal = wordIdeal2;
        wordIdeal2 = wordIdeal3.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal2.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal2.equals(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal2.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"I contains(K)", (boolean)wordIdeal.contains(wordIdeal2));
        WordIdealTest.assertEquals((String)"compareTo( K, I )", (int)wordIdeal2.compareTo(wordIdeal), (int)0);
        this.L.clear();
        this.e = this.fac.parse("x x");
        this.L.add(this.e);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        wordIdeal.doGB();
        wordIdeal3 = wordIdeal.power(3);
        wordIdeal3 = wordIdeal3.power(2);
        wordIdeal2 = wordIdeal.power(6);
        WordIdealTest.assertEquals((String)"equals( (I**3)**2, I**6 )", wordIdeal2, wordIdeal3);
    }

    public void testWordIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.c;
        this.e = this.d;
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdealTest.assertTrue((String)"not isONE( I )", (!wordIdeal.isONE() || this.a.isConstant() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.b);
        WordIdeal<BigRational> wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdealTest.assertTrue((String)"not isONE( J )", (!wordIdeal2.isONE() || this.a.isConstant() || this.b.isConstant() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( J )", (boolean)wordIdeal2.isGB());
        WordIdeal<BigRational> wordIdeal3 = wordIdeal.product(wordIdeal2);
        WordIdeal<BigRational> wordIdeal4 = wordIdeal2.product(wordIdeal);
        WordIdeal<BigRational> wordIdeal5 = wordIdeal3.sum(wordIdeal4);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"isGB( H )", (boolean)wordIdeal4.isGB());
        WordIdealTest.assertTrue((String)"isGB( G )", (boolean)wordIdeal5.isGB());
        WordIdealTest.assertTrue((String)"I contains(K)", (boolean)wordIdeal.contains(wordIdeal3));
        WordIdealTest.assertTrue((String)"J contains(H)", (boolean)wordIdeal2.contains(wordIdeal4));
        wordIdeal3 = wordIdeal.product(wordIdeal2.getList().get(0));
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"I contains(K)", (boolean)wordIdeal.contains(wordIdeal3));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        wordIdeal3 = wordIdeal.product(wordIdeal2);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"I contains(K)", (boolean)wordIdeal.contains(wordIdeal3));
        WordIdealTest.assertTrue((String)"J contains(K)", (boolean)wordIdeal2.contains(wordIdeal3));
        this.M = wordIdeal.normalform(wordIdeal3.getList());
        wordIdeal4 = new WordIdeal<BigRational>(this.fac, this.M, false, this.bb);
        WordIdealTest.assertTrue((String)"isGB( H )", (boolean)wordIdeal4.isGB());
        WordIdealTest.assertTrue((String)"isZERO( H )", (boolean)wordIdeal4.isZERO());
    }

    public void testWordIdealCommonZeros() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
            WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)0);
        WordIdeal<BigRational> wordIdeal2 = wordIdeal.product(wordIdeal);
        WordIdealTest.assertEquals((String)"commonZeroTest( J )", (int)wordIdeal2.commonZeroTest(), (int)0);
        this.L.remove(0);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true, this.bb);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
    }

    public void testContraction() {
        BigRational bigRational = new BigRational(17L, 1L);
        String[] stringArray = new String[]{"beta", "x", "y", "z"};
        GenWordPolynomialRing<BigRational> genWordPolynomialRing = new GenWordPolynomialRing<BigRational>(bigRational, stringArray);
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = genWordPolynomialRing.getZERO();
        this.L.add(this.a);
        this.b = ((GenWordPolynomial)genWordPolynomialRing.random(3)).monic();
        this.b = genWordPolynomialRing.valueOf(this.b);
        this.L.add(this.b);
        this.c = ((GenWordPolynomial)this.fac.random(4)).monic();
        this.c = genWordPolynomialRing.valueOf(this.c);
        this.L.add(this.c);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(genWordPolynomialRing, this.L, false, this.bb);
        wordIdeal.doGB();
        WordIdeal<BigRational> wordIdeal2 = wordIdeal.intersect(this.fac);
        ArrayList arrayList = new ArrayList();
        for (GenWordPolynomial<BigRational> genWordPolynomial : wordIdeal2.getList()) {
            GenWordPolynomial<BigRational> genWordPolynomial2 = genWordPolynomialRing.valueOf(genWordPolynomial);
            arrayList.add(genWordPolynomial2);
        }
        WordIdeal<BigRational> wordIdeal3 = new WordIdeal<BigRational>(genWordPolynomialRing, arrayList, false, this.bb);
        WordIdealTest.assertTrue((String)"intersect ", (boolean)wordIdeal.contains(wordIdeal3));
    }

    public void testIntersection() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.b = ((GenWordPolynomial)this.fac.random(3)).monic();
        this.L.add(this.b);
        this.c = ((GenWordPolynomial)this.fac.random(4)).monic();
        this.L.add(this.c);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        this.L.clear();
        this.a = ((GenWordPolynomial)this.fac.random(3)).monic();
        this.L.add(this.a);
        WordIdeal<BigRational> wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, false, this.bb);
        WordIdeal<BigRational> wordIdeal3 = wordIdeal.intersect(wordIdeal2);
        WordIdealTest.assertTrue((String)"intersect ", (boolean)wordIdeal.contains(wordIdeal3));
        WordIdealTest.assertTrue((String)"intersect ", (boolean)wordIdeal2.contains(wordIdeal3));
        ArrayList arrayList = new ArrayList();
        arrayList.add(wordIdeal2);
        wordIdeal3 = wordIdeal.intersect(arrayList);
        WordIdealTest.assertTrue((String)"intersect ", (boolean)wordIdeal.contains(wordIdeal3));
        WordIdealTest.assertTrue((String)"intersect ", (boolean)wordIdeal2.contains(wordIdeal3));
    }
}

