/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BigQuaternionInteger
extends BigQuaternion {
    private static final Logger logger = LogManager.getLogger(BigQuaternionInteger.class);

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2, BigRational bigRational3, BigRational bigRational4) {
        super(bigQuaternionRing, bigRational, bigRational2, bigRational3, bigRational4);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2, BigRational bigRational3) {
        this(bigQuaternionRing, bigRational, bigRational2, bigRational3, BigRational.ZERO);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2) {
        this(bigQuaternionRing, bigRational, bigRational2, BigRational.ZERO);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigRational bigRational) {
        this(bigQuaternionRing, bigRational, BigRational.ZERO);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigComplex bigComplex) {
        this(bigQuaternionRing, bigComplex.re, bigComplex.im);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, BigQuaternion bigQuaternion) {
        this(bigQuaternionRing, bigQuaternion.re, bigQuaternion.im, bigQuaternion.jm, bigQuaternion.km);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, long l) {
        this(bigQuaternionRing, new BigRational(l), BigRational.ZERO);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing) {
        this(bigQuaternionRing, BigRational.ZERO);
    }

    public BigQuaternionInteger(BigQuaternionRing bigQuaternionRing, String string) throws NumberFormatException {
        super(bigQuaternionRing, string);
    }

    @Override
    public BigQuaternionRing factory() {
        return this.ring;
    }

    @Override
    public BigQuaternionInteger copy() {
        return new BigQuaternionInteger(this.ring, this.re, this.im, this.jm, this.km);
    }

    @Override
    public BigQuaternion abs() {
        BigQuaternion bigQuaternion = this.norm();
        logger.error("abs() square root missing");
        return bigQuaternion;
    }

    public static BigQuaternion QINV(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.inverse();
    }

    @Override
    public BigQuaternion inverse() {
        if (!this.isUnit()) {
            logger.info("ring = {}", (Object)this.ring);
            throw new ArithmeticException("not invertible: " + this);
        }
        return super.inverse();
    }

    @Override
    public BigQuaternion remainder(BigQuaternion bigQuaternion) {
        return this.rightRemainder(bigQuaternion);
    }

    public static BigQuaternion QQ(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.divide(bigQuaternion2);
    }

    @Override
    public BigQuaternion divide(BigQuaternion bigQuaternion) {
        return this.rightDivide(bigQuaternion);
    }

    @Override
    public BigQuaternion rightDivide(BigQuaternion bigQuaternion) {
        return this.rightQuotientAndRemainder(bigQuaternion)[0];
    }

    @Override
    public BigQuaternion leftDivide(BigQuaternion bigQuaternion) {
        return this.leftQuotientAndRemainder(bigQuaternion)[0];
    }

    @Override
    public BigQuaternion divide(BigRational bigRational) {
        BigQuaternion bigQuaternion = super.divide(bigRational);
        if (!bigQuaternion.isEntier()) {
            throw new ArithmeticException("not divisible: " + this + " / " + bigRational);
        }
        return bigQuaternion;
    }

    @Override
    public BigQuaternion[] quotientRemainder(BigQuaternion bigQuaternion) {
        return new BigQuaternion[]{this.divide(bigQuaternion), this.remainder(bigQuaternion)};
    }

    @Override
    public BigQuaternion gcd(BigQuaternion bigQuaternion) {
        return this.rightGcd(bigQuaternion);
    }

    @Override
    public BigQuaternion[] egcd(BigQuaternion bigQuaternion) {
        throw new UnsupportedOperationException("not implemented: egcd");
    }

    public BigQuaternion[] leftQuotientAndRemainder(BigQuaternion bigQuaternion) {
        if (!this.isEntier() || !bigQuaternion.isEntier()) {
            throw new IllegalArgumentException("entier elements required");
        }
        BigQuaternion bigQuaternion2 = bigQuaternion.inverse();
        BigQuaternion bigQuaternion3 = bigQuaternion2.multiply(this);
        BigQuaternionInteger bigQuaternionInteger = bigQuaternion3.roundToHurwitzian();
        BigQuaternion bigQuaternion4 = this.subtract(bigQuaternion.multiply(bigQuaternionInteger));
        BigQuaternion[] bigQuaternionArray = new BigQuaternion[]{bigQuaternionInteger, bigQuaternion4};
        return bigQuaternionArray;
    }

    public BigQuaternion[] rightQuotientAndRemainder(BigQuaternion bigQuaternion) {
        if (!this.isEntier() || !bigQuaternion.isEntier()) {
            throw new IllegalArgumentException("entier elements required");
        }
        BigQuaternion bigQuaternion2 = bigQuaternion.inverse();
        BigQuaternion bigQuaternion3 = this.multiply(bigQuaternion2);
        BigQuaternionInteger bigQuaternionInteger = bigQuaternion3.roundToHurwitzian();
        BigQuaternion bigQuaternion4 = this.subtract(bigQuaternionInteger.multiply(bigQuaternion));
        BigQuaternion[] bigQuaternionArray = new BigQuaternion[]{bigQuaternionInteger, bigQuaternion4};
        return bigQuaternionArray;
    }

    @Override
    public BigQuaternion leftRemainder(BigQuaternion bigQuaternion) {
        return this.leftQuotientAndRemainder(bigQuaternion)[1];
    }

    @Override
    public BigQuaternion rightRemainder(BigQuaternion bigQuaternion) {
        return this.rightQuotientAndRemainder(bigQuaternion)[1];
    }

    @Override
    public BigQuaternion leftGcd(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigQuaternion;
        }
        BigQuaternionInteger bigQuaternionInteger = this;
        BigQuaternion bigQuaternion2 = bigQuaternion;
        while (!bigQuaternion2.isZERO()) {
            BigQuaternion bigQuaternion3 = bigQuaternionInteger.leftQuotientAndRemainder(bigQuaternion2)[1];
            bigQuaternionInteger = new BigQuaternionInteger(this.ring, bigQuaternion2);
            bigQuaternion2 = bigQuaternion3;
        }
        return bigQuaternionInteger;
    }

    @Override
    public BigQuaternion rightGcd(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigQuaternion;
        }
        BigQuaternionInteger bigQuaternionInteger = this;
        BigQuaternion bigQuaternion2 = bigQuaternion;
        while (!bigQuaternion2.isZERO()) {
            BigQuaternion bigQuaternion3 = bigQuaternionInteger.rightQuotientAndRemainder(bigQuaternion2)[1];
            bigQuaternionInteger = new BigQuaternionInteger(this.ring, bigQuaternion2);
            bigQuaternion2 = bigQuaternion3;
        }
        return bigQuaternionInteger;
    }
}

