/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.kern.PrettyPrint;
import edu.jas.structure.NotInvertibleException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModLongTest
extends TestCase {
    ModLongRing zm;
    ModLongRing z1;
    ModLongRing z2;
    ModLong a;
    ModLong b;
    ModLong c;
    ModLong d;
    ModLong e;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModLongTest.suite());
    }

    public ModLongTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModLongTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.z2 = null;
        this.z1 = null;
        this.zm = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected static java.math.BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 35L));
    }

    protected static java.math.BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 93L));
    }

    protected static java.math.BigInteger getPrime3() {
        int n = 2;
        for (int i = 1; i < 15; ++i) {
            n *= 2;
        }
        return new java.math.BigInteger("" + (n -= 135));
    }

    protected static java.math.BigInteger getPrime4() {
        int n = 37;
        return new java.math.BigInteger("" + n);
    }

    public void testConstants() {
        this.zm = new ModLongRing(5L);
        this.d = new ModLong(this.zm, 11L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.b.subtract(this.b);
        ModLongTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        ModLongTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testBitLength() {
        this.zm = new ModLongRing(163L);
        this.a = this.zm.getZERO();
        this.b = this.zm.getONE();
        this.c = this.zm.random(30);
        ModLongTest.assertEquals((String)"len(0) = 1", (long)1L, (long)this.a.bitLength());
        ModLongTest.assertEquals((String)"len(1) = 2", (long)2L, (long)this.b.bitLength());
        ModLongTest.assertEquals((String)"len(-1) = len(mod)", (long)BigInteger.bitLength(this.zm.modul), (long)this.b.negate().bitLength());
        ModLongTest.assertTrue((String)"len(random) >= 1", (1L <= this.c.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        Object object;
        this.zm = new ModLongRing("5");
        this.a = new ModLong(this.zm, "64");
        this.b = new ModLong(this.zm, "34");
        ModLongTest.assertEquals((String)"64(5) = 34(5)", (Object)this.a, (Object)this.b);
        this.zm = new ModLongRing("7");
        this.a = new ModLong(this.zm, "-4");
        this.b = new ModLong(this.zm, "3");
        ModLongTest.assertEquals((String)"-4(7) = 3(7)", (Object)this.a, (Object)this.b);
        String string = "61111111111111111";
        this.zm = new ModLongRing("10");
        this.a = new ModLong(this.zm, string);
        String string2 = this.a.toString();
        if (PrettyPrint.isTrue()) {
            object = "1";
            ModLongTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        } else {
            object = "1 mod(10)";
            ModLongTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string2);
        }
        this.zm = new ModLongRing(7L);
        this.a = new ModLong(this.zm, 1L);
        this.b = new ModLong(this.zm, -1L);
        this.c = this.b.sum(this.a);
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        ModLongTest.assertTrue((String)"1 = 1", (boolean)this.b.isUnit());
        ModLongTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.zm = new ModLongRing(5L);
        this.a = new ModLong(this.zm, 3L);
        this.b = new ModLong(this.zm, 0L);
        this.c = this.zm.parse(" 13 ");
        ModLongTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
        object = new StringReader("  13\n w ");
        this.c = this.zm.parse((Reader)object);
        ModLongTest.assertEquals((String)"3(5) = 3(5)", (Object)this.a, (Object)this.c);
    }

    public void testRandom() {
        this.zm = new ModLongRing(19L);
        this.a = this.zm.random(500);
        this.b = this.a.copy();
        this.c = this.b.subtract(this.a);
        ModLongTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)this.zm.getZERO());
        this.d = new ModLong(new ModLongRing(this.b.getModul()), this.b.getVal());
        ModLongTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.zm = new ModLongRing(19L);
        this.a = this.zm.random(100);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        ModLongTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ModLongTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(this.zm.getZERO());
        ModLongTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.zm.getZERO());
        ModLongTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        ModLongTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.zm.getZERO());
    }

    public void testMultiplication() {
        this.zm = new ModLongRing(5L);
        this.d = new ModLong(this.zm, 11L);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        ModLongTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        ModLongTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(this.zm.getONE());
        ModLongTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.zm.getONE());
        ModLongTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.zm.random(100);
        if (this.a.isZERO()) {
            this.a = this.d;
        }
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        ModLongTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        try {
            this.a = this.zm.getZERO().inverse();
            ModLongTest.fail((String)"0 invertible");
        }
        catch (NotInvertibleException notInvertibleException) {
            // empty catch block
        }
        this.zm = new ModLongRing(15L);
        this.a = new ModLong(this.zm, 5L);
        ModLongTest.assertFalse((String)"5 !unit mod 15", (boolean)this.a.isUnit());
        try {
            this.b = this.a.inverse();
            ModLongTest.fail((String)"5 invertible");
        }
        catch (ModularNotInvertibleException modularNotInvertibleException) {
            ModLongTest.assertTrue((String)"f  = 15 ", (boolean)modularNotInvertibleException.f.equals(new BigInteger(15L)));
            ModLongTest.assertTrue((String)"f1 =  5 ", (boolean)modularNotInvertibleException.f1.equals(new BigInteger(5L)));
            ModLongTest.assertTrue((String)"f2 =  3 ", (boolean)modularNotInvertibleException.f2.equals(new BigInteger(3L)));
            ModLongTest.assertTrue((String)"f  =  f1*f2 ", (boolean)modularNotInvertibleException.f.equals(modularNotInvertibleException.f1.multiply(modularNotInvertibleException.f2)));
        }
        catch (NotInvertibleException notInvertibleException) {
            ModLongTest.fail((String)("wrong exception " + notInvertibleException));
        }
    }

    public void testChineseRemainder() {
        this.zm = new ModLongRing(247L);
        this.a = this.zm.random(9);
        this.z1 = new ModLongRing(19L);
        this.b = new ModLong(this.z1, this.a.getVal());
        this.z2 = new ModLongRing(13L);
        this.c = new ModLong(this.z2, this.a.getVal());
        this.d = new ModLong(this.z2, 19L);
        this.d = this.d.inverse();
        this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
        ModLongTest.assertEquals((String)"cra(a mod 19,a mod 13) = a", (Object)this.a, (Object)this.e);
        java.math.BigInteger bigInteger = ModLongTest.getPrime2();
        try {
            this.z1 = new ModLongRing(bigInteger);
            ModLongTest.fail((String)"p1 too large");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bigInteger = ModLongTest.getPrime3();
        java.math.BigInteger bigInteger2 = new java.math.BigInteger("19");
        java.math.BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        this.zm = new ModLongRing(bigInteger3);
        this.z1 = new ModLongRing(bigInteger);
        this.z2 = new ModLongRing(bigInteger2);
        for (int i = 0; i < 5; ++i) {
            this.a = this.zm.random(44);
            this.b = new ModLong(this.z1, this.a.getVal());
            this.c = new ModLong(this.z2, this.a.getVal());
            ModLong modLong = new ModLong(this.z2, bigInteger);
            this.d = modLong.inverse();
            this.e = this.zm.chineseRemainder(this.b, this.d, this.c);
            ModLongTest.assertEquals((String)"cra(a mod p1,a mod p2) = a ", (Object)this.a, (Object)this.e);
        }
    }

    public void testChineseRemainderLists() {
        this.zm = new ModLongRing(247L);
        this.z1 = new ModLongRing(19L);
        this.z2 = new ModLongRing(13L);
        ArrayList<ModLong> arrayList = new ArrayList<ModLong>();
        ArrayList<ModLong> arrayList2 = new ArrayList<ModLong>();
        for (int i = 0; i < 7; ++i) {
            this.a = this.zm.random(9);
            this.b = new ModLong(this.z1, this.a.getVal());
            this.c = new ModLong(this.z2, this.a.getVal());
            arrayList.add(this.b);
            arrayList2.add(this.c);
        }
        List<ModLong> list = ModLongRing.chineseRemainder(this.z1.getONE(), this.z2.getONE(), arrayList, arrayList2);
        ModLongTest.assertEquals((String)"19 * 13) = a.modul: ", (Object)this.zm, (Object)list.get((int)0).ring);
        for (ModLong modLong : list) {
            this.b = new ModLong(this.z1, modLong.getVal());
            this.c = new ModLong(this.z2, modLong.getVal());
            ModLongTest.assertTrue((String)"cra(a mod 19, a mod 13) = a: ", (boolean)arrayList.contains(this.b));
            ModLongTest.assertTrue((String)"cra(a mod 19, a mod 13) = a: ", (boolean)arrayList2.contains(this.c));
        }
    }

    public void testTiming() {
        this.zm = new ModLongRing(ModLongTest.getPrime1());
        this.a = this.zm.random(9);
        this.b = this.zm.random(9);
        this.c = this.zm.getONE();
        ModIntegerRing modIntegerRing = new ModIntegerRing(this.zm.modul);
        ModInteger modInteger = new ModInteger(modIntegerRing, this.a.getVal());
        ModInteger modInteger2 = new ModInteger(modIntegerRing, this.b.getVal());
        ModInteger modInteger3 = modIntegerRing.getONE();
        int n = 1000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            if (this.c.isZERO()) {
                this.c = this.zm.getONE();
            }
            this.c = this.a.sum(this.b.divide(this.c));
        }
        l = System.currentTimeMillis() - l;
        ModInteger modInteger4 = new ModInteger(modIntegerRing, this.c.getVal());
        l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            if (modInteger3.isZERO()) {
                modInteger3 = modIntegerRing.getONE();
            }
            modInteger3 = modInteger.sum(modInteger2.divide(modInteger3));
        }
        l = System.currentTimeMillis() - l;
        ModLongTest.assertEquals((String)"C == D ", (Object)modInteger3, (Object)modInteger4);
    }

    public void testIterator() {
        int n = 10;
        this.zm = new ModLongRing(n);
        ModLong modLong = null;
        Object object = this.zm.iterator();
        while (object.hasNext()) {
            ModLong modLong2;
            modLong = modLong2 = object.next();
        }
        object = new ModLong(this.zm, n - 1);
        ModLongTest.assertTrue((String)"j == m-1 ", (boolean)modLong.equals(object));
    }
}

