/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PowerTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)PowerTest.suite());
    }

    public PowerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PowerTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testAddition() {
        LinkedList<BigInteger> linkedList = new LinkedList<BigInteger>();
        int n = 471;
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger2 = BigInteger.ZERO.random(50);
            linkedList.add(bigInteger2);
            bigInteger = bigInteger.sum(bigInteger2);
        }
        BigInteger bigInteger3 = Power.sum(BigInteger.ONE, linkedList);
        PowerTest.assertEquals((String)"a = c", (Object)bigInteger3, (Object)bigInteger);
    }

    public void testMultiplication() {
        LinkedList<BigInteger> linkedList = new LinkedList<BigInteger>();
        int n = 471;
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger2 = BigInteger.ZERO.random(50);
            linkedList.add(bigInteger2);
            bigInteger = bigInteger.multiply(bigInteger2);
        }
        BigInteger bigInteger3 = Power.multiply(BigInteger.ONE, linkedList);
        PowerTest.assertEquals((String)"a = c", (Object)bigInteger3, (Object)bigInteger);
    }

    public void testLog() {
        long l = Power.logarithm(2L, 1024L);
        PowerTest.assertEquals((String)"x = 10", (long)l, (long)10L);
        BigInteger bigInteger = new BigInteger("2");
        BigInteger bigInteger2 = new BigInteger("1024");
        l = Power.logarithm(bigInteger, bigInteger2);
        PowerTest.assertEquals((String)"x = 10", (long)l, (long)10L);
    }

    public void testRationalPower() {
        BigRational bigRational = BigRational.ZERO.random(100);
        BigRational bigRational2 = Power.positivePower(bigRational, 1L);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigRational2, (Object)bigRational);
        Power<BigRational> power = new Power<BigRational>(BigRational.ONE);
        bigRational2 = power.power(bigRational, 1L);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigRational2, (Object)bigRational);
        bigRational2 = power.power(bigRational, 2L);
        BigRational bigRational3 = bigRational.multiply(bigRational);
        PowerTest.assertEquals((String)"a^2 = a*a", (Object)bigRational2, (Object)bigRational3);
        BigRational bigRational4 = power.power(bigRational, -2L);
        bigRational3 = bigRational2.multiply(bigRational4);
        PowerTest.assertTrue((String)"a^2 * a^-2 = 1", (boolean)bigRational3.isONE());
        bigRational2 = power.power(bigRational, 3L);
        bigRational3 = bigRational.multiply(bigRational).multiply(bigRational);
        PowerTest.assertEquals((String)"a^3 = a*a*a", (Object)bigRational2, (Object)bigRational3);
        bigRational4 = power.power(bigRational, -3L);
        bigRational3 = bigRational2.multiply(bigRational4);
        PowerTest.assertTrue((String)"a^3 * a^-3 = 1", (boolean)bigRational3.isONE());
        bigRational4 = (BigRational)bigRational.power(-3L);
        bigRational3 = bigRational2.multiply(bigRational4);
        PowerTest.assertTrue((String)"a^3 * a^-3 = 1", (boolean)bigRational3.isONE());
        bigRational4 = (BigRational)bigRational.power(0L);
        bigRational3 = BigRational.ONE;
        PowerTest.assertEquals((String)"a^0 == 1", (Object)bigRational3, (Object)bigRational4);
        bigRational4 = (BigRational)bigRational.power(3L);
        bigRational3 = bigRational.multiply(bigRational).multiply(bigRational);
        PowerTest.assertEquals((String)"a^3 == a*a*a", (Object)bigRational3, (Object)bigRational4);
    }

    public void testIntegerPower() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = Power.positivePower(bigInteger, 1L);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        Power<BigInteger> power = new Power<BigInteger>(BigInteger.ONE);
        bigInteger2 = power.power(bigInteger, 1L);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger2 = power.power(bigInteger, 2L);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger);
        PowerTest.assertEquals((String)"a^2 = a*a", (Object)bigInteger2, (Object)bigInteger3);
        bigInteger2 = power.power(bigInteger, 3L);
        bigInteger3 = bigInteger.multiply(bigInteger).multiply(bigInteger);
        PowerTest.assertEquals((String)"a^3 = a*a*a", (Object)bigInteger2, (Object)bigInteger3);
        bigInteger = new BigInteger(3L);
        bigInteger2 = Power.positivePower(bigInteger, 1L);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        java.math.BigInteger bigInteger4 = java.math.BigInteger.ONE;
        bigInteger2 = Power.positivePower(bigInteger, bigInteger4);
        PowerTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger = new BigInteger(11L);
        BigInteger bigInteger5 = new BigInteger(2L);
        bigInteger3 = Power.modPositivePower(bigInteger, 10L, bigInteger5);
        PowerTest.assertTrue((String)"3^n mod 2 = 1", (boolean)bigInteger3.isONE());
        bigInteger = BigInteger.ZERO.random(500);
        bigInteger2 = new BigInteger(32003L);
        bigInteger3 = Power.modPositivePower(bigInteger, 32003L, bigInteger2);
        BigInteger bigInteger6 = bigInteger.remainder(bigInteger2);
        PowerTest.assertEquals((String)"a^p = a mod p", (Object)bigInteger3, (Object)bigInteger6);
        bigInteger3 = power.modPower(bigInteger, 32003L, bigInteger2);
        PowerTest.assertEquals((String)"a^p = a mod p", (Object)bigInteger3, (Object)bigInteger6);
        bigInteger = BigInteger.ZERO.random(100);
        bigInteger6 = (BigInteger)bigInteger.power(1L);
        bigInteger3 = bigInteger;
        PowerTest.assertEquals((String)"a^1 == a", (Object)bigInteger3, (Object)bigInteger6);
        bigInteger6 = (BigInteger)bigInteger.power(0L);
        bigInteger3 = BigInteger.ONE;
        PowerTest.assertEquals((String)"a^0 == 1", (Object)bigInteger3, (Object)bigInteger6);
        bigInteger6 = (BigInteger)bigInteger.power(3L);
        bigInteger3 = bigInteger.multiply(bigInteger).multiply(bigInteger);
        PowerTest.assertEquals((String)"a^3 == a*a*a", (Object)bigInteger3, (Object)bigInteger6);
    }

    public void testIntegerLeftRight() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = BigInteger.ZERO.random(50);
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        BigInteger bigInteger4 = bigInteger.leftDivide(bigInteger2);
        BigInteger bigInteger5 = bigInteger.rightDivide(bigInteger2);
        PowerTest.assertEquals((String)"a /_l b == a/b", (Object)bigInteger3, (Object)bigInteger4);
        PowerTest.assertEquals((String)"a /_r b == a/b", (Object)bigInteger3, (Object)bigInteger5);
        BigInteger bigInteger6 = bigInteger3;
        bigInteger3 = bigInteger.remainder(bigInteger2);
        bigInteger4 = bigInteger.leftRemainder(bigInteger2);
        bigInteger5 = bigInteger.rightRemainder(bigInteger2);
        PowerTest.assertEquals((String)"a rem_l b == a rem b", (Object)bigInteger3, (Object)bigInteger4);
        PowerTest.assertEquals((String)"a rem_r b == a rem b", (Object)bigInteger3, (Object)bigInteger5);
        bigInteger5 = bigInteger3;
        BigInteger[] bigIntegerArray = bigInteger.quotientRemainder(bigInteger2);
        PowerTest.assertEquals((String)"qr[0] == a/b", (Object)bigIntegerArray[0], (Object)bigInteger6);
        PowerTest.assertEquals((String)"qr[1] == a rem b", (Object)bigIntegerArray[1], (Object)bigInteger5);
        MonoidElem[] monoidElemArray = bigInteger.twosidedDivide(bigInteger2);
        PowerTest.assertEquals((String)"lr[0] == a/b", (Object)monoidElemArray[0], (Object)bigInteger6);
        PowerTest.assertTrue((String)"lr[1] == 1", (boolean)monoidElemArray[1].isONE());
        BigInteger bigInteger7 = bigInteger.twosidedRemainder(bigInteger2);
        PowerTest.assertEquals((String)"r == e", (Object)bigInteger7, (Object)bigInteger5);
        bigInteger3 = bigInteger.gcd(bigInteger2);
        bigInteger4 = bigInteger.leftGcd(bigInteger2);
        bigInteger5 = bigInteger.rightGcd(bigInteger2);
        PowerTest.assertEquals((String)"a ggt_l b == a ggt b", (Object)bigInteger3, (Object)bigInteger4);
        PowerTest.assertEquals((String)"a ggt_r b == a ggt b", (Object)bigInteger3, (Object)bigInteger5);
    }
}

