/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.QuotSolvablePolynomialRing;
import edu.jas.fd.SolvableQuotient;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuotSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableQuotient<C>> {
    public final QuotSolvablePolynomialRing<C> ring;
    private static final Logger logger = LogManager.getLogger(QuotSolvablePolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing) {
        super(quotSolvablePolynomialRing);
        this.ring = quotSolvablePolynomialRing;
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing, SolvableQuotient<C> solvableQuotient, ExpVector expVector) {
        this(quotSolvablePolynomialRing);
        if (solvableQuotient != null && !solvableQuotient.isZERO()) {
            this.val.put(expVector, solvableQuotient);
        }
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing, SolvableQuotient<C> solvableQuotient) {
        this(quotSolvablePolynomialRing, solvableQuotient, quotSolvablePolynomialRing.evzero);
    }

    public QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing, GenSolvablePolynomial<SolvableQuotient<C>> genSolvablePolynomial) {
        this(quotSolvablePolynomialRing, genSolvablePolynomial.getMap());
    }

    protected QuotSolvablePolynomial(QuotSolvablePolynomialRing<C> quotSolvablePolynomialRing, SortedMap<ExpVector, SolvableQuotient<C>> sortedMap) {
        this(quotSolvablePolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public QuotSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public QuotSolvablePolynomial<C> copy() {
        return new QuotSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QuotSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(QuotSolvablePolynomial<C> quotSolvablePolynomial) {
        if (quotSolvablePolynomial == null || quotSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (quotSolvablePolynomial.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return quotSolvablePolynomial;
        }
        assert (this.ring.nvar == quotSolvablePolynomial.ring.nvar);
        logger.debug("ring = {}", this.ring);
        ExpVector expVector = this.ring.evzero;
        GenSolvablePolynomial genSolvablePolynomial = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableQuotient solvableQuotient = (SolvableQuotient)this.ring.getONECoefficient();
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = quotSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            SolvableQuotient solvableQuotient2 = (SolvableQuotient)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (debug) {
                logger.info("e = {}, a = {}", (Object)expVector2, (Object)solvableQuotient2);
            }
            for (Map.Entry entry2 : set) {
                AbelianGroupElem<ExpVector> abelianGroupElem;
                RingElem ringElem;
                Object object;
                QuotSolvablePolynomial<C> quotSolvablePolynomial2;
                GenSolvablePolynomial genSolvablePolynomial3;
                RingElem<GenPolynomial<GenPolynomial<C>>> ringElem2;
                GenSolvablePolynomial genSolvablePolynomial4;
                SolvableQuotient solvableQuotient3 = (SolvableQuotient)entry2.getValue();
                ExpVector expVector3 = (ExpVector)entry2.getKey();
                if (debug) {
                    logger.info("f = {}, b = {}", (Object)expVector3, (Object)solvableQuotient3);
                }
                int[] nArray = expVector3.dependencyOnVariables();
                int n = 0;
                if (nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                }
                int n2 = this.ring.nvar + 1 - n;
                QuotSolvablePolynomial<C> quotSolvablePolynomial3 = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || solvableQuotient3.isConstant() || expVector2.isZERO()) {
                    quotSolvablePolynomial3 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient3, expVector2);
                    if (debug) {
                        logger.info("symmetric coeff: b = {}, e = {}", (Object)solvableQuotient3, (Object)expVector2);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric coeff: b = {}, e = {}", (Object)solvableQuotient3, (Object)expVector2);
                    }
                    if (solvableQuotient3.den.isONE()) {
                        genSolvablePolynomial4 = new RecSolvablePolynomial(this.ring.polCoeff, expVector2);
                        ringElem2 = new RecSolvablePolynomial(this.ring.polCoeff, solvableQuotient3.num);
                        genSolvablePolynomial3 = ((RecSolvablePolynomial)genSolvablePolynomial4).multiply(ringElem2);
                        quotSolvablePolynomial2 = this.ring.fromPolyCoefficients(genSolvablePolynomial3);
                        quotSolvablePolynomial3 = quotSolvablePolynomial2;
                    } else {
                        if (debug) {
                            logger.info("coeff-num: Cps = {}, num = {}, den = {}", quotSolvablePolynomial3, solvableQuotient3.num, solvableQuotient3.den);
                        }
                        quotSolvablePolynomial3 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient3.ring.getONE(), expVector2);
                        genSolvablePolynomial4 = quotSolvablePolynomial3;
                        ringElem2 = new SolvableQuotient(solvableQuotient3.ring, solvableQuotient3.den);
                        genSolvablePolynomial3 = ((QuotSolvablePolynomial)genSolvablePolynomial4).multiply((SolvableQuotient<C>)ringElem2);
                        quotSolvablePolynomial2 = ((QuotSolvablePolynomial)genSolvablePolynomial4).multiplyLeft((SolvableQuotient<C>)ringElem2);
                        object = (QuotSolvablePolynomial)genSolvablePolynomial3.subtract(quotSolvablePolynomial2);
                        SolvableQuotient solvableQuotient4 = new SolvableQuotient(solvableQuotient3.ring, solvableQuotient3.ring.ring.getONE(), solvableQuotient3.den);
                        ringElem = ((QuotSolvablePolynomial)object).multiply(solvableQuotient4);
                        QuotSolvablePolynomial quotSolvablePolynomial4 = (QuotSolvablePolynomial)genSolvablePolynomial4.subtract(ringElem);
                        quotSolvablePolynomial4 = quotSolvablePolynomial4.multiplyLeft(solvableQuotient4);
                        quotSolvablePolynomial3 = quotSolvablePolynomial4;
                        if (!solvableQuotient3.num.isONE()) {
                            abelianGroupElem = new SolvableQuotient(solvableQuotient3.ring, solvableQuotient3.num);
                            quotSolvablePolynomial3 = quotSolvablePolynomial3.multiply((SolvableQuotient<C>)abelianGroupElem);
                        }
                    }
                }
                if (debug) {
                    logger.info("coeff-den: Cps = {}", quotSolvablePolynomial3);
                }
                genSolvablePolynomial4 = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
                ringElem2 = null;
                if (this.ring.table.isEmpty() || quotSolvablePolynomial3.isConstant() || expVector3.isZERO()) {
                    if (debug) {
                        logger.info("symmetric poly: b = {}, e = {}", (Object)solvableQuotient3, (Object)expVector2);
                    }
                    object = expVector2.sum(expVector3);
                    ringElem2 = quotSolvablePolynomial3.isConstant() ? new QuotSolvablePolynomial<C>(this.ring, (SolvableQuotient)quotSolvablePolynomial3.leadingBaseCoefficient(), (ExpVector)object) : quotSolvablePolynomial3.shift(expVector3);
                } else {
                    if (debug) {
                        logger.info("unsymmetric poly: Cps = {}, f = {}", quotSolvablePolynomial3, (Object)expVector3);
                    }
                    for (Map.Entry entry3 : quotSolvablePolynomial3.val.entrySet()) {
                        ExpVector expVector4;
                        int n3;
                        ringElem = (SolvableQuotient)entry3.getValue();
                        abelianGroupElem = (ExpVector)entry3.getKey();
                        if (debug) {
                            logger.info("g = {}, c = {}", (Object)abelianGroupElem, (Object)ringElem);
                        }
                        int[] nArray2 = abelianGroupElem.dependencyOnVariables();
                        int n4 = this.ring.nvar + 1;
                        if (nArray2.length > 0) {
                            n4 = nArray2[0];
                        }
                        if ((n3 = this.ring.nvar + 1 - n4) <= n2) {
                            expVector4 = abelianGroupElem.sum(expVector3);
                            if (debug) {
                                logger.info("disjoint poly: g = {}, f = {}, h = {}", (Object)abelianGroupElem, (Object)expVector3, (Object)expVector4);
                            }
                            ringElem2 = (QuotSolvablePolynomial)genSolvablePolynomial2.sum(solvableQuotient, expVector4);
                        } else {
                            expVector4 = abelianGroupElem.subst(n4, 0L);
                            ExpVector expVector5 = expVector.subst(n4, abelianGroupElem.getVal(n4));
                            ExpVector expVector6 = expVector3.subst(n, 0L);
                            ExpVector expVector7 = expVector.subst(n, expVector3.getVal(n));
                            if (debug) {
                                logger.info("poly, g1 = {}, f1 = {}, Dps = {}", (Object)expVector4, (Object)expVector6, (Object)genSolvablePolynomial4);
                                logger.info("poly, g2 = {}, f2 = {}", (Object)expVector5, (Object)expVector7);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector5, expVector7);
                            if (debug) {
                                logger.info("poly, g  = {}, f  = {}, rel = {}", (Object)abelianGroupElem, (Object)expVector3, tableRelation);
                            }
                            ringElem2 = new QuotSolvablePolynomial<C>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                quotSolvablePolynomial2 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, tableRelation.f);
                                ringElem2 = ((QuotSolvablePolynomial)ringElem2).multiply(quotSolvablePolynomial2);
                                ExpVector expVector8 = tableRelation.e == null ? expVector5 : expVector5.subtract(tableRelation.e);
                                this.ring.table.update(expVector8, expVector7, ringElem2);
                            }
                            if (tableRelation.e != null) {
                                genSolvablePolynomial3 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, tableRelation.e);
                                ringElem2 = ((QuotSolvablePolynomial)genSolvablePolynomial3).multiply((QuotSolvablePolynomial<C>)ringElem2);
                                this.ring.table.update(expVector5, expVector7, ringElem2);
                            }
                            if (!expVector6.isZERO()) {
                                quotSolvablePolynomial2 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector6);
                                ringElem2 = ((QuotSolvablePolynomial)ringElem2).multiply(quotSolvablePolynomial2);
                            }
                            if (!expVector4.isZERO()) {
                                genSolvablePolynomial3 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector4);
                                ringElem2 = ((QuotSolvablePolynomial)genSolvablePolynomial3).multiply((QuotSolvablePolynomial<C>)ringElem2);
                            }
                        }
                        ringElem2 = ((QuotSolvablePolynomial)ringElem2).multiplyLeft((SolvableQuotient<C>)ringElem);
                        genSolvablePolynomial4 = (QuotSolvablePolynomial)genSolvablePolynomial4.sum(ringElem2);
                    }
                    ringElem2 = genSolvablePolynomial4;
                }
                ringElem2 = ((QuotSolvablePolynomial)ringElem2).multiplyLeft(solvableQuotient2);
                logger.debug("Ds = {}", ringElem2);
                genSolvablePolynomial = (QuotSolvablePolynomial)genSolvablePolynomial.sum(ringElem2);
            }
        }
        return genSolvablePolynomial;
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(QuotSolvablePolynomial<C> quotSolvablePolynomial, QuotSolvablePolynomial<C> quotSolvablePolynomial2) {
        if (quotSolvablePolynomial.isZERO() || quotSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (quotSolvablePolynomial.isONE()) {
            return this.multiply(quotSolvablePolynomial2);
        }
        if (quotSolvablePolynomial2.isONE()) {
            return quotSolvablePolynomial.multiply(this);
        }
        return quotSolvablePolynomial.multiply(this).multiply(quotSolvablePolynomial2);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> solvableQuotient) {
        QuotSolvablePolynomial<C> quotSolvablePolynomial = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return quotSolvablePolynomial;
        }
        if (solvableQuotient.isONE()) {
            return this;
        }
        quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, this.ring.evzero);
        return this.multiply(quotSolvablePolynomial);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> solvableQuotient, SolvableQuotient<C> solvableQuotient2) {
        QuotSolvablePolynomial<C> quotSolvablePolynomial = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return quotSolvablePolynomial;
        }
        if (solvableQuotient2 == null || solvableQuotient2.isZERO()) {
            return quotSolvablePolynomial;
        }
        if (solvableQuotient.isONE() && solvableQuotient2.isONE()) {
            return this;
        }
        quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, this.ring.evzero);
        QuotSolvablePolynomial<C> quotSolvablePolynomial2 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient2, this.ring.evzero);
        return this.multiply(quotSolvablePolynomial, quotSolvablePolynomial2);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableQuotient solvableQuotient = (SolvableQuotient)this.ring.getONECoefficient();
        return this.multiply(solvableQuotient, expVector);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        SolvableQuotient solvableQuotient = (SolvableQuotient)this.ring.getONECoefficient();
        return this.multiply(solvableQuotient, expVector, solvableQuotient, expVector2);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> solvableQuotient, ExpVector expVector) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableQuotient.isONE() && expVector.isZERO()) {
            return this;
        }
        QuotSolvablePolynomial<C> quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector);
        return this.multiply(quotSolvablePolynomial);
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(SolvableQuotient<C> solvableQuotient, ExpVector expVector, SolvableQuotient<C> solvableQuotient2, ExpVector expVector2) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableQuotient2 == null || solvableQuotient2.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableQuotient.isONE() && expVector.isZERO() && solvableQuotient2.isONE() && expVector2.isZERO()) {
            return this;
        }
        QuotSolvablePolynomial<C> quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector);
        QuotSolvablePolynomial<C> quotSolvablePolynomial2 = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient2, expVector2);
        return this.multiply(quotSolvablePolynomial, quotSolvablePolynomial2);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(SolvableQuotient<C> solvableQuotient, ExpVector expVector) {
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return this.ring.getZERO();
        }
        QuotSolvablePolynomial<C> quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector);
        return quotSolvablePolynomial.multiply(this);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableQuotient solvableQuotient = (SolvableQuotient)this.ring.getONECoefficient();
        QuotSolvablePolynomial<C> quotSolvablePolynomial = new QuotSolvablePolynomial<C>(this.ring, solvableQuotient, expVector);
        return quotSolvablePolynomial.multiply(this);
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(SolvableQuotient<C> solvableQuotient) {
        GenSolvablePolynomial genSolvablePolynomial = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableQuotient == null || solvableQuotient.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((QuotSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            SolvableQuotient solvableQuotient2 = (SolvableQuotient)entry.getValue();
            SolvableQuotient<SolvableQuotient> solvableQuotient3 = solvableQuotient.multiply(solvableQuotient2);
            if (solvableQuotient3.isZERO()) continue;
            sortedMap.put(expVector, solvableQuotient3);
        }
        return genSolvablePolynomial;
    }

    @Override
    public QuotSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableQuotient<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public QuotSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableQuotient<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    protected QuotSolvablePolynomial<C> shift(ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((QuotSolvablePolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((QuotSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            SolvableQuotient solvableQuotient = (SolvableQuotient)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (solvableQuotient.isZERO()) continue;
            sortedMap.put(expVector3, solvableQuotient);
        }
        return genSolvablePolynomial;
    }
}

