/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedDPairlist;
import edu.jas.gb.Pair;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DGroebnerBaseSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(DGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected DReduction<C> dred;

    public DGroebnerBaseSeq() {
        this(new DReductionSeq());
    }

    public DGroebnerBaseSeq(DReduction<C> dReduction) {
        super(dReduction);
        this.dred = dReduction;
        assert (this.dred == this.red);
    }

    @Override
    public boolean isGB(int n, List<GenPolynomial<C>> list) {
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<C> genPolynomial2 = list.get(j);
                if (!this.dred.moduleCriterion(n, genPolynomial, genPolynomial2)) continue;
                GenPolynomial<C> genPolynomial3 = this.dred.GPolynomial(genPolynomial, genPolynomial2);
                if (!genPolynomial3.isZERO()) {
                    genPolynomial3 = this.dred.normalform(list, genPolynomial3);
                }
                if (!genPolynomial3.isZERO()) {
                    System.out.println("d-pol(" + genPolynomial + "," + genPolynomial2 + ") != 0: " + genPolynomial3);
                    return false;
                }
                if (!this.dred.criterion4(genPolynomial, genPolynomial2)) continue;
                GenPolynomial<C> genPolynomial4 = this.dred.SPolynomial(genPolynomial, genPolynomial2);
                if (!genPolynomial4.isZERO()) {
                    genPolynomial4 = this.dred.normalform(list, genPolynomial4);
                }
                if (genPolynomial4.isZERO()) continue;
                System.out.println("s-pol(" + i + "," + j + ") != 0: " + genPolynomial4);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        OrderedDPairlist<C> orderedDPairlist = new OrderedDPairlist<C>(n, genPolynomialRing);
        orderedDPairlist.put(list2);
        while (orderedDPairlist.hasNext()) {
            Pair pair = orderedDPairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial = pair.pi;
            GenPolynomial genPolynomial2 = pair.pj;
            if (debug) {
                logger.debug("pi    = {}", (Object)genPolynomial);
                logger.debug("pj    = {}", (Object)genPolynomial2);
            }
            GenPolynomial<C> genPolynomial3 = null;
            GenPolynomial<C> genPolynomial4 = this.dred.GPolynomial(genPolynomial, genPolynomial2);
            if (!genPolynomial4.isZERO() && !this.dred.isTopReducible(list2, genPolynomial4)) {
                genPolynomial3 = this.dred.normalform(list2, genPolynomial4);
                if (genPolynomial3.isONE()) {
                    list2.clear();
                    list2.add(genPolynomial3);
                    return list2;
                }
                if (!genPolynomial3.isZERO()) {
                    logger.info("Dred = {}", genPolynomial3);
                    list2.add(genPolynomial3);
                    orderedDPairlist.put(genPolynomial3);
                }
            }
            if (!pair.getUseCriterion3() || !pair.getUseCriterion4()) continue;
            GenPolynomial genPolynomial5 = this.dred.SPolynomial(genPolynomial, genPolynomial2);
            if (genPolynomial5.isZERO()) {
                pair.setZero();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = {}", (Object)genPolynomial5.leadingExpVector());
            }
            if ((genPolynomial3 = this.dred.normalform(list2, genPolynomial5)).isZERO()) {
                pair.setZero();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(H) = {}", (Object)genPolynomial3.leadingExpVector());
            }
            if (genPolynomial3.isONE()) {
                list2.clear();
                list2.add(genPolynomial3);
                return list2;
            }
            logger.debug("H = {}", genPolynomial3);
            if (genPolynomial3.isZERO()) continue;
            logger.info("Sred = {}", genPolynomial3);
            list2.add(genPolynomial3);
            orderedDPairlist.put(genPolynomial3);
        }
        logger.debug("#sequential list = {}", (Object)list2.size());
        list2 = this.minimalGB(list2);
        logger.info("{}", orderedDPairlist);
        return list2;
    }

    @Override
    public ExtendedGB<C> extGB(int n, List<GenPolynomial<C>> list) {
        boolean bl;
        int n2;
        AbelianGroupElem abelianGroupElem;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List list2 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        List list3 = new ArrayList();
        OrderedDPairlist orderedDPairlist = null;
        boolean bl2 = false;
        int n3 = list.size();
        List<Object> list4 = null;
        List<Object> list5 = null;
        List<Object> list6 = null;
        GenPolynomialRing genPolynomialRing = null;
        int n4 = 0;
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.length() > 0) {
                ++n4;
            }
            if (genPolynomialRing != null) continue;
            genPolynomialRing = genPolynomial.ring;
        }
        MonoidElem monoidElem = genPolynomialRing.getONE();
        int n5 = 0;
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial<C> genPolynomial = listIterator.next();
            if (genPolynomial.length() > 0) {
                list4 = this.blas.genVector(n4, null);
                list4.set(n5, monoidElem);
                ++n5;
                if (genPolynomial.isUnit()) {
                    list2.clear();
                    list2.add(genPolynomial);
                    list3.clear();
                    list3.add(list4);
                    bl2 = true;
                    break;
                }
                list2.add(genPolynomial);
                list3.add(list4);
                if (orderedDPairlist == null) {
                    orderedDPairlist = new OrderedDPairlist(n, genPolynomial.ring);
                    if (genPolynomial.ring.coFac.isField()) {
                        logger.warn("coefficients from a field " + genPolynomial.ring.coFac);
                    }
                }
                orderedDPairlist.put(genPolynomial);
                continue;
            }
            --n3;
        }
        if (n3 <= 1 || bl2) {
            for (GenPolynomial<C> genPolynomial : list) {
                list4 = this.blas.genVector(list2.size(), null);
                GenPolynomial genPolynomial2 = this.dred.normalform(list4, list2, genPolynomial);
                if (!genPolynomial2.isZERO()) {
                    logger.error("nonzero H = {}", genPolynomial2);
                }
                logger.info("f row = {}", list4);
                arrayList.add(list4);
            }
            ExtendedGB<C> extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            return extendedGB;
        }
        n5 = 0;
        while (orderedDPairlist.hasNext() && !bl2) {
            Pair pair = orderedDPairlist.removeNext();
            if (pair == null) continue;
            int n6 = pair.i;
            int n7 = pair.j;
            GenPolynomial genPolynomial = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (debug) {
                logger.info("i, pi    = {}, {}", (Object)n6, (Object)genPolynomial);
                logger.info("j, pj    = {}, {}", (Object)n7, (Object)genPolynomial3);
            }
            abelianGroupElem = null;
            list5 = this.blas.genVector(list2.size() + 1, null);
            GenPolynomial<C> genPolynomial4 = this.dred.GPolynomial(list5, n6, genPolynomial, n7, genPolynomial3);
            logger.info("Gpol = {}", genPolynomial4);
            if (debug) {
                logger.info("is reduction D = " + this.dred.isReductionNF(list5, list2, genPolynomial4, genPolynomialRing.getZERO()));
            }
            if (!genPolynomial4.isZERO()) {
                list6 = this.blas.genVector(list2.size() + 1, null);
                abelianGroupElem = this.dred.normalform(list6, list2, genPolynomial4);
                if (debug) {
                    logger.info("is reduction H = " + this.dred.isReductionNF(list6, list2, genPolynomial4, abelianGroupElem));
                }
                if ((n2 = ((GenPolynomial)abelianGroupElem).leadingBaseCoefficient().signum()) < 0) {
                    logger.info("negate: H_D rowd, rowh = {}, {}", list5, list6);
                    abelianGroupElem = ((GenPolynomial)abelianGroupElem).negate();
                    list5 = this.blas.vectorNegate(list5);
                    list6 = this.blas.vectorNegate(list6);
                }
                if (((GenPolynomial)abelianGroupElem).isONE()) {
                    list2.add(abelianGroupElem);
                    bl2 = true;
                } else if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                    logger.info("H_G red = {}", abelianGroupElem);
                    list2.add(abelianGroupElem);
                    orderedDPairlist.put(abelianGroupElem);
                }
                list4 = this.blas.vectorCombineRep(list5, list6);
                logger.debug("H_G row = {}", list4);
                if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                    list3.add(list4);
                }
                if (debug) {
                    logger.debug("ht(H) = {}", (Object)((GenPolynomial)abelianGroupElem).leadingExpVector());
                    logger.info("is reduction D,H = " + this.dred.isReductionNF(list4, list2, abelianGroupElem, genPolynomialRing.getZERO()));
                }
            }
            list5 = this.blas.genVector(list2.size() + 1, null);
            GenPolynomial genPolynomial5 = this.dred.SPolynomial(list5, n6, genPolynomial, n7, genPolynomial3);
            logger.info("Spol = {}", genPolynomial5);
            if (debug) {
                logger.info("is reduction S = " + this.dred.isReductionNF(list5, list2, genPolynomial5, genPolynomialRing.getZERO()));
            }
            list6 = this.blas.genVector(list2.size() + 1, null);
            if (genPolynomial5.isZERO()) continue;
            abelianGroupElem = this.dred.normalform(list6, list2, genPolynomial5);
            if (debug) {
                logger.info("Spol_red = {}", abelianGroupElem);
                logger.info("is reduction H = " + this.dred.isReductionNF(list6, list2, genPolynomial5, abelianGroupElem));
            }
            if ((n2 = ((GenPolynomial)abelianGroupElem).leadingBaseCoefficient().signum()) < 0) {
                logger.info("negate: H_S rows, rowh = {}, {}", list5, list6);
                abelianGroupElem = ((GenPolynomial)abelianGroupElem).negate();
                list5 = this.blas.vectorNegate(list5);
                list6 = this.blas.vectorNegate(list6);
            }
            if (((GenPolynomial)abelianGroupElem).isONE()) {
                list2.add(abelianGroupElem);
                bl2 = true;
            } else if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                logger.info("H_S red = {}", abelianGroupElem);
                list2.add(abelianGroupElem);
                orderedDPairlist.put(abelianGroupElem);
            }
            list4 = this.blas.vectorCombineRep(list5, list6);
            logger.debug("H_S row = {}", list4);
            if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                list3.add(list4);
            }
            if (!debug) continue;
            logger.debug("ht(H) = {}", (Object)((GenPolynomial)abelianGroupElem).leadingExpVector());
            logger.info("is reduction S,H = " + this.dred.isReductionNF(list4, list2, abelianGroupElem, genPolynomialRing.getZERO()));
        }
        ExtendedGB<C> extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        n2 = this.isReductionMatrix(extendedGB);
        if (n2 == 0) {
            logger.info("exgb unnorm = {}", extendedGB);
            logger.info("exgb t_1 = {}", (Object)(n2 != 0));
        }
        list3 = this.normalizeMatrix(list.size(), list3);
        if (debug && (n2 = this.isReductionMatrix(extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3))) == 0) {
            logger.info("exgb norm nonmin = {}", extendedGB);
            logger.info("exgb t_2 = {}", (Object)(n2 != 0));
        }
        extendedGB = this.minimalExtendedGB(list.size(), list2, list3);
        list2 = extendedGB.G;
        list3 = extendedGB.G2F;
        extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        n2 = this.isMinReductionMatrix(extendedGB);
        if (n2 == 0) {
            logger.info("exgb minGB = {}", extendedGB);
            logger.info("exgb t_3 = {}", (Object)(n2 != 0));
        }
        extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        for (GenPolynomial<C> genPolynomial : list) {
            list4 = this.blas.genVector(list2.size() + 1, null);
            abelianGroupElem = this.dred.normalform(list4, list2, genPolynomial);
            if (!((GenPolynomial)abelianGroupElem).isZERO()) {
                logger.error("nonzero H, G = {}, {}", abelianGroupElem, list2);
                throw new RuntimeException("H != 0");
            }
            arrayList.add(list4);
        }
        extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        if (debug && !(bl = this.isMinReductionMatrix(extendedGB))) {
            logger.info("exgb +F+F2G = {}", extendedGB);
            logger.info("exgb t_4 = {}", (Object)bl);
        }
        return extendedGB;
    }

    @Override
    public ExtendedGB<C> minimalExtendedGB(int n, List<GenPolynomial<C>> list, List<List<GenPolynomial<C>>> list2) {
        ArrayList<Object> arrayList;
        if (list == null) {
            return null;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list);
        ArrayList arrayList3 = new ArrayList(list.size());
        ArrayList<ArrayList<Object>> arrayList4 = new ArrayList<ArrayList<Object>>(list2.size());
        ArrayList arrayList5 = new ArrayList(list2.size());
        for (List<GenPolynomial<C>> listIterator : list2) {
            arrayList = new ArrayList<GenPolynomial<C>>(listIterator);
            arrayList4.add(arrayList);
        }
        arrayList = new ArrayList();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n2 = 0;
        GenPolynomialRing genPolynomialRing = null;
        while (arrayList2.size() > 0) {
            RingElem ringElem;
            Object c;
            ExpVector expVector;
            GenPolynomial genPolynomial;
            GenPolynomial genPolynomial2 = (GenPolynomial)arrayList2.remove(0);
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            Object c2 = genPolynomial2.leadingBaseCoefficient();
            if (genPolynomialRing == null) {
                genPolynomialRing = genPolynomial2.ring;
            }
            ListIterator listIterator = arrayList2.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial = (GenPolynomial)listIterator.next();
                expVector = genPolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
                if (!bl) continue;
                c = genPolynomial.leadingBaseCoefficient();
                ringElem = (RingElem)c2.remainder(c);
                bl = ringElem.isZERO();
            }
            ListIterator listIterator2 = arrayList3.listIterator();
            while (listIterator2.hasNext() && !bl) {
                genPolynomial = (GenPolynomial)listIterator2.next();
                expVector = genPolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
                if (!bl) continue;
                c = genPolynomial.leadingBaseCoefficient();
                ringElem = (RingElem)c2.remainder(c);
                bl = ringElem.isZERO();
            }
            ArrayList<GenPolynomial<C>> arrayList7 = new ArrayList<GenPolynomial<C>>(arrayList2);
            arrayList7.addAll(arrayList3);
            if (!bl) {
                arrayList3.add(genPolynomial2);
                arrayList.add(n2);
            } else {
                arrayList6.add(n2);
            }
            ++n2;
        }
        logger.info("ix, jx, #M = {}, {}, {}", arrayList, arrayList6, (Object)arrayList4.size());
        int n3 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n4 = (Integer)arrayList.get(i);
            if (n4 >= n && n3 == -1) {
                n3 = arrayList5.size();
            }
            if (n4 < 0) continue;
            List list3 = (List)arrayList4.get(n4);
            arrayList5.add(list3);
        }
        if (arrayList3.size() <= 1 || n3 == -1) {
            return new ExtendedGB(null, arrayList3, null, arrayList5);
        }
        return new ExtendedGB(null, arrayList3, null, arrayList5);
    }

    /*
     * WARNING - void declaration
     */
    public GenPolynomial<C> inverse(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        void var10_13;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (list == null || list.size() == 0) {
            throw new NotInvertibleException("zero ideal");
        }
        if (genPolynomial.isUnit()) {
            return genPolynomial.inverse();
        }
        List<GenPolynomial<C>> list2 = this.GB(list);
        ArrayList arrayList = new ArrayList(1 + list2.size());
        arrayList.add(genPolynomial);
        arrayList.addAll(list2);
        ExtendedGB extendedGB = this.extGB(arrayList);
        List list3 = extendedGB.G;
        GenPolynomial genPolynomial3 = null;
        int n = -1;
        for (GenPolynomial genPolynomial22 : list3) {
            ++n;
            if (genPolynomial22 == null || !genPolynomial22.isUnit()) continue;
            genPolynomial3 = genPolynomial22;
            break;
        }
        if (genPolynomial3 == null) {
            throw new NotInvertibleException("h = " + genPolynomial);
        }
        List list4 = extendedGB.G2F.get(n);
        GenPolynomial genPolynomial2 = (GenPolynomial)list4.get(0);
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new NotInvertibleException("h = " + genPolynomial);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.red.normalform(list2, genPolynomial4);
        if (genPolynomial5.signum() < 0) {
            GenPolynomial<GenPolynomial<C>> genPolynomial6 = genPolynomial2.sum(list2.get(0));
        }
        return var10_13;
    }
}

