/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerIter;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReducerIter;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseParIter<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseParIter.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected final transient ExecutorService pool;

    public GroebnerBaseParIter() {
        this(2);
    }

    public GroebnerBaseParIter(int n) {
        this(n, Executors.newFixedThreadPool(n));
    }

    public GroebnerBaseParIter(int n, Reduction<C> reduction) {
        this(n, Executors.newFixedThreadPool(n), reduction);
    }

    public GroebnerBaseParIter(int n, PairList<C> pairList) {
        this(n, Executors.newFixedThreadPool(n), new ReductionPar(), pairList);
    }

    public GroebnerBaseParIter(int n, ExecutorService executorService) {
        this(n, executorService, new ReductionPar());
    }

    public GroebnerBaseParIter(int n, ExecutorService executorService, Reduction<C> reduction) {
        this(n, executorService, reduction, new OrderedPairlist());
    }

    public GroebnerBaseParIter(int n, Reduction<C> reduction, PairList<C> pairList) {
        this(n, Executors.newFixedThreadPool(n), reduction, pairList);
    }

    public GroebnerBaseParIter(int n, ExecutorService executorService, Reduction<C> reduction, PairList<C> pairList) {
        super(reduction, pairList);
        if (!(reduction instanceof ReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = executorService;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            while (!this.pool.isTerminated()) {
                boolean bl = this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        logger.info("{}", (Object)this.pool);
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.shutdownNow().size();
        logger.info("{}", (Object)this.pool);
        return n;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        list2 = OrderedPolynomialList.sort(list2);
        logger.info("G-sort = {}", list2);
        List<GenPolynomial<C>> list3 = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list2) {
            if (debug) {
                logger.info("p = {}", genPolynomial);
            }
            if ((list3 = this.GB(n, list3, genPolynomial)).size() <= 0 || !list3.get(0).isONE()) continue;
            return list3;
        }
        return list3;
    }

    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (arrayList.isEmpty()) {
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        if (genPolynomial2.isZERO()) {
            return arrayList;
        }
        if (genPolynomial2.isONE()) {
            arrayList.clear();
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.setList(list);
        list.add(genPolynomial2);
        pairList.put(genPolynomial2);
        logger.info("start {}", pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            ReducerIter<C> reducerIter = new ReducerIter<C>(terminator, list, pairList);
            this.pool.execute(reducerIter);
        }
        terminator.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug("#parallel list = {}", (Object)list.size());
        list = this.minimalGB(list);
        logger.info("end   {}", pairList);
        return list;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerIter[] miReducerIterArray = new MiReducerIter[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerIterArray[n] = new MiReducerIter(arrayList3, genPolynomial);
            this.pool.execute(miReducerIterArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerIterArray.length; ++n) {
            genPolynomial = miReducerIterArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

