/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseParTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> G;
    PolynomialList<BigRational> F;
    GroebnerBase<BigRational> bbseq;
    GroebnerBase<BigRational> bbpar;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseParTest.suite());
    }

    public GroebnerBaseParTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseParTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbpar = new GroebnerBaseParallel<BigRational>(this.threads);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        ((GroebnerBaseParallel)this.bbpar).terminate();
        this.bbpar = null;
    }

    public void testParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbpar.isGB(this.L));
        GroebnerBaseParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbpar.isGB(this.L));
        GroebnerBaseParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbpar.isGB(this.L));
        GroebnerBaseParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbpar.isGB(this.L));
        GroebnerBaseParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbpar.isGB(this.L));
    }

    public void testSequentialParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> list = this.bbseq.GB(this.L);
        List<GenPolynomial<BigRational>> list2 = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.b);
        list = this.bbseq.GB(this.L);
        list2 = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.c);
        list = this.bbseq.GB(this.L);
        list2 = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.d);
        list = this.bbseq.GB(this.L);
        list2 = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.e);
        list = this.bbseq.GB(this.L);
        list2 = this.bbpar.GB(this.L);
        GroebnerBaseParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseParTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseParTest.fail((String)("" + iOException));
        }
        this.G = this.bbpar.GB(this.F.list);
        GroebnerBaseParTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbpar.isGB(this.G));
        GroebnerBaseParTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

