/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Reduction;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseSeqPairSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseSeqPairSeq.class);
    private static final boolean debug = logger.isDebugEnabled();

    public GroebnerBaseSeqPairSeq() {
    }

    public GroebnerBaseSeqPairSeq(Reduction<C> reduction) {
        super(reduction);
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>();
        if (list == null) {
            return list2;
        }
        CriticalPairList criticalPairList = null;
        int n2 = list.size();
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial<C> genPolynomial = listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = genPolynomial.monic()).isONE()) {
                    list2.clear();
                    list2.add(genPolynomial);
                    return list2;
                }
                list2.add(genPolynomial);
                if (criticalPairList == null) {
                    criticalPairList = new CriticalPairList(n, genPolynomial.ring);
                }
                criticalPairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list2;
        }
        while (criticalPairList.hasNext()) {
            GenPolynomial<C> genPolynomial;
            GenPolynomial genPolynomial2;
            CriticalPair criticalPair = criticalPairList.getNext();
            if (criticalPair == null) {
                criticalPairList.update();
                continue;
            }
            GenPolynomial genPolynomial3 = criticalPair.pi;
            GenPolynomial genPolynomial4 = criticalPair.pj;
            if (debug) {
                logger.debug("pi    = {}", (Object)genPolynomial3);
                logger.debug("pj    = {}", (Object)genPolynomial4);
            }
            if ((genPolynomial2 = this.red.SPolynomial(genPolynomial3, genPolynomial4)).isZERO()) {
                criticalPairList.update(criticalPair, genPolynomial2);
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = {}", (Object)genPolynomial2.leadingExpVector());
            }
            if ((genPolynomial = this.red.normalform(list2, genPolynomial2)).isZERO()) {
                criticalPairList.update(criticalPair, genPolynomial);
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = {}", (Object)genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = genPolynomial.monic()).isONE()) {
                list2.clear();
                list2.add(genPolynomial);
                return list2;
            }
            if (debug) {
                logger.debug("H = {}", genPolynomial);
            }
            list2.add(genPolynomial);
            criticalPairList.update(criticalPair, genPolynomial);
        }
        logger.debug("#sequential list = {}", (Object)list2.size());
        list2 = this.minimalGB(list2);
        logger.info("{}", (Object)criticalPairList);
        return list2;
    }

    @Override
    public ExtendedGB<C> extGB(int n, List<GenPolynomial<C>> list) {
        ExtendedGB<C> extendedGB;
        GenPolynomial genPolynomial;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List list2 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        List list3 = new ArrayList();
        CriticalPairList criticalPairList = null;
        boolean bl = false;
        int n2 = list.size();
        List<Object> list4 = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        GenPolynomialRing genPolynomialRing = null;
        int n3 = 0;
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2.length() > 0) {
                ++n3;
            }
            if (genPolynomialRing != null) continue;
            genPolynomialRing = genPolynomial2.ring;
        }
        MonoidElem monoidElem = genPolynomialRing.getONE();
        int n4 = 0;
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial<C> genPolynomial3 = listIterator.next();
            if (genPolynomial3.length() > 0) {
                list4 = this.blas.genVector(n3, null);
                list4.set(n4, monoidElem);
                ++n4;
                if (genPolynomial3.isUnit()) {
                    list2.clear();
                    list2.add(genPolynomial3);
                    list3.clear();
                    list3.add(list4);
                    bl = true;
                    break;
                }
                list2.add(genPolynomial3);
                list3.add(list4);
                if (criticalPairList == null) {
                    criticalPairList = new CriticalPairList(n, genPolynomial3.ring);
                }
                criticalPairList.put(genPolynomial3);
                continue;
            }
            --n2;
        }
        if (n2 <= 1 || bl) {
            for (GenPolynomial<C> genPolynomial4 : list) {
                list4 = this.blas.genVector(list2.size(), null);
                GenPolynomial genPolynomial5 = this.red.normalform(list4, list2, genPolynomial4);
                if (!genPolynomial5.isZERO()) {
                    logger.error("nonzero H = {}", genPolynomial5);
                }
                arrayList.add(list4);
            }
            ExtendedGB<C> extendedGB2 = new ExtendedGB<C>(list, list2, arrayList, list3);
            return extendedGB2;
        }
        while (criticalPairList.hasNext() && !bl) {
            int n5;
            CriticalPair criticalPair = criticalPairList.getNext();
            if (criticalPair == null) {
                criticalPairList.update();
                continue;
            }
            int n6 = criticalPair.i;
            int n7 = criticalPair.j;
            GenPolynomial genPolynomial6 = criticalPair.pi;
            GenPolynomial genPolynomial7 = criticalPair.pj;
            if (debug) {
                logger.info("i, pi    = {}, {}", (Object)n6, (Object)genPolynomial6);
                logger.info("j, pj    = {}, {}", (Object)n7, (Object)genPolynomial7);
            }
            arrayList2 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList2.add(null);
            }
            GenPolynomial genPolynomial8 = this.red.SPolynomial(arrayList2, n6, genPolynomial6, n7, genPolynomial7);
            if (debug) {
                logger.debug("is reduction S = {}", (Object)this.red.isReductionNF(arrayList2, list2, genPolynomialRing.getZERO(), genPolynomial8));
            }
            if (genPolynomial8.isZERO()) {
                criticalPairList.update(criticalPair, genPolynomial8);
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = {}", (Object)genPolynomial8.leadingExpVector());
            }
            arrayList3 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList3.add(null);
            }
            genPolynomial = this.red.normalform(arrayList3, list2, genPolynomial8);
            if (debug) {
                logger.debug("is reduction H = {}", (Object)this.red.isReductionNF(arrayList3, list2, genPolynomial8, genPolynomial));
            }
            if (genPolynomial.isZERO()) {
                criticalPairList.update(criticalPair, genPolynomial);
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = {}", (Object)genPolynomial.leadingExpVector());
            }
            list4 = this.blas.vectorCombineOld(arrayList2, arrayList3);
            Object object = genPolynomial.leadingBaseCoefficient();
            object = (RingElem)object.inverse();
            genPolynomial = genPolynomial.multiply(object);
            list4 = this.blas.scalarProduct(((GenPolynomial)monoidElem).multiply(object), list4);
            list4.set(list2.size(), monoidElem);
            if (genPolynomial.isONE()) {
                list2.add(genPolynomial);
                list3.add(list4);
                bl = true;
                break;
            }
            if (debug) {
                logger.debug("H = {}", genPolynomial);
            }
            list2.add(genPolynomial);
            criticalPairList.update(criticalPair, genPolynomial);
            list3.add(list4);
        }
        if (debug) {
            extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb unnorm = {}", extendedGB);
        }
        list3 = this.normalizeMatrix(list.size(), list3);
        if (debug) {
            extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb nonmin = {}", extendedGB);
            boolean bl2 = this.isReductionMatrix(extendedGB);
            logger.info("exgb t2 = {}", (Object)bl2);
        }
        extendedGB = this.minimalExtendedGB(list.size(), list2, list3);
        list2 = extendedGB.G;
        list3 = extendedGB.G2F;
        logger.debug("#sequential list = {}", (Object)list2.size());
        logger.info("{}", criticalPairList);
        for (GenPolynomial<C> genPolynomial9 : list) {
            list4 = this.blas.genVector(list2.size(), null);
            genPolynomial = this.red.normalform(list4, list2, genPolynomial9);
            if (!genPolynomial.isZERO()) {
                logger.error("nonzero H = {}", genPolynomial);
            }
            arrayList.add(list4);
        }
        extendedGB = new ExtendedGB<C>(list, list2, arrayList, list3);
        if (debug) {
            logger.info("exgb nonmin = {}", extendedGB);
            boolean bl3 = this.isReductionMatrix(extendedGB);
            logger.info("exgb t2 = {}", (Object)bl3);
        }
        return extendedGB;
    }
}

