/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TwosidedSolvableReducer<C extends RingElem<C>>
implements Runnable {
    private final List<GenSolvablePolynomial<C>> X;
    private final List<GenSolvablePolynomial<C>> G;
    private final PairList<C> pairlist;
    private final int modv;
    private final Terminator pool;
    private final SolvableReductionPar<C> sred;
    private static final Logger logger = LogManager.getLogger(TwosidedSolvableReducer.class);
    private static final boolean debug = logger.isDebugEnabled();

    TwosidedSolvableReducer(Terminator terminator, int n, List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2, PairList<C> pairList) {
        this.pool = terminator;
        this.modv = n;
        this.X = list;
        this.G = list2;
        this.pairlist = pairList;
        this.sred = new SolvableReductionPar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        logger.debug("modv = {}", (Object)this.modv);
        while (this.pairlist.hasNext() || this.pool.hasJobs()) {
            GenSolvablePolynomial genSolvablePolynomial;
            Pair<C> pair;
            while (!this.pairlist.hasNext()) {
                this.pool.beIdle();
                bl = true;
                try {
                    if (++n2 % 10 == 0) {
                        logger.info(" reducer is sleeping");
                    } else {
                        logger.debug("r");
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (this.pool.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.pool.hasJobs()) break;
            if (bl) {
                this.pool.notIdle();
                bl = false;
            }
            if ((pair = this.pairlist.removeNext()) == null) continue;
            if (debug) {
                logger.debug("pi = {}", (Object)pair.pi);
                logger.debug("pj = {}", (Object)pair.pj);
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial((GenSolvablePolynomial)pair.pi, (GenSolvablePolynomial)pair.pj)).isZERO()) continue;
            if (debug) {
                logger.debug("ht(S) = {}", (Object)genSolvablePolynomial.leadingExpVector());
            }
            GenPolynomial genPolynomial = this.sred.leftNormalform(this.G, genSolvablePolynomial);
            ++n;
            if (genPolynomial.isZERO()) continue;
            if (debug) {
                logger.debug("ht(H) = {}", (Object)genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                this.pairlist.putOne();
                List<GenSolvablePolynomial<C>> list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenSolvablePolynomial<C>)genPolynomial);
                }
                this.pool.allIdle();
                return;
            }
            if (debug) {
                logger.debug("H = {}", (Object)genPolynomial);
            }
            List<GenSolvablePolynomial<C>> list = this.G;
            synchronized (list) {
                this.G.add((GenSolvablePolynomial<C>)genPolynomial);
            }
            this.pairlist.put(genPolynomial);
            for (int i = 0; i < this.X.size(); ++i) {
                List<GenSolvablePolynomial<C>> list2;
                GenSolvablePolynomial<C> genSolvablePolynomial2 = this.X.get(i);
                GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial2);
                if ((genPolynomial2 = this.sred.leftNormalform((List<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)this.G, (GenSolvablePolynomial<GenSolvablePolynomial<C>>)genPolynomial2)).isZERO()) continue;
                if ((genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).monic()).isONE()) {
                    list2 = this.G;
                    synchronized (list2) {
                        this.G.clear();
                        this.G.add((GenSolvablePolynomial<C>)genPolynomial2);
                    }
                    this.pool.allIdle();
                    return;
                }
                list2 = this.G;
                synchronized (list2) {
                    this.G.add((GenSolvablePolynomial<C>)genPolynomial2);
                }
                this.pairlist.put(genPolynomial2);
            }
        }
        logger.info("terminated, done {} reductions", (Object)n);
    }
}

