/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBasePartial<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBasePartial.class);
    protected GroebnerBaseAbstract<C> bb;
    protected GroebnerBaseAbstract<GenPolynomial<C>> rbb;

    public GroebnerBasePartial() {
        this(new GroebnerBaseSeq(), null);
    }

    public GroebnerBasePartial(RingFactory<GenPolynomial<C>> ringFactory) {
        this(new GroebnerBaseSeq(), new GroebnerBasePseudoRecSeq<C>(ringFactory));
    }

    public GroebnerBasePartial(GroebnerBaseAbstract<C> groebnerBaseAbstract, GroebnerBaseAbstract<GenPolynomial<C>> groebnerBaseAbstract2) {
        this.bb = groebnerBaseAbstract;
        this.rbb = groebnerBaseAbstract2;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        return this.bb.GB(n, list);
    }

    public boolean isGBrec(List<GenPolynomial<GenPolynomial<C>>> list) {
        return this.isGBrec(0, list);
    }

    public boolean isGBrec(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        this.rbb = new GroebnerBasePseudoRecSeq(list.get((int)0).ring.coFac);
        return this.rbb.isGB(n, list);
    }

    public static List<Integer> partialPermutation(String[] stringArray, String[] stringArray2) {
        return GroebnerBasePartial.partialPermutation(stringArray, stringArray2, null);
    }

    public static List<Integer> getPermutation(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("aname or ename may not be null");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        for (n = 0; n < stringArray2.length; ++n) {
            int n2 = GroebnerBasePartial.indexOf(stringArray2[n], stringArray);
            if (n2 < 0) {
                throw new IllegalArgumentException("ename not contained in aname");
            }
            arrayList.add(n2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (arrayList.contains(n)) continue;
            arrayList.add(n);
        }
        n = stringArray.length - 1;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(stringArray.length);
        for (Integer n3 : arrayList) {
            arrayList2.add(n - n3);
        }
        arrayList = arrayList2;
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static int indexOf(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> partialPermutation(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n;
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("no variable names found");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray2.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            arrayList2.add(stringArray2[n]);
        }
        if (stringArray3 == null) {
            stringArray3 = GroebnerBasePartial.remainingVars(stringArray, stringArray2);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(stringArray3.length);
        for (int i = 0; i < stringArray3.length; ++i) {
            arrayList3.add(stringArray3[i]);
        }
        if (stringArray3.length + stringArray2.length == stringArray.length) {
            return GroebnerBasePartial.getPermutation(stringArray, stringArray3);
        }
        logger.info("not implemented for {} != {} cup {}", arrayList, arrayList2, arrayList3);
        throw new UnsupportedOperationException("not implemented");
    }

    public static List<Integer> partialPermutation(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        String[] stringArray5;
        if (stringArray == null || stringArray2 == null || stringArray3 == null) {
            throw new IllegalArgumentException("not all variable names given");
        }
        if (stringArray4 != null) {
            int n;
            stringArray5 = new String[stringArray3.length + stringArray4.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray5[n] = stringArray3[n];
            }
            for (n = 0; n < stringArray4.length; ++n) {
                stringArray5[stringArray3.length + n] = stringArray4[n];
            }
        } else {
            stringArray5 = stringArray3;
        }
        List<Integer> list = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, stringArray5);
        return list;
    }

    public static String[] remainingVars(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("no variable names found");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray2.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            arrayList2.add(stringArray2[n]);
        }
        if (!arrayList.containsAll(arrayList2)) {
            throw new IllegalArgumentException("partial variables not contained in all variables ");
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        for (String stringArray32 : arrayList2) {
            arrayList3.remove(stringArray32);
        }
        int n2 = stringArray.length - stringArray2.length;
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        for (String string : arrayList3) {
            stringArray3[n3++] = string;
        }
        return stringArray3;
    }

    public OptimizedPolynomialList<GenPolynomial<C>> partialGBrec(List<GenPolynomial<C>> list, String[] stringArray) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        String[] stringArray2 = genPolynomialRing.getVars();
        if (stringArray2 == null || stringArray == null) {
            throw new IllegalArgumentException("not all variable names found");
        }
        if (stringArray2.length == stringArray.length) {
            throw new IllegalArgumentException("use non recursive partialGB algorithm");
        }
        List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray2, stringArray);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.permutation(list2);
        logger.info("pfac = {}", genPolynomialRing2);
        List list3 = TermOrderOptimization.permutation(list2, genPolynomialRing2, list);
        int n = genPolynomialRing.nvar - stringArray.length;
        int n2 = stringArray.length;
        String[] stringArray3 = GroebnerBasePartial.remainingVars(stringArray2, stringArray);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing.coFac, n, genPolynomialRing.tord, stringArray3);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, n2, genPolynomialRing.tord, stringArray);
        logger.info("rfac = {}", genPolynomialRing4);
        List list4 = PolyUtil.recursive(genPolynomialRing4, list3);
        this.rbb = new GroebnerBasePseudoRecSeq(genPolynomialRing3);
        List list5 = this.rbb.GB(list4);
        OptimizedPolynomialList optimizedPolynomialList = new OptimizedPolynomialList(list2, genPolynomialRing4, list5);
        return optimizedPolynomialList;
    }

    public OptimizedPolynomialList<C> partialGB(List<GenPolynomial<C>> list, String[] stringArray) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        String[] stringArray2 = genPolynomialRing.getVars();
        List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray2, stringArray);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.permutation(list2);
        logger.info("pfac = {}", genPolynomialRing2);
        List list3 = TermOrderOptimization.permutation(list2, genPolynomialRing2, list);
        int n = genPolynomialRing.nvar - stringArray.length;
        if (n == 0) {
            List<GenPolynomial<C>> list4 = this.bb.GB(list3);
            OptimizedPolynomialList optimizedPolynomialList = new OptimizedPolynomialList(list2, genPolynomialRing2, list4);
            return optimizedPolynomialList;
        }
        int n2 = stringArray.length;
        String[] stringArray3 = GroebnerBasePartial.remainingVars(stringArray2, stringArray);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing.coFac, n, genPolynomialRing.tord, stringArray3);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, n2, genPolynomialRing.tord, stringArray);
        logger.info("rfac = {}", genPolynomialRing4);
        List list5 = PolyUtil.recursive(genPolynomialRing4, list3);
        this.rbb = new GroebnerBasePseudoRecSeq(genPolynomialRing3);
        List<GenPolynomial<GenPolynomial<C>>> list6 = this.rbb.GB(list5);
        List list7 = PolyUtil.distribute(genPolynomialRing2, list6);
        OptimizedPolynomialList optimizedPolynomialList = new OptimizedPolynomialList(list2, genPolynomialRing2, list7);
        return optimizedPolynomialList;
    }

    public OptimizedPolynomialList<C> elimPartialGB(List<GenPolynomial<C>> list, String[] stringArray, String[] stringArray2) {
        int n;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        String[] stringArray3 = genPolynomialRing.getVars();
        List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray3, stringArray, stringArray2);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.permutation(list2);
        logger.info("pfac = {}", genPolynomialRing2);
        List list3 = TermOrderOptimization.permutation(list2, genPolynomialRing2, list);
        int n2 = genPolynomialRing.nvar - stringArray.length - stringArray2.length;
        if (n2 == 0) {
            Comparable comparable2;
            TermOrder termOrder = genPolynomialRing2.tord;
            int n3 = termOrder.getEvord();
            TermOrder termOrder2 = new TermOrder(n3, n3, genPolynomialRing2.nvar, stringArray.length);
            genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing2.coFac, genPolynomialRing2.nvar, termOrder2, genPolynomialRing2.getVars());
            logger.info("pfac = {}", genPolynomialRing2);
            ArrayList arrayList = new ArrayList(list3.size());
            for (Comparable comparable2 : list3) {
                arrayList.add(genPolynomialRing2.copy(comparable2));
            }
            List<GenPolynomial<C>> list4 = this.bb.GB(arrayList);
            comparable2 = new OptimizedPolynomialList(list2, genPolynomialRing2, list4);
            logger.info("pgb = {}", comparable2);
            return comparable2;
        }
        logger.warn("not meaningful for elimination {}", (Object)n2);
        int n4 = stringArray2.length + stringArray2.length;
        String[] stringArray4 = GroebnerBasePartial.remainingVars(stringArray3, stringArray);
        stringArray4 = GroebnerBasePartial.remainingVars(stringArray4, stringArray2);
        String[] stringArray5 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray5[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray5[stringArray2.length + n] = stringArray[n];
        }
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing.coFac, n2, genPolynomialRing.tord, stringArray4);
        TermOrder termOrder = genPolynomialRing2.tord;
        int n5 = termOrder.getEvord();
        TermOrder termOrder3 = new TermOrder(n5, n5, n4, stringArray.length);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, n4, termOrder3, stringArray5);
        List list5 = PolyUtil.recursive(genPolynomialRing4, list3);
        logger.info("rfac = {}", genPolynomialRing4);
        logger.info("Fr   = {}", list5);
        this.rbb = new GroebnerBasePseudoRecSeq(genPolynomialRing3);
        List<GenPolynomial<GenPolynomial<C>>> list6 = this.rbb.GB(list5);
        List list7 = PolyUtil.distribute(genPolynomialRing2, list6);
        OptimizedPolynomialList optimizedPolynomialList = new OptimizedPolynomialList(list2, genPolynomialRing2, list7);
        return optimizedPolynomialList;
    }
}

