/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.ufd.GCDProxy;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyGBUtilTest
extends TestCase {
    TermOrder to = new TermOrder(4);
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.29f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolyGBUtilTest.suite());
        ComputerThreads.terminate();
    }

    public PolyGBUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PolyGBUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testResultantModular() {
        PrimeList primeList = new PrimeList();
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(1));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        GreatestCommonDivisorSimple<ModInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModInteger>();
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        GreatestCommonDivisorModEval greatestCommonDivisorModEval = new GreatestCommonDivisorModEval();
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = greatestCommonDivisorSimple.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial4 = greatestCommonDivisorSubres.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModEval).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            boolean bl3 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial5);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,e): " + genPolynomial5), (boolean)bl3);
        }
    }

    public void testResultantInteger() {
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        GreatestCommonDivisorSimple<BigInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<BigInteger>();
        GreatestCommonDivisorSubres<BigInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<BigInteger>();
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial3 = greatestCommonDivisorSimple.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial4 = greatestCommonDivisorSubres.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            boolean bl3 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial5);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,e): " + genPolynomial5), (boolean)bl3);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
        }
    }

    public void testResultantModularParallel() {
        PrimeList primeList = new PrimeList();
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(1));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModEval greatestCommonDivisorModEval = new GreatestCommonDivisorModEval();
        GCDProxy<ModInteger> gCDProxy = new GCDProxy<ModInteger>(greatestCommonDivisorSubres, greatestCommonDivisorSimple);
        GCDProxy gCDProxy2 = new GCDProxy(greatestCommonDivisorModEval, greatestCommonDivisorSubres);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)gCDProxy).resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial4 = ((GreatestCommonDivisorAbstract)gCDProxy2).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
        }
    }

    public void testResultantIntegerProxy() {
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        GCDProxy<BigInteger> gCDProxy = new GCDProxy<BigInteger>(greatestCommonDivisorSubres, greatestCommonDivisorSimple);
        GCDProxy<BigInteger> gCDProxy2 = new GCDProxy<BigInteger>(greatestCommonDivisorModular, greatestCommonDivisorSubres);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 1, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)gCDProxy).resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial4 = ((GreatestCommonDivisorAbstract)gCDProxy2).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
        }
    }

    public void testCoefficientBasePseudoRemainder() {
        GenPolynomial genPolynomial;
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x1", "x2"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        GenPolynomialRing<GenPolynomial<BigRational>> genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)genPolynomialRing2.coFac;
        GenPolynomial genPolynomial2 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q * 1.1f);
        GenPolynomial genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial2, genPolynomial = genPolynomialRing3.random(this.kl, this.ll + 2, this.el * 2, this.q));
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) <= genPolynomial2.degree(0) || genPolynomial2.degree(0) == 0L ? 1 : 0) != 0);
        PolyGBUtilTest.assertTrue((String)"deg(lfcd(c)) < deg(b): ", (genPolynomial3.leadingBaseCoefficient().degree(0) < genPolynomial.degree(0) || genPolynomial.degree(0) == 0L ? 1 : 0) != 0);
        GenPolynomial genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial4, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"c == 0: ", (boolean)genPolynomial3.isZERO());
        long l = genPolynomial2.degree(0);
        GenPolynomial genPolynomial5 = genPolynomialRing2.univariate(0, l + 1L);
        genPolynomial5 = genPolynomial5.multiply(genPolynomial.multiply(genPolynomial));
        genPolynomial5 = genPolynomial5.sum(genPolynomial2);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial5, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) < genPolynomial5.degree(0) ? 1 : 0) != 0);
    }

    public void testCoefficientRecursivePseudoRemainder() {
        GenPolynomial<GenPolynomial<Element>> genPolynomial;
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x1", "x2", "x3"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        GenPolynomialRing<GenPolynomial<BigRational>> genPolynomialRing2 = genPolynomialRing.recursive(2);
        GenPolynomialRing<GenPolynomial<GenPolynomial<BigRational>>> genPolynomialRing3 = genPolynomialRing2.recursive(1);
        GenPolynomialRing genPolynomialRing4 = (GenPolynomialRing)genPolynomialRing3.coFac;
        GenPolynomial genPolynomial2 = genPolynomialRing3.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial2, genPolynomial = genPolynomialRing4.random(this.kl, this.ll + 2, this.el, this.q));
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) <= genPolynomial2.degree(0) || genPolynomial2.degree(0) == 0L ? 1 : 0) != 0);
        PolyGBUtilTest.assertTrue((String)"deg(lfcd(c)) < deg(b): ", (genPolynomial3.leadingBaseCoefficient().degree(0) < genPolynomial.degree(0) || genPolynomial.degree(0) == 0L ? 1 : 0) != 0);
        GenPolynomial genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial4, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"c == 0: ", (boolean)genPolynomial3.isZERO());
        long l = genPolynomial2.degree(0);
        GenPolynomial genPolynomial5 = genPolynomialRing3.univariate(0, l + 1L);
        genPolynomial5 = genPolynomial5.multiply(genPolynomial.multiply((GenPolynomial<Element>)genPolynomialRing4.fromInteger(100L)));
        genPolynomial5 = genPolynomial5.sum(genPolynomial2);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial5, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) < genPolynomial5.degree(0) ? 1 : 0) != 0);
    }

    public void testSubRing() {
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to);
        AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        AbelianGroupElem abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        GenPolynomial<AbelianGroupElem> genPolynomial = ((GenPolynomial)abelianGroupElem).multiply(abelianGroupElem2).sum(abelianGroupElem2);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(abelianGroupElem);
        arrayList.add(abelianGroupElem2);
        List list = PolyGBUtil.subRing(arrayList);
        boolean bl = PolyGBUtil.subRingMember(list, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"d in SR: ", (boolean)bl);
        AbelianGroupElem abelianGroupElem3 = genPolynomialRing.random(this.kl, this.ll, this.el + this.el, this.q * 1.5f).abs();
        arrayList.add(abelianGroupElem3);
        genPolynomial = ((GenPolynomial)abelianGroupElem).multiply(abelianGroupElem2).sum(abelianGroupElem3);
        bl = PolyGBUtil.subRingAndMember(arrayList, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"d in SR: ", (boolean)bl);
    }

    public void testCRTrandom() {
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, stringArray);
        ArrayList arrayList = new ArrayList(2);
        ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>(2);
        AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        AbelianGroupElem abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        arrayList2.add(abelianGroupElem);
        arrayList2.add(abelianGroupElem2);
        arrayList.add(arrayList2);
        ArrayList<AbelianGroupElem> arrayList3 = new ArrayList<AbelianGroupElem>(2);
        abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        arrayList3.add(abelianGroupElem);
        arrayList3.add(abelianGroupElem2);
        arrayList.add(arrayList3);
        ArrayList arrayList4 = new ArrayList(2);
        abelianGroupElem = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.q).abs();
        arrayList4.add(abelianGroupElem);
        arrayList4.add(abelianGroupElem2);
        GenPolynomial genPolynomial = PolyGBUtil.chineseRemainderTheorem(arrayList, arrayList4);
        PolyGBUtilTest.assertTrue((String)"h == null or deg(h) >= 0: ", (genPolynomial == null || genPolynomial.degree() >= 0L ? 1 : 0) != 0);
        if (genPolynomial == null) {
            return;
        }
        PolyGBUtilTest.assertTrue((String)("isChineseRemainder " + genPolynomial), (boolean)PolyGBUtil.isChineseRemainder(arrayList, arrayList4, genPolynomial));
    }

    public void testCRTrandomInt() {
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to, stringArray);
        ArrayList arrayList = new ArrayList(2);
        ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>(2);
        AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        AbelianGroupElem abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        arrayList2.add(abelianGroupElem);
        arrayList2.add(abelianGroupElem2);
        arrayList.add(arrayList2);
        ArrayList<AbelianGroupElem> arrayList3 = new ArrayList<AbelianGroupElem>(2);
        abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        arrayList3.add(abelianGroupElem);
        arrayList3.add(abelianGroupElem2);
        arrayList.add(arrayList3);
        ArrayList arrayList4 = new ArrayList(2);
        abelianGroupElem = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.q).abs();
        arrayList4.add(abelianGroupElem);
        arrayList4.add(abelianGroupElem2);
        GenPolynomial genPolynomial = PolyGBUtil.chineseRemainderTheorem(arrayList, arrayList4);
        if (genPolynomial == null) {
            return;
        }
        PolyGBUtilTest.assertTrue((String)"h == null or deg(h) >= 0: ", (genPolynomial == null || genPolynomial.degree() >= 0L ? 1 : 0) != 0);
    }

    public void testCRTLagrange() {
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, stringArray);
        ArrayList arrayList = new ArrayList(2);
        ArrayList<Element> arrayList2 = new ArrayList<Element>(3);
        Element element = genPolynomialRing.parse("(x-(2**16-15))");
        arrayList2.add(element);
        Element element2 = genPolynomialRing.parse("(y-13)");
        arrayList2.add(element2);
        Element element3 = genPolynomialRing.parse("(z-169)");
        arrayList2.add(element3);
        arrayList.add(arrayList2);
        ArrayList<Element> arrayList3 = new ArrayList<Element>(3);
        element = genPolynomialRing.parse("(x-7)");
        arrayList3.add(element);
        element2 = genPolynomialRing.parse("(y-(2**32-5))");
        arrayList3.add(element2);
        element3 = genPolynomialRing.parse("(z-101)");
        arrayList3.add(element3);
        arrayList.add(arrayList3);
        ArrayList<Element> arrayList4 = new ArrayList<Element>(3);
        element = genPolynomialRing.parse("(x-17)");
        arrayList4.add(element);
        element2 = genPolynomialRing.parse("(y-23)");
        arrayList4.add(element2);
        element3 = genPolynomialRing.parse("(z-(2**15-19))");
        arrayList4.add(element3);
        arrayList.add(arrayList4);
        ArrayList arrayList5 = new ArrayList(2);
        element = genPolynomialRing.parse("(4)");
        element2 = genPolynomialRing.parse("(11)");
        element3 = genPolynomialRing.parse("(103)");
        arrayList5.add(element);
        arrayList5.add(element2);
        arrayList5.add(element3);
        GenPolynomial genPolynomial = PolyGBUtil.chineseRemainderTheorem(arrayList, arrayList5);
        PolyGBUtilTest.assertTrue((String)"h == null or deg(h) >= 0: ", (genPolynomial == null || genPolynomial.degree() >= 0L ? 1 : 0) != 0);
        if (genPolynomial == null) {
            return;
        }
        PolyGBUtilTest.assertTrue((String)("isChineseRemainder " + genPolynomial), (boolean)PolyGBUtil.isChineseRemainder(arrayList, arrayList5, genPolynomial));
    }

    public void testCRTLagrangeInt() {
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to, stringArray);
        ArrayList arrayList = new ArrayList(2);
        ArrayList<Element> arrayList2 = new ArrayList<Element>(3);
        Element element = genPolynomialRing.parse("(x-(2**16-15))");
        arrayList2.add(element);
        Element element2 = genPolynomialRing.parse("(y-13)");
        arrayList2.add(element2);
        Element element3 = genPolynomialRing.parse("(z-169)");
        arrayList2.add(element3);
        arrayList.add(arrayList2);
        ArrayList<Element> arrayList3 = new ArrayList<Element>(3);
        element = genPolynomialRing.parse("(x-7)");
        arrayList3.add(element);
        element2 = genPolynomialRing.parse("(y-(2**32-5))");
        arrayList3.add(element2);
        element3 = genPolynomialRing.parse("(z-101)");
        arrayList3.add(element3);
        arrayList.add(arrayList3);
        ArrayList<Element> arrayList4 = new ArrayList<Element>(3);
        element = genPolynomialRing.parse("(x-17)");
        arrayList4.add(element);
        element2 = genPolynomialRing.parse("(y-23)");
        arrayList4.add(element2);
        element3 = genPolynomialRing.parse("(z-(2**15-19))");
        arrayList4.add(element3);
        arrayList.add(arrayList4);
        ArrayList arrayList5 = new ArrayList(2);
        element = genPolynomialRing.parse("(4)");
        element2 = genPolynomialRing.parse("(11)");
        element3 = genPolynomialRing.parse("(103)");
        arrayList5.add(element);
        arrayList5.add(element2);
        arrayList5.add(element3);
        GenPolynomial genPolynomial = PolyGBUtil.chineseRemainderTheorem(arrayList, arrayList5);
        PolyGBUtilTest.assertTrue((String)"deg(h) > 0: ", (genPolynomial.degree() > 0L ? 1 : 0) != 0);
    }

    public void testCRTnterpolation() {
        String[] stringArray = new String[]{"x", "y", "z"};
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        ArrayList arrayList = new ArrayList(3);
        ArrayList<BigRational> arrayList2 = new ArrayList<BigRational>(3);
        BigRational bigRational2 = bigRational.parse("65521");
        arrayList2.add(bigRational2);
        BigRational bigRational3 = bigRational.parse("13");
        arrayList2.add(bigRational3);
        BigRational bigRational4 = bigRational.parse("169");
        arrayList2.add(bigRational4);
        arrayList.add(arrayList2);
        ArrayList<BigRational> arrayList3 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("7");
        arrayList3.add(bigRational2);
        bigRational3 = bigRational.parse("4294967291");
        arrayList3.add(bigRational3);
        bigRational4 = bigRational.parse("101");
        arrayList3.add(bigRational4);
        arrayList.add(arrayList3);
        ArrayList<BigRational> arrayList4 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("17");
        arrayList4.add(bigRational2);
        bigRational3 = bigRational.parse("23");
        arrayList4.add(bigRational3);
        bigRational4 = bigRational.parse("32749");
        arrayList4.add(bigRational4);
        arrayList.add(arrayList4);
        ArrayList<BigRational> arrayList5 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("27");
        arrayList5.add(bigRational2);
        bigRational3 = bigRational.parse("33");
        arrayList5.add(bigRational3);
        bigRational4 = bigRational.parse("42749");
        arrayList5.add(bigRational4);
        arrayList.add(arrayList5);
        ArrayList<BigRational> arrayList6 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("37");
        arrayList6.add(bigRational2);
        bigRational3 = bigRational.parse("43");
        arrayList6.add(bigRational3);
        bigRational4 = bigRational.parse("22749");
        arrayList6.add(bigRational4);
        arrayList.add(arrayList6);
        ArrayList<BigRational> arrayList7 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("47");
        arrayList7.add(bigRational2);
        bigRational3 = bigRational.parse("53");
        arrayList7.add(bigRational3);
        bigRational4 = bigRational.parse("12749");
        arrayList7.add(bigRational4);
        arrayList.add(arrayList7);
        ArrayList<BigRational> arrayList8 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("57");
        arrayList8.add(bigRational2);
        bigRational3 = bigRational.parse("63");
        arrayList8.add(bigRational3);
        bigRational4 = bigRational.parse("2749");
        arrayList8.add(bigRational4);
        arrayList.add(arrayList8);
        ArrayList<BigRational> arrayList9 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("67");
        arrayList9.add(bigRational2);
        bigRational3 = bigRational.parse("93");
        arrayList9.add(bigRational3);
        bigRational4 = bigRational.parse("749");
        arrayList9.add(bigRational4);
        arrayList.add(arrayList9);
        ArrayList<BigRational> arrayList10 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("77");
        arrayList10.add(bigRational2);
        bigRational3 = bigRational.parse("103");
        arrayList10.add(bigRational3);
        bigRational4 = bigRational.parse("49");
        arrayList10.add(bigRational4);
        arrayList.add(arrayList10);
        ArrayList<BigRational> arrayList11 = new ArrayList<BigRational>(3);
        bigRational2 = bigRational.parse("4");
        bigRational3 = bigRational.parse("11");
        bigRational4 = bigRational.parse("103");
        arrayList11.add(bigRational2);
        arrayList11.add(bigRational3);
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("13");
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("23");
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("91");
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("81");
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("72");
        arrayList11.add(bigRational4);
        bigRational4 = bigRational.parse("102");
        arrayList11.add(bigRational4);
        GenPolynomial<BigRational> genPolynomial = PolyGBUtil.CRTInterpolation(genPolynomialRing, arrayList, arrayList11);
        PolyGBUtilTest.assertTrue((String)"deg(h) > 0: ", (genPolynomial.degree() > 0L ? 1 : 0) != 0);
    }
}

