/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.ReductionAbstract;
import edu.jas.gbufd.RReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RReductionSeq<C extends RegularRingElem<C>>
extends ReductionAbstract<C>
implements RReduction<C> {
    private static final Logger logger = LogManager.getLogger(RReductionSeq.class);
    private static final boolean debug = logger.isDebugEnabled();

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = genPolynomial.leadingExpVector();
        RegularRingElem<RegularRingElem> regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
        regularRingElem = regularRingElem.idempotent();
        for (GenPolynomial<C> genPolynomial2 : list) {
            RegularRingElem regularRingElem2;
            RegularRingElem regularRingElem3;
            bl = expVector.multipleOf(genPolynomial2.leadingExpVector());
            if (!bl || !(bl = !(regularRingElem3 = regularRingElem.idempotentAnd(regularRingElem2 = (RegularRingElem)genPolynomial2.leadingBaseCoefficient())).isZERO())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStrongTopReducible(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = genPolynomial.leadingExpVector();
        RegularRingElem regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
        regularRingElem = regularRingElem.idempotent();
        for (GenPolynomial<C> genPolynomial2 : list) {
            RegularRingElem regularRingElem2;
            bl = expVector.multipleOf(genPolynomial2.leadingExpVector());
            if (!bl || !(bl = regularRingElem.equals((regularRingElem2 = (RegularRingElem)genPolynomial2.leadingBaseCoefficient()).idempotent()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> expVectorArray, GenPolynomial<C> genPolynomial) {
        if (expVectorArray == null || expVectorArray.isEmpty()) {
            return true;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        ExpVector[] expVectorArray2 = expVectorArray;
        synchronized (expVectorArray) {
            int n;
            int n2 = expVectorArray.size();
            GenPolynomial[] genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < expVectorArray.size(); ++i) {
                genPolynomialArray[i] = expVectorArray.get(i);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            expVectorArray2 = new ExpVector[n2];
            RegularRingElem[] regularRingElemArray = new RegularRingElem[n2];
            GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                if (genPolynomialArray[n] == null) continue;
                genPolynomialArray2[n] = genPolynomialArray[n];
                Map.Entry entry = genPolynomialArray2[n].leadingMonomial();
                if (entry == null) continue;
                genPolynomialArray2[n3] = genPolynomialArray2[n];
                expVectorArray2[n3] = entry.getKey();
                regularRingElemArray[n3] = (RegularRingElem)entry.getValue();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            SortedMap<ExpVector, C> sortedMap = genPolynomial.getMap();
            for (Map.Entry entry : sortedMap.entrySet()) {
                ExpVector expVector = (ExpVector)entry.getKey();
                RegularRingElem regularRingElem = (RegularRingElem)entry.getValue();
                for (n = 0; n < n2; ++n) {
                    bl = expVector.multipleOf(expVectorArray2[n]);
                    if (!bl) continue;
                    RegularRingElem regularRingElem2 = regularRingElem.idempotentAnd(regularRingElemArray[n]);
                    boolean bl2 = bl = !regularRingElem2.isZERO();
                    if (!bl) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        int n;
        GenPolynomial[] genPolynomialArray;
        int n2;
        if (list == null || list.isEmpty()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        Map.Entry<ExpVector, C> entry = list;
        synchronized (entry) {
            n2 = list.size();
            genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < list.size(); ++i) {
                genPolynomialArray[i] = list.get(i);
            }
        }
        ExpVector[] expVectorArray = new ExpVector[n2];
        RegularRingElem[] regularRingElemArray = new RegularRingElem[n2];
        GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (genPolynomialArray[n] == null) continue;
            genPolynomialArray2[n] = genPolynomialArray[n];
            entry = genPolynomialArray2[n].leadingMonomial();
            if (entry == null) continue;
            genPolynomialArray2[n3] = genPolynomialArray2[n];
            expVectorArray[n3] = entry.getKey();
            regularRingElemArray[n3] = (RegularRingElem)entry.getValue();
            ++n3;
        }
        n2 = n3;
        RegularRingElem regularRingElem = null;
        boolean bl = false;
        GenPolynomial<RegularRingElem> genPolynomial2 = genPolynomial.ring.getZERO();
        GenPolynomial<RegularRingElem> genPolynomial3 = null;
        GenPolynomial<Object> genPolynomial4 = genPolynomial;
        while (genPolynomial4.length() > 0) {
            entry = genPolynomial4.leadingMonomial();
            ExpVector expVector = entry.getKey();
            RegularRingElem regularRingElem2 = (RegularRingElem)entry.getValue();
            if (debug && regularRingElem2.isZERO()) {
                throw new RuntimeException("a.isZERO(): S = " + genPolynomial4);
            }
            for (n = 0; n < n2; ++n) {
                bl = expVector.multipleOf(expVectorArray[n]);
                if (!bl) continue;
                regularRingElem = regularRingElem2.idempotentAnd(regularRingElemArray[n]);
                boolean bl2 = bl = !regularRingElem.isZERO();
                if (!bl) continue;
                RegularRingElem regularRingElem3 = regularRingElem2.divide(regularRingElemArray[n]);
                if (regularRingElem3.isZERO()) {
                    System.out.println("b == zero: r = " + regularRingElem);
                    continue;
                }
                ExpVector expVector2 = expVector.subtract(expVectorArray[n]);
                genPolynomial3 = genPolynomialArray2[n].multiply(regularRingElem3, expVector2);
                if (!expVector.equals(expVector2 = (genPolynomial4 = genPolynomial4.subtract((Object)genPolynomial3)).leadingExpVector())) {
                    regularRingElem2 = (RegularRingElem)genPolynomial.ring.coFac.getZERO();
                    break;
                }
                regularRingElem2 = (RegularRingElem)genPolynomial4.leadingBaseCoefficient();
            }
            if (regularRingElem2.isZERO()) continue;
            genPolynomial2 = genPolynomial2.sum(regularRingElem2, expVector);
            genPolynomial4 = genPolynomial4.reductum();
        }
        return genPolynomial2;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, ExpVector expVector) {
        RegularRingElem regularRingElem;
        RegularRingElem regularRingElem2;
        RegularRingElem regularRingElem3;
        ExpVector expVector2;
        ExpVector expVector3;
        ExpVector expVector4;
        ExpVector expVector5;
        int n;
        if (logger.isInfoEnabled()) {
            if (!genPolynomial.ring.equals(genPolynomial2.ring)) {
                logger.error("rings equal");
            }
            if (genPolynomial instanceof GenSolvablePolynomial || genPolynomial2 instanceof GenSolvablePolynomial) {
                logger.error("GBCriterion4 not applicabable to SolvablePolynomials");
                return true;
            }
        }
        return (n = (expVector5 = (expVector4 = (expVector3 = genPolynomial.leadingExpVector()).sum(expVector2 = genPolynomial2.leadingExpVector())).subtract(expVector)).signum()) != 0 || !(regularRingElem3 = (regularRingElem2 = (RegularRingElem)genPolynomial.leadingBaseCoefficient()).multiply(regularRingElem = (RegularRingElem)genPolynomial2.leadingBaseCoefficient())).isZERO();
    }

    @Override
    public boolean criterion4(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        RegularRingElem regularRingElem;
        RegularRingElem regularRingElem2;
        RegularRingElem regularRingElem3;
        ExpVector expVector;
        ExpVector expVector2;
        if (logger.isInfoEnabled() && (genPolynomial instanceof GenSolvablePolynomial || genPolynomial2 instanceof GenSolvablePolynomial)) {
            logger.error("GBCriterion4 not applicabable to SolvablePolynomials");
            return true;
        }
        ExpVector expVector3 = genPolynomial.leadingExpVector();
        ExpVector expVector4 = expVector3.sum(expVector2 = genPolynomial2.leadingExpVector());
        ExpVector expVector5 = expVector4.subtract(expVector = expVector3.lcm(expVector2));
        int n = expVector5.signum();
        return n != 0 || !(regularRingElem3 = (regularRingElem2 = (RegularRingElem)genPolynomial.leadingBaseCoefficient()).multiply(regularRingElem = (RegularRingElem)genPolynomial2.leadingBaseCoefficient())).isZERO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenPolynomial<C> normalform(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2, GenPolynomial<C> genPolynomial) {
        int n;
        GenPolynomial[] genPolynomialArray;
        int n2;
        if (list2 == null || list2.isEmpty()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        Map.Entry<ExpVector, C> entry = list2;
        synchronized (entry) {
            n2 = list2.size();
            genPolynomialArray = new GenPolynomial[n2];
            for (int i = 0; i < list2.size(); ++i) {
                genPolynomialArray[i] = list2.get(i);
            }
        }
        ExpVector[] expVectorArray = new ExpVector[n2];
        RegularRingElem[] regularRingElemArray = new RegularRingElem[n2];
        GenPolynomial[] genPolynomialArray2 = new GenPolynomial[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            genPolynomialArray2[n] = genPolynomialArray[n];
            entry = genPolynomialArray2[n].leadingMonomial();
            if (entry == null) continue;
            genPolynomialArray2[n3] = genPolynomialArray2[n];
            expVectorArray[n3] = (ExpVector)entry.getKey();
            regularRingElemArray[n3] = (RegularRingElem)entry.getValue();
            ++n3;
        }
        n2 = n3;
        RegularRingElem regularRingElem = null;
        boolean bl = false;
        GenPolynomial<RegularRingElem> genPolynomial2 = null;
        AbelianGroupElem abelianGroupElem = genPolynomial.ring.getZERO();
        GenPolynomial<RegularRingElem> genPolynomial3 = genPolynomial.ring.getZERO();
        GenPolynomial<RegularRingElem> genPolynomial4 = null;
        GenPolynomial<Object> genPolynomial5 = genPolynomial;
        while (genPolynomial5.length() > 0) {
            entry = genPolynomial5.leadingMonomial();
            ExpVector expVector = entry.getKey();
            RegularRingElem regularRingElem2 = (RegularRingElem)entry.getValue();
            for (n = 0; n < n2; ++n) {
                bl = expVector.multipleOf(expVectorArray[n]);
                if (!bl) continue;
                regularRingElem = regularRingElem2.idempotentAnd(regularRingElemArray[n]);
                boolean bl2 = bl = !regularRingElem.isZERO();
                if (!bl) continue;
                if ((regularRingElem2 = regularRingElem2.divide(regularRingElemArray[n])).isZERO()) {
                    System.out.println("b == zero: r = " + regularRingElem);
                    continue;
                }
                ExpVector expVector2 = expVector.subtract(expVectorArray[n]);
                genPolynomial4 = genPolynomialArray2[n].multiply(regularRingElem2, expVector2);
                genPolynomial5 = genPolynomial5.subtract((Object)genPolynomial4);
                genPolynomial2 = list.get(n);
                genPolynomial2 = genPolynomial2 == null ? ((GenPolynomial)abelianGroupElem).sum(regularRingElem2, expVector2) : genPolynomial2.sum(regularRingElem2, expVector2);
                list.set(n, genPolynomial2);
                expVector2 = genPolynomial5.leadingExpVector();
                if (!expVector.equals(expVector2)) {
                    regularRingElem2 = (RegularRingElem)genPolynomial.ring.coFac.getZERO();
                    break;
                }
                regularRingElem2 = (RegularRingElem)genPolynomial5.leadingBaseCoefficient();
            }
            if (regularRingElem2.isZERO()) continue;
            genPolynomial3 = genPolynomial3.sum(regularRingElem2, expVector);
            genPolynomial5 = genPolynomial5.reductum();
        }
        return genPolynomial3;
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (list == null) {
            return null;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            arrayList.add(genPolynomial);
        }
        int n = arrayList.size();
        if (n <= 1) {
            return arrayList;
        }
        int n2 = 0;
        logger.debug("irr = ");
        while (n2 != n) {
            GenPolynomial<C> genPolynomial = arrayList.remove(0);
            ExpVector expVector = genPolynomial.leadingExpVector();
            genPolynomial = this.normalform(arrayList, genPolynomial);
            logger.debug(String.valueOf(n2));
            if (genPolynomial.isZERO()) {
                if (--n > 1) continue;
                return arrayList;
            }
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            n2 = expVector.equals(expVector2) ? ++n2 : 0;
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isBooleanClosed(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        RegularRingElem regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
        Object c = regularRingElem.idempotent();
        GenPolynomial<C> genPolynomial2 = genPolynomial.multiply(c);
        return genPolynomial.equals(genPolynomial2);
    }

    @Override
    public boolean isBooleanClosed(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial == null || genPolynomial.isZERO() || this.isBooleanClosed(genPolynomial)) continue;
            return false;
        }
        return true;
    }

    public boolean isReducedBooleanClosed(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial == null) continue;
            while (!genPolynomial.isZERO()) {
                if (!this.isBooleanClosed(genPolynomial)) {
                    GenPolynomial<C> genPolynomial2 = this.booleanClosure(genPolynomial);
                    if (!(genPolynomial2 = this.normalform(list, genPolynomial2)).isZERO()) {
                        return false;
                    }
                }
                GenPolynomial<C> genPolynomial3 = this.booleanRemainder(genPolynomial);
                if (!(genPolynomial3 = this.normalform(list, genPolynomial3)).isZERO()) {
                    return false;
                }
                genPolynomial = genPolynomial3;
            }
        }
        return true;
    }

    @Override
    public GenPolynomial<C> booleanClosure(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        RegularRingElem regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
        Object c = regularRingElem.idempotent();
        GenPolynomial<C> genPolynomial2 = genPolynomial.multiply(c);
        return genPolynomial2;
    }

    @Override
    public GenPolynomial<C> booleanRemainder(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        RegularRingElem regularRingElem = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
        Object c = regularRingElem.idemComplement();
        GenPolynomial<C> genPolynomial2 = genPolynomial.multiply(c);
        return genPolynomial2;
    }

    @Override
    public List<GenPolynomial<C>> booleanClosure(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial == null) continue;
            while (!genPolynomial.isZERO()) {
                GenPolynomial<C> genPolynomial2 = this.booleanClosure(genPolynomial);
                arrayList.add(genPolynomial2);
                genPolynomial = this.booleanRemainder(genPolynomial);
            }
        }
        return arrayList;
    }

    @Override
    public List<GenPolynomial<C>> reducedBooleanClosure(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        int n = arrayList.size();
        block0: for (int i = 0; i < n; ++i) {
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> genPolynomial = (GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)arrayList.remove(0);
            if (genPolynomial == null) continue;
            while (!genPolynomial.isZERO()) {
                GenPolynomial<C> genPolynomial2 = this.booleanClosure(genPolynomial);
                if ((genPolynomial2 = this.booleanClosure(this.normalform(arrayList, genPolynomial2))).isZERO()) continue block0;
                arrayList.add(genPolynomial2);
                GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> genPolynomial3 = genPolynomial.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)genPolynomial2);
                genPolynomial = genPolynomial3 = this.normalform(arrayList, genPolynomial3);
            }
        }
        return arrayList;
    }

    @Override
    public List<GenPolynomial<C>> reducedBooleanClosure(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return arrayList;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomial;
        while (!genPolynomial2.isZERO()) {
            GenPolynomial<C> genPolynomial3 = this.booleanClosure(genPolynomial2);
            if ((genPolynomial3 = this.booleanClosure(this.normalform(list, genPolynomial3))).isZERO()) break;
            arrayList.add(genPolynomial3);
            GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial2.subtract(genPolynomial3);
            genPolynomial4 = this.normalform(list, genPolynomial4);
            genPolynomial2 = genPolynomial4;
        }
        return arrayList;
    }
}

