/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.Syzygy;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.vector.BasicLinAlg;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SyzygyAbstract<C extends GcdRingElem<C>>
implements Syzygy<C> {
    private static final Logger logger = LogManager.getLogger(SyzygyAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected Reduction<C> red = new ReductionSeq();
    protected BasicLinAlg<GenPolynomial<C>> blas = new BasicLinAlg();

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(List<GenPolynomial<C>> list) {
        return this.zeroRelations(0, list);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int n, List<GenPolynomial<C>> list) {
        AbelianGroupElem<Object> abelianGroupElem;
        ArrayList<List<GenPolynomial<C>>> arrayList = new ArrayList<List<GenPolynomial<C>>>();
        if (list == null) {
            return arrayList;
        }
        GenVectorModul genVectorModul = null;
        int n2 = 0;
        while (genVectorModul == null && n2 < list.size()) {
            abelianGroupElem = list.get(n2);
            if (abelianGroupElem == null) continue;
            genVectorModul = new GenVectorModul(((GenPolynomial)abelianGroupElem).ring, list.size());
        }
        if (genVectorModul == null) {
            return arrayList;
        }
        abelianGroupElem = genVectorModul.fromList(list);
        return this.zeroRelations(n, (GenVector<GenPolynomial<C>>)abelianGroupElem);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int n, GenVector<GenPolynomial<C>> genVector) {
        ArrayList<List<GenPolynomial<C>>> arrayList = new ArrayList<List<GenPolynomial<C>>>();
        GenVectorModul genVectorModul = genVector.modul;
        List list = genVector.val;
        AbelianGroupElem abelianGroupElem = genVectorModul.getZERO();
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial genPolynomial = (GenPolynomial)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial genPolynomial2 = (GenPolynomial)list.get(j);
                if (!this.red.moduleCriterion(n, genPolynomial, genPolynomial2)) continue;
                List list2 = ((GenVector)((GenVector)abelianGroupElem).copy()).val;
                GenPolynomial<C> genPolynomial3 = this.red.SPolynomial(list2, i, genPolynomial, j, genPolynomial2);
                if (genPolynomial3.isZERO()) {
                    arrayList.add(list2);
                    continue;
                }
                GenPolynomial<C> genPolynomial4 = this.red.normalform(list2, list, genPolynomial3);
                if (!genPolynomial4.isZERO()) {
                    throw new RuntimeException("Syzygy no GB");
                }
                if (debug) {
                    logger.info("row = {}", (Object)list2.size());
                }
                arrayList.add(list2);
            }
        }
        return arrayList;
    }

    @Override
    public ModuleList<C> zeroRelations(ModuleList<C> moduleList) {
        ModuleList<C> moduleList2 = moduleList;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        AbelianGroupElem abelianGroupElem = moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        List list = this.zeroRelations(n, polynomialList.list);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = list.get(i);
            ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>();
            for (int j = 0; j < list2.size(); ++j) {
                GenPolynomial genPolynomial = list2.get(j);
                if (genPolynomial == null) continue;
                Map map = genPolynomial.contract(moduleList.ring);
                int n2 = 0;
                for (GenPolynomial genPolynomial2 : map.values()) {
                    arrayList2.add(genPolynomial2);
                    ++n2;
                }
                if (n2 == 0) {
                    arrayList2.add(abelianGroupElem);
                    continue;
                }
                if (n2 <= true) continue;
                System.out.println("p = " + genPolynomial);
                System.out.println("map(" + i + "," + j + ") = " + map + ", size = " + map.size());
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList(moduleList.ring, arrayList);
        return moduleList2;
    }

    @Override
    public boolean isZeroRelation(List<List<GenPolynomial<C>>> list, List<GenPolynomial<C>> list2) {
        for (List<GenPolynomial<C>> list3 : list) {
            GenPolynomial<C> genPolynomial = this.blas.scalarProduct(list3, list2);
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            logger.info("is not ZeroRelation = {}", (Object)genPolynomial.toString(genPolynomial.ring.getVars()));
            logger.info("row = {}", list3);
            return false;
        }
        return true;
    }

    @Override
    public boolean isZeroRelation(ModuleList<C> moduleList, ModuleList<C> moduleList2) {
        if (moduleList == null || moduleList.list == null) {
            return true;
        }
        for (List list : moduleList.list) {
            List list2 = this.blas.leftScalarProduct(list, moduleList2.list);
            if (this.blas.isZero(list2)) continue;
            logger.info("is not ZeroRelation ({}) = {}", (Object)list2.size(), list2);
            return false;
        }
        return true;
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(List<GenPolynomial<C>> list) {
        return this.zeroRelationsArbitrary(0, list);
    }

    @Override
    public ModuleList<C> zeroRelationsArbitrary(ModuleList<C> moduleList) {
        ModuleList<C> moduleList2 = moduleList;
        if (moduleList == null || moduleList.list == null) {
            return moduleList2;
        }
        if (moduleList.rows == 0 || moduleList.cols == 0) {
            return moduleList2;
        }
        AbelianGroupElem abelianGroupElem = moduleList.ring.getZERO();
        PolynomialList<C> polynomialList = moduleList.getPolynomialList();
        int n = moduleList.cols;
        List list = this.zeroRelationsArbitrary(n, polynomialList.list);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = list.get(i);
            ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>();
            for (int j = 0; j < list2.size(); ++j) {
                GenPolynomial genPolynomial = list2.get(j);
                if (genPolynomial == null) continue;
                Map map = genPolynomial.contract(moduleList.ring);
                int n2 = 0;
                for (GenPolynomial genPolynomial2 : map.values()) {
                    arrayList2.add(genPolynomial2);
                    ++n2;
                }
                if (n2 == 0) {
                    arrayList2.add(abelianGroupElem);
                    continue;
                }
                if (n2 <= true) continue;
                System.out.println("p = " + genPolynomial);
                System.out.println("map(" + i + "," + j + ") = " + map + ", size = " + map.size());
                throw new RuntimeException("Map.size() > 1 = " + map.size());
            }
            arrayList.add(arrayList2);
        }
        moduleList2 = new ModuleList(moduleList.ring, arrayList);
        return moduleList2;
    }
}

