/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.LogIntegral;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.PartialFraction;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementaryIntegrationBernoulli<C extends GcdRingElem<C>>
extends ElementaryIntegration<C> {
    private static final Logger logger = LogManager.getLogger(ElementaryIntegrationBernoulli.class);

    public ElementaryIntegrationBernoulli(RingFactory<C> ringFactory) {
        super(ringFactory);
        if (!(this.irr instanceof FactorAbsolute)) {
            logger.error("no absolute factorization available for coefficient ring {}", ringFactory);
            throw new IllegalArgumentException("no absolute factorization available for coefficient ring " + ringFactory);
        }
        this.irredLogPart = true;
    }

    @Override
    public LogIntegral<C> integrateLogPart(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("P == null or P == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + genPolynomialRing);
        }
        ArrayList<GcdRingElem> arrayList = new ArrayList<GcdRingElem>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add((GcdRingElem)genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        PartialFraction<C> partialFraction = ((FactorAbsolute)this.irr).baseAlgebraicPartialFraction(genPolynomial, genPolynomial2);
        return new LogIntegral<C>(genPolynomial, genPolynomial2, partialFraction.cfactors, partialFraction.cdenom, partialFraction.afactors, partialFraction.adenom);
    }
}

