/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.LocalTimeStatus;
import edu.jas.kern.TimeExceededException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalTimeStatusTest
extends TestCase {
    LocalTimeStatus lt1;
    LocalTimeStatus lt2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LocalTimeStatusTest.suite());
    }

    public LocalTimeStatusTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(LocalTimeStatusTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.lt1 = new LocalTimeStatus();
        this.lt2 = new LocalTimeStatus(true, 0L, true);
    }

    protected void tearDown() {
        this.lt1.setNotActive();
        this.lt1.setLimit(Long.MAX_VALUE);
        this.lt1.setCallBack(null);
        this.lt2 = null;
    }

    public void testCheckTime() {
        this.lt1.setActive();
        LocalTimeStatusTest.assertTrue((String)"is active lt1", (boolean)this.lt1.isActive());
        LocalTimeStatusTest.assertTrue((String)"is active lt2", (boolean)this.lt2.isActive());
        this.lt1.restart();
        try {
            this.lt1.checkTime("test1");
            this.lt2.checkTime("test1-2");
        }
        catch (TimeExceededException timeExceededException) {
            LocalTimeStatusTest.fail((String)("test1 " + timeExceededException));
        }
        this.lt1.setLimit(0L);
        LocalTimeStatusTest.assertTrue((String)"is active lt1", (boolean)this.lt1.isActive());
        try {
            Thread.sleep(10L);
            this.lt1.checkTime("test2");
            this.lt2.checkTime("test2-2");
            LocalTimeStatusTest.fail((String)"test2 checkTime 1|2");
        }
        catch (TimeExceededException timeExceededException) {
        }
        catch (InterruptedException interruptedException) {
            LocalTimeStatusTest.fail((String)"test2 interrupt");
        }
    }

    public void testCallBack() {
        this.lt1.setActive();
        this.lt1.restart();
        this.lt1.setLimit(0L);
        this.lt1.setCallBack(new LocalTimeStatus.TSCall(true));
        LocalTimeStatusTest.assertTrue((String)"is active lt1", (boolean)this.lt1.isActive());
        LocalTimeStatusTest.assertTrue((String)"is active lt2", (boolean)this.lt2.isActive());
        try {
            Thread.sleep(10L);
            this.lt1.checkTime("test3");
            this.lt2.checkTime("test3-2");
        }
        catch (TimeExceededException timeExceededException) {
            LocalTimeStatusTest.fail((String)"test3 checkTime");
        }
        catch (InterruptedException interruptedException) {
            LocalTimeStatusTest.fail((String)"test3 interrupt");
        }
        this.lt1.setCallBack(new LocalTimeStatus.TSCall(false));
        try {
            Thread.sleep(10L);
            this.lt1.checkTime("test4");
            LocalTimeStatusTest.fail((String)"test4 checkTime");
        }
        catch (TimeExceededException timeExceededException) {
        }
        catch (InterruptedException interruptedException) {
            LocalTimeStatusTest.fail((String)"test4 interrupt");
        }
        this.lt2.setCallBack(new LocalTimeStatus.TSCall(false));
        try {
            Thread.sleep(10L);
            this.lt2.checkTime("test4-2");
            LocalTimeStatusTest.fail((String)"test4 checkTime");
        }
        catch (TimeExceededException timeExceededException) {
        }
        catch (InterruptedException interruptedException) {
            LocalTimeStatusTest.fail((String)"test4 interrupt");
        }
    }
}

