/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.TimeExceededException;
import edu.jas.kern.TimeStatus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TimeStatusTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)TimeStatusTest.suite());
    }

    public TimeStatusTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TimeStatusTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        TimeStatus.setNotActive();
        TimeStatus.setLimit(Long.MAX_VALUE);
        TimeStatus.setCallBack(null);
    }

    public void testCheckTime() {
        TimeStatus.setActive();
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        TimeStatus.restart();
        try {
            TimeStatus.checkTime("test1");
        }
        catch (TimeExceededException timeExceededException) {
            TimeStatusTest.fail((String)("test1 " + timeExceededException));
        }
        TimeStatus.setLimit(0L);
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test2");
            TimeStatusTest.fail((String)"test2 checkTime");
        }
        catch (TimeExceededException timeExceededException) {
        }
        catch (InterruptedException interruptedException) {
            TimeStatusTest.fail((String)"test2 interrupt");
        }
    }

    public void testCallBack() {
        TimeStatus.setActive();
        TimeStatus.restart();
        TimeStatus.setLimit(0L);
        TimeStatus.setCallBack(new TimeStatus.TSCall(true));
        TimeStatusTest.assertTrue((String)"is active ", (boolean)TimeStatus.isActive());
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test3");
        }
        catch (TimeExceededException timeExceededException) {
            TimeStatusTest.fail((String)"test3 checkTime");
        }
        catch (InterruptedException interruptedException) {
            TimeStatusTest.fail((String)"test3 interrupt");
        }
        TimeStatus.setCallBack(new TimeStatus.TSCall(false));
        try {
            Thread.sleep(10L);
            TimeStatus.checkTime("test4");
            TimeStatusTest.fail((String)"test4 checkTime");
        }
        catch (TimeExceededException timeExceededException) {
        }
        catch (InterruptedException interruptedException) {
            TimeStatusTest.fail((String)"test4 interrupt");
        }
    }
}

