/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ExpVectorLong
extends ExpVector {
    final long[] val;

    public ExpVectorLong(int n) {
        this(new long[n], true);
    }

    public ExpVectorLong(int n, int n2, long l) {
        this(new long[n], true);
        this.val[n2] = l;
    }

    public ExpVectorLong(long[] lArray) {
        this(lArray, false);
    }

    protected ExpVectorLong(long[] lArray, boolean bl) {
        if (lArray == null) {
            throw new IllegalArgumentException("null val not allowed");
        }
        this.val = bl ? lArray : Arrays.copyOf(lArray, lArray.length);
    }

    public ExpVectorLong(String string) throws NumberFormatException {
        this(ExpVectorLong.parse((String)string).val, true);
    }

    public static ExpVectorLong parse(String string) throws NumberFormatException {
        long[] lArray = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        string = string.trim();
        int n = string.indexOf(40);
        int n2 = string.indexOf(41, n + 1);
        if (n >= 0 && n2 >= 0) {
            long l;
            String string2;
            int n3;
            ++n;
            while ((n3 = string.indexOf(44, n)) >= 0) {
                string2 = string.substring(n, n3);
                l = Long.parseLong(string2);
                arrayList.add(l);
                n = n3 + 1;
            }
            if (n <= n2) {
                string2 = string.substring(n, n2);
                l = Long.parseLong(string2);
                arrayList.add(l);
            }
            int n4 = arrayList.size();
            lArray = new long[n4];
            for (int i = 0; i < n4; ++i) {
                lArray[i] = (Long)arrayList.get(i);
            }
        }
        return new ExpVectorLong(lArray, true);
    }

    public static ExpVector valueOf(ExpVector expVector) {
        return new ExpVectorLong(expVector.getVal());
    }

    @Override
    public ExpVectorLong copy() {
        long[] lArray = new long[this.val.length];
        System.arraycopy(this.val, 0, lArray, 0, this.val.length);
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public long[] getVal() {
        long[] lArray = new long[this.val.length];
        System.arraycopy(this.val, 0, lArray, 0, this.val.length);
        return lArray;
    }

    @Override
    public long getVal(int n) {
        return this.val[n];
    }

    @Override
    protected long setVal(int n, long l) {
        long l2 = this.val[n];
        this.val[n] = l;
        this.hash = -1;
        return l2;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorLong extend(int n, int n2, long l) {
        long[] lArray = new long[this.val.length + n];
        System.arraycopy(this.val, 0, lArray, n, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        lArray[n2] = l;
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong extendLower(int n, int n2, long l) {
        long[] lArray = new long[this.val.length + n];
        System.arraycopy(this.val, 0, lArray, 0, this.val.length);
        if (n2 >= n) {
            throw new IllegalArgumentException("i " + n + " <= j " + n2 + " invalid");
        }
        lArray[this.val.length + n2] = l;
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong contract(int n, int n2) {
        if (n + n2 > this.val.length) {
            throw new IllegalArgumentException("len " + n2 + " > val.len " + this.val.length);
        }
        long[] lArray = new long[n2];
        System.arraycopy(this.val, n, lArray, 0, n2);
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong reverse() {
        long[] lArray = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            lArray[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong reverse(int n) {
        int n2;
        if (n < 0 || n > this.val.length) {
            return this;
        }
        long[] lArray = new long[this.val.length];
        for (n2 = 0; n2 < n; ++n2) {
            lArray[n2] = this.val[n2];
        }
        for (n2 = n; n2 < this.val.length; ++n2) {
            lArray[n2] = this.val[this.val.length + n - 1 - n2];
        }
        return new ExpVectorLong(lArray, true);
    }

    public ExpVectorLong reverseUpper(int n) {
        int n2;
        if (n < 0 || n > this.val.length) {
            return this;
        }
        long[] lArray = new long[this.val.length];
        for (n2 = 0; n2 < n; ++n2) {
            lArray[n2] = this.val[n - 1 - n2];
        }
        for (n2 = n; n2 < this.val.length; ++n2) {
            lArray[n2] = this.val[n2];
        }
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorLong expVectorLong = (ExpVectorLong)expVector;
        if (this.val.length == 0) {
            return expVectorLong;
        }
        long[] lArray = new long[this.val.length + expVectorLong.val.length];
        System.arraycopy(this.val, 0, lArray, 0, this.val.length);
        System.arraycopy(expVectorLong.val, 0, lArray, this.val.length, expVectorLong.val.length);
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public ExpVectorLong permutation(List<Integer> list) {
        long[] lArray = new long[this.val.length];
        int n = 0;
        for (Integer n2 : list) {
            lArray[n++] = this.val[n2];
        }
        return new ExpVectorLong(lArray, true);
    }

    @Override
    public String toString() {
        return super.toString() + ":long";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorLong)) {
            return false;
        }
        ExpVectorLong expVectorLong = (ExpVectorLong)object;
        int n = this.invLexCompareTo(expVectorLong);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorLong abs() {
        long[] lArray = this.val;
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray2[i] = lArray[i] >= 0L ? lArray[i] : -lArray[i];
        }
        return new ExpVectorLong(lArray2, true);
    }

    @Override
    public ExpVectorLong negate() {
        long[] lArray = this.val;
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray2[i] = -lArray[i];
        }
        return new ExpVectorLong(lArray2, true);
    }

    @Override
    public ExpVectorLong sum(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        long[] lArray3 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray3[i] = lArray[i] + lArray2[i];
        }
        return new ExpVectorLong(lArray3, true);
    }

    @Override
    public ExpVectorLong subtract(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        long[] lArray3 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray3[i] = lArray[i] - lArray2[i];
        }
        return new ExpVectorLong(lArray3, true);
    }

    @Override
    public ExpVectorLong scalarMultiply(long l) {
        long[] lArray = this.val;
        long[] lArray2 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray2[i] = l * lArray[i];
        }
        return new ExpVectorLong(lArray2, true);
    }

    @Override
    public ExpVectorLong subst(int n, long l) {
        ExpVectorLong expVectorLong = this.copy();
        expVectorLong.setVal(n, l);
        return expVectorLong;
    }

    @Override
    public int signum() {
        int n = 0;
        long[] lArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] < 0L) {
                return -1;
            }
            if (lArray[i] <= 0L) continue;
            n = 1;
        }
        return n;
    }

    @Override
    public long totalDeg() {
        long l = 0L;
        long[] lArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l;
    }

    @Override
    public long maxDeg() {
        long l = 0L;
        long[] lArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= l) continue;
            l = lArray[i];
        }
        return l;
    }

    @Override
    public long minDeg() {
        long l = Long.MAX_VALUE;
        long[] lArray = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= l) continue;
            l = lArray[i];
        }
        return l;
    }

    @Override
    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        long[] lArray2 = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray3 = lArray[i];
            for (int j = 0; j < lArray2.length; ++j) {
                l += lArray3[j] * lArray2[j];
            }
        }
        return l;
    }

    @Override
    public long weightDeg(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l = 0L;
        long[] lArray2 = this.val;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i] * lArray2[i];
        }
        return l;
    }

    @Override
    public ExpVectorLong lcm(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        long[] lArray3 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray3[i] = lArray[i] >= lArray2[i] ? lArray[i] : lArray2[i];
        }
        return new ExpVectorLong(lArray3, true);
    }

    @Override
    public ExpVectorLong gcd(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        long[] lArray3 = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray3[i] = lArray[i] <= lArray2[i] ? lArray[i] : lArray2[i];
        }
        return new ExpVectorLong(lArray3, true);
    }

    @Override
    public int dependentVariables() {
        int n = 0;
        for (int i = 0; i < this.val.length; ++i) {
            if (this.val[i] <= 0L) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int[] dependencyOnVariables() {
        long[] lArray = this.val;
        int n = this.dependentVariables();
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0L) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    @Override
    public boolean multipleOf(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= lArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    @Override
    public int invLexCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > lArray2[i]) {
                return 1;
            }
            if (lArray[i] >= lArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invLexCompareTo(ExpVector expVector, int n, int n2) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] > lArray2[i]) {
                return 1;
            }
            if (lArray[i] >= lArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > lArray2[i]) {
                n = 1;
                break;
            }
            if (lArray[i] >= lArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < lArray.length; ++i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int invGradCompareTo(ExpVector expVector, int n, int n2) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] > lArray2[i]) {
                n3 = 1;
                break;
            }
            if (lArray[i] >= lArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < n2; ++i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = lArray.length - 1; i >= 0; --i) {
            if (lArray[i] > lArray2[i]) {
                return 1;
            }
            if (lArray[i] >= lArray2[i]) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int revInvLexCompareTo(ExpVector expVector, int n, int n2) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (lArray[i] > lArray2[i]) {
                return 1;
            }
            if (lArray[i] >= lArray2[i]) continue;
            return -1;
        }
        return n3;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = lArray.length - 1; i >= 0; --i) {
            if (lArray[i] > lArray2[i]) {
                n = 1;
                break;
            }
            if (lArray[i] >= lArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= 0; --i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int revInvGradCompareTo(ExpVector expVector, int n, int n2) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n2 - 1; i >= n; --i) {
            if (lArray[i] > lArray2[i]) {
                n3 = 1;
                break;
            }
            if (lArray[i] >= lArray2[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= n; --i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n3 = 1;
        } else if (l < l2) {
            n3 = -1;
        }
        return n3;
    }

    @Override
    public int invTdegCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] < lArray2[i]) {
                n = 1;
                break;
            }
            if (lArray[i] <= lArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i < lArray.length; ++i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int revLexInvTdegCompareTo(ExpVector expVector) {
        long[] lArray = this.val;
        long[] lArray2 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = lArray.length - 1; i >= 0; --i) {
            if (lArray[i] < lArray2[i]) {
                n = 1;
                break;
            }
            if (lArray[i] <= lArray2[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = i; i >= 0; --i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l > l2) {
            n = 1;
        } else if (l < l2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        long[] lArray2 = this.val;
        long[] lArray3 = ((ExpVectorLong)expVector).val;
        int n = 0;
        for (int i = 0; i < lArray2.length; ++i) {
            if (lArray2[i] > lArray3[i]) {
                n = 1;
                break;
            }
            if (lArray2[i] >= lArray3[i]) continue;
            n = -1;
            break;
        }
        if (n == 0) {
            return n;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray4 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < lArray2.length; ++j) {
                l += lArray4[j] * lArray2[j];
                l2 += lArray4[j] * lArray3[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n;
    }

    @Override
    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n, int n2) {
        long[] lArray2 = this.val;
        long[] lArray3 = ((ExpVectorLong)expVector).val;
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.val.length) {
            n2 = this.val.length;
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (lArray2[i] > lArray3[i]) {
                n3 = 1;
                break;
            }
            if (lArray2[i] >= lArray3[i]) continue;
            n3 = -1;
            break;
        }
        if (n3 == 0) {
            return n3;
        }
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray4 = lArray[i];
            long l = 0L;
            long l2 = 0L;
            for (int j = i; j < n2; ++j) {
                l += lArray4[j] * lArray2[j];
                l2 += lArray4[j] * lArray3[j];
            }
            if (l > l2) {
                return 1;
            }
            if (l >= l2) continue;
            return -1;
        }
        return n3;
    }
}

