/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.WeylRelations;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.poly.WordMonomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenWordPolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 10;
    int ll = 7;
    int el = 5;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenWordPolynomialTest.suite());
    }

    public GenWordPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenWordPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomialTest.assertFalse((String)"not commutative", (boolean)genWordPolynomialRing.isCommutative());
        GenWordPolynomialTest.assertTrue((String)"associative", (boolean)genWordPolynomialRing.isAssociative());
        GenWordPolynomialTest.assertFalse((String)"not field", (boolean)genWordPolynomialRing.isField());
        String string = genWordPolynomialRing.toScript();
        GenWordPolynomialTest.assertEquals((String)("#s == 32: " + string), (int)string.length(), (int)32);
        string = genWordPolynomialRing.toString();
        GenWordPolynomialTest.assertEquals((String)("#s == 32: " + string), (int)string.length(), (int)32);
        Element element = genWordPolynomialRing.getONE();
        GenWordPolynomialTest.assertTrue((String)"p == 1", (boolean)((GenWordPolynomial)element).isONE());
        element = genWordPolynomialRing.getZERO();
        GenWordPolynomialTest.assertTrue((String)"p == 0", (boolean)((GenWordPolynomial)element).isZERO());
        List<GenWordPolynomial<BigInteger>> list = genWordPolynomialRing.generators();
        GenWordPolynomialTest.assertTrue((String)"#gens == 7", (list.size() == 7 ? 1 : 0) != 0);
        RingElem ringElem = new GenWordPolynomial<BigInteger>(genWordPolynomialRing);
        GenWordPolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenWordPolynomial)element).equals(ringElem));
        GenWordPolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenWordPolynomial)element).equals(element));
        ringElem = (RingElem)ringElem.sum(element);
        GenWordPolynomialTest.assertTrue((String)"pe.isZERO() = ", (boolean)ringElem.isZERO());
        element = genWordPolynomialRing.random(9);
        element = ((GenWordPolynomial)element).subtract(element);
        GenWordPolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)((GenWordPolynomial)element).isZERO());
        WordFactory wordFactory2 = new WordFactory("xyz");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing2 = new GenWordPolynomialRing<BigInteger>(genWordPolynomialRing, wordFactory2);
        Element element2 = genWordPolynomialRing2.getONE();
        GenWordPolynomialTest.assertTrue((String)"pp == 1", (boolean)((GenWordPolynomial)element2).isONE());
        element2 = genWordPolynomialRing2.getZERO();
        GenWordPolynomialTest.assertTrue((String)"pp == 0", (boolean)((GenWordPolynomial)element2).isZERO());
        List<GenWordPolynomial<BigInteger>> list2 = genWordPolynomialRing2.generators();
        GenWordPolynomialTest.assertTrue((String)"#pgens == 7+3", (list2.size() == 10 ? 1 : 0) != 0);
        RingElem ringElem2 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing2);
        GenWordPolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)((GenWordPolynomial)element2).equals(ringElem2));
        GenWordPolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)((GenWordPolynomial)element2).equals(element2));
        ringElem2 = (RingElem)ringElem2.sum(element2);
        GenWordPolynomialTest.assertTrue((String)"ppe.isZERO() = ", (boolean)ringElem2.isZERO());
        element2 = genWordPolynomialRing2.random(2);
        element2 = ((GenWordPolynomial)element2).subtract(element2);
        GenWordPolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)((GenWordPolynomial)element2).isZERO());
        WordFactory wordFactory3 = new WordFactory("uvw");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing3 = new GenWordPolynomialRing<BigInteger>(genWordPolynomialRing2, wordFactory3);
        Element element3 = genWordPolynomialRing3.getONE();
        GenWordPolynomialTest.assertTrue((String)"ppp == 1", (boolean)((GenWordPolynomial)element3).isONE());
        element3 = genWordPolynomialRing3.getZERO();
        GenWordPolynomialTest.assertTrue((String)"ppp == 0", (boolean)((GenWordPolynomial)element3).isZERO());
        List<GenWordPolynomial<BigInteger>> list3 = genWordPolynomialRing3.generators();
        GenWordPolynomialTest.assertTrue((String)"#ppgens == 7+3+3", (list3.size() == 13 ? 1 : 0) != 0);
        RingElem ringElem3 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing3);
        GenWordPolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)((GenWordPolynomial)element3).equals(ringElem3));
        GenWordPolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)((GenWordPolynomial)element3).equals(element3));
        ringElem3 = (RingElem)ringElem3.sum(element3);
        GenWordPolynomialTest.assertTrue((String)"pppe.isZERO() = ", (boolean)ringElem3.isZERO());
        element3 = ((GenWordPolynomial)element3).subtract(element3);
        GenWordPolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)((GenWordPolynomial)element3).isZERO());
    }

    public void testAccessors() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        Element element = genWordPolynomialRing.getONE();
        Word word = ((GenWordPolynomial)element).leadingWord();
        BigInteger bigInteger2 = (BigInteger)((GenWordPolynomial)element).leadingBaseCoefficient();
        AbelianGroupElem<GenWordPolynomial<Object>> abelianGroupElem = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"1 == 1 ", (Object)element, abelianGroupElem);
        GenWordPolynomial<GenWordPolynomial<BigInteger>> genWordPolynomial = ((GenWordPolynomial)element).reductum();
        GenWordPolynomialTest.assertTrue((String)"red(1) == 0 ", (boolean)genWordPolynomial.isZERO());
        element = genWordPolynomialRing.getZERO();
        word = ((GenWordPolynomial)element).leadingWord();
        bigInteger2 = (BigInteger)((GenWordPolynomial)element).leadingBaseCoefficient();
        abelianGroupElem = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"0 == 0 ", element, abelianGroupElem);
        genWordPolynomial = ((GenWordPolynomial)element).reductum();
        GenWordPolynomialTest.assertTrue((String)"red(0) == 0 ", (boolean)genWordPolynomial.isZERO());
        element = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        word = ((GenWordPolynomial)element).leadingWord();
        bigInteger2 = (BigInteger)((GenWordPolynomial)element).leadingBaseCoefficient();
        genWordPolynomial = ((GenWordPolynomial)element).reductum();
        abelianGroupElem = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        abelianGroupElem = genWordPolynomial.sum((GenWordPolynomial<BigInteger>)abelianGroupElem);
        GenWordPolynomialTest.assertEquals((String)"p == lm(f)+red(f) ", element, abelianGroupElem);
        Element element2 = element;
        abelianGroupElem = genWordPolynomialRing.getZERO();
        while (!((GenWordPolynomial)element2).isZERO()) {
            word = ((GenWordPolynomial)element2).leadingWord();
            bigInteger2 = (BigInteger)((GenWordPolynomial)element2).leadingBaseCoefficient();
            genWordPolynomial = ((GenWordPolynomial)element2).reductum();
            abelianGroupElem = ((GenWordPolynomial)abelianGroupElem).sum((GenWordPolynomial<Object>)((Object)bigInteger2), word);
            element2 = genWordPolynomial;
        }
        GenWordPolynomialTest.assertEquals((String)"p == lm(f)+lm(red(f))+... ", element, abelianGroupElem);
    }

    public void testAddition() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomial<BigInteger> genWordPolynomial = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial<BigInteger> genWordPolynomial2 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial genWordPolynomial3 = genWordPolynomial.sum((BigInteger)((Object)genWordPolynomial2));
        GenWordPolynomial<RingElem<GenWordPolynomial<Object>>> genWordPolynomial4 = genWordPolynomial3.subtract(genWordPolynomial2);
        GenWordPolynomialTest.assertEquals((String)"a+b-b = a", genWordPolynomial, genWordPolynomial4);
        GenWordPolynomialTest.assertTrue((String)"deg(a+b) >= deg(a)", (genWordPolynomial3.degree() >= genWordPolynomial.degree() ? 1 : 0) != 0);
        GenWordPolynomialTest.assertTrue((String)"deg(a+b) >= deg(b)", (genWordPolynomial3.degree() >= genWordPolynomial2.degree() ? 1 : 0) != 0);
        genWordPolynomial3 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        genWordPolynomial4 = genWordPolynomial.sum((BigInteger)((Object)genWordPolynomial2.sum((BigInteger)((Object)genWordPolynomial3))));
        GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<BigInteger>>> genWordPolynomial5 = genWordPolynomial.sum((BigInteger)((Object)genWordPolynomial2)).sum(genWordPolynomial3);
        GenWordPolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", genWordPolynomial4, genWordPolynomial5);
        Word word = wordFactory.random(this.rl);
        BigInteger bigInteger2 = bigInteger.random(this.kl);
        genWordPolynomial2 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        genWordPolynomial3 = genWordPolynomial.sum((BigInteger)((Object)genWordPolynomial2));
        genWordPolynomial4 = genWordPolynomial.sum(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", genWordPolynomial3, genWordPolynomial4);
        genWordPolynomial3 = genWordPolynomial.subtract((BigInteger)((Object)genWordPolynomial2));
        genWordPolynomial4 = genWordPolynomial.subtract(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", genWordPolynomial3, genWordPolynomial4);
        genWordPolynomial2 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        genWordPolynomial3 = genWordPolynomial2.sum((BigInteger)((Object)genWordPolynomial));
        genWordPolynomial4 = genWordPolynomial.sum(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", genWordPolynomial3, genWordPolynomial4);
        genWordPolynomial3 = genWordPolynomial.subtract((BigInteger)((Object)genWordPolynomial2));
        genWordPolynomial4 = genWordPolynomial.subtract(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", genWordPolynomial3, genWordPolynomial4);
    }

    public void testMultiplication() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomial<BigInteger> genWordPolynomial = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial<BigInteger> genWordPolynomial2 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial genWordPolynomial3 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2));
        GenWordPolynomial<RingElem<GenWordPolynomial<Object>>> genWordPolynomial4 = genWordPolynomial2.multiply((BigInteger)((Object)genWordPolynomial));
        GenWordPolynomialTest.assertFalse((String)"a*b != b*a", (boolean)genWordPolynomial3.equals(genWordPolynomial4));
        GenWordPolynomialTest.assertTrue((String)"maxNorm(a*b) >= maxNorm(a)", (((BigInteger)((Object)genWordPolynomial3.maxNorm())).compareTo(genWordPolynomial.maxNorm()) >= 0 ? 1 : 0) != 0);
        GenWordPolynomialTest.assertTrue((String)"maxNorm(a*b) >= maxNorm(b)", (((BigInteger)((Object)genWordPolynomial3.maxNorm())).compareTo(genWordPolynomial2.maxNorm()) >= 0 ? 1 : 0) != 0);
        genWordPolynomial3 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        genWordPolynomial4 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2.multiply((BigInteger)((Object)genWordPolynomial3))));
        GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<BigInteger>>> genWordPolynomial5 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2)).multiply(genWordPolynomial3);
        GenWordPolynomialTest.assertEquals((String)"a*(b*c) = (a*b)*c", genWordPolynomial4, genWordPolynomial5);
        Word word = wordFactory.random(this.rl);
        BigInteger bigInteger2 = bigInteger.random(this.kl);
        genWordPolynomial2 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        genWordPolynomial3 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2));
        genWordPolynomial4 = genWordPolynomial.multiply(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a*p(x,u) = a*(x,u)", genWordPolynomial3, genWordPolynomial4);
        genWordPolynomial2 = new GenWordPolynomial<BigInteger>(genWordPolynomialRing, bigInteger2, word);
        genWordPolynomial3 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2));
        genWordPolynomial4 = genWordPolynomial.multiply(bigInteger2, word);
        GenWordPolynomialTest.assertEquals((String)"a*p(x,u) = a*(x,u)", genWordPolynomial3, genWordPolynomial4);
        BigInteger bigInteger3 = bigInteger.random(this.kl);
        genWordPolynomial3 = genWordPolynomial.multiply(bigInteger2, bigInteger3);
        genWordPolynomial4 = genWordPolynomial.multiply(bigInteger3, bigInteger2);
        GenWordPolynomialTest.assertEquals((String)"x a y = y a x", genWordPolynomial3, genWordPolynomial4);
    }

    public void testDistributive() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomial<BigInteger> genWordPolynomial = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial<BigInteger> genWordPolynomial2 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial<BigInteger> genWordPolynomial3 = genWordPolynomialRing.random(this.kl, this.ll, this.el);
        GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<BigInteger>>> genWordPolynomial4 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2.sum((BigInteger)((Object)genWordPolynomial3))));
        GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<BigInteger>>> genWordPolynomial5 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2)).sum((GenWordPolynomial<BigInteger>)genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial3)));
        GenWordPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", genWordPolynomial4, genWordPolynomial5);
    }

    public void testUnivDivision() {
        BigRational bigRational = new BigRational();
        WordFactory wordFactory = new WordFactory("x");
        GenWordPolynomialRing<BigRational> genWordPolynomialRing = new GenWordPolynomialRing<BigRational>(bigRational, wordFactory);
        GenWordPolynomial<BigRational> genWordPolynomial = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<BigRational> genWordPolynomial2 = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<GenWordPolynomial<RingElem<BigRational>>> genWordPolynomial3 = genWordPolynomial.multiply((BigRational)((Object)genWordPolynomial2));
        GenWordPolynomial<RingElem<GenWordPolynomial<GenWordPolynomial<BigRational>>>> genWordPolynomial4 = genWordPolynomial2.multiply((BigRational)((Object)genWordPolynomial));
        GenWordPolynomialTest.assertTrue((String)"a*b == b*a", (boolean)genWordPolynomial3.equals(genWordPolynomial4));
        GenWordPolynomial<RingElem<BigRational>> genWordPolynomial5 = genWordPolynomial3.divide((GenWordPolynomial<GenWordPolynomial<RingElem<BigRational>>>)((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial));
        GenWordPolynomialTest.assertTrue((String)"a*b/a == b", (boolean)genWordPolynomial2.equals(genWordPolynomial5));
        genWordPolynomial4 = genWordPolynomial3.divide((GenWordPolynomial<GenWordPolynomial<RingElem<BigRational>>>)((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial2));
        GenWordPolynomialTest.assertTrue((String)"a*b/b == a", (boolean)genWordPolynomial.equals(genWordPolynomial4));
        genWordPolynomial4 = genWordPolynomial3.gcd((GenWordPolynomial<GenWordPolynomial<RingElem<BigRational>>>)((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial));
        GenWordPolynomialTest.assertTrue((String)"gcd(a*b,a) == a", (boolean)genWordPolynomial.equals(genWordPolynomial4));
        genWordPolynomial4 = genWordPolynomial.gcd(genWordPolynomial2);
        if (!genWordPolynomial4.isConstant()) {
            return;
        }
        GenWordPolynomialTest.assertTrue((String)"gcd(b,a) == 1", (boolean)genWordPolynomial4.isONE());
        genWordPolynomial4 = genWordPolynomial.modInverse(genWordPolynomial2);
        genWordPolynomial5 = genWordPolynomial4.multiply((RingElem<GenWordPolynomial<GenWordPolynomial<BigRational>>>)genWordPolynomial);
        GenWordPolynomial<BigRational> genWordPolynomial6 = genWordPolynomial5.remainder(genWordPolynomial2);
        GenWordPolynomialTest.assertTrue((String)"d * a == 1 mod b ", (boolean)genWordPolynomial6.isONE());
        GenWordPolynomial<BigRational>[] genWordPolynomialArray = genWordPolynomial.egcd(genWordPolynomial2);
        genWordPolynomial4 = genWordPolynomialArray[0];
        genWordPolynomial5 = genWordPolynomialArray[1];
        genWordPolynomial6 = genWordPolynomialArray[2];
        genWordPolynomial3 = genWordPolynomial5.multiply((RingElem<BigRational>)genWordPolynomial).sum((GenWordPolynomial<BigRational>)genWordPolynomial6.multiply((BigRational)((Object)genWordPolynomial2)));
        GenWordPolynomialTest.assertEquals((String)"gcd(a,b) == e*a + f*b", genWordPolynomial3, genWordPolynomial4);
    }

    public void testMulti2Division() {
        BigRational bigRational = new BigRational();
        WordFactory wordFactory = new WordFactory("xy");
        GenWordPolynomialRing<BigRational> genWordPolynomialRing = new GenWordPolynomialRing<BigRational>(bigRational, wordFactory);
        GenWordPolynomial<BigRational> genWordPolynomial = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<BigRational> genWordPolynomial2 = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<GenWordPolynomial<BigRational>> genWordPolynomial3 = genWordPolynomial.multiply((BigRational)((Object)genWordPolynomial2));
        GenWordPolynomial<GenWordPolynomial<BigRational>> genWordPolynomial4 = genWordPolynomial2.multiply((BigRational)((Object)genWordPolynomial));
        GenWordPolynomialTest.assertFalse((String)"a*b == b*a", (boolean)genWordPolynomial3.equals(genWordPolynomial4));
        GenWordPolynomial<BigRational> genWordPolynomial5 = genWordPolynomial3.divide((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial);
        GenWordPolynomialTest.assertTrue((String)"a*b/a == b", (boolean)genWordPolynomial2.equals(genWordPolynomial5));
        GenWordPolynomial<BigRational> genWordPolynomial6 = genWordPolynomial4.divide((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial2);
        GenWordPolynomialTest.assertTrue((String)"a*b/b == a", (boolean)genWordPolynomial.equals(genWordPolynomial6));
        try {
            genWordPolynomial6 = genWordPolynomial.divide(genWordPolynomial2);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("a divide b fail: " + genWordPolynomial + ", " + genWordPolynomial2);
            return;
        }
        WordFactory.WordComparator wordComparator = genWordPolynomialRing.alphabet.getDescendComparator();
        genWordPolynomial6 = genWordPolynomial.remainder(genWordPolynomial2);
        GenWordPolynomialTest.assertTrue((String)"a rem2 b <= a", (wordComparator.compare(genWordPolynomial.leadingWord(), genWordPolynomial6.leadingWord()) <= 0 ? 1 : 0) != 0);
    }

    public void testMulti3Division() {
        BigRational bigRational = new BigRational();
        WordFactory wordFactory = new WordFactory("xyz");
        GenWordPolynomialRing<BigRational> genWordPolynomialRing = new GenWordPolynomialRing<BigRational>(bigRational, wordFactory);
        GenWordPolynomial<BigRational> genWordPolynomial = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<BigRational> genWordPolynomial2 = genWordPolynomialRing.random(7, this.ll, this.el).monic();
        GenWordPolynomial<GenWordPolynomial<BigRational>> genWordPolynomial3 = genWordPolynomial.multiply((BigRational)((Object)genWordPolynomial2));
        GenWordPolynomial<GenWordPolynomial<BigRational>> genWordPolynomial4 = genWordPolynomial2.multiply((BigRational)((Object)genWordPolynomial));
        GenWordPolynomialTest.assertFalse((String)"a*b == b*a", (boolean)genWordPolynomial3.equals(genWordPolynomial4));
        GenWordPolynomial<BigRational> genWordPolynomial5 = genWordPolynomial3.divide((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial);
        GenWordPolynomialTest.assertTrue((String)"a*b/a == b", (boolean)genWordPolynomial2.equals(genWordPolynomial5));
        GenWordPolynomial<BigRational> genWordPolynomial6 = genWordPolynomial4.divide((GenWordPolynomial<GenWordPolynomial<BigRational>>)genWordPolynomial2);
        GenWordPolynomialTest.assertTrue((String)"a*b/b == a", (boolean)genWordPolynomial.equals(genWordPolynomial6));
        try {
            genWordPolynomial6 = genWordPolynomial.divide(genWordPolynomial2);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("a divide b fail: " + genWordPolynomial + ", " + genWordPolynomial2);
            return;
        }
        WordFactory.WordComparator wordComparator = genWordPolynomialRing.alphabet.getDescendComparator();
        genWordPolynomial6 = genWordPolynomial.remainder(genWordPolynomial2);
        GenWordPolynomialTest.assertTrue((String)("a rem3 b <= a: " + genWordPolynomial.leadingWord() + ", " + genWordPolynomial6.leadingWord()), (wordComparator.compare(genWordPolynomial.leadingWord(), genWordPolynomial6.leadingWord()) <= 0 ? 1 : 0) != 0);
    }

    public void testCoefficients() {
        BigComplex bigComplex = new BigComplex();
        String[] stringArray = new String[]{"u", "v", "w"};
        GenPolynomialRing<BigComplex> genPolynomialRing = new GenPolynomialRing<BigComplex>(bigComplex, stringArray);
        String[] stringArray2 = new String[]{"x1", "x2", "y1", "y2"};
        GenSolvablePolynomialRing<BigComplex> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigComplex>(genPolynomialRing, stringArray2);
        WeylRelations<BigComplex> weylRelations = new WeylRelations<BigComplex>();
        weylRelations.generate(genSolvablePolynomialRing);
        WordFactory wordFactory = new WordFactory("abcdef");
        GenWordPolynomialRing<BigComplex> genWordPolynomialRing = new GenWordPolynomialRing<BigComplex>(genSolvablePolynomialRing, wordFactory);
        GenWordPolynomialTest.assertFalse((String)"not commutative", (boolean)genWordPolynomialRing.isCommutative());
        GenWordPolynomialTest.assertTrue((String)"associative", (boolean)genWordPolynomialRing.isAssociative());
        GenWordPolynomialTest.assertFalse((String)"not field", (boolean)genWordPolynomialRing.isField());
        Element element = genWordPolynomialRing.getONE();
        GenWordPolynomialTest.assertTrue((String)"p == 1", (boolean)((GenWordPolynomial)element).isONE());
        element = genWordPolynomialRing.getZERO();
        GenWordPolynomialTest.assertTrue((String)"p == 0", (boolean)((GenWordPolynomial)element).isZERO());
        element = genWordPolynomialRing.random(3);
        element = ((GenWordPolynomial)element).multiply(element);
        element = ((GenWordPolynomial)element).subtract(element);
        GenWordPolynomialTest.assertTrue((String)"p == 0", (boolean)((GenWordPolynomial)element).isZERO());
        List<GenWordPolynomial<BigComplex>> list = genWordPolynomialRing.generators();
        GenWordPolynomialTest.assertTrue((String)"#gens == 2+3+4+6", (list.size() == 15 ? 1 : 0) != 0);
    }

    public void testContraction() {
        BigInteger bigInteger = new BigInteger();
        WordFactory wordFactory = new WordFactory("abcdef");
        WordFactory wordFactory2 = new WordFactory("abc");
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing2 = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory2);
        ArrayList arrayList = new ArrayList();
        Element<BigInteger> element = ((GenWordPolynomial)genWordPolynomialRing.random(5)).abs();
        AbelianGroupElem abelianGroupElem = ((GenWordPolynomial)genWordPolynomialRing2.random(5)).abs();
        GenWordPolynomial<BigInteger> genWordPolynomial = genWordPolynomialRing.valueOf((GenWordPolynomial<BigInteger>)abelianGroupElem);
        arrayList.add(genWordPolynomial);
        arrayList.add(genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomialRing.valueOf((GenWordPolynomial<BigInteger>)((GenWordPolynomial)genWordPolynomialRing2.random(5)).abs()))));
        arrayList.add(((GenWordPolynomial)genWordPolynomialRing2.random(5)).abs());
        GenWordPolynomial<BigInteger> genWordPolynomial2 = genWordPolynomial.contract(genWordPolynomialRing2);
        GenWordPolynomialTest.assertEquals((String)"as == contract(extend(as)): ", (Object)abelianGroupElem, genWordPolynomial2);
        GenWordPolynomial<BigInteger> genWordPolynomial3 = ((GenWordPolynomial)element).contract(genWordPolynomialRing2);
        arrayList.add(element);
        GenWordPolynomialTest.assertTrue((String)("contract(a) == 0: " + genWordPolynomial3), (genWordPolynomial3.isZERO() || genWordPolynomialRing.valueOf(genWordPolynomial3).equals(element) ? 1 : 0) != 0);
        element = genWordPolynomialRing.getONE();
        arrayList.add(element);
        genWordPolynomial3 = ((GenWordPolynomial)element).contract(genWordPolynomialRing2);
        GenWordPolynomialTest.assertTrue((String)"contract(1) == 1: ", (boolean)genWordPolynomial3.isONE());
        List<GenWordPolynomial<BigInteger>> list = PolyUtil.intersect(genWordPolynomialRing2, arrayList);
        int n = 0;
        for (GenWordPolynomial genWordPolynomial4 : arrayList) {
            if (genWordPolynomial4.contract(genWordPolynomialRing2).isZERO()) continue;
            GenWordPolynomialTest.assertEquals((String)("extend(contract(h)) == h: " + genWordPolynomial4), (Object)genWordPolynomial4, genWordPolynomialRing.valueOf(list.get(n++)));
        }
    }

    public void testParser() {
        Element element;
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f"};
        WordFactory wordFactory = new WordFactory(stringArray);
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, wordFactory);
        GenWordPolynomialTest.assertFalse((String)"not commutative", (boolean)genWordPolynomialRing.isCommutative());
        GenWordPolynomialTest.assertTrue((String)"associative", (boolean)genWordPolynomialRing.isAssociative());
        GenWordPolynomialTest.assertFalse((String)"not field", (boolean)genWordPolynomialRing.isField());
        List<GenWordPolynomial<BigInteger>> list = genWordPolynomialRing.generators();
        GenWordPolynomial<BigInteger> genWordPolynomial = list.get(1);
        GenWordPolynomial<BigInteger> genWordPolynomial2 = list.get(2);
        GenWordPolynomialTest.assertEquals((String)"#s == 3: ", (int)genWordPolynomial.toString().length(), (int)3);
        GenWordPolynomialTest.assertEquals((String)"#s == 1: ", (int)genWordPolynomial.toScript().length(), (int)1);
        GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<BigInteger>>> genWordPolynomial3 = genWordPolynomial.multiply((BigInteger)((Object)genWordPolynomial2)).subtract((GenWordPolynomial<BigInteger>)genWordPolynomial2.multiply((BigInteger)((Object)genWordPolynomial)));
        StringReader stringReader = new StringReader("a b - b a, b c - c b");
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            element = genPolynomialTokenizer.nextWordPolynomial(genWordPolynomialRing);
        }
        catch (IOException iOException) {
            element = null;
            iOException.printStackTrace();
        }
        GenWordPolynomialTest.assertEquals((String)"parse() == ab - ba: ", (Object)element, genWordPolynomial3);
        element = genWordPolynomialRing.parse("a b - b a");
        GenWordPolynomialTest.assertEquals((String)"parse() == ab - ba: ", (Object)element, genWordPolynomial3);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        GenWordPolynomialTest.assertTrue((String)"commutative", (boolean)genPolynomialRing.isCommutative());
        GenWordPolynomialTest.assertTrue((String)"associative", (boolean)genPolynomialRing.isAssociative());
        GenWordPolynomialTest.assertFalse((String)"not field", (boolean)genPolynomialRing.isField());
        stringReader = new StringReader("a b - b a, b c - c b");
        genPolynomialTokenizer = new GenPolynomialTokenizer(genPolynomialRing, stringReader);
        try {
            element = genPolynomialTokenizer.nextWordPolynomial();
        }
        catch (IOException iOException) {
            element = null;
            iOException.printStackTrace();
        }
        GenWordPolynomialTest.assertEquals((String)"parse() == ab - ba: ", (Object)element, genWordPolynomial3);
    }

    public void testIterators() {
        BigInteger bigInteger = new BigInteger();
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(bigInteger, "abcdef");
        GenWordPolynomial<BigInteger> genWordPolynomial = genWordPolynomialRing.random(this.kl, 2 * this.ll, this.el);
        for (WordMonomial<BigInteger> wordMonomial : genWordPolynomial) {
            GenWordPolynomialTest.assertFalse((String)"m.c == 0 ", (boolean)wordMonomial.coefficient().isZERO());
            GenWordPolynomialTest.assertFalse((String)"m.e < (0) ", (wordMonomial.word().signum() < 0 ? 1 : 0) != 0);
        }
    }
}

