/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModGenSolvablePolynomialTest
extends TestCase {
    GenSolvablePolynomial<ModInteger> a;
    GenSolvablePolynomial<ModInteger> b;
    GenSolvablePolynomial<ModInteger> c;
    GenSolvablePolynomial<ModInteger> d;
    GenSolvablePolynomial<ModInteger> e;
    GenSolvablePolynomial<ModInteger> f;
    GenSolvablePolynomial<ModInteger> x1;
    GenSolvablePolynomial<ModInteger> x2;
    int ml = 19;
    int rl = 5;
    int kl = 10;
    int ll = 5;
    int el = 3;
    float q = 0.5f;
    RelationTable<ModInteger> table;
    GenSolvablePolynomialRing<ModInteger> ring;
    ModIntegerRing cfac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModGenSolvablePolynomialTest.suite());
    }

    public ModGenSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModGenSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new ModIntegerRing(this.ml);
        this.ring = new GenSolvablePolynomialRing<ModInteger>(this.cfac, this.rl);
        this.table = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        this.a = new GenSolvablePolynomial<ModInteger>(this.ring);
        ModGenSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        ModGenSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        ModGenSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        ModGenSolvablePolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ModGenSolvablePolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        ModGenSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        for (int i = 0; i < 2; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            ModGenSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ModGenSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ModGenSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (GenSolvablePolynomial)this.a.subtract((ModInteger)((Object)this.a));
        ModGenSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (GenSolvablePolynomial)this.a.sum((ModInteger)((Object)this.a));
        this.c = (GenSolvablePolynomial)this.b.subtract((ModInteger)((Object)this.a));
        ModGenSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        ModGenSolvablePolynomialTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (GenSolvablePolynomial)this.b.sum((ModInteger)((Object)this.a));
        this.d = (GenSolvablePolynomial)this.a.sum((ModInteger)((Object)this.b));
        ModGenSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        ModGenSolvablePolynomialTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (GenSolvablePolynomial)this.a.sum((ModInteger)((Object)this.b.sum((ModInteger)((Object)this.c))));
        this.e = (GenSolvablePolynomial)this.a.sum((ModInteger)((Object)this.b)).sum(this.c);
        ModGenSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ModGenSolvablePolynomialTest.assertTrue((String)"a+(b+c) = (a+b)+c", (boolean)this.d.equals(this.e));
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        ModInteger modInteger = this.cfac.random(this.kl);
        this.b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(modInteger, expVector);
        this.c = (GenSolvablePolynomial)this.a.sum((ModInteger)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.sum(modInteger, expVector);
        ModGenSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (GenSolvablePolynomial)this.a.subtract((ModInteger)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.subtract(modInteger, expVector);
        ModGenSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(modInteger, expVector);
        this.c = (GenSolvablePolynomial)this.b.sum((ModInteger)((Object)this.a));
        this.d = (GenSolvablePolynomial)this.a.sum(modInteger, expVector);
        ModGenSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (GenSolvablePolynomial)this.a.subtract((ModInteger)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.subtract(modInteger, expVector);
        ModGenSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((ModInteger)((Object)this.a));
        this.d = this.a.multiply((ModInteger)((Object)this.b));
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((ModInteger)((Object)this.c));
        ModGenSolvablePolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ModGenSolvablePolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        ModGenSolvablePolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ModInteger)((Object)this.b.multiply((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        ModGenSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ModGenSolvablePolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        ModInteger modInteger = ((ModInteger)this.a.leadingBaseCoefficient()).inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply((RingElem)modInteger);
        ModGenSolvablePolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        ExpVector expVector = this.ring.evzero;
        ModInteger modInteger2 = ((ModInteger)this.b.leadingBaseCoefficient()).inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply((RingElem)modInteger2, expVector);
        ModGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = ((GenSolvablePolynomial)this.ring.getONE()).multiply(modInteger2, expVector);
        this.d = this.b.multiply((ModInteger)((Object)this.e));
        ModGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((ModInteger)((Object)this.b));
        ModGenSolvablePolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
        this.d = this.a.monic();
        ModGenSolvablePolynomialTest.assertTrue((String)"a.monic(): ", (boolean)((ModInteger)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testWeyl() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<ModInteger>(this.cfac, n);
        WeylRelations<ModInteger> weylRelations = new WeylRelations<ModInteger>();
        weylRelations.generate(this.ring);
        ModGenSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ModGenSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el + 2, this.q);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.ring.random(this.kl, this.ll, this.el + 2, this.q);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((ModInteger)((Object)this.a));
        this.d = this.a.multiply((ModInteger)((Object)this.b));
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((ModInteger)((Object)this.c));
        ModGenSolvablePolynomialTest.assertTrue((String)("!isZERO( a*b-b*a ) " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        ModGenSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ModInteger)((Object)this.b.multiply((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        ModGenSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ModGenSolvablePolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
    }

    public void testBLAS1() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<ModInteger>(this.cfac, n);
        WeylRelations<ModInteger> weylRelations = new WeylRelations<ModInteger>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.random(n, this.el, this.q);
        ModInteger modInteger = this.cfac.random(this.kl);
        this.d = this.a.subtractMultiple(modInteger, this.b);
        this.e = (GenSolvablePolynomial)this.a.subtract((ModInteger)((Object)this.b.multiply((RingElem)modInteger)));
        ModGenSolvablePolynomialTest.assertEquals((String)"a - (lc) b == a - ((lc) b)", this.d, this.e);
        this.d = this.a.subtractMultiple(modInteger, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.subtract((ModInteger)((Object)this.b.multiplyLeft(modInteger, expVector)));
        ModGenSolvablePolynomialTest.assertEquals((String)("a - (lc ev) b == a - ((lc ev) b): " + modInteger + ", " + expVector), this.d, this.e);
        ExpVector expVector2 = ExpVector.random(n, this.el, this.q);
        ModInteger modInteger2 = this.cfac.random(this.kl);
        this.d = this.a.scaleSubtractMultiple(modInteger2, modInteger, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft((RingElem)modInteger2).subtract(this.b.multiplyLeft(modInteger, expVector));
        ModGenSolvablePolynomialTest.assertEquals((String)"(tc) a - (lc ev) b == ((tc) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(modInteger2, expVector2, modInteger, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft(modInteger2, expVector2).subtract((ModInteger)((Object)this.b.multiplyLeft(modInteger, expVector)));
        ModGenSolvablePolynomialTest.assertEquals((String)("(tc fv) a - (lc ev) b == ((tc fv) a - ((lc ev) b)): " + modInteger2 + ", " + expVector2 + ", " + modInteger + ", " + expVector), this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(modInteger2, modInteger, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft((RingElem)modInteger2).subtract(this.b.multiplyLeft((RingElem)modInteger));
        ModGenSolvablePolynomialTest.assertEquals((String)"tc a - lc b == (tc a) - (lc b)", this.d, this.e);
    }

    public void testDistributive() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<ModInteger>(this.cfac, n);
        WeylRelations<ModInteger> weylRelations = new WeylRelations<ModInteger>();
        weylRelations.generate(this.ring);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ModInteger)((Object)((GenSolvablePolynomial)this.b.sum((ModInteger)((Object)this.c)))));
        this.e = (GenSolvablePolynomial)this.a.multiply((ModInteger)((Object)this.b)).sum(this.a.multiply((ModInteger)((Object)this.c)));
        ModGenSolvablePolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }
}

