/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RatGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RatGenPolynomialTest.suite());
    }

    public RatGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RatGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testGenerate() {
        String string = this.fac.toScript();
        RatGenPolynomialTest.assertTrue((String)("#s == 50: " + string), (string.length() == 50 ? 1 : 0) != 0);
        List<GenPolynomial<BigRational>> list = this.fac.generators();
        RatGenPolynomialTest.assertFalse((String)"#gens != () ", (boolean)list.isEmpty());
        HashSet<GenPolynomial<BigRational>> hashSet = new HashSet<GenPolynomial<BigRational>>(list);
        RatGenPolynomialTest.assertEquals((String)"#gens == #set: ", (int)list.size(), (int)hashSet.size());
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        RatGenPolynomialTest.assertFalse((String)"0 not in #set: ", (boolean)hashSet.contains(this.a));
        RatGenPolynomialTest.assertTrue((String)"1 in #set: ", (boolean)hashSet.contains(this.b));
        RatGenPolynomialTest.assertEquals((String)"#gens == rl+1 ", (int)(this.rl + 1), (int)list.size());
        HashSet<Integer> hashSet2 = new HashSet<Integer>(hashSet.size());
        for (GenPolynomial<BigRational> genPolynomial : list) {
            RatGenPolynomialTest.assertTrue((String)"red(p) == 0 ", (boolean)genPolynomial.reductum().isZERO());
            hashSet2.add(genPolynomial.hashCode());
        }
        RatGenPolynomialTest.assertEquals((String)"#gens == #iset: ", (int)list.size(), (int)hashSet2.size());
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RatGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RatGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RatGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            RatGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RatGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RatGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.c.subtract((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigRational bigRational = BigRational.RNRAND(this.kl);
        this.b = new GenPolynomial<BigRational>(this.fac, bigRational, expVector);
        this.c = this.a.sum((BigRational)((Object)this.b));
        this.d = this.a.sum(bigRational, expVector);
        RatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigRational)((Object)this.b));
        this.d = this.a.subtract(bigRational, expVector);
        RatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigRational>(this.fac);
        this.b = new GenPolynomial<BigRational>(this.fac, bigRational, expVector);
        this.c = this.b.sum((BigRational)((Object)this.a));
        this.d = this.a.sum(bigRational, expVector);
        RatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigRational)((Object)this.b));
        this.d = this.a.subtract(bigRational, expVector);
        RatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigRational)((Object)this.c));
        RatGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RatGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RatGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RatGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RatGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigRational bigRational = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(bigRational);
        RatGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigRational bigRational2 = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(bigRational2);
        RatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigRational>(this.fac, bigRational2);
        this.d = this.b.multiply((BigRational)((Object)this.e));
        RatGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigRational)((Object)this.b));
        RatGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }

    public void testBLAS1() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, 3, this.el * this.el, this.q);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigRational bigRational = BigRational.RNRAND(this.kl);
        this.d = this.a.subtractMultiple(bigRational, this.b);
        this.e = this.a.subtract((BigRational)((Object)this.b.multiply(bigRational)));
        RatGenPolynomialTest.assertEquals((String)"a - (lc) b == a - ((lc) b)", this.d, this.e);
        this.d = this.a.subtractMultiple(bigRational, expVector, this.b);
        this.e = this.a.subtract((BigRational)((Object)this.b.multiply(bigRational, expVector)));
        RatGenPolynomialTest.assertEquals((String)"a - (lc ev) b == a - ((lc ev) b)", this.d, this.e);
        ExpVector expVector2 = ExpVector.random(this.rl, this.el, this.q);
        BigRational bigRational2 = BigRational.RNRAND(this.kl);
        this.d = this.a.scaleSubtractMultiple(bigRational2, bigRational, expVector, this.b);
        this.e = this.a.multiply(bigRational2).subtract((BigRational)((Object)this.b.multiply(bigRational, expVector)));
        RatGenPolynomialTest.assertEquals((String)"(tc) a - (lc ev) b == ((tc) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(bigRational2, expVector2, bigRational, expVector, this.b);
        this.e = this.a.multiply(bigRational2, expVector2).subtract((BigRational)((Object)this.b.multiply(bigRational, expVector)));
        RatGenPolynomialTest.assertEquals((String)"(tc fv) a - (lc ev) b == ((tc fv) a - ((lc ev) b))", this.d, this.e);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).sum((GenPolynomial<BigRational>)this.a.multiply((BigRational)((Object)this.c)));
        RatGenPolynomialTest.assertEquals((String)"a(b+c) == ab+ac", this.d, this.e);
    }

    public void testQuotRem() {
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        this.a = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        GenPolynomial<BigRational> genPolynomial = this.a;
        GenPolynomial genPolynomial2 = ((GenPolynomial)this.fac.random(this.ll)).monic();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( g )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        this.a = this.a.multiply((BigRational)((Object)genPolynomial2));
        this.b = this.b.multiply((BigRational)((Object)genPolynomial2));
        GenPolynomial<BigRational>[] genPolynomialArray = this.b.quotientRemainder(this.a);
        this.c = genPolynomialArray[0];
        this.d = genPolynomialArray[1];
        this.e = this.c.multiply((BigRational)((Object)this.a)).sum(this.d);
        RatGenPolynomialTest.assertEquals((String)"b = q a + r", this.b, this.e);
        genPolynomialArray = this.a.quotientRemainder(this.b);
        this.c = genPolynomialArray[0];
        this.d = genPolynomialArray[1];
        this.e = this.c.multiply((BigRational)((Object)this.b)).sum(this.d);
        RatGenPolynomialTest.assertEquals((String)"a = q b + r", this.a, this.e);
        this.c = this.a.gcd(this.b);
        RatGenPolynomialTest.assertTrue((String)"a mod gcd(a,b) = 0", (boolean)this.a.remainder(this.c).isZERO());
        RatGenPolynomialTest.assertTrue((String)"b mod gcd(a,b) = 0", (boolean)this.b.remainder(this.c).isZERO());
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, genPolynomial2);
        GenPolynomial<BigRational>[] genPolynomialArray2 = this.a.egcd(this.b);
        this.c = genPolynomialArray2[0];
        this.d = genPolynomialArray2[1];
        this.e = genPolynomialArray2[2];
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, genPolynomial2);
        GenPolynomial<RingElem<GenPolynomial<BigRational>>> genPolynomial3 = this.a.multiply((BigRational)((Object)this.d)).sum((GenPolynomial<BigRational>)this.b.multiply((BigRational)((Object)this.e))).monic();
        RatGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s + b t", this.c, genPolynomial3);
        genPolynomialArray2 = this.a.hegcd(this.b);
        this.c = genPolynomialArray2[0];
        this.d = genPolynomialArray2[1];
        RatGenPolynomialTest.assertEquals((String)"g = gcd(a,b)", this.c, genPolynomial2);
        genPolynomial3 = this.a.multiply((BigRational)((Object)this.d)).remainder((GenPolynomial<GenPolynomial<BigRational>>)this.b).monic();
        RatGenPolynomialTest.assertEquals((String)"gcd(a,b) = a s mod b", this.c, genPolynomial3);
        this.c = genPolynomial.modInverse(genPolynomial2);
        genPolynomial3 = this.c.multiply((BigRational)((Object)genPolynomial)).remainder(genPolynomial2).monic();
        RatGenPolynomialTest.assertTrue((String)"h invertible mod g", (boolean)genPolynomial3.isONE());
    }

    public void testAdditionSpeed() {
        int n = 100;
        long l = 1000L;
        boolean bl = false;
        int n2 = 1;
        for (int i = 1; i < 5; ++i) {
            for (int j = 1; j < 5; ++j) {
                this.a = this.fac.random(this.kl, j * n, this.el, this.q);
                this.b = this.fac.random(this.kl, n, this.el, this.q);
                for (int k = 0; k < n2; ++k) {
                    long l2 = System.nanoTime();
                    this.c = this.a.sum((BigRational)((Object)this.b));
                    l2 = System.nanoTime() - l2;
                    RatGenPolynomialTest.assertTrue((String)"c != 0", (!this.c.isZERO() ? 1 : 0) != 0);
                    long l3 = System.nanoTime();
                    this.d = this.b.sum((BigRational)((Object)this.a));
                    l3 = System.nanoTime() - l3;
                    RatGenPolynomialTest.assertTrue((String)"d != 0", (!this.d.isZERO() ? 1 : 0) != 0);
                    if (!bl) continue;
                    System.out.print("#a = " + this.a.length() + ", #b = " + this.b.length());
                    System.out.println(",\t t1 = " + l2 / l + ", t2 = " + l3 / l);
                }
                if (bl) {
                    System.out.println();
                }
                RatGenPolynomialTest.assertEquals((String)"c == d", this.c, this.d);
            }
            n = 3 * n;
        }
    }

    public void testAbsNorm() {
        this.a = ((GenPolynomial)this.fac.getONE()).negate();
        BigRational bigRational = PolyUtil.absNorm(this.a);
        RatGenPolynomialTest.assertTrue((String)"isONE( absNorm(-1) )", (boolean)bigRational.isONE());
        this.a = this.fac.random(this.kl * 2, this.ll + 2, this.el, this.q);
        bigRational = PolyUtil.absNorm(this.a);
        RatGenPolynomialTest.assertTrue((String)" not isZERO( absNorm(a) )", (!bigRational.isZERO() || this.a.isZERO() ? 1 : 0) != 0);
    }

    public void testMaxNorm() {
        this.a = this.fac.getZERO();
        BigRational bigRational = this.a.maxNorm();
        RatGenPolynomialTest.assertTrue((String)"isONE( maxNorm(0) )", (boolean)bigRational.isZERO());
        bigRational = this.a.sumNorm();
        RatGenPolynomialTest.assertTrue((String)"isONE( sumNorm(0) )", (boolean)bigRational.isZERO());
        this.a = ((GenPolynomial)this.fac.getONE()).negate();
        bigRational = this.a.maxNorm();
        RatGenPolynomialTest.assertTrue((String)"isONE( maxNorm(-1) )", (boolean)bigRational.isONE());
        bigRational = this.a.sumNorm();
        RatGenPolynomialTest.assertTrue((String)"isONE( sumNorm(-1) )", (boolean)bigRational.isONE());
        this.a = this.fac.random(this.kl * 2, this.ll + 2, this.el, this.q);
        bigRational = this.a.maxNorm();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( maxNorm(a) )", (!bigRational.isZERO() || this.a.isZERO() ? 1 : 0) != 0);
        bigRational = this.a.sumNorm();
        RatGenPolynomialTest.assertTrue((String)"not isZERO( maxNorm(a) )", (!bigRational.isZERO() || this.a.isZERO() ? 1 : 0) != 0);
    }
}

