/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.ps.Coefficients;
import edu.jas.ps.Multiply;
import edu.jas.ps.Negate;
import edu.jas.ps.Subtract;
import edu.jas.ps.Sum;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.BinaryFunctor;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.Selector;
import edu.jas.structure.UnaryFunctor;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;

public class UnivPowerSeries<C extends RingElem<C>>
implements RingElem<UnivPowerSeries<C>> {
    public final UnivPowerSeriesRing<C> ring;
    Coefficients<C> lazyCoeffs;
    private int truncate = 11;
    private int order = -1;

    private UnivPowerSeries() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    UnivPowerSeries(UnivPowerSeriesRing<C> univPowerSeriesRing) {
        this.ring = univPowerSeriesRing;
        this.lazyCoeffs = null;
    }

    public UnivPowerSeries(UnivPowerSeriesRing<C> univPowerSeriesRing, Coefficients<C> coefficients) {
        if (coefficients == null || univPowerSeriesRing == null) {
            throw new IllegalArgumentException("null not allowed: ring = " + univPowerSeriesRing + ", lazyCoeffs = " + coefficients);
        }
        this.ring = univPowerSeriesRing;
        this.lazyCoeffs = coefficients;
        this.truncate = univPowerSeriesRing.truncate;
    }

    @Override
    public UnivPowerSeriesRing<C> factory() {
        return this.ring;
    }

    @Override
    public UnivPowerSeries<C> copy() {
        return new UnivPowerSeries<C>(this.ring, this.lazyCoeffs);
    }

    public String toString() {
        return this.toString(this.truncate);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        UnivPowerSeries univPowerSeries = this;
        String string = this.ring.var;
        for (int i = 0; i < n; ++i) {
            Object object = univPowerSeries.coefficient(i);
            int n2 = object.signum();
            if (n2 == 0) continue;
            if (n2 > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" + ");
                }
            } else {
                object = (RingElem)object.negate();
                stringBuffer.append(" - ");
            }
            if (!object.isONE() || i == 0) {
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append("{ ");
                }
                stringBuffer.append(object.toString());
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append(" }");
                }
                if (i > 0) {
                    stringBuffer.append(" * ");
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string + "^" + i);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("0");
        }
        stringBuffer.append(" + BigO(" + string + "^" + n + ")");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("");
        UnivPowerSeries univPowerSeries = this;
        String string = this.ring.var;
        for (int i = 0; i < this.truncate; ++i) {
            Object object = univPowerSeries.coefficient(i);
            int n = object.signum();
            if (n == 0) continue;
            if (n > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" + ");
                }
            } else {
                object = (RingElem)object.negate();
                stringBuffer.append(" - ");
            }
            if (!object.isONE() || i == 0) {
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append("{ ");
                }
                stringBuffer.append(object.toScript());
                if (object instanceof GenPolynomial || object instanceof AlgebraicNumber) {
                    stringBuffer.append(" }");
                }
                if (i > 0) {
                    stringBuffer.append(" * ");
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string + "**" + i);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((UnivPowerSeriesRing)this.factory()).toScript();
    }

    public C coefficient(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index not allowed");
        }
        return this.lazyCoeffs.get(n);
    }

    public GenPolynomial<C> asPolynomial() {
        GenPolynomial<C> genPolynomial = this.ring.polyRing().getZERO();
        for (int i = 0; i < this.truncate; ++i) {
            C c = this.coefficient(i);
            ExpVector expVector = ExpVector.create(1, 0, i);
            genPolynomial = genPolynomial.sum(c, expVector);
        }
        return genPolynomial;
    }

    public GenVector<C> asVector() {
        GenVectorModul genVectorModul = new GenVectorModul(this.ring.coFac, this.truncate);
        ArrayList<C> arrayList = new ArrayList<C>(this.truncate);
        for (int i = 0; i < this.truncate; ++i) {
            C c = this.coefficient(i);
            arrayList.add(c);
        }
        GenVector genVector = new GenVector(genVectorModul, arrayList);
        return genVector;
    }

    public C leadingCoefficient() {
        return this.coefficient(0);
    }

    public UnivPowerSeries<C> reductum() {
        final int n = this.order();
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n2) {
                if (n == n2) {
                    return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
                }
                return UnivPowerSeries.this.coefficient(n2);
            }
        });
    }

    public UnivPowerSeries<C> prepend(C c) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>((RingElem)c){
            final /* synthetic */ RingElem val$h;
            {
                this.val$h = ringElem;
            }

            @Override
            public C generate(int n) {
                if (n == 0) {
                    return this.val$h;
                }
                return UnivPowerSeries.this.coefficient(n - 1);
            }
        });
    }

    public UnivPowerSeries<C> shift(final int n) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n2) {
                if (n2 - n < 0) {
                    return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
                }
                return UnivPowerSeries.this.coefficient(n2 - n);
            }
        });
    }

    public UnivPowerSeries<C> select(final Selector<? super C> selector) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                Object c = UnivPowerSeries.this.coefficient(n);
                if (selector.select(c)) {
                    return c;
                }
                return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> shiftSelect(final Selector<? super C> selector) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){
            int pos = 0;

            @Override
            public C generate(int n) {
                Object c;
                if (n > 0) {
                    c = this.get(n - 1);
                }
                while (!selector.select(c = UnivPowerSeries.this.coefficient(this.pos++))) {
                }
                return c;
            }
        });
    }

    public UnivPowerSeries<C> map(final UnaryFunctor<? super C, C> unaryFunctor) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                return (RingElem)unaryFunctor.eval(UnivPowerSeries.this.coefficient(n));
            }
        });
    }

    public <C2 extends RingElem<C2>> UnivPowerSeries<C> zip(final BinaryFunctor<? super C, ? super C2, C> binaryFunctor, final UnivPowerSeries<C2> univPowerSeries) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                return (RingElem)binaryFunctor.eval(UnivPowerSeries.this.coefficient(n), univPowerSeries.coefficient(n));
            }
        });
    }

    @Override
    public UnivPowerSeries<C> sum(UnivPowerSeries<C> univPowerSeries) {
        return this.zip(new Sum(), univPowerSeries);
    }

    @Override
    public UnivPowerSeries<C> subtract(UnivPowerSeries<C> univPowerSeries) {
        return this.zip(new Subtract(), univPowerSeries);
    }

    @Override
    public UnivPowerSeries<C> multiply(C c) {
        return this.map(new Multiply<C>(c));
    }

    public UnivPowerSeries<C> monic() {
        int n = this.order();
        C c = this.coefficient(n);
        if (c.isONE()) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        final RingElem ringElem = (RingElem)c.inverse();
        return this.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)ringElem.multiply(c);
            }
        });
    }

    @Override
    public UnivPowerSeries<C> negate() {
        return this.map(new Negate());
    }

    @Override
    public UnivPowerSeries<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public C evaluate(C c) {
        RingElem ringElem = this.coefficient(0);
        Object object = c;
        for (int i = 1; i < this.truncate; ++i) {
            RingElem ringElem2 = (RingElem)this.coefficient(i).multiply(object);
            ringElem = ringElem.sum((RingElem)ringElem2);
            object = (RingElem)object.multiply(c);
        }
        return (C)ringElem;
    }

    public int order() {
        if (this.order < 0) {
            for (int i = 0; i < this.truncate; ++i) {
                if (this.coefficient(i).isZERO()) continue;
                this.order = i;
                return this.order;
            }
            this.order = this.truncate;
        }
        return this.order;
    }

    public int truncate() {
        return this.truncate;
    }

    public int setTruncate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative truncate not allowed");
        }
        int n2 = this.truncate;
        this.truncate = n;
        return n2;
    }

    @Override
    public int signum() {
        return this.coefficient(this.order()).signum();
    }

    @Override
    public int compareTo(UnivPowerSeries<C> univPowerSeries) {
        int n;
        int n2 = this.order();
        int n3 = n2 <= (n = univPowerSeries.order()) ? n2 : n;
        int n4 = 0;
        while ((n4 = this.coefficient(n3).compareTo(univPowerSeries.coefficient(n3))) == 0 && ++n3 < this.truncate) {
        }
        return n4;
    }

    @Override
    public boolean isZERO() {
        return this.compareTo(this.ring.ZERO) == 0;
    }

    @Override
    public boolean isONE() {
        return this.compareTo(this.ring.ONE) == 0;
    }

    @Override
    public boolean equals(Object object) {
        UnivPowerSeries univPowerSeries = null;
        try {
            univPowerSeries = (UnivPowerSeries)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (univPowerSeries == null) {
            return false;
        }
        return this.compareTo(univPowerSeries) == 0;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.truncate; ++i) {
            C c = this.coefficient(i);
            if (!c.isZERO()) {
                n += i;
                n = Math.abs(n << 1);
            }
            n += c.hashCode();
            n = Math.abs(n);
        }
        return n;
    }

    @Override
    public boolean isUnit() {
        return this.leadingCoefficient().isUnit();
    }

    @Override
    public UnivPowerSeries<C> multiply(final UnivPowerSeries<C> univPowerSeries) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                RingElem ringElem = null;
                for (int i = 0; i <= n; ++i) {
                    RingElem ringElem2 = (RingElem)UnivPowerSeries.this.coefficient(i).multiply(univPowerSeries.coefficient(n - i));
                    ringElem = ringElem == null ? ringElem2 : ringElem.sum(ringElem2);
                }
                return ringElem;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> inverse() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                RingElem ringElem = (RingElem)UnivPowerSeries.this.leadingCoefficient().inverse();
                if (n == 0) {
                    return ringElem;
                }
                MonoidElem monoidElem = null;
                for (int i = 0; i < n; ++i) {
                    RingElem ringElem2 = (RingElem)this.get(i).multiply(UnivPowerSeries.this.coefficient(n - i));
                    monoidElem = monoidElem == null ? ringElem2 : monoidElem.sum(ringElem2);
                }
                monoidElem = monoidElem.multiply((RingElem)ringElem.negate());
                return monoidElem;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> divide(UnivPowerSeries<C> univPowerSeries) {
        int n;
        if (univPowerSeries.isUnit()) {
            return this.multiply((UnivPowerSeries<C>)univPowerSeries.inverse());
        }
        int n2 = this.order();
        if (n2 < (n = univPowerSeries.order())) {
            return this.ring.getZERO();
        }
        if (!univPowerSeries.coefficient(n).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + univPowerSeries.coefficient(n) + ", n = " + n);
        }
        UnivPowerSeries<C> univPowerSeries2 = n2 == 0 ? this : this.shift(-n2);
        UnivPowerSeries<C> univPowerSeries3 = n == 0 ? univPowerSeries : univPowerSeries.shift(-n);
        UnivPowerSeries<C> univPowerSeries4 = univPowerSeries2.multiply((UnivPowerSeries<C>)univPowerSeries3.inverse());
        UnivPowerSeries<C> univPowerSeries5 = n2 == n ? univPowerSeries4 : univPowerSeries4.shift(n2 - n);
        return univPowerSeries5;
    }

    @Override
    public UnivPowerSeries<C> remainder(UnivPowerSeries<C> univPowerSeries) {
        int n;
        int n2 = this.order();
        if (n2 >= (n = univPowerSeries.order())) {
            return this.ring.getZERO();
        }
        return this;
    }

    public UnivPowerSeries<C>[] quotientRemainder(UnivPowerSeries<C> univPowerSeries) {
        return new UnivPowerSeries[]{this.divide(univPowerSeries), this.remainder(univPowerSeries)};
    }

    public UnivPowerSeries<C> differentiate() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                RingElem ringElem = UnivPowerSeries.this.coefficient(n + 1);
                ringElem = ringElem.multiply((RingElem)((RingElem)UnivPowerSeries.this.ring.coFac.fromInteger(n + 1)));
                return ringElem;
            }
        });
    }

    public UnivPowerSeries<C> integrate(C c) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>((RingElem)c){
            final /* synthetic */ RingElem val$c;
            {
                this.val$c = ringElem;
            }

            @Override
            public C generate(int n) {
                if (n == 0) {
                    return this.val$c;
                }
                RingElem ringElem = UnivPowerSeries.this.coefficient(n - 1);
                ringElem = ringElem.divide((RingElem)((RingElem)UnivPowerSeries.this.ring.coFac.fromInteger(n)));
                return ringElem;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> gcd(UnivPowerSeries<C> univPowerSeries) {
        int n;
        if (univPowerSeries.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return univPowerSeries;
        }
        int n2 = this.order();
        int n3 = n2 < (n = univPowerSeries.order()) ? n2 : n;
        return ((UnivPowerSeries)this.ring.getONE()).shift(n3);
    }

    public UnivPowerSeries<C>[] egcd(UnivPowerSeries<C> univPowerSeries) {
        throw new UnsupportedOperationException("egcd for power series not implemented");
    }
}

