/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RealRootTuple<C extends GcdRingElem<C> & Rational>
implements Serializable {
    public final List<RealAlgebraicNumber<C>> tuple;

    public RealRootTuple(List<RealAlgebraicNumber<C>> list) {
        if (list == null) {
            throw new IllegalArgumentException("null tuple not allowed");
        }
        this.tuple = list;
    }

    public String toString() {
        return this.tuple.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("[");
        boolean bl = true;
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(realAlgebraicNumber.toScript());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean contains(RealRootTuple<C> realRootTuple) {
        return this.contains(realRootTuple.tuple);
    }

    public boolean contains(List<RealAlgebraicNumber<C>> list) {
        int n = 0;
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            RealAlgebraicNumber<C> realAlgebraicNumber2 = list.get(n++);
            boolean bl = realAlgebraicNumber.ring.root.contains(realAlgebraicNumber2.ring.root);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List<C> randomPoint() {
        ArrayList<GcdRingElem> arrayList = new ArrayList<GcdRingElem>(this.tuple.size());
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            GcdRingElem gcdRingElem = (GcdRingElem)realAlgebraicNumber.ring.root.randomPoint();
            arrayList.add(gcdRingElem);
        }
        return arrayList;
    }

    public void refineRoot(BigRational bigRational) {
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            realAlgebraicNumber.ring.refineRoot(bigRational);
        }
    }

    public RealRootTuple<C> copy() {
        return new RealRootTuple<C>(new ArrayList<RealAlgebraicNumber<C>>(this.tuple));
    }

    public boolean equals(Object object) {
        RealRootTuple realRootTuple = null;
        try {
            realRootTuple = (RealRootTuple)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (realRootTuple == null) {
            return false;
        }
        return this.tuple.equals(realRootTuple.tuple);
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    public List<BigRational> getRational() {
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(this.tuple.size());
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            BigRational bigRational = realAlgebraicNumber.getRational();
            arrayList.add(bigRational);
        }
        return arrayList;
    }

    public List<BigDecimal> decimalMagnitude() {
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(this.tuple.size());
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            BigDecimal bigDecimal = realAlgebraicNumber.decimalMagnitude();
            arrayList.add(bigDecimal);
        }
        return arrayList;
    }

    public BigRational rationalLength() {
        BigRational bigRational = new BigRational();
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            BigRational bigRational2 = realAlgebraicNumber.ring.root.rationalLength();
            int n = bigRational.compareTo(bigRational2);
            if (n >= 0) continue;
            bigRational = bigRational2;
        }
        return bigRational;
    }

    public int signum() {
        int n = 0;
        for (RealAlgebraicNumber<C> realAlgebraicNumber : this.tuple) {
            int n2 = realAlgebraicNumber.signum();
            if (n2 == 0) continue;
            n = n2;
        }
        return n;
    }
}

