/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GCDProxy<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GCDProxy.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GreatestCommonDivisorAbstract<C> e1;
    public final GreatestCommonDivisorAbstract<C> e2;
    protected transient ExecutorService pool;

    public GCDProxy(GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract, GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract2) {
        this.e1 = greatestCommonDivisorAbstract;
        this.e2 = greatestCommonDivisorAbstract2;
        this.pool = ComputerThreads.getPool();
    }

    @Override
    public String toString() {
        return "GCDProxy[ " + this.e1.getClass().getName() + ", " + this.e2.getClass().getName() + " ]";
    }

    @Override
    public GenPolynomial<C> baseGcd(final GenPolynomial<C> genPolynomial, final GenPolynomial<C> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.baseGcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.baseGcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(final GenPolynomial<GenPolynomial<C>> genPolynomial, final GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.recursiveUnivariateGcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.recursiveUnivariateGcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<C> gcd(final GenPolynomial<C> genPolynomial, final GenPolynomial<C> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.gcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.gcd(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<C> baseResultant(final GenPolynomial<C> genPolynomial, final GenPolynomial<C> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.baseResultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.baseResultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateResultant(final GenPolynomial<GenPolynomial<C>> genPolynomial, final GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.recursiveUnivariateResultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.recursiveUnivariateResultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<C> resultant(final GenPolynomial<C> genPolynomial, final GenPolynomial<C> genPolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e1.resultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e1 {}", (Object)GCDProxy.this.e1.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e1 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> call() {
                try {
                    GenPolynomial genPolynomial3 = GCDProxy.this.e2.resultant(genPolynomial, genPolynomial2);
                    if (debug) {
                        logger.info("GCDProxy done e2 {}", (Object)GCDProxy.this.e2.getClass().getName());
                    }
                    return genPolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GCDProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("GCDProxy e2 {}", (Throwable)exception);
                    logger.info("GCDProxy P = {}", (Object)genPolynomial);
                    logger.info("GCDProxy S = {}", (Object)genPolynomial2);
                    throw new RuntimeException("GCDProxy e2 " + exception);
                }
            }
        });
        try {
            genPolynomial3 = (GenPolynomial)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return genPolynomial3;
    }
}

