/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.LinAlg;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenMatrixFFTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;
    int rows = 23;
    int cols = 23;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenMatrixFFTest.suite());
    }

    public GenMatrixFFTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenMatrixFFTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testFractionfreeGE() {
        BigInteger bigInteger = new BigInteger(1L);
        int n = 4;
        int n2 = 5;
        GenMatrixRing<BigInteger> genMatrixRing = new GenMatrixRing<BigInteger>(bigInteger, n, n2);
        Element element = genMatrixRing.parse("[ [3,4,-2,1,-2], [1,-1,2,2,7], [4,-3,4,-3,2], [-1,1,6,-1,1] ]");
        if (((GenMatrix)element).isZERO()) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)element).isZERO() ? 1 : 0) != 0);
        Element element2 = ((GenMatrix)element).copy();
        LinAlg linAlg = new LinAlg();
        List<Integer> list = linAlg.fractionfreeGaussElimination(element2);
        if (list.size() == 0) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)"#P != 0: ", (list.size() > 0 ? 1 : 0) != 0);
        n2 = n = 10;
        genMatrixRing = new GenMatrixRing<BigInteger>(bigInteger, n, n2);
        element = genMatrixRing.random(5, 0.67f);
        if (((GenMatrix)element).isZERO()) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)element).isZERO() ? 1 : 0) != 0);
        element2 = ((GenMatrix)element).copy();
        list = linAlg.fractionfreeGaussElimination(element);
        if (list.size() == 0) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)"#P != 0: ", (list.size() > 0 ? 1 : 0) != 0);
    }

    public void testFractionfreeGEpoly() {
        int n;
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"a1", "a2", "a3", "a4"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        int n2 = n = 4;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, n, n2);
        Element element = genMatrixRing.random(4, 0.5f);
        if (((GenMatrix)element).isZERO()) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)element).isZERO() ? 1 : 0) != 0);
        Element element2 = ((GenMatrix)element).copy();
        LinAlg linAlg = new LinAlg();
        List<Integer> list = linAlg.fractionfreeGaussElimination(element2);
        if (list.size() == 0) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)"#P != 0: ", (list.size() > 0 ? 1 : 0) != 0);
        stringArray = new String[]{"a11", "a12", "a13", "a14", "a21", "a22", "a23", "a24", "a31", "a32", "a33", "a34", "a41", "a42", "a43", "a44"};
        genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        genMatrixRing = new GenMatrixRing<BigRational>(genPolynomialRing, n, n2);
        element = genMatrixRing.parse("[ [a11, a12, a13, a14], [a21, a22, a23, a24], [a31, a32, a33, a34], [a41, a42, a43, a44]] ");
        if (((GenMatrix)element).isZERO()) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)element).isZERO() ? 1 : 0) != 0);
        element2 = ((GenMatrix)element).copy();
        list = linAlg.fractionfreeGaussElimination(element);
        if (list.size() == 0) {
            return;
        }
        GenMatrixFFTest.assertTrue((String)"#P != 0: ", (list.size() > 0 ? 1 : 0) != 0);
        FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(bigRational);
        int n3 = 0;
        for (ArrayList arrayList : ((GenMatrix)element).matrix) {
            int n4 = 0;
            for (GenPolynomial genPolynomial : arrayList) {
                if (genPolynomial.isZERO()) {
                    ++n4;
                    continue;
                }
                SortedMap<GenPolynomial<BigRational>, Long> sortedMap = factorAbstract.factors(genPolynomial);
                GenMatrixFFTest.assertTrue((String)"#factors == 1:", (sortedMap.size() == 1 ? 1 : 0) != 0);
                ++n4;
            }
            ++n3;
        }
        ComputerThreads.terminate();
    }
}

