/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HenselUtil {
    private static final Logger logger = LogManager.getLogger(HenselUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, GenPolynomial<MOD> genPolynomial4, GenPolynomial<MOD> genPolynomial5) throws NoLiftingException {
        RingElem<BigInteger> ringElem;
        RingElem<BigInteger> ringElem2;
        GenPolynomial<Object>[] genPolynomialArray;
        GcdRingElem gcdRingElem;
        RingFactory ringFactory;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return new HenselApprox<MOD>(genPolynomial, genPolynomial, genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        RingFactory ringFactory2 = ringFactory = genPolynomialRing2.coFac;
        ModularRingFactory modularRingFactory = (ModularRingFactory)ringFactory;
        ModularRingFactory<ModLong> modularRingFactory2 = (ModularRingFactory<ModLong>)ringFactory2;
        BigInteger bigInteger2 = modularRingFactory2.getIntegerModul();
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger.fromInteger(2L));
        BigInteger bigInteger4 = bigInteger2;
        BigInteger bigInteger5 = genPolynomial.leadingBaseCoefficient();
        genPolynomial = genPolynomial.multiply(bigInteger5);
        GcdRingElem gcdRingElem2 = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem2.isONE()) {
            genPolynomial2 = genPolynomial2.divide((Object)gcdRingElem2);
            genPolynomial4 = genPolynomial4.multiply((Object)gcdRingElem2);
        }
        if (!(gcdRingElem = (GcdRingElem)genPolynomial3.leadingBaseCoefficient()).isONE()) {
            genPolynomial3 = genPolynomial3.divide((Object)gcdRingElem);
            genPolynomial5 = genPolynomial5.multiply((Object)gcdRingElem);
        }
        GcdRingElem gcdRingElem3 = (GcdRingElem)modularRingFactory.fromInteger(bigInteger5.getVal());
        genPolynomial2 = genPolynomial2.multiply((Object)gcdRingElem3);
        genPolynomial3 = genPolynomial3.multiply((Object)gcdRingElem3);
        genPolynomial5 = genPolynomial5.divide((Object)gcdRingElem3);
        genPolynomial4 = genPolynomial4.divide((Object)gcdRingElem3);
        GenPolynomial<RingElem<BigInteger>> genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial2);
        GenPolynomial<RingElem<BigInteger>> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial3);
        ExpVector expVector = genPolynomial6.leadingExpVector();
        ExpVector expVector2 = genPolynomial7.leadingExpVector();
        genPolynomial6.doPutToMap(expVector, bigInteger5);
        genPolynomial7.doPutToMap(expVector2, bigInteger5);
        RingElem ringElem3 = genPolynomial2;
        GenPolynomial<Object> genPolynomial8 = genPolynomial3;
        while (bigInteger4.compareTo(bigInteger3) < 0) {
            GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> genPolynomial9 = genPolynomial.subtract((BigInteger)((Object)genPolynomial6.multiply((BigInteger)((Object)genPolynomial7))));
            if (genPolynomial9.isZERO()) {
                logger.info("leaving on zero E");
                break;
            }
            genPolynomial9 = genPolynomial9.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)bigInteger2));
            GenPolynomial genPolynomial10 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial9);
            GenPolynomial<GenPolynomial<Object>> genPolynomial11 = genPolynomial4.multiply((Object)genPolynomial10);
            GenPolynomial<GenPolynomial<GenPolynomial<Object>>> genPolynomial12 = genPolynomial5.multiply((Object)genPolynomial10);
            genPolynomialArray = genPolynomial11.quotientRemainder((GenPolynomial<GenPolynomial<Object>>)genPolynomial3);
            ringElem2 = genPolynomialArray[0];
            ringElem = genPolynomialArray[1];
            ringElem3 = ringElem;
            genPolynomial8 = genPolynomial12.sum((GenPolynomial<GenPolynomial<Object>>)genPolynomial2.multiply((Object)ringElem2));
            GenPolynomial<RingElem<BigInteger>> genPolynomial13 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, ringElem3);
            GenPolynomial<RingElem<BigInteger>> genPolynomial14 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial8);
            GenPolynomial<BigInteger> genPolynomial15 = genPolynomial13.multiply(bigInteger2);
            GenPolynomial<BigInteger> genPolynomial16 = genPolynomial14.multiply(bigInteger2);
            genPolynomial13 = genPolynomial6.sum((BigInteger)((Object)genPolynomial16));
            genPolynomial14 = genPolynomial7.sum((BigInteger)((Object)genPolynomial15));
            assert (genPolynomial13.degree(0) + genPolynomial14.degree(0) <= genPolynomial.degree(0));
            bigInteger4 = bigInteger2;
            bigInteger2 = modularRingFactory2.getIntegerModul().multiply(modularRingFactory.getIntegerModul());
            modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
            genPolynomial6 = genPolynomial13;
            genPolynomial7 = genPolynomial14;
        }
        genPolynomialArray = new GreatestCommonDivisorPrimitive();
        ringElem2 = genPolynomialArray.baseContent(genPolynomial6);
        genPolynomial6 = genPolynomial6.divide(ringElem2);
        ringElem = null;
        try {
            ringElem = bigInteger5.divide((BigInteger)ringElem2);
            genPolynomial7 = genPolynomial7.divide(ringElem);
        }
        catch (RuntimeException runtimeException) {
            throw new NoLiftingException("no exact lifting possible " + runtimeException);
        }
        return new HenselApprox<Object>((GenPolynomial<BigInteger>)genPolynomial6, (GenPolynomial<BigInteger>)genPolynomial7, (GenPolynomial<Object>)ringElem3, genPolynomial8);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHensel(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3) throws NoLiftingException {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return new HenselApprox<MOD>(genPolynomial, genPolynomial, genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] genPolynomialArray = genPolynomial2.egcd(genPolynomial3);
            if (!genPolynomialArray[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + genPolynomialArray[0] + ", A = " + genPolynomial2 + ", B = " + genPolynomial3);
            }
            GenPolynomial<MOD> genPolynomial4 = genPolynomialArray[1];
            GenPolynomial<MOD> genPolynomial5 = genPolynomialArray[2];
            HenselApprox<MOD> henselApprox = HenselUtil.liftHensel(genPolynomial, bigInteger, genPolynomial2, genPolynomial3, genPolynomial4, genPolynomial5);
            return henselApprox;
        }
        catch (ArithmeticException arithmeticException) {
            throw new NoLiftingException("coefficient error " + arithmeticException);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, GenPolynomial<MOD> genPolynomial4, GenPolynomial<MOD> genPolynomial5) throws NoLiftingException {
        RingElem<BigInteger> ringElem;
        RingElem<BigInteger> ringElem2;
        GenPolynomial<GenPolynomial<C>>[] genPolynomialArray;
        GcdRingElem gcdRingElem;
        RingFactory ringFactory;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return new HenselApprox<MOD>(genPolynomial, genPolynomial, genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        RingFactory ringFactory2 = ringFactory = genPolynomialRing2.coFac;
        ModularRingFactory modularRingFactory = (ModularRingFactory)ringFactory;
        ModularRingFactory<ModLong> modularRingFactory2 = (ModularRingFactory<ModLong>)ringFactory2;
        BigInteger bigInteger2 = modularRingFactory2.getIntegerModul();
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger.fromInteger(2L));
        BigInteger bigInteger4 = bigInteger2;
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing2);
        BigInteger bigInteger5 = genPolynomial.leadingBaseCoefficient();
        genPolynomial = genPolynomial.multiply(bigInteger5);
        GcdRingElem gcdRingElem2 = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem2.isONE()) {
            genPolynomial2 = genPolynomial2.divide((Object)gcdRingElem2);
            genPolynomial4 = genPolynomial4.multiply((Object)gcdRingElem2);
        }
        if (!(gcdRingElem = (GcdRingElem)genPolynomial3.leadingBaseCoefficient()).isONE()) {
            genPolynomial3 = genPolynomial3.divide((Object)gcdRingElem);
            genPolynomial5 = genPolynomial5.multiply((Object)gcdRingElem);
        }
        GcdRingElem gcdRingElem3 = (GcdRingElem)modularRingFactory.fromInteger(bigInteger5.getVal());
        genPolynomial2 = genPolynomial2.multiply((Object)gcdRingElem3);
        genPolynomial3 = genPolynomial3.multiply((Object)gcdRingElem3);
        genPolynomial5 = genPolynomial5.divide((Object)gcdRingElem3);
        genPolynomial4 = genPolynomial4.divide((Object)gcdRingElem3);
        GenPolynomial<BigInteger> genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial2);
        GenPolynomial<BigInteger> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial3);
        ExpVector expVector = genPolynomial6.leadingExpVector();
        ExpVector expVector2 = genPolynomial7.leadingExpVector();
        genPolynomial6.doPutToMap(expVector, bigInteger5);
        genPolynomial7.doPutToMap(expVector2, bigInteger5);
        RingElem ringElem3 = genPolynomial2;
        RingElem ringElem4 = genPolynomial3;
        GenPolynomial<Object> genPolynomial8 = genPolynomial4;
        GenPolynomial<Object> genPolynomial9 = genPolynomial5;
        GenPolynomial<RingElem<BigInteger>> genPolynomial10 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
        GenPolynomial<RingElem<BigInteger>> genPolynomial11 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial5);
        GenPolynomial<BigInteger> genPolynomial12 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial6);
        GenPolynomial<BigInteger> genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial7);
        while (bigInteger4.compareTo(bigInteger3) < 0) {
            MonoidElem<GenPolynomial<GenPolynomial<BigInteger>>> monoidElem = genPolynomial.subtract((BigInteger)((Object)genPolynomial6.multiply((BigInteger)((Object)genPolynomial7))));
            if (((GenPolynomial)monoidElem).isZERO()) {
                logger.info("leaving on zero E");
                break;
            }
            monoidElem = ((GenPolynomial)monoidElem).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)bigInteger2));
            GenPolynomial genPolynomial14 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, monoidElem);
            GenPolynomial<GenPolynomial<RingElem<BigInteger>>> genPolynomial15 = genPolynomial8.multiply((Object)genPolynomial14);
            GenPolynomial genPolynomial16 = genPolynomial9.multiply((Object)genPolynomial14);
            genPolynomialArray = genPolynomial15.quotientRemainder((GenPolynomial<GenPolynomial<RingElem<BigInteger>>>)genPolynomial13);
            ringElem2 = genPolynomialArray[0];
            ringElem = genPolynomialArray[1];
            ringElem3 = ringElem;
            ringElem4 = genPolynomial16.sum(genPolynomial12.multiply((BigInteger)ringElem2));
            GenPolynomial<RingElem<BigInteger>> genPolynomial17 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, ringElem3);
            GenPolynomial<RingElem<BigInteger>> genPolynomial18 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, ringElem4);
            GenPolynomial<RingElem<BigInteger>> genPolynomial19 = genPolynomial17.multiply(bigInteger2);
            GenPolynomial<RingElem<BigInteger>> genPolynomial20 = genPolynomial18.multiply(bigInteger2);
            genPolynomial17 = genPolynomial6.sum((BigInteger)((Object)genPolynomial20));
            genPolynomial18 = genPolynomial7.sum((BigInteger)((Object)genPolynomial19));
            assert (genPolynomial17.degree(0) + genPolynomial18.degree(0) <= genPolynomial.degree(0));
            genPolynomial6 = genPolynomial17;
            genPolynomial7 = genPolynomial18;
            monoidElem = genPolynomialRing.getONE();
            monoidElem = ((GenPolynomial)monoidElem).subtract(genPolynomial10.multiply((BigInteger)((Object)genPolynomial6))).subtract(genPolynomial11.multiply((BigInteger)((Object)genPolynomial7)));
            monoidElem = ((GenPolynomial)monoidElem).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)bigInteger2));
            genPolynomial14 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, monoidElem);
            genPolynomial15 = genPolynomial8.multiply((Object)genPolynomial14);
            genPolynomial16 = genPolynomial9.multiply((Object)genPolynomial14);
            genPolynomialArray = genPolynomial16.quotientRemainder(genPolynomial12);
            ringElem2 = genPolynomialArray[0];
            ringElem = genPolynomialArray[1];
            ringElem4 = ringElem;
            ringElem3 = genPolynomial15.sum((GenPolynomial<RingElem<BigInteger>>)genPolynomial13.multiply((BigInteger)ringElem2));
            genPolynomial17 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, ringElem3);
            genPolynomial18 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, ringElem4);
            genPolynomial19 = genPolynomial17.multiply(bigInteger2);
            genPolynomial20 = genPolynomial18.multiply(bigInteger2);
            genPolynomial17 = genPolynomial10.sum((BigInteger)((Object)genPolynomial19));
            genPolynomial18 = genPolynomial11.sum((BigInteger)((Object)genPolynomial20));
            genPolynomial10 = genPolynomial17;
            genPolynomial11 = genPolynomial18;
            bigInteger4 = bigInteger2;
            bigInteger2 = modularRingFactory2.getIntegerModul().multiply(modularRingFactory2.getIntegerModul());
            modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
            genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing2);
            genPolynomial12 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial6);
            genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial7);
            genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial10);
            genPolynomial9 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial11);
        }
        genPolynomialArray = new GreatestCommonDivisorPrimitive();
        ringElem2 = genPolynomialArray.baseContent(genPolynomial6);
        genPolynomial6 = genPolynomial6.divide((BigInteger)ringElem2);
        ringElem = null;
        try {
            ringElem = bigInteger5.divide((BigInteger)ringElem2);
            genPolynomial7 = genPolynomial7.divide((BigInteger)ringElem);
        }
        catch (RuntimeException runtimeException) {
            throw new NoLiftingException("no exact lifting possible " + runtimeException);
        }
        return new HenselApprox<Object>(genPolynomial6, genPolynomial7, (GenPolynomial<Object>)ringElem3, (GenPolynomial<Object>)ringElem4);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3) throws NoLiftingException {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return new HenselApprox<MOD>(genPolynomial, genPolynomial, genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] genPolynomialArray = genPolynomial2.egcd(genPolynomial3);
            if (!genPolynomialArray[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + genPolynomialArray[0] + ", A = " + genPolynomial2 + ", B = " + genPolynomial3);
            }
            GenPolynomial<MOD> genPolynomial4 = genPolynomialArray[1];
            GenPolynomial<MOD> genPolynomial5 = genPolynomialArray[2];
            HenselApprox<MOD> henselApprox = HenselUtil.liftHenselQuadratic(genPolynomial, bigInteger, genPolynomial2, genPolynomial3, genPolynomial4, genPolynomial5);
            return henselApprox;
        }
        catch (ArithmeticException arithmeticException) {
            throw new NoLiftingException("coefficient error " + arithmeticException);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3) throws NoLiftingException {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] genPolynomialArray = genPolynomial2.egcd(genPolynomial3);
            if (!genPolynomialArray[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + genPolynomialArray[0] + ", A = " + genPolynomial2 + ", B = " + genPolynomial3);
            }
            GenPolynomial<MOD> genPolynomial4 = genPolynomialArray[1];
            GenPolynomial<MOD> genPolynomial5 = genPolynomialArray[2];
            HenselApprox<MOD> henselApprox = HenselUtil.liftHenselQuadraticFac(genPolynomial, bigInteger, genPolynomial2, genPolynomial3, genPolynomial4, genPolynomial5);
            return henselApprox;
        }
        catch (ArithmeticException arithmeticException) {
            throw new NoLiftingException("coefficient error " + arithmeticException);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadraticFac(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, GenPolynomial<MOD> genPolynomial4, GenPolynomial<MOD> genPolynomial5) throws NoLiftingException {
        BigInteger bigInteger2;
        Object object;
        RingElem<BigInteger> ringElem;
        GenPolynomial<GenPolynomial<C>>[] genPolynomialArray;
        MonoidElem<GenPolynomial<GenPolynomial<ModLong>>> monoidElem;
        GcdRingElem gcdRingElem;
        GcdRingElem gcdRingElem2;
        BigInteger bigInteger3;
        RingFactory ringFactory;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException("C must be nonzero");
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO() || genPolynomial3 == null || genPolynomial3.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        RingFactory ringFactory2 = ringFactory = genPolynomialRing2.coFac;
        ModularRingFactory modularRingFactory = (ModularRingFactory)ringFactory;
        ModularRingFactory<ModLong> modularRingFactory2 = (ModularRingFactory<ModLong>)ringFactory2;
        BigInteger bigInteger4 = bigInteger3 = modularRingFactory2.getIntegerModul();
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger.fromInteger(2L));
        if (debug) {
            logger.debug("M2 =  {}", (Object)bigInteger5);
        }
        BigInteger bigInteger6 = bigInteger4;
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing2);
        BigInteger bigInteger7 = modularRingFactory2.getIntegerModul().multiply(modularRingFactory2.getIntegerModul());
        ModularRingFactory<ModLong> modularRingFactory3 = ModLongRing.MAX_LONG.compareTo(bigInteger7.getVal()) > 0 ? new ModLongRing(bigInteger7.getVal()) : new ModIntegerRing(bigInteger7.getVal());
        GenPolynomialRing<ModLong> genPolynomialRing4 = new GenPolynomialRing<ModLong>(modularRingFactory3, genPolynomialRing3);
        GcdRingElem gcdRingElem3 = (GcdRingElem)modularRingFactory3.fromInteger(bigInteger4.getVal());
        BigInteger bigInteger8 = genPolynomial.leadingBaseCoefficient();
        genPolynomial = genPolynomial.multiply(bigInteger8);
        GcdRingElem gcdRingElem4 = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem4.isONE()) {
            genPolynomial2 = genPolynomial2.divide((Object)gcdRingElem4);
            genPolynomial4 = genPolynomial4.multiply((Object)gcdRingElem4);
        }
        if (!(gcdRingElem2 = (GcdRingElem)genPolynomial3.leadingBaseCoefficient()).isONE()) {
            genPolynomial3 = genPolynomial3.divide((Object)gcdRingElem2);
            genPolynomial5 = genPolynomial5.multiply((Object)gcdRingElem2);
        }
        if ((gcdRingElem = (GcdRingElem)modularRingFactory.fromInteger(bigInteger8.getVal())).isZERO()) {
            System.out.println("c =  " + bigInteger8);
            System.out.println("P =  " + modularRingFactory);
            throw new ArithmeticException("c mod p == 0 not meaningful");
        }
        genPolynomial2 = genPolynomial2.multiply((Object)gcdRingElem);
        genPolynomial4 = genPolynomial4.divide((Object)gcdRingElem);
        genPolynomial3 = genPolynomial3.multiply((Object)gcdRingElem);
        genPolynomial5 = genPolynomial5.divide((Object)gcdRingElem);
        GenPolynomial<BigInteger> genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial2);
        GenPolynomial<BigInteger> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial3);
        ExpVector expVector = genPolynomial6.leadingExpVector();
        ExpVector expVector2 = genPolynomial7.leadingExpVector();
        genPolynomial6.doPutToMap(expVector, bigInteger8);
        genPolynomial7.doPutToMap(expVector2, bigInteger8);
        Object object2 = genPolynomial2;
        Object object3 = genPolynomial3;
        GenPolynomial<Object> genPolynomial8 = genPolynomial4;
        GenPolynomial<Object> genPolynomial9 = genPolynomial5;
        GenPolynomial<BigInteger> genPolynomial10 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
        GenPolynomial<BigInteger> genPolynomial11 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial5);
        GenPolynomial<BigInteger> genPolynomial12 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial6);
        GenPolynomial<BigInteger> genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial7);
        GenPolynomial<ModLong> genPolynomial14 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial);
        GenPolynomial<ModLong> genPolynomial15 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial6);
        GenPolynomial<ModLong> genPolynomial16 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial7);
        GenPolynomial<RingElem<ModLong>> genPolynomial17 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial10);
        GenPolynomial<RingElem<ModLong>> genPolynomial18 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial11);
        while (bigInteger6.compareTo(bigInteger5) < 0) {
            if (debug) {
                logger.debug("mfac =  {}", genPolynomial14.ring);
            }
            if (((GenPolynomial)(monoidElem = genPolynomial14.subtract((ModLong)((Object)genPolynomial15.multiply((ModLong)((Object)genPolynomial16)))))).isZERO() && genPolynomial.subtract((BigInteger)((Object)genPolynomial6.multiply((BigInteger)((Object)genPolynomial7)))).isZERO()) {
                logger.info("leaving on zero E");
                break;
            }
            GenPolynomial<BigInteger> genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, monoidElem);
            GenPolynomial genPolynomial20 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial19 = genPolynomial19.divide(bigInteger4));
            if (genPolynomial20.isZERO() && genPolynomial.subtract((BigInteger)((Object)genPolynomial6.multiply((BigInteger)((Object)genPolynomial7)))).isZERO()) {
                logger.info("leaving on zero Emp");
                break;
            }
            GenPolynomial<GenPolynomial<RingElem<BigInteger>>> genPolynomial21 = genPolynomial8.multiply((Object)genPolynomial20);
            GenPolynomial genPolynomial22 = genPolynomial9.multiply((Object)genPolynomial20);
            genPolynomialArray = null;
            genPolynomialArray = genPolynomial21.quotientRemainder((GenPolynomial<GenPolynomial<RingElem<BigInteger>>>)genPolynomial13);
            ringElem = genPolynomialArray[0];
            object2 = object = genPolynomialArray[1];
            object3 = genPolynomial22.sum(genPolynomial12.multiply((BigInteger)ringElem));
            GenPolynomial<RingElem<ModLong>> genPolynomial23 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, PolyUtil.integerFromModularCoefficients(genPolynomialRing, object2));
            GenPolynomial<RingElem<ModLong>> genPolynomial24 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, PolyUtil.integerFromModularCoefficients(genPolynomialRing, object3));
            GenPolynomial<RingElem<ModLong>> genPolynomial25 = genPolynomial23.multiply((ModLong)gcdRingElem3);
            GenPolynomial<RingElem<ModLong>> genPolynomial26 = genPolynomial24.multiply((ModLong)gcdRingElem3);
            genPolynomial23 = genPolynomial15.sum((ModLong)((Object)genPolynomial26));
            genPolynomial24 = genPolynomial16.sum((ModLong)((Object)genPolynomial25));
            assert (genPolynomial23.degree(0) + genPolynomial24.degree(0) <= genPolynomial14.degree(0));
            genPolynomial15 = genPolynomial23;
            genPolynomial16 = genPolynomial24;
            genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial15);
            genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial16);
            monoidElem = genPolynomialRing4.getONE();
            monoidElem = ((GenPolynomial)monoidElem).subtract(genPolynomial17.multiply((ModLong)((Object)genPolynomial15))).subtract(genPolynomial18.multiply((ModLong)((Object)genPolynomial16)));
            genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, monoidElem);
            genPolynomial19 = genPolynomial19.divide(bigInteger4);
            genPolynomial20 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial19);
            genPolynomial21 = genPolynomial8.multiply((Object)genPolynomial20);
            genPolynomial22 = genPolynomial9.multiply((Object)genPolynomial20);
            genPolynomialArray = genPolynomial22.quotientRemainder(genPolynomial12);
            ringElem = genPolynomialArray[0];
            object3 = object = genPolynomialArray[1];
            object2 = genPolynomial21.sum((GenPolynomial<RingElem<BigInteger>>)genPolynomial13.multiply((BigInteger)ringElem));
            genPolynomial23 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, PolyUtil.integerFromModularCoefficients(genPolynomialRing, object2));
            genPolynomial24 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, PolyUtil.integerFromModularCoefficients(genPolynomialRing, object3));
            genPolynomial25 = genPolynomial23.multiply(gcdRingElem3);
            genPolynomial26 = genPolynomial24.multiply(gcdRingElem3);
            genPolynomial23 = genPolynomial17.sum((ModLong)((Object)genPolynomial25));
            genPolynomial24 = genPolynomial18.sum((ModLong)((Object)genPolynomial26));
            genPolynomial17 = genPolynomial23;
            genPolynomial18 = genPolynomial24;
            genPolynomial10 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial17);
            genPolynomial11 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial18);
            bigInteger6 = bigInteger4 = modularRingFactory2.getIntegerModul().multiply(modularRingFactory2.getIntegerModul());
            modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger4.getVal()) > 0 ? new ModLongRing(bigInteger4.getVal()) : new ModIntegerRing(bigInteger4.getVal());
            genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing2);
            bigInteger2 = modularRingFactory3.getIntegerModul().multiply(modularRingFactory3.getIntegerModul());
            modularRingFactory3 = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
            genPolynomialRing4 = new GenPolynomialRing<ModLong>(modularRingFactory3, genPolynomialRing3);
            gcdRingElem3 = (GcdRingElem)modularRingFactory3.fromInteger(bigInteger4.getVal());
            genPolynomial14 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial);
            genPolynomial15 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial6);
            genPolynomial16 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial7);
            genPolynomial17 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial10);
            genPolynomial18 = PolyUtil.fromIntegerCoefficients(genPolynomialRing4, genPolynomial11);
            assert (HenselUtil.isHenselLift(genPolynomial, bigInteger7, bigInteger3, genPolynomial6, genPolynomial7));
            bigInteger7 = bigInteger7.fromInteger(modularRingFactory3.getIntegerModul().getVal());
            genPolynomial12 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial6);
            genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial7);
            genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial10);
            genPolynomial9 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial11);
        }
        if (!((GenPolynomial)(monoidElem = genPolynomial14.subtract((ModLong)((Object)genPolynomial15.multiply((ModLong)((Object)genPolynomial16)))))).isZERO()) {
            System.out.println("Em =  " + monoidElem);
        }
        genPolynomialArray = new GreatestCommonDivisorPrimitive();
        ringElem = genPolynomialArray.baseContent(genPolynomial6);
        genPolynomial6 = genPolynomial6.divide((BigInteger)ringElem);
        object = bigInteger8.quotientRemainder((BigInteger)ringElem);
        bigInteger2 = null;
        boolean bl = true;
        if (object[1].isZERO()) {
            bigInteger2 = object[0];
            try {
                genPolynomial7 = genPolynomial7.divide(bigInteger2);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("*catch: no exact factorization: " + bigInteger2 + ", e = " + runtimeException);
                bl = false;
            }
        } else {
            System.out.println("*remainder: no exact factorization: q = " + object[0] + ", r = " + object[1]);
            bl = false;
        }
        if (!bl) {
            System.out.println("*Ai =  " + genPolynomial6);
            System.out.println("*ai =  " + ringElem);
            System.out.println("*Bi =  " + genPolynomial7);
            System.out.println("*bi =  " + bigInteger2);
            System.out.println("*c  =  " + bigInteger8);
            throw new NoLiftingException("no exact lifting possible");
        }
        return new HenselApprox(genPolynomial6, genPolynomial7, genPolynomial12, genPolynomial13);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isHenselLift(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, BigInteger bigInteger2, List<GenPolynomial<BigInteger>> list) {
        void var10_12;
        GenPolynomial<ModInteger> genPolynomial2;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger2.getVal(), true);
        GenPolynomialRing<ModInteger> genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing, genPolynomialRing);
        MonoidElem<GenPolynomial<ModInteger>> monoidElem = genPolynomialRing2.getONE();
        for (GenPolynomial<BigInteger> ringElem2 : list) {
            genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, ringElem2);
            monoidElem = ((GenPolynomial)monoidElem).multiply(genPolynomial2);
        }
        GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        if (!genPolynomial3.equals(monoidElem)) {
            System.out.println("Hensel precondition wrong!");
            if (debug) {
                System.out.println("cl      = " + monoidElem);
                System.out.println("cp      = " + genPolynomial3);
                System.out.println("mon(cl) = " + ((GenPolynomial)monoidElem).monic());
                System.out.println("mon(cp) = " + genPolynomial3.monic());
                System.out.println("cp-cl   = " + genPolynomial3.subtract((ModInteger)monoidElem));
                System.out.println("M       = " + bigInteger + ", p = " + bigInteger2);
            }
            return false;
        }
        BigInteger bigInteger3 = bigInteger2;
        while (var10_12.compareTo(bigInteger) < 0) {
            BigInteger bigInteger4 = var10_12.multiply((BigInteger)var10_12);
        }
        modIntegerRing = new ModIntegerRing(var10_12.getVal(), false);
        genPolynomialRing2 = new GenPolynomialRing<ModInteger>(modIntegerRing, genPolynomialRing);
        monoidElem = genPolynomialRing2.getONE();
        for (GenPolynomial<BigInteger> genPolynomial4 : list) {
            genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial4);
            monoidElem = ((GenPolynomial)monoidElem).multiply(genPolynomial2);
        }
        genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        if (!genPolynomial3.equals(monoidElem)) {
            System.out.println("Hensel post condition wrong!");
            System.out.println("cl    = " + monoidElem);
            System.out.println("cp    = " + genPolynomial3);
            System.out.println("cp-cl = " + genPolynomial3.subtract((ModInteger)monoidElem));
            System.out.println("M = " + bigInteger + ", p = " + bigInteger2 + ", p^e = " + (BigInteger)var10_12);
            return false;
        }
        return true;
    }

    public static boolean isHenselLift(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, BigInteger bigInteger2, GenPolynomial<BigInteger> genPolynomial2, GenPolynomial<BigInteger> genPolynomial3) {
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(2);
        arrayList.add(genPolynomial2);
        arrayList.add(genPolynomial3);
        return HenselUtil.isHenselLift(genPolynomial, bigInteger, bigInteger2, arrayList);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> genPolynomial, BigInteger bigInteger, BigInteger bigInteger2, HenselApprox<MOD> henselApprox) {
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(2);
        arrayList.add(henselApprox.A);
        arrayList.add(henselApprox.B);
        return HenselUtil.isHenselLift(genPolynomial, bigInteger, bigInteger2, arrayList);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> GenPolynomial<MOD>[] liftExtendedEuclidean(GenPolynomial<MOD> genPolynomial, GenPolynomial<MOD> genPolynomial2, long l) throws NoLiftingException {
        Iterable<Monomial<GenPolynomial<BigInteger>>> iterable;
        BigInteger bigInteger;
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + genPolynomial + ", B = " + genPolynomial2);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] genPolynomialArray = null;
        try {
            genPolynomialArray = genPolynomial.egcd(genPolynomial2);
            if (!genPolynomialArray[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + genPolynomialArray[0] + ", A = " + genPolynomial + ", B = " + genPolynomial2);
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new NoLiftingException("coefficient error " + arithmeticException);
        }
        GenPolynomial<Object> genPolynomial3 = genPolynomialArray[1];
        GenPolynomial<Object> genPolynomial4 = genPolynomialArray[2];
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        MonoidElem monoidElem = genPolynomialRing2.getONE();
        GenPolynomial<BigInteger> genPolynomial5 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial);
        GenPolynomial<BigInteger> genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2);
        GenPolynomial<RingElem<BigInteger>> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial3);
        GenPolynomial<RingElem<BigInteger>> genPolynomial8 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial4);
        ModularRingFactory<ModLong> modularRingFactory = (ModularRingFactory<ModLong>)genPolynomialRing.coFac;
        BigInteger bigInteger2 = bigInteger = modularRingFactory.getIntegerModul();
        int n = 1;
        while ((long)n < l) {
            iterable = ((GenPolynomial)monoidElem).subtract(genPolynomial7.multiply((BigInteger)((Object)genPolynomial5))).subtract(genPolynomial8.multiply((BigInteger)((Object)genPolynomial6)));
            if (((GenPolynomial)iterable).isZERO()) {
                logger.info("leaving on zero e in liftExtendedEuclidean");
                break;
            }
            iterable = ((GenPolynomial)iterable).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)bigInteger2));
            GenPolynomial genPolynomial9 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, iterable);
            GenPolynomial<GenPolynomial<MOD>> genPolynomial10 = genPolynomial3.multiply((Object)genPolynomial9);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>> genPolynomial11 = genPolynomial4.multiply((Object)genPolynomial9);
            GenPolynomial<GenPolynomial<C>>[] genPolynomialArray2 = genPolynomial10.quotientRemainder((GenPolynomial<GenPolynomial<MOD>>)genPolynomial2);
            GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> genPolynomial12 = genPolynomialArray2[0];
            genPolynomial10 = genPolynomialArray2[1];
            genPolynomial11 = genPolynomial11.sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)genPolynomial12.multiply((GenPolynomial<GenPolynomial<MOD>>)genPolynomial));
            GenPolynomial<BigInteger> genPolynomial13 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial10);
            GenPolynomial<BigInteger> genPolynomial14 = PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial11);
            genPolynomial7 = genPolynomial7.sum((BigInteger)((Object)genPolynomial13.multiply(bigInteger2)));
            genPolynomial8 = genPolynomial8.sum((BigInteger)((Object)genPolynomial14.multiply(bigInteger2)));
            bigInteger2 = bigInteger2.multiply(bigInteger);
            ++n;
        }
        modularRingFactory = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(modularRingFactory, genPolynomialRing);
        genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial7);
        genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial8);
        if (debug) {
            ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial);
            iterable = new ArrayList();
            iterable.add(genPolynomial3);
            iterable.add(genPolynomial4);
            if (!HenselUtil.isExtendedEuclideanLift(arrayList, iterable)) {
                System.out.println("isExtendedEuclideanLift: false");
            }
        }
        GenPolynomial[] genPolynomialArray3 = new GenPolynomial[]{genPolynomial3, genPolynomial4};
        return genPolynomialArray3;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftExtendedEuclidean(List<GenPolynomial<MOD>> list, long l) throws NoLiftingException {
        Iterable<Object> iterable;
        int n;
        if (list == null || list.size() <= 1) {
            throw new IllegalArgumentException("A must be non null and non empty");
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
        int n2 = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(abelianGroupElem);
        }
        arrayList.set(n2 - 2, list.get(n2 - 1));
        for (n = n2 - 3; n >= 0; --n) {
            iterable = list.get(n + 1).multiply((MOD)((GenPolynomial)arrayList.get(n + 1)));
            arrayList.set(n, iterable);
        }
        ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>(n2 + 1);
        iterable = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList2.add(abelianGroupElem);
            iterable.add(abelianGroupElem);
        }
        GenPolynomial<MOD> genPolynomial = genPolynomialRing.getONE();
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        arrayList2.add(0, genPolynomial);
        GenPolynomial<MOD> genPolynomial2 = genPolynomial;
        for (int i = 0; i < n2 - 1; ++i) {
            List<GenPolynomial<MOD>> list2 = HenselUtil.liftDiophant((GenPolynomial)arrayList.get(i), list.get(i), (GenPolynomial)arrayList2.get(i), l);
            genPolynomial2 = list2.get(0);
            GenPolynomial genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2));
            arrayList2.set(i + 1, genPolynomial3);
            iterable.set(i, list2.get(1));
            if (!debug) continue;
            logger.info("lift({}) = {}", (Object)i, iterable.get(i));
        }
        iterable.set(n2 - 1, (MonoidElem)genPolynomial2);
        if (debug) {
            logger.info("lift({}) = {}", (Object)(n2 - 1), (Object)genPolynomial2);
        }
        return iterable;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> genPolynomial, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, long l) throws NoLiftingException {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + genPolynomial + ", B = " + genPolynomial2 + ", C = " + genPolynomial3);
        }
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing genPolynomialRing = genPolynomial3.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
        for (int i = 0; i < 2; ++i) {
            arrayList.add((GenPolynomial<MOD>)abelianGroupElem);
        }
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        for (Monomial<Object> monomial : genPolynomial3) {
            long l2 = monomial.e.getVal(0);
            List<GenPolynomial<Object>> list = HenselUtil.liftDiophant(genPolynomial, genPolynomial2, l2, l);
            GcdRingElem gcdRingElem = (GcdRingElem)monomial.c;
            gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
            int n = 0;
            for (GenPolynomial<Object> genPolynomial4 : list) {
                GenPolynomial<GcdRingElem> genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial4));
                genPolynomial6 = genPolynomial6.multiply(gcdRingElem);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial42 = ((GenPolynomial)arrayList.get(n)).sum(genPolynomial6);
                arrayList.set(n++, genPolynomial42);
            }
        }
        if (debug) {
            genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial));
            genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2));
            genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial3));
            GenPolynomial<GenPolynomial<GenPolynomial>> genPolynomial5 = genPolynomial2.multiply((Object)((GenPolynomial)arrayList.get(0))).sum((GenPolynomial)genPolynomial.multiply((Object)((GenPolynomial)arrayList.get(1))));
            if (!genPolynomial5.equals(genPolynomial3)) {
                System.out.println("A = " + genPolynomial + ", B = " + genPolynomial2);
                System.out.println("s1 = " + arrayList.get(0) + ", s2 = " + arrayList.get(1));
                System.out.println("Error: A*r1 + B*r2 = " + genPolynomial5 + " : " + genPolynomialRing.coFac);
            }
        }
        return arrayList;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> list, GenPolynomial<MOD> genPolynomial, long l) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add((GenPolynomial<MOD>)abelianGroupElem);
        }
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        for (Monomial<MOD> monomial : genPolynomial) {
            long l2 = monomial.e.getVal(0);
            List<GenPolynomial<MOD>> list2 = HenselUtil.liftDiophant(list, l2, l);
            GcdRingElem gcdRingElem = (GcdRingElem)monomial.c;
            gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
            int n = 0;
            for (GenPolynomial<MOD> genPolynomial2 : list2) {
                GenPolynomial<GcdRingElem> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2));
                genPolynomial4 = genPolynomial4.multiply(gcdRingElem);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial22 = ((GenPolynomial)arrayList.get(n)).sum(genPolynomial4);
                arrayList.set(n++, genPolynomial22);
            }
        }
        return arrayList;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> genPolynomial, GenPolynomial<MOD> genPolynomial2, long l, long l2) throws NoLiftingException {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>> genPolynomial3;
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + genPolynomial + ", B = " + genPolynomial2);
        }
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] genPolynomialArray = HenselUtil.liftExtendedEuclidean(genPolynomial2, genPolynomial, l2);
        GenPolynomial<MOD> genPolynomial4 = genPolynomialArray[0];
        GenPolynomial<MOD> genPolynomial5 = genPolynomialArray[1];
        if (l == 0L) {
            arrayList.add(genPolynomial4);
            arrayList.add(genPolynomial5);
            return arrayList;
        }
        genPolynomialRing = genPolynomial4.ring;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial));
        genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2));
        GenPolynomial genPolynomial6 = genPolynomialRing.univariate(0, l);
        GenPolynomial<GenPolynomial<Object>> genPolynomial7 = genPolynomial4.multiply((MOD)genPolynomial6);
        GenPolynomial<GenPolynomial<C>>[] genPolynomialArray2 = genPolynomial7.quotientRemainder((GenPolynomial<GenPolynomial<Object>>)genPolynomial);
        genPolynomial7 = genPolynomialArray2[0];
        GenPolynomial genPolynomial8 = genPolynomialArray2[1];
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> genPolynomial9 = genPolynomial5.multiply((MOD)genPolynomial6).sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)genPolynomial7.multiply(genPolynomial2));
        arrayList.add(genPolynomial8);
        arrayList.add(genPolynomial9);
        if (debug && !(genPolynomial3 = genPolynomial2.multiply((Object)genPolynomial8).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>>>)genPolynomial.multiply((Object)genPolynomial9))).equals(genPolynomial6)) {
            System.out.println("A = " + genPolynomial + ", B = " + genPolynomial2);
            System.out.println("r1 = " + genPolynomial8 + ", r2 = " + genPolynomial9);
            System.out.println("Error: A*r1 + B*r2 = " + genPolynomial3);
        }
        return arrayList;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> list, long l, long l2) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<MOD>> list2 = HenselUtil.liftExtendedEuclidean(list, l2);
        if (l == 0L) {
            return list2;
        }
        genPolynomialRing = list2.get((int)0).ring;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        ArrayList<GenPolynomial<MOD>> arrayList2 = new ArrayList<GenPolynomial<MOD>>(list2.size());
        for (GenPolynomial<Object> genPolynomial : list2) {
            genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial));
            arrayList2.add(genPolynomial);
        }
        GenPolynomial genPolynomial = genPolynomialRing.univariate(0, l);
        int n = 0;
        for (GenPolynomial genPolynomial2 : arrayList2) {
            GenPolynomial<Object> genPolynomial3 = genPolynomial2.multiply(genPolynomial);
            GenPolynomial<Object> genPolynomial4 = genPolynomial3.remainder(list.get(n++));
            arrayList.add(genPolynomial4);
        }
        return arrayList;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(GenPolynomial<MOD> genPolynomial, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, GenPolynomial<MOD> genPolynomial4, GenPolynomial<MOD> genPolynomial5) {
        GenPolynomialRing genPolynomialRing = genPolynomial5.ring;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomial genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial));
        GenPolynomial genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial2));
        GenPolynomial genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial3));
        GenPolynomial genPolynomial9 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial4));
        GenPolynomial genPolynomial10 = genPolynomial6.multiply(genPolynomial8).sum(genPolynomial7.multiply(genPolynomial9));
        if (genPolynomial10.equals(genPolynomial5)) {
            return true;
        }
        if (debug) {
            System.out.println("a  = " + genPolynomial6);
            System.out.println("b  = " + genPolynomial7);
            System.out.println("s1 = " + genPolynomial8);
            System.out.println("s2 = " + genPolynomial9);
            System.out.println("t  = " + genPolynomial10);
            System.out.println("C  = " + genPolynomial5);
        }
        return false;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isExtendedEuclideanLift(List<GenPolynomial<MOD>> list, List<GenPolynomial<MOD>> list2) {
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        MonoidElem monoidElem = genPolynomialRing.getONE();
        return HenselUtil.isDiophantLift(list, list2, monoidElem);
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(List<GenPolynomial<MOD>> list, List<GenPolynomial<MOD>> list2, GenPolynomial<MOD> genPolynomial) {
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        ArrayList arrayList = new ArrayList(list.size());
        int n = 0;
        for (GenPolynomial<MOD> object : list) {
            void var9_12;
            MonoidElem monoidElem = genPolynomialRing.getONE();
            int n2 = 0;
            for (GenPolynomial<MOD> genPolynomial2 : list) {
                if (n != n2) {
                    GenPolynomial<GenPolynomial<MOD>> genPolynomial3 = var9_12.multiply(genPolynomial2);
                }
                ++n2;
            }
            GenPolynomial genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, var9_12));
            arrayList.add(genPolynomial4);
            ++n;
        }
        GenPolynomial<Object> genPolynomial4 = genPolynomialRing.getZERO();
        n = 0;
        for (GenPolynomial genPolynomial5 : arrayList) {
            GenPolynomial<Object> genPolynomial6 = list2.get(n++);
            genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(genPolynomialRing2, genPolynomial6));
            GenPolynomial<GenPolynomial<MOD>> genPolynomial7 = genPolynomial5.multiply(genPolynomial6);
            genPolynomial4 = genPolynomial4.sum((Object)genPolynomial7);
        }
        if (!genPolynomial4.equals(genPolynomial)) {
            if (debug) {
                System.out.println("no diophant lift!");
                System.out.println("A = " + list);
                System.out.println("B = " + arrayList);
                System.out.println("S = " + list2);
                System.out.println("C = " + genPolynomial);
                System.out.println("t = " + genPolynomial4);
            }
            return false;
        }
        return true;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> genPolynomial, List<GenPolynomial<MOD>> list, long l) throws NoLiftingException {
        BigInteger bigInteger;
        List<GenPolynomial<BigInteger>> list2;
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> list3 = new ArrayList<GenPolynomial<MOD>>(list.size());
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        RingFactory ringFactory = genPolynomialRing2.coFac;
        ModularRingFactory<ModLong> modularRingFactory = (ModularRingFactory<ModLong>)ringFactory;
        BigInteger bigInteger2 = modularRingFactory.getIntegerModul();
        int n = list.size();
        if (n == 1) {
            GenPolynomial<Object> genPolynomial2 = list.get(0);
            ModularRingFactory<ModLong> modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
            GenPolynomialRing<ModLong> genPolynomialRing3 = new GenPolynomialRing<ModLong>(modularRingFactory2, genPolynomialRing);
            genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial2));
            list3.add(genPolynomial2);
            return list3;
        }
        GenPolynomialRing<BigInteger> genPolynomialRing4 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        List<GenPolynomial<BigInteger>> iterable = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list);
        List list4 = HenselUtil.liftExtendedEuclidean(list, l + 1L);
        if (debug) {
            logger.info("EE lift = {}", list4);
            list2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list4));
            try {
                boolean bl = HenselUtil.isExtendedEuclideanLift(list, list2);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        list2 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list4);
        ModularRingFactory<ModLong> modularRingFactory3 = modularRingFactory;
        BigInteger bigInteger3 = bigInteger = modularRingFactory3.getIntegerModul();
        GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(modularRingFactory3, genPolynomialRing);
        List list5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, list2);
        int n2 = 1;
        while ((long)n2 < l) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial3 = genPolynomialRing.getONE();
            for (GenPolynomial<BigInteger> genPolynomial2 : iterable) {
                genPolynomial3 = genPolynomial3.multiply((RingElem<BigInteger>)genPolynomial2);
            }
            if ((genPolynomial3 = genPolynomial.subtract((BigInteger)((Object)genPolynomial3))).isZERO()) {
                logger.info("leaving on zero e");
                break;
            }
            try {
                genPolynomial3 = genPolynomial3.divide(bigInteger3);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            GenPolynomial genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, genPolynomial3);
            ArrayList iterable32 = new ArrayList(list4.size());
            int n3 = 0;
            for (GenPolynomial<Object> genPolynomial5 : list5) {
                GenPolynomial<Object> genPolynomial7 = genPolynomial5.multiply((Object)genPolynomial4);
                genPolynomial7 = genPolynomial7.remainder(list.get(n3++));
                iterable32.add(genPolynomial7);
            }
            List<GenPolynomial<BigInteger>> list6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, iterable32);
            ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(list.size());
            n3 = 0;
            for (GenPolynomial<RingElem<BigInteger>> genPolynomial8 : iterable) {
                genPolynomial8 = genPolynomial8.sum((BigInteger)((Object)((GenPolynomial)list6.get(n3++)).multiply(bigInteger3)));
                arrayList.add(genPolynomial8);
            }
            iterable = arrayList;
            bigInteger3 = bigInteger3.multiply(bigInteger);
            if ((long)n2 >= l - 1L) {
                logger.info("e != 0 for k = {}", (Object)l);
            }
            ++n2;
        }
        modularRingFactory3 = ModLongRing.MAX_LONG.compareTo((bigInteger3 = (BigInteger)bigInteger.power(l)).getVal()) > 0 ? new ModLongRing(bigInteger3.getVal()) : new ModIntegerRing(bigInteger3.getVal());
        genPolynomialRing5 = new GenPolynomialRing(modularRingFactory3, genPolynomialRing);
        list3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5, iterable);
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHensel(GenPolynomial<BigInteger> genPolynomial, List<GenPolynomial<MOD>> list, long l, BigInteger bigInteger) throws NoLiftingException {
        void var16_21;
        GenPolynomial<BigInteger> genPolynomial2;
        BigInteger bigInteger2;
        List list2;
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> list3 = new ArrayList<GenPolynomial<MOD>>(list.size());
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        RingFactory ringFactory = genPolynomialRing2.coFac;
        ModularRingFactory<ModLong> modularRingFactory = (ModularRingFactory<ModLong>)ringFactory;
        BigInteger bigInteger3 = modularRingFactory.getIntegerModul();
        int n = list.size();
        if (n == 1) {
            GenPolynomial<Object> genPolynomial3 = list.get(0);
            ModularRingFactory<ModLong> modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger3.getVal()) > 0 ? new ModLongRing(bigInteger3.getVal()) : new ModIntegerRing(bigInteger3.getVal());
            GenPolynomialRing<ModLong> genPolynomialRing3 = new GenPolynomialRing<ModLong>(modularRingFactory2, genPolynomialRing);
            genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial3));
            list3.add(genPolynomial3);
            return list3;
        }
        BigInteger bigInteger4 = bigInteger;
        for (int i = 1; i < list.size(); ++i) {
            genPolynomial = genPolynomial.multiply(bigInteger4);
        }
        GcdRingElem gcdRingElem = (GcdRingElem)modularRingFactory.fromInteger(bigInteger4.getVal());
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>(list.size());
        for (GenPolynomial<MOD> iterable22 : list) {
            list2 = iterable22.monic();
            list2 = ((GenPolynomial)((Object)list2)).multiply(gcdRingElem);
            arrayList.add((GenPolynomial<MOD>)((Object)list2));
        }
        list = arrayList;
        GenPolynomialRing<BigInteger> genPolynomialRing4 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        List<GenPolynomial<BigInteger>> list4 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list);
        for (GenPolynomial genPolynomial3 : list4) {
            if (genPolynomial3.isZERO()) continue;
            ExpVector expVector = genPolynomial3.leadingExpVector();
            genPolynomial3.doPutToMap(expVector, bigInteger4);
        }
        list2 = HenselUtil.liftExtendedEuclidean(list, l + 1L);
        if (debug) {
            logger.info("EE lift = {}", list2);
            List<GenPolynomial<MOD>> list5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list2));
            try {
                boolean bl = HenselUtil.isExtendedEuclideanLift(list, list5);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        List<GenPolynomial<BigInteger>> list6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, list2);
        ModularRingFactory<ModLong> modularRingFactory2 = modularRingFactory;
        BigInteger bigInteger5 = bigInteger2 = modularRingFactory2.getIntegerModul();
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing);
        List list7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, list6);
        int n2 = 1;
        while ((long)n2 < l) {
            genPolynomial2 = genPolynomialRing.getONE();
            for (GenPolynomial genPolynomial4 : var16_21) {
                genPolynomial2 = genPolynomial2.multiply((BigInteger)((Object)genPolynomial4));
            }
            if ((genPolynomial2 = genPolynomial.subtract((BigInteger)((Object)genPolynomial2))).isZERO()) {
                logger.info("leaving on zero e");
                break;
            }
            try {
                genPolynomial2 = genPolynomial2.divide(bigInteger5);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            GenPolynomial genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial2);
            ArrayList arrayList2 = new ArrayList(list2.size());
            int n3 = 0;
            for (GenPolynomial<Object> genPolynomial6 : list7) {
                GenPolynomial<Object> genPolynomial8 = genPolynomial6.multiply((Object)genPolynomial5);
                genPolynomial8 = genPolynomial8.remainder(list.get(n3++));
                arrayList2.add(genPolynomial8);
            }
            List<GenPolynomial<BigInteger>> list8 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, arrayList2);
            ArrayList<GenPolynomial<GenPolynomial<BigInteger>>> arrayList3 = new ArrayList<GenPolynomial<GenPolynomial<BigInteger>>>(list.size());
            n3 = 0;
            for (GenPolynomial genPolynomial9 : var16_21) {
                GenPolynomial<GenPolynomial<BigInteger>> genPolynomial10 = genPolynomial9.sum(((GenPolynomial)list8.get(n3++)).multiply(bigInteger5));
                arrayList3.add(genPolynomial10);
            }
            ArrayList<GenPolynomial<GenPolynomial<BigInteger>>> arrayList4 = arrayList3;
            bigInteger5 = bigInteger5.multiply(bigInteger2);
            if ((long)n2 >= l - 1L) {
                logger.info("e != 0 for k = {}", (Object)l);
            }
            ++n2;
        }
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger4);
        genPolynomial2 = new ArrayList(list.size());
        for (GenPolynomial genPolynomial11 : var16_21) {
            GenPolynomial<BigInteger> genPolynomial12 = null;
            genPolynomial12 = greatestCommonDivisorAbstract.basePrimitivePart(genPolynomial11);
            genPolynomial2.add(genPolynomial12);
        }
        GenPolynomial<BigInteger> genPolynomial13 = genPolynomial2;
        bigInteger5 = (BigInteger)bigInteger2.power(l);
        modularRingFactory2 = ModLongRing.MAX_LONG.compareTo(bigInteger5.getVal()) > 0 ? new ModLongRing(bigInteger5.getVal()) : new ModIntegerRing(bigInteger5.getVal());
        genPolynomialRing3 = new GenPolynomialRing(modularRingFactory2, genPolynomialRing);
        list3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial13);
        return list3;
    }
}

