/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import edu.jas.ufd.Quotient;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuotientRing<C extends GcdRingElem<C>>
implements RingFactory<Quotient<C>>,
QuotPairFactory<GenPolynomial<C>, Quotient<C>> {
    private static final Logger logger = LogManager.getLogger(QuotientRing.class);
    public static final QuoNorm quoNorm = QuoNorm.normDenLead;
    public final GenPolynomialRing<C> ring;
    public final GreatestCommonDivisor<C> engine;
    public final boolean ufdGCD;

    public QuotientRing(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, true);
    }

    public QuotientRing(GenPolynomialRing<C> genPolynomialRing, boolean bl) {
        this.ring = genPolynomialRing;
        this.ufdGCD = bl;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
        logger.debug("quotient ring constructed");
    }

    @Override
    public GenPolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Quotient<C> create(GenPolynomial<C> genPolynomial) {
        return new Quotient<C>(this, genPolynomial);
    }

    @Override
    public Quotient<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return new Quotient<C>(this, genPolynomial, genPolynomial2);
    }

    protected GenPolynomial<C> divide(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return PolyUtil.basePseudoDivide(genPolynomial, genPolynomial2);
    }

    protected GenPolynomial<C> gcd(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (this.ufdGCD) {
            return this.engine.gcd(genPolynomial, genPolynomial2);
        }
        return this.engine.gcd(genPolynomial, genPolynomial2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Quotient<C> copy(Quotient<C> quotient) {
        return new Quotient(quotient.ring, quotient.num, quotient.den, true);
    }

    @Override
    public Quotient<C> getZERO() {
        return new Quotient(this, this.ring.getZERO());
    }

    @Override
    public Quotient<C> getONE() {
        return new Quotient(this, this.ring.getONE());
    }

    @Override
    public List<Quotient<C>> generators() {
        List<GenPolynomial<C>> list = this.ring.generators();
        ArrayList<Quotient<C>> arrayList = new ArrayList<Quotient<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            Quotient<C> quotient = new Quotient<C>(this, genPolynomial);
            arrayList.add(quotient);
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Quotient<C> fromInteger(BigInteger bigInteger) {
        return new Quotient(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public Quotient<C> fromInteger(long l) {
        return new Quotient(this, this.ring.fromInteger(l));
    }

    public String toString() {
        String string = null;
        string = this.ring.coFac.characteristic().signum() == 0 ? "RatFunc" : "ModFunc";
        return string + "( " + this.ring.toString() + " )";
    }

    @Override
    public String toScript() {
        return "RF(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QuotientRing)) {
            return false;
        }
        QuotientRing quotientRing = (QuotientRing)object;
        return this.ring.equals(quotientRing.ring);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        return n;
    }

    @Override
    public Quotient<C> random(int n) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n)).monic();
        GenPolynomial genPolynomial2 = ((GenPolynomial)this.ring.random(n)).monic();
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = ((GenPolynomial)this.ring.random(n)).monic();
        }
        return new Quotient(this, genPolynomial, genPolynomial2, false);
    }

    public Quotient<C> random(int n, int n2, int n3, float f) {
        GenPolynomial<C> genPolynomial = this.ring.random(n, n2, n3, f).monic();
        GenPolynomial<C> genPolynomial2 = this.ring.random(n, n2, n3, f).monic();
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = this.ring.random(n, n2, n3, f).monic();
        }
        return new Quotient<C>(this, genPolynomial, genPolynomial2, false);
    }

    @Override
    public Quotient<C> random(int n, Random random) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n, random)).monic();
        GenPolynomial genPolynomial2 = ((GenPolynomial)this.ring.random(n, random)).monic();
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = ((GenPolynomial)this.ring.random(n, random)).monic();
        }
        return new Quotient(this, genPolynomial, genPolynomial2, false);
    }

    @Override
    public Quotient<C> parse(String string) {
        int n = string.indexOf("{");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("}")) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("|")) < 0) {
            Element element = this.ring.parse(string);
            return new Quotient(this, element);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Element element = this.ring.parse(string2);
        Element element2 = this.ring.parse(string3);
        return new Quotient(this, element, element2);
    }

    @Override
    public Quotient<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '{', '}');
        return this.parse(string);
    }

    public long extensionDegree() {
        long l = -1L;
        if (this.ring.nvar <= 0) {
            l = 0L;
        }
        return l;
    }

    public static enum QuoNorm {
        normNumLead,
        normNumTrail,
        normDenLead,
        normDenTrail;

    }
}

