/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.ExpVector;
import edu.jas.ps.TaylorFunction;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import java.util.List;

public class QuotientTaylorFunction<C extends GcdRingElem<C>>
implements TaylorFunction<C> {
    final Quotient<C> quo;
    final long facul;

    public QuotientTaylorFunction(Quotient<C> quotient) {
        this(quotient, 1L);
    }

    public QuotientTaylorFunction(Quotient<C> quotient, long l) {
        this.quo = quotient;
        this.facul = l;
    }

    public String toString() {
        return this.quo.toString();
    }

    @Override
    public long getFacul() {
        return this.facul;
    }

    @Override
    public boolean isZERO() {
        return this.quo.isZERO();
    }

    @Override
    public TaylorFunction<C> derivative() {
        return new QuotientTaylorFunction<C>(PolyUfdUtil.derivative(this.quo));
    }

    public TaylorFunction<C> derivative(int n) {
        return new QuotientTaylorFunction<C>(PolyUfdUtil.derivative(this.quo, n));
    }

    @Override
    public TaylorFunction<C> derivative(ExpVector expVector) {
        Quotient<C> quotient = this.quo;
        long l = 1L;
        if (expVector.signum() == 0 || this.quo.isZERO()) {
            return new QuotientTaylorFunction<C>(quotient, l);
        }
        for (int i = 0; i < expVector.length(); ++i) {
            long l2 = expVector.getVal(i);
            if (l2 == 0L) continue;
            int n = expVector.length() - 1 - i;
            for (long j = 0L; j < l2; ++j) {
                quotient = PolyUfdUtil.derivative(quotient, n);
                l *= j + 1L;
                if (!quotient.isZERO()) continue;
                return new QuotientTaylorFunction<C>(quotient, l);
            }
        }
        return new QuotientTaylorFunction<C>(quotient, l);
    }

    @Override
    public C evaluate(C c) {
        Object c2 = PolyUfdUtil.evaluateMain(this.quo.ring.ring.coFac, this.quo, c);
        return c2;
    }

    @Override
    public C evaluate(List<C> list) {
        return PolyUfdUtil.evaluateAll(this.quo.ring.ring.coFac, this.quo, list);
    }
}

