/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.DHTBroadcaster;
import edu.jas.util.DHTTransport;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistHashTableServer<K>
extends Thread {
    private static final Logger logger = LogManager.getLogger(DistHashTableServer.class);
    private static final boolean debug = logger.isDebugEnabled();
    public static final int DEFAULT_PORT = 9009;
    protected final ChannelFactory cf;
    protected List<DHTBroadcaster<K>> servers;
    private volatile boolean goon = true;
    private volatile Thread mythread = null;
    protected final SortedMap<K, DHTTransport> theList;
    private long etime;
    private long dtime;
    private long ertime;
    private long drtime;

    public DistHashTableServer() {
        this(9009);
    }

    public DistHashTableServer(int n) {
        this(new ChannelFactory(n));
    }

    public DistHashTableServer(ChannelFactory channelFactory) {
        this.cf = channelFactory;
        channelFactory.init();
        this.servers = new ArrayList<DHTBroadcaster<K>>();
        this.theList = new TreeMap<K, DHTTransport>();
        this.etime = DHTTransport.etime;
        this.dtime = DHTTransport.dtime;
        this.ertime = DHTTransport.ertime;
        this.drtime = DHTTransport.drtime;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        int n = 9009;
        if (stringArray.length < 1) {
            System.out.println("Usage: DistHashTableServer <port>");
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DistHashTableServer distHashTableServer = new DistHashTableServer(n);
        distHashTableServer.init();
        distHashTableServer.join();
    }

    public void init() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel socketChannel = null;
        DHTBroadcaster<K> dHTBroadcaster = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            try {
                socketChannel = this.cf.getChannel();
                if (debug) {
                    logger.debug("dls channel = {}", (Object)socketChannel);
                }
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    continue;
                }
                dHTBroadcaster = new DHTBroadcaster<K>(socketChannel, this.servers, this.theList);
                int n = 0;
                Object object = this.servers;
                synchronized (object) {
                    if (this.goon) {
                        this.servers.add(dHTBroadcaster);
                        n = this.theList.size();
                        dHTBroadcaster.start();
                    }
                }
                if (debug) {
                    logger.info("server {} started {}", dHTBroadcaster, (Object)dHTBroadcaster.isAlive());
                }
                if (n <= 0) continue;
                object = this.theList;
                synchronized (object) {
                    Iterator<Map.Entry<K, DHTTransport>> iterator = this.theList.entrySet().iterator();
                    for (int i = 0; i < n; ++i) {
                        Map.Entry<K, DHTTransport> entry = iterator.next();
                        DHTTransport dHTTransport = entry.getValue();
                        try {
                            dHTBroadcaster.sendChannel(dHTTransport);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.goon = false;
                Thread.currentThread().interrupt();
            }
        }
        if (debug) {
            logger.info("DHTserver {} terminated", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.goon = false;
        logger.info("terminating");
        if (this.cf != null) {
            this.cf.terminate();
        }
        int n = 0;
        ArrayList<DHTBroadcaster<K>> arrayList = null;
        if (this.servers != null) {
            List<DHTBroadcaster<K>> list = this.servers;
            synchronized (list) {
                n = this.servers.size();
                arrayList = new ArrayList<DHTBroadcaster<K>>(this.servers);
                for (DHTBroadcaster dHTBroadcaster : arrayList) {
                    dHTBroadcaster.goon = false;
                    dHTBroadcaster.closeChannel();
                    try {
                        int n2 = 0;
                        while (dHTBroadcaster.isAlive()) {
                            if (++n2 > 10) {
                                logger.warn("giving up on {}", (Object)dHTBroadcaster);
                                break;
                            }
                            dHTBroadcaster.interrupt();
                            dHTBroadcaster.join(50L);
                        }
                        if (debug) {
                            logger.info("server {} terminated", (Object)dHTBroadcaster);
                        }
                        this.servers.remove(dHTBroadcaster);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.servers.clear();
            }
            logger.info("{} broadcasters terminated {}", (Object)n, arrayList);
        }
        logger.debug("DHTBroadcasters terminated");
        long l = DHTTransport.etime - this.etime;
        long l2 = DHTTransport.dtime - this.dtime;
        long l3 = DHTTransport.ertime - this.ertime;
        long l4 = DHTTransport.drtime - this.drtime;
        long l5 = l3 * l2 / (l + 1L);
        long l6 = l + l2 + l3 + l5;
        logger.info("DHT time: encode = {}, decode = {}, enc raw = {}, dec raw wait = {}, dec raw est = {}, sum est = {}", (Object)l, (Object)l2, (Object)l3, (Object)l4, (Object)l5, (Object)l6);
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
            logger.warn("server terminated {}", (Object)this.mythread);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.info("terminated");
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }

    @Override
    public String toString() {
        return "DHTServer(" + this.servers.size() + ", " + this.cf + ", " + super.toString() + ")";
    }
}

