/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CPair;
import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.OrderedCPairlist;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.ResidueRing;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.SGBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComprehensiveGroebnerBaseSeq<C extends GcdRingElem<C>> {
    private static final Logger logger = LogManager.getLogger(ComprehensiveGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final SquarefreeAbstract<C> engine;
    protected final CReductionSeq<C> cred;
    protected final RingFactory<C> cofac;

    public ComprehensiveGroebnerBaseSeq(RingFactory<C> ringFactory) {
        this(new CReductionSeq<C>(ringFactory), ringFactory);
    }

    public ComprehensiveGroebnerBaseSeq(CReductionSeq<C> cReductionSeq, RingFactory<C> ringFactory) {
        this.cred = cReductionSeq;
        this.cofac = ringFactory;
        this.engine = SquarefreeFactory.getImplementation(ringFactory);
    }

    public boolean isGB(List<GenPolynomial<GenPolynomial<C>>> list) {
        return this.isGB(0, list);
    }

    public boolean isGB(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        return this.isGBsubst(n, list);
    }

    public boolean isGBcol(List<GenPolynomial<GenPolynomial<C>>> list) {
        return this.isGBcol(0, list);
    }

    public boolean isGBcol(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        List<ColoredSystem<C>> list2 = this.cred.determine(list);
        return this.isGBsys(n, list2);
    }

    public boolean isGBsys(List<ColoredSystem<C>> list) {
        return this.isGBsys(0, list);
    }

    public boolean isGBsys(int n, List<ColoredSystem<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        if (n != 0) {
            throw new IllegalArgumentException("modv !0 not supported.");
        }
        for (ColoredSystem<C> coloredSystem : list) {
            if (debug) {
                if (!coloredSystem.isDetermined()) {
                    System.out.println("not determined, cs = " + coloredSystem);
                    return false;
                }
                if (!coloredSystem.checkInvariant()) {
                    System.out.println("not invariant, cs = " + coloredSystem);
                    return false;
                }
            }
            Condition<C> condition = coloredSystem.condition;
            List list2 = coloredSystem.list;
            int n2 = list2.size();
            for (int i = 0; i < n2; ++i) {
                ColorPolynomial colorPolynomial = list2.get(i);
                for (int j = i + 1; j < n2; ++j) {
                    ColorPolynomial colorPolynomial2;
                    ColorPolynomial colorPolynomial3 = list2.get(j);
                    ColorPolynomial<C> colorPolynomial4 = this.cred.SPolynomial(colorPolynomial, colorPolynomial3);
                    colorPolynomial4 = this.cred.normalform(condition, list2, colorPolynomial4);
                    if (debug && !this.cred.isNormalform(list2, colorPolynomial4)) {
                        System.out.println("not normalform, h = " + colorPolynomial4);
                        System.out.println("cs = " + coloredSystem);
                        return false;
                    }
                    if (colorPolynomial4.isZERO() || (colorPolynomial2 = condition.reDetermine(colorPolynomial4)).isZERO()) continue;
                    System.out.println("p = " + colorPolynomial);
                    System.out.println("q = " + colorPolynomial3);
                    System.out.println("not zero:   NF(spol(p,q))  = " + colorPolynomial4);
                    System.out.println("redetermine(NF(spol(p,q))) = " + colorPolynomial2);
                    System.out.println("cs = " + coloredSystem);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isGBsubst(List<GenPolynomial<GenPolynomial<C>>> list) {
        return this.isGBsubst(0, list);
    }

    public boolean isGBsubst(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        boolean bl;
        GroebnerBaseAbstract groebnerBaseAbstract;
        Iterable iterable;
        Iterable iterable2;
        Iterable<GenPolynomial<Object>> iterable3;
        Serializable serializable;
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (n != 0) {
            throw new IllegalArgumentException("modv !0 not supported.");
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial = list.get(0);
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        List<ColoredSystem<C>> list2 = this.cred.determine(list);
        if (logger.isDebugEnabled()) {
            logger.info("determined polynomials =\n{}", list2);
        }
        for (ColoredSystem<C> coloredSystem : list2) {
            boolean bl2;
            Object object;
            serializable = coloredSystem.condition.zero;
            ResidueRing residueRing = new ResidueRing(serializable);
            if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
                iterable3 = new GenSolvablePolynomialRing(residueRing, genPolynomialRing);
                object = ((GenSolvablePolynomialRing)genPolynomialRing).table.relationList();
                iterable2 = PolyUtilApp.toResidue(iterable3, PolynomialList.castToList(object));
                iterable3.addRelations(iterable2);
                iterable = PolyUtilApp.toResidue(iterable3, list);
                groebnerBaseAbstract = SGBFactory.getImplementation(residueRing);
                bl2 = groebnerBaseAbstract.isLeftGB(PolynomialList.castToSolvableList(iterable));
            } else {
                iterable3 = new GenPolynomialRing(residueRing, genPolynomialRing);
                iterable = PolyUtilApp.toResidue(iterable3, list);
                object = GBFactory.getImplementation(residueRing);
                bl2 = object.isGB(iterable);
            }
            if (bl2) continue;
            System.out.println("test condition = " + coloredSystem.condition);
            System.out.println("test ideal     = " + ((Ideal)serializable).toScript());
            System.out.println("test F         = " + list);
            System.out.println("no GB for residue coefficients = " + iterable);
            return false;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        int n2 = genPolynomialRing2.nvar - 2;
        if (n2 < 1) {
            n2 = 1;
        }
        serializable = new ArrayList();
        int n3 = 0;
        while (n3 < n2) {
            iterable = genPolynomialRing2.random(3, 2, 3, 0.43f).monic();
            if (((GenPolynomial)iterable).isConstant() || ((GenPolynomial)iterable).isZERO()) continue;
            if (((GenPolynomial)iterable).length() <= 1) {
                iterable = ((GenPolynomial)iterable).sum((MonoidElem)genPolynomialRing2.getONE());
            }
            iterable = this.engine.squarefreePart((List<GenPolynomial<MonoidElem>>)iterable);
            serializable.add(iterable);
            ++n3;
        }
        logger.info("random ideal = {}", serializable);
        iterable = new Ideal(genPolynomialRing2, serializable);
        ((Ideal)((Object)iterable)).doGB();
        ResidueRing residueRing = new ResidueRing(iterable);
        if (!residueRing.isField()) {
            return true;
        }
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            iterable2 = new GenSolvablePolynomialRing(residueRing, genPolynomialRing);
            groebnerBaseAbstract = ((GenSolvablePolynomialRing)genPolynomialRing).table.relationList();
            List list3 = PolyUtilApp.toResidue(iterable2, PolynomialList.castToList(groebnerBaseAbstract));
            ((GenSolvablePolynomialRing)iterable2).addRelations(list3);
            iterable3 = PolyUtilApp.toResidue(iterable2, list);
            SolvableGroebnerBaseAbstract solvableGroebnerBaseAbstract = SGBFactory.getImplementation(residueRing);
            bl = solvableGroebnerBaseAbstract.isLeftGB(PolynomialList.castToSolvableList(iterable3));
        } else {
            iterable2 = new GenPolynomialRing(residueRing, genPolynomialRing);
            iterable3 = PolyUtilApp.toResidue(iterable2, list);
            groebnerBaseAbstract = GBFactory.getImplementation(residueRing);
            bl = groebnerBaseAbstract.isGB(iterable3);
        }
        if (!bl) {
            System.out.println("test random ideal = " + ((Ideal)((Object)iterable)).toScript());
            System.out.println("no GB for residue coefficients = " + iterable3);
            return false;
        }
        return true;
    }

    public boolean isGBsys(GroebnerSystem<C> groebnerSystem) {
        return this.isGBsys(0, groebnerSystem.list);
    }

    public boolean isCGB(GroebnerSystem<C> groebnerSystem) {
        return this.isGB(groebnerSystem.getCGB());
    }

    public boolean isGB(GroebnerSystem<C> groebnerSystem) {
        return this.isGBsys(0, groebnerSystem.list) && this.isGB(groebnerSystem.getCGB());
    }

    public GroebnerSystem<C> GBsys(List<GenPolynomial<GenPolynomial<C>>> list) {
        List list2;
        ColoredSystem coloredSystem;
        Serializable serializable;
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        if (list.size() == 0) {
            return new GroebnerSystem(arrayList);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial = list.get(0);
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        List<ColoredSystem<C>> list3 = this.cred.determine(list);
        logger.info("determined polynomials =\n{}", list3);
        List list4 = new ArrayList();
        for (ColoredSystem<C> object : list3) {
            serializable = new OrderedCPairlist(genPolynomialRing);
            coloredSystem = object.list.iterator();
            while (coloredSystem.hasNext()) {
                list2 = (ColorPolynomial)coloredSystem.next();
                ((OrderedCPairlist)serializable).put(list2);
            }
            ColoredSystem coloredSystem2 = new ColoredSystem(object.condition, object.list, serializable);
            list4.add(coloredSystem2);
        }
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (list4.size() > 0) {
            coloredSystem = (ColoredSystem)list4.get(0);
            logger.info("poped GBsys number    {} with condition = {}", (Object)(++n), coloredSystem.condition);
            logger.info("poped GBsys (remaining {}) with pairlist  = {}", (Object)(list4.size() - 1), coloredSystem.pairlist);
            if (!coloredSystem.isDetermined()) {
                coloredSystem = coloredSystem.reDetermine();
            }
            OrderedCPairlist orderedCPairlist = coloredSystem.pairlist;
            list2 = coloredSystem.list;
            Condition condition = coloredSystem.condition;
            while (orderedCPairlist.hasNext()) {
                List list5;
                ColorPolynomial<C> colorPolynomial;
                ColorPolynomial<C> colorPolynomial2;
                CPair cPair = orderedCPairlist.removeNext();
                if (cPair == null) continue;
                ColoredSystem coloredSystem2 = cPair.pi;
                ColorPolynomial colorPolynomial3 = cPair.pj;
                if (debug) {
                    logger.info("pi = {}, pj = {}", (Object)coloredSystem2, colorPolynomial3);
                }
                if ((colorPolynomial2 = this.cred.SPolynomial(coloredSystem2, colorPolynomial3)).isZERO()) {
                    cPair.setZero();
                    continue;
                }
                if (debug) {
                    logger.info("S = {}", colorPolynomial2);
                }
                if ((colorPolynomial = this.cred.normalform(condition, list2, colorPolynomial2)).isZERO()) {
                    cPair.setZero();
                    continue;
                }
                if (debug) {
                    logger.info("ht(H) = {}", (Object)colorPolynomial.leadingExpVector());
                }
                colorPolynomial = colorPolynomial.abs();
                if (debug) {
                    logger.debug("H = {}", colorPolynomial);
                }
                logger.info("H = {}", colorPolynomial);
                if (colorPolynomial.isZERO() || (list5 = this.determineAddPairs(coloredSystem, colorPolynomial)).size() == 0) continue;
                coloredSystem = list5.remove(0);
                orderedCPairlist = coloredSystem.pairlist;
                list2 = coloredSystem.list;
                condition = coloredSystem.condition;
                logger.info("replaced main branch = {}", condition);
                logger.info("#new systems       = {}", (Object)list5.size());
                int n2 = list4.size();
                for (ColoredSystem coloredSystem3 : list5) {
                    if (!coloredSystem3.isDetermined()) {
                        coloredSystem3 = coloredSystem3.reDetermine();
                    }
                    list4 = coloredSystem3.addToList(list4);
                }
                logger.info("#new systems added = {}", (Object)(list4.size() - n2));
            }
            if (!coloredSystem.isDetermined()) {
                coloredSystem = coloredSystem.reDetermine();
            }
            arrayList2.add(coloredSystem);
            list4.remove(0);
            logger.info("done with = {}", coloredSystem.condition);
        }
        serializable = new ArrayList();
        for (ColoredSystem coloredSystem2 : arrayList2) {
            if (!coloredSystem2.isDetermined()) {
                coloredSystem2 = coloredSystem2.reDetermine();
            }
            if (!(coloredSystem = this.minimalGB(coloredSystem2)).isDetermined()) {
                coloredSystem = coloredSystem.reDetermine();
            }
            serializable.add(coloredSystem);
            logger.info("#sequential done = {}", coloredSystem2.condition);
            logger.info("{}", coloredSystem2.pairlist);
        }
        arrayList2 = new ArrayList(serializable);
        return new GroebnerSystem(arrayList2);
    }

    public List<ColoredSystem<C>> determineAddPairs(ColoredSystem<C> coloredSystem, ColorPolynomial<C> colorPolynomial) {
        List<ColoredSystem<C>> list = new ArrayList<ColoredSystem<C>>();
        if (colorPolynomial == null || colorPolynomial.isZERO()) {
            return list;
        }
        List list2 = coloredSystem.list;
        Condition condition = coloredSystem.condition;
        OrderedCPairlist orderedCPairlist = coloredSystem.pairlist;
        GenPolynomial<GenPolynomial<C>> genPolynomial = colorPolynomial.getPolynomial();
        List<Condition<C>> list3 = this.cred.caseDistinction(condition, genPolynomial);
        logger.info("# cases = {}", (Object)list3.size());
        for (Condition<C> condition2 : list3) {
            ColoredSystem<C> coloredSystem2;
            block9: {
                OrderedCPairlist<C> orderedCPairlist2;
                ArrayList arrayList;
                ColorPolynomial<C> colorPolynomial2 = condition2.reDetermine(colorPolynomial);
                if (colorPolynomial2.isZERO()) {
                    block8: {
                        logger.info("zero determined nz = {}", colorPolynomial2);
                        arrayList = new ArrayList(list2);
                        orderedCPairlist2 = orderedCPairlist.copy();
                        coloredSystem2 = new ColoredSystem<C>(condition2, arrayList, orderedCPairlist2);
                        try {
                            if (coloredSystem2.isDetermined()) break block8;
                            coloredSystem2 = coloredSystem2.reDetermine();
                        }
                        catch (RuntimeException runtimeException) {
                            System.out.println("Contradiction in NS_0 = " + coloredSystem2);
                            continue;
                        }
                    }
                    list = coloredSystem2.addToList(list);
                    continue;
                }
                if (list2.contains(colorPolynomial2)) {
                    System.out.println("*** S.contains(nz) ***");
                    continue;
                }
                logger.info("new determined nz = {}", colorPolynomial2);
                arrayList = new ArrayList(list2);
                arrayList.add(colorPolynomial2);
                orderedCPairlist2 = orderedCPairlist.copy();
                orderedCPairlist2.put(colorPolynomial2);
                coloredSystem2 = new ColoredSystem<C>(condition2, arrayList, orderedCPairlist2);
                try {
                    if (coloredSystem2.isDetermined()) break block9;
                    coloredSystem2 = coloredSystem2.reDetermine();
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Contradiction in NS = " + coloredSystem2);
                    continue;
                }
            }
            list = coloredSystem2.addToList(list);
        }
        return list;
    }

    public List<GenPolynomial<GenPolynomial<C>>> GB(List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null) {
            return list;
        }
        GroebnerSystem<C> groebnerSystem = this.GBsys(list);
        return groebnerSystem.getCGB();
    }

    public ColoredSystem<C> minimalGB(ColoredSystem<C> coloredSystem) {
        ColorPolynomial<C> colorPolynomial;
        ColorPolynomial<C> colorPolynomial22;
        if (coloredSystem == null || coloredSystem.list == null || coloredSystem.list.size() <= 1) {
            return coloredSystem;
        }
        ArrayList arrayList = new ArrayList(coloredSystem.list.size());
        for (ColorPolynomial<C> colorPolynomial22 : coloredSystem.list) {
            if (colorPolynomial22 == null || colorPolynomial22.isZERO()) continue;
            arrayList.add(colorPolynomial22);
        }
        if (arrayList.size() <= 1) {
            return new ColoredSystem(coloredSystem.condition, arrayList, coloredSystem.pairlist);
        }
        Condition condition = coloredSystem.condition;
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            colorPolynomial = colorPolynomial22 = (ColorPolynomial<C>)arrayList.remove(0);
            if (this.cred.isTopReducible(arrayList, colorPolynomial22) || this.cred.isTopReducible(arrayList2, colorPolynomial22)) {
                if (!debug) continue;
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.addAll(arrayList2);
                colorPolynomial22 = this.cred.normalform(condition, arrayList3, colorPolynomial22);
                try {
                    colorPolynomial22 = condition.reDetermine(colorPolynomial22);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (colorPolynomial22.isZERO()) continue;
                logger.error("nf(a) != 0 {}, {}", colorPolynomial, colorPolynomial22);
                arrayList2.add(colorPolynomial);
                continue;
            }
            arrayList2.add(colorPolynomial22);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return new ColoredSystem(coloredSystem.condition, arrayList, coloredSystem.pairlist);
        }
        Collections.reverse(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            colorPolynomial = colorPolynomial22 = (ColorPolynomial)arrayList.remove(0);
            ExpVector expVector = colorPolynomial22.red.leadingExpVector();
            colorPolynomial22 = this.cred.normalform(condition, arrayList, colorPolynomial22);
            try {
                colorPolynomial22 = condition.reDetermine(colorPolynomial22);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ExpVector expVector2 = colorPolynomial22.red.leadingExpVector();
            if (expVector.equals(expVector2)) {
                arrayList.add(colorPolynomial22);
                continue;
            }
            if (debug) {
                logger.error("nf(a) not determined {}, {}", colorPolynomial, colorPolynomial22);
            }
            arrayList.add(colorPolynomial);
        }
        return new ColoredSystem(coloredSystem.condition, arrayList, coloredSystem.pairlist);
    }
}

