/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorFactory;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorAlgebraicPrim<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    private static final Logger logger = LogManager.getLogger(FactorAlgebraicPrim.class);
    public final FactorAbstract<C> factorCoeff;

    protected FactorAlgebraicPrim() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAlgebraicPrim(AlgebraicNumberRing<C> algebraicNumberRing) {
        this(algebraicNumberRing, FactorFactory.getImplementation(algebraicNumberRing.ring.coFac));
    }

    public FactorAlgebraicPrim(AlgebraicNumberRing<C> algebraicNumberRing, FactorAbstract<C> factorAbstract) {
        super(algebraicNumberRing);
        this.factorCoeff = factorAbstract;
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        Iterable iterable;
        Serializable serializable;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> arrayList = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        AlgebraicNumber<C> algebraicNumber = genPolynomial.leadingBaseCoefficient();
        if (!algebraicNumber.isONE()) {
            genPolynomial = genPolynomial.monic();
            arrayList.add(((GenPolynomial)genPolynomialRing.getONE()).multiply(algebraicNumber));
        }
        if (logger.isDebugEnabled()) {
            serializable = SquarefreeFactory.getImplementation(algebraicNumberRing);
            if (!serializable.isSquarefree(genPolynomial)) {
                throw new RuntimeException("P not squarefree: " + serializable.squarefreeFactors(genPolynomial));
            }
            iterable = algebraicNumberRing.modul;
            if (!this.factorCoeff.isIrreducible(iterable)) {
                throw new RuntimeException("modul not irreducible: " + this.factorCoeff.factors(iterable));
            }
            System.out.println("P squarefree and modul irreducible via ideal decomposition");
        }
        serializable = algebraicNumberRing.modul;
        iterable = algebraicNumberRing.ring;
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(iterable, genPolynomialRing);
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{((GenPolynomialRing)iterable).getVars()[0], genPolynomialRing2.getVars()[0]};
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(((GenPolynomialRing)iterable).coFac, termOrder, stringArray);
        GenPolynomial genPolynomial2 = ((GenPolynomial)serializable).extend(genPolynomialRing3, 0, 0L);
        GenPolynomial genPolynomial3 = PolyUtil.fromAlgebraicCoefficients(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing3, genPolynomial3);
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(genPolynomial2);
        arrayList2.add(genPolynomial4);
        Ideal ideal = new Ideal(genPolynomialRing3, arrayList2);
        List list = ideal.zeroDimPrimeDecomposition();
        if (list.size() == 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomial genPolynomial5 = genPolynomialRing.getONE();
        for (IdealWithUniv idealWithUniv : list) {
            List list2 = idealWithUniv.ideal.getList();
            GenPolynomial genPolynomial6 = PolyUtil.selectWithVariable(list2, 1);
            GenPolynomial genPolynomial7 = PolyUtil.selectWithVariable(list2, 0);
            if (genPolynomial6.equals(genPolynomial2)) {
                GenPolynomial genPolynomial8 = PolyUtil.recursive(genPolynomialRing2, genPolynomial7);
                GenPolynomial genPolynomial9 = PolyUtil.convertRecursiveToAlgebraicCoefficients(genPolynomialRing, genPolynomial8);
                genPolynomial5 = genPolynomial5.multiply(genPolynomial9);
                arrayList.add(genPolynomial9);
                continue;
            }
            logger.warn("algebraic number mismatch: ag = {}, expected Ad = {}", genPolynomial6, genPolynomial2);
        }
        if (!(genPolynomial5 = genPolynomial5.subtract(genPolynomial)).isZERO()) {
            throw new RuntimeException("no factorization: " + genPolynomial5 + ", factors = " + arrayList);
        }
        return arrayList;
    }
}

