/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalSolvablePolynomial;
import edu.jas.application.LocalSolvablePolynomialRing;
import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocal;
import edu.jas.application.SolvableLocalRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalSolvablePolynomialTest
extends TestCase {
    LocalSolvablePolynomial<BigRational> a;
    LocalSolvablePolynomial<BigRational> b;
    LocalSolvablePolynomial<BigRational> c;
    LocalSolvablePolynomial<BigRational> d;
    LocalSolvablePolynomial<BigRational> e;
    LocalSolvablePolynomial<BigRational> f;
    LocalSolvablePolynomial<BigRational> x1;
    LocalSolvablePolynomial<BigRational> x2;
    int rl = 4;
    int kl = 1;
    int ll = 4;
    int el = 3;
    float q = 0.2f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    LocalSolvablePolynomialRing<BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<SolvableLocal<BigRational>> sring;
    GenSolvablePolynomialRing<BigRational> cring;
    SolvableLocalRing<BigRational> qcring;
    SolvableIdeal<BigRational> sideal;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LocalSolvablePolynomialTest.suite());
    }

    public LocalSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(LocalSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        this.cring.addRelations(weylRelations);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalRing<BigRational>(this.sideal);
        this.ring = new LocalSolvablePolynomialRing(this.qcring, this.tord, this.vars);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        String string = this.ring.toString() + ", " + this.ring.toScript();
        LocalSolvablePolynomialTest.assertTrue((String)"length( string(ring) ) >= 563", (string.length() >= 563 ? 1 : 0) != 0);
        this.a = this.ring.getZERO();
        LocalSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        LocalSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new LocalSolvablePolynomial<BigRational>(this.ring);
        LocalSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        LocalSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        LocalSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            LocalSolvablePolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative: ", (boolean)this.ring.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.ring.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            LocalSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            LocalSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            LocalSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            String string = this.a.toString() + ", " + this.a.toScript();
            LocalSolvablePolynomialTest.assertTrue((String)"length( string(a) ) >= 9", (string.length() >= 9 ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl + 1, this.ll, this.el, this.q);
        this.c = (LocalSolvablePolynomial)this.a.subtract((BigRational)((Object)this.a));
        LocalSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (LocalSolvablePolynomial)this.b.subtract((BigRational)((Object)this.a));
        LocalSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (LocalSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        LocalSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (LocalSolvablePolynomial)this.c.subtract((BigRational)((Object)this.b));
        LocalSolvablePolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        LocalSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.qcring.random(this.kl);
        this.b = ((LocalSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (LocalSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (LocalSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        LocalSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (LocalSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (LocalSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        LocalSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((LocalSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (LocalSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (LocalSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        LocalSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (LocalSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (LocalSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        LocalSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.b = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        LocalSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        LocalSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MonoidElem monoidElem = ((SolvableLocal)this.a.leadingBaseCoefficient()).inverse();
        this.d = this.a.multiply((SolvableLocal<BigRational>)monoidElem);
        LocalSolvablePolynomialTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((SolvableLocal)this.d.leadingBaseCoefficient()).isONE());
        this.d = (LocalSolvablePolynomial)this.a.monic();
        LocalSolvablePolynomialTest.assertTrue((String)"a.monic(): ", (boolean)((SolvableLocal)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testCommutative() {
        LocalSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalRing<BigRational>(this.sideal);
        this.ring = new LocalSolvablePolynomialRing(this.qcring, this.ring);
        LocalSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        LocalSolvablePolynomialTest.assertEquals((String)"b*a == a*b: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((LocalSolvablePolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (LocalSolvablePolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        LocalSolvablePolynomialTest.assertEquals((String)"a*(b+c) = a*b+a*c", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        LocalSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(genSolvablePolynomialRing, arrayList);
        SolvableLocalRing<BigRational> solvableLocalRing = new SolvableLocalRing<BigRational>(this.sideal);
        LocalSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)solvableLocalRing.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)solvableLocalRing.isAssociative());
        this.ring = new LocalSolvablePolynomialRing(solvableLocalRing, this.ring);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        LocalSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        LocalSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.polCoeff.parse("x");
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.polCoeff.parse("b x + a");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial2.leadingExpVector(), genSolvablePolynomial2);
        LocalSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial3 : list) {
            RecSolvablePolynomial<BigRational> recSolvablePolynomial;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial3;
            try {
                recSolvablePolynomial = this.ring.toPolyCoefficients(genSolvablePolynomial3);
                this.c = this.ring.fromPolyCoefficients(recSolvablePolynomial);
                LocalSolvablePolynomialTest.assertEquals((String)"from(to(xx)) == xx", (Object)genSolvablePolynomial3, this.c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.a = new LocalSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            try {
                recSolvablePolynomial = this.ring.toPolyCoefficients(this.a);
                this.c = this.ring.fromPolyCoefficients(recSolvablePolynomial);
                LocalSolvablePolynomialTest.assertEquals((String)"from(to(a)) == a", this.a, this.c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (GenPolynomial genPolynomial4 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial4;
                this.b = new LocalSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                LocalSolvablePolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.parse("x^2 + a b");
        this.b = this.ring.parse("a b + a");
        this.b = (LocalSolvablePolynomial)this.b.inverse();
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        LocalSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = (LocalSolvablePolynomial)this.b.inverse();
        LocalSolvablePolynomialTest.assertTrue((String)"b*b^-1 == 1", (boolean)this.e.multiply(this.b).isONE());
        this.c = this.e.multiply(this.c);
        this.d = this.d.multiply(this.e);
        LocalSolvablePolynomialTest.assertTrue((String)"a == b * 1/b * a", (boolean)this.a.equals(this.c));
        LocalSolvablePolynomialTest.assertTrue((String)"a == a * 1/b * b", (boolean)this.a.equals(this.d));
    }
}

