/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigOctonion;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigOctonionTest
extends TestCase {
    BigOctonion a;
    BigOctonion b;
    BigOctonion c;
    BigOctonion d;
    BigOctonion e;
    BigOctonion fac;
    BigQuaternionRing cfac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigOctonionTest.suite());
    }

    public BigOctonionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigOctonionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigQuaternionRing();
        this.fac = new BigOctonion(this.cfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstants() {
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.subtract(this.b);
        BigOctonionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigOctonionTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.subtract(this.b);
        BigOctonionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testBitLength() {
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.random(10);
        BigOctonionTest.assertEquals((String)"len(0) = 24", (long)24L, (long)this.a.bitLength());
        BigOctonionTest.assertEquals((String)"len(1) = 25", (long)25L, (long)this.b.bitLength());
        BigOctonionTest.assertEquals((String)"len(-1) = 25", (long)25L, (long)this.b.negate().bitLength());
        BigOctonionTest.assertTrue((String)"len(random) >= 24", (24L <= this.c.bitLength() ? 1 : 0) != 0);
        this.d = this.fac.I;
        BigOctonionTest.assertEquals((String)"len(i) = 25", (long)25L, (long)this.d.bitLength());
        BigOctonionTest.assertEquals((String)"len(-i) = 25", (long)25L, (long)this.d.negate().bitLength());
    }

    public void testConstructor() {
        this.a = new BigOctonion(this.cfac, "6/8");
        this.b = new BigOctonion(this.cfac, "3/4");
        BigOctonionTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigOctonion(this.cfac, "3/4 i 4/5 j 1/5 k 2/5");
        this.b = new BigOctonion(this.cfac, "-3/4 i -4/5 j -1/5 k -2/5");
        BigOctonionTest.assertEquals((String)"3/4 + i 4/5 + j 1/5 + k 2/5", (Object)this.a, (Object)this.b.negate());
        Object object = "6/1111111111111111111111111111111111111111111";
        this.a = new BigOctonion(this.cfac, (String)object);
        String string = this.a.toString();
        BigOctonionTest.assertEquals((String)"stringConstr = toString", (String)object, (String)string);
        String string2 = "3/4 i 4/5 j 1/5 k 2/5";
        String string3 = "-3/4 i -4/5 j -1/5 k -2/5";
        object = string2 + " o " + string3;
        this.a = new BigOctonion(this.cfac, (String)object);
        BigQuaternion bigQuaternion = new BigQuaternion(this.cfac, string2);
        BigQuaternion bigQuaternion2 = new BigQuaternion(this.cfac, string3);
        this.b = new BigOctonion(bigQuaternion, bigQuaternion2);
        BigOctonionTest.assertEquals((String)("s = " + (String)object), (Object)this.a, (Object)this.b);
        this.a = new BigOctonion(this.cfac, 1L);
        this.b = new BigOctonion(this.cfac, -1L);
        this.c = this.b.sum(this.a);
        BigOctonionTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigOctonionTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.fac.getZERO());
    }

    public void testRandom() {
        this.a = this.fac.random(10);
        this.b = new BigOctonion(this.a.getR(), this.a.getI());
        this.c = this.b.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a-b = 0", (Object)this.fac.getZERO(), (Object)this.c);
        this.d = new BigOctonion(this.b.getR(), this.b.getI());
        BigOctonionTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = this.fac.random(10);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(this.fac.getZERO());
        BigOctonionTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.fac.getZERO());
        BigOctonionTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.fac.getZERO());
    }

    public void testMultiplication() {
        this.a = this.fac.random(10);
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        BigOctonionTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(this.fac.getONE());
        BigOctonionTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.fac.getONE());
        BigOctonionTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.fac.random(30);
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        BigOctonionTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        this.b = this.a.abs();
        this.c = this.b.inverse();
        this.d = this.b.multiply(this.c);
        BigOctonionTest.assertTrue((String)"abs(a)*1/abs(a) = 1", (boolean)this.d.isONE());
        this.a = this.fac.random(30);
        this.b = this.a.norm();
        this.d = this.a.multiply(this.a.conjugate());
        BigOctonionTest.assertEquals((String)"norm(a) == a a^", (Object)this.b, (Object)this.d);
        this.c = this.a.abs();
        this.d = this.c.multiply(this.c);
        BigRational bigRational = this.d.or.re.subtract(this.b.or.re).abs().divide(this.d.or.re.abs().sum(this.b.or.re.abs()));
        BigRational bigRational2 = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        BigOctonionTest.assertTrue((String)("abs()*abs() == norm(): " + bigRational), (bigRational.compareTo(bigRational2) <= 0 ? 1 : 0) != 0);
        this.b = this.fac.random(10);
        this.c = this.a.inverse();
        this.d = this.c.multiply(this.b);
        this.e = this.a.multiply(this.d);
        BigOctonionTest.assertEquals((String)"a*(1/a)*b = b", (Object)this.b, (Object)this.e);
        this.d = this.b.multiply(this.c);
        this.e = this.d.multiply(this.a);
        BigOctonionTest.assertEquals((String)"b*(1/a)*a = b", (Object)this.b, (Object)this.e);
        this.c = this.a.rightDivide(this.b);
        this.d = this.c.multiply(this.b);
        BigOctonionTest.assertEquals((String)"a*(1/b)*b = a", (Object)this.a, (Object)this.d);
        this.c = this.a.leftDivide(this.b);
        this.d = this.b.multiply(this.c);
        BigOctonionTest.assertEquals((String)"b*(1/b)*a = a", (Object)this.a, (Object)this.d);
    }

    public void testMultiplicationAxioms() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigOctonionTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) ? 1 : 0) != 0);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        BigOctonionTest.assertTrue((String)"a(bc) != (ab)c", (!this.e.equals(this.d) ? 1 : 0) != 0);
    }

    public void testDistributive() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigOctonionTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }
}

