/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.kern.Scripting;
import edu.jas.kern.StringUtil;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BigQuaternionRing
implements RingFactory<BigQuaternion> {
    static List<BigQuaternion> entierUnits = null;
    protected boolean integral = false;
    protected static final Random random = new Random();
    private static final Logger logger = LogManager.getLogger(BigQuaternionRing.class);
    public final BigQuaternion ZERO = new BigQuaternion(this);
    public final BigQuaternion ONE = new BigQuaternion(this, BigRational.ONE);
    public final BigQuaternion I = new BigQuaternion(this, BigRational.ZERO, BigRational.ONE);
    public final BigQuaternion J = new BigQuaternion(this, BigRational.ZERO, BigRational.ZERO, BigRational.ONE);
    public final BigQuaternion K = new BigQuaternion(this, BigRational.ZERO, BigRational.ZERO, BigRational.ZERO, BigRational.ONE);

    public BigQuaternionRing() {
        this(false);
    }

    public BigQuaternionRing(boolean bl) {
        this.integral = bl;
        logger.info("integral = {}", (Object)this.integral);
    }

    @Override
    public List<BigQuaternion> generators() {
        ArrayList<BigQuaternion> arrayList = new ArrayList<BigQuaternion>(4);
        arrayList.add(this.getONE());
        arrayList.add(this.I);
        arrayList.add(this.J);
        arrayList.add(this.K);
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigQuaternion copy(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this, bigQuaternion.re, bigQuaternion.im, bigQuaternion.jm, bigQuaternion.km);
    }

    @Override
    public BigQuaternion getZERO() {
        return this.ZERO;
    }

    @Override
    public BigQuaternion getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return !this.integral;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigQuaternion fromInteger(BigInteger bigInteger) {
        return new BigQuaternion(this, new BigRational(bigInteger));
    }

    @Override
    public BigQuaternion fromInteger(long l) {
        return new BigQuaternion(this, new BigRational(l));
    }

    public BigQuaternion fromInteger(long[] lArray) {
        return new BigQuaternion(this, new BigRational(lArray[0]), new BigRational(lArray[1]), new BigRational(lArray[2]), new BigRational(lArray[3]));
    }

    public String toString() {
        String string = "BigQuaternionRing(" + this.integral + ")";
        return string;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("Quat(");
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append(this.integral ? "true" : "");
                break;
            }
            default: {
                stringBuffer.append(this.integral ? "True" : "");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigQuaternionRing)) {
            return false;
        }
        BigQuaternionRing bigQuaternionRing = (BigQuaternionRing)object;
        return this.integral == bigQuaternionRing.integral;
    }

    public int hashCode() {
        int n = 4711;
        return n;
    }

    public List<BigQuaternion> unitsOfHurwitzian() {
        if (entierUnits != null) {
            return entierUnits;
        }
        BigRational bigRational = BigRational.HALF;
        List<BigQuaternion> list = this.generators();
        ArrayList<BigQuaternion> arrayList = new ArrayList<BigQuaternion>(list);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            BigQuaternion bigQuaternion = (BigQuaternion)object.next();
            list.add(bigQuaternion.negate());
        }
        for (Object object2 : object = (Object)new long[][]{{1L, 1L, 1L, 1L}, {-1L, 1L, 1L, 1L}, {1L, -1L, 1L, 1L}, {-1L, -1L, 1L, 1L}, {1L, 1L, -1L, 1L}, {-1L, 1L, -1L, 1L}, {1L, -1L, -1L, 1L}, {-1L, -1L, -1L, 1L}, {1L, 1L, 1L, -1L}, {-1L, 1L, 1L, -1L}, {1L, -1L, 1L, -1L}, {-1L, -1L, 1L, -1L}, {1L, 1L, -1L, -1L}, {-1L, 1L, -1L, -1L}, {1L, -1L, -1L, -1L}, {-1L, -1L, -1L, -1L}}) {
            BigQuaternion bigQuaternion = this.fromInteger((long[])object2);
            bigQuaternion = bigQuaternion.multiply(bigRational);
            list.add(bigQuaternion);
        }
        entierUnits = list;
        return list;
    }

    @Override
    public BigQuaternion random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigQuaternion random(int n, Random random) {
        BigRational bigRational = BigRational.ONE.random(n, random);
        BigRational bigRational2 = BigRational.ONE.random(n, random);
        BigRational bigRational3 = BigRational.ONE.random(n, random);
        BigRational bigRational4 = BigRational.ONE.random(n, random);
        BigQuaternion bigQuaternion = new BigQuaternion(this, bigRational, bigRational2, bigRational3, bigRational4);
        if (this.integral) {
            bigQuaternion = bigQuaternion.roundToHurwitzian();
        }
        return bigQuaternion;
    }

    @Override
    public BigQuaternion parse(String string) {
        return new BigQuaternion(this, string);
    }

    @Override
    public BigQuaternion parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }
}

