/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigRational;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigRationalTest
extends TestCase {
    BigRational a;
    BigRational b;
    BigRational c;
    BigRational d;
    BigRational e;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigRationalTest.suite());
    }

    public BigRationalTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigRationalTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstants() {
        this.a = BigRational.ZERO;
        this.b = BigRational.ONE;
        this.c = BigRational.RNDIF(this.b, this.b);
        BigRationalTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigRationalTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigRationalTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        BigRationalTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testBitLength() {
        this.a = BigRational.ZERO;
        this.b = BigRational.ONE;
        this.c = BigRational.RNDIF(this.b, this.b);
        this.d = BigRational.RNRAND(500);
        BigRationalTest.assertEquals((String)"len(0) = 3", (long)3L, (long)this.a.bitLength());
        BigRationalTest.assertEquals((String)"len(1) = 4", (long)4L, (long)this.b.bitLength());
        BigRationalTest.assertEquals((String)"len(-1) = 4", (long)4L, (long)this.b.negate().bitLength());
        BigRationalTest.assertTrue((String)"len(rnd) >= 1", (1L <= this.d.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        this.a = new BigRational("6/8");
        this.b = new BigRational("3/4");
        BigRationalTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigRational("3/-4");
        this.b = new BigRational("-3/4");
        BigRationalTest.assertEquals((String)"3/-4 = -3/4", (Object)this.a, (Object)this.b);
        String string = "6/1111111111111111111111111111111111111111111";
        this.a = new BigRational(string);
        String string2 = this.a.toString();
        BigRationalTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        this.a = new BigRational(1L);
        this.b = new BigRational(-1L);
        this.c = BigRational.RNSUM(this.b, this.a);
        BigRationalTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigRationalTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)BigRational.ZERO);
        string = "1.500000000";
        this.a = new BigRational(string);
        this.b = new BigRational("3/2");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        string = "-1.500000000";
        this.a = new BigRational(string);
        this.b = new BigRational("-3/2");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        string = "0.750000000";
        this.a = new BigRational(string);
        this.b = new BigRational("3/4");
        BigRationalTest.assertEquals((String)"decimalConstr = b ", (Object)this.a, (Object)this.b);
        string = "0.333333333";
        this.a = new BigRational(string);
        string2 = this.a.toString(9);
        BigRationalTest.assertEquals((String)("decimalConstr = b " + string2), (String)string, (String)string2);
        string = "-0.000033333";
        this.a = new BigRational(string);
        string2 = this.a.toString(9);
        BigRationalTest.assertEquals((String)("decimalConstr = b " + string2), (String)string, (String)string2);
    }

    public void testRandom() {
        this.a = BigRational.RNRAND(500);
        this.b = new BigRational("" + this.a);
        this.c = BigRational.RNDIF(this.b, this.a);
        BigRationalTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)BigRational.ZERO);
        this.d = new BigRational(this.b.numerator(), this.b.denominator());
        BigRationalTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNSUM(this.a, this.a);
        this.c = BigRational.RNDIF(this.b, this.a);
        BigRationalTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigRationalTest.assertEquals((String)"a+a-a = a", (int)0, (int)BigRational.RNCOMP(this.c, this.a));
        this.d = BigRational.RNSUM(this.a, BigRational.ZERO);
        BigRationalTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNDIF(this.a, BigRational.ZERO);
        BigRationalTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNDIF(this.a, this.a);
        BigRationalTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)BigRational.ZERO);
    }

    public void testMultiplication() {
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNPROD(this.a, this.a);
        this.c = BigRational.RNQ(this.b, this.a);
        BigRationalTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigRationalTest.assertEquals((String)"a*a/a = a", (int)0, (int)BigRational.RNCOMP(this.c, this.a));
        this.d = BigRational.RNPROD(this.a, BigRational.ONE);
        BigRationalTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = BigRational.RNQ(this.a, BigRational.ONE);
        BigRationalTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = BigRational.RNRAND(100);
        this.b = BigRational.RNINV(this.a);
        this.c = BigRational.RNPROD(this.a, this.b);
        BigRationalTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
    }

    public void testDistributive() {
        BigRational bigRational = new BigRational();
        this.a = bigRational.random(500);
        this.b = bigRational.random(500);
        this.c = bigRational.random(500);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigRationalTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }

    public void testIterator() {
        int n = 0;
        BigRational bigRational = new BigRational();
        bigRational.setAllIterator();
        BigRational bigRational2 = null;
        BigRational bigRational3 = null;
        for (BigRational bigRational4 : bigRational) {
            if (++n < 20) continue;
            bigRational2 = bigRational4;
            break;
        }
        BigRationalTest.assertFalse((String)"j == null ", (bigRational2 == null ? 1 : 0) != 0);
        bigRational3 = new BigRational(-2L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)bigRational2.equals(bigRational3));
    }

    public void testNNIterator() {
        int n = 0;
        BigRational bigRational = new BigRational();
        bigRational.setNonNegativeIterator();
        BigRational bigRational2 = null;
        BigRational bigRational3 = null;
        for (BigRational bigRational4 : bigRational) {
            if (++n < 20) continue;
            bigRational2 = bigRational4;
            break;
        }
        BigRationalTest.assertFalse((String)"j == null ", (bigRational2 == null ? 1 : 0) != 0);
        bigRational3 = new BigRational(4L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)bigRational2.equals(bigRational3));
    }

    public void testUniqueNNIterator() {
        int n = 0;
        BigRational bigRational = new BigRational();
        bigRational.setNonNegativeIterator();
        BigRational bigRational2 = null;
        BigRational bigRational3 = null;
        Iterator<BigRational> iterator = bigRational.uniqueIterator();
        while (iterator.hasNext()) {
            BigRational bigRational4 = iterator.next();
            if (++n < 20) continue;
            bigRational2 = bigRational4;
            break;
        }
        BigRationalTest.assertFalse((String)"j == null ", (bigRational2 == null ? 1 : 0) != 0);
        bigRational3 = new BigRational(5L, 3L);
        BigRationalTest.assertTrue((String)"j == 10 ", (boolean)bigRational2.equals(bigRational3));
    }

    public void testDoubleValue() {
        BigRational bigRational = new BigRational();
        this.a = bigRational.random(5000);
        double d = this.a.doubleValue();
        String string = this.a.toString(16);
        String string2 = Double.toString(d);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        if (string2.indexOf(".") >= 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        if (string.indexOf(".") >= 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        int n = Math.min(string.length(), string2.length());
        string = string.substring(0, n - 1);
        string2 = string2.substring(0, n - 1);
        BigRationalTest.assertEquals((String)("a = decimal(d): " + d), (String)string, (String)string2);
    }
}

