/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GroebnerBaseDistributedHybridEC;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class HybridReducerReceiverEC<C extends RingElem<C>>
extends Thread {
    private static final Logger logger = LogManager.getLogger(HybridReducerReceiverEC.class);
    private static final boolean debug = logger.isDebugEnabled();
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private final TaggedSocketChannel pairChannel;
    private final Terminator finner;
    private final AtomicInteger active;
    private volatile boolean goon;
    public final Integer pairTag = GroebnerBaseDistributedHybridEC.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybridEC.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybridEC.ackTag;

    HybridReducerReceiverEC(Terminator terminator, AtomicInteger atomicInteger, TaggedSocketChannel taggedSocketChannel, DistHashTable<Integer, GenPolynomial<C>> distHashTable, PairList<C> pairList) {
        this.active = atomicInteger;
        this.finner = terminator;
        this.pairChannel = taggedSocketChannel;
        this.theList = distHashTable;
        this.pairlist = pairList;
        this.goon = true;
    }

    @Override
    public void run() {
        GenPolynomial genPolynomial = null;
        int n = 0;
        int n2 = -1;
        while (this.goon) {
            logger.info("receive result");
            Object object = null;
            try {
                object = this.pairChannel.receive(this.resultTag);
                int n3 = this.active.getAndDecrement();
            }
            catch (InterruptedException interruptedException) {
                this.goon = false;
                break;
            }
            catch (IOException iOException) {
                this.goon = false;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                this.goon = false;
                this.finner.initIdle(1);
                break;
            }
            logger.info("received H polynomial {}", object);
            if (object == null) {
                if (this.isInterrupted()) {
                    this.goon = false;
                    this.finner.initIdle(1);
                    break;
                }
            } else {
                if (object instanceof GBTransportMessEnd) {
                    logger.info("received GBTransportMessEnd");
                    this.goon = false;
                    break;
                }
                if (object instanceof GBTransportMessPoly) {
                    ++n;
                    GBTransportMessPoly gBTransportMessPoly = (GBTransportMessPoly)object;
                    genPolynomial = gBTransportMessPoly.pol;
                    if (genPolynomial != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("H = {}", (Object)genPolynomial.leadingExpVector());
                        }
                        if (!genPolynomial.isZERO()) {
                            if (genPolynomial.isONE()) {
                                n2 = this.pairlist.putOne();
                                this.theList.putWait(n2, genPolynomial);
                            } else {
                                n2 = this.pairlist.put(genPolynomial);
                                this.theList.putWait(n2, genPolynomial);
                            }
                        }
                    }
                }
            }
            this.finner.initIdle(1);
            try {
                this.pairChannel.send(this.ackTag, new GBTransportMess());
                logger.debug("send acknowledgement");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.goon = false;
                break;
            }
        }
        this.goon = false;
        logger.info("terminated, received {} reductions", (Object)n);
    }

    public void terminate() {
        this.goon = false;
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("HybridReducerReceiver terminated");
    }
}

