/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MiReducerServerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private GenPolynomial<C> H;
    private final Semaphore done = new Semaphore(0);
    private final Reduction<C> red;
    private static final Logger logger = LogManager.getLogger(MiReducerServerSeqPair.class);

    MiReducerServerSeqPair(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        this.G = list;
        this.H = genPolynomial;
        this.red = new ReductionPar();
    }

    public GenPolynomial<C> getNF() {
        try {
            this.done.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.H;
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("ht(H) = {}", (Object)this.H.leadingExpVector());
        }
        this.H = this.red.normalform(this.G, this.H);
        this.done.release();
        if (logger.isDebugEnabled()) {
            logger.debug("ht(H) = {}", (Object)this.H.leadingExpVector());
        }
    }
}

