/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderedPairlist<C extends RingElem<C>>
implements PairList<C> {
    protected final List<GenPolynomial<C>> P;
    protected final SortedMap<ExpVector, LinkedList<Pair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final GenPolynomialRing<C> ring;
    protected final Reduction<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = true;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;
    private static final Logger logger = LogManager.getLogger(OrderedPairlist.class);

    public OrderedPairlist() {
        this.moduleVars = 0;
        this.ring = null;
        this.P = null;
        this.pairlist = null;
        this.red = null;
        this.reduction = null;
        this.putCount = 0;
        this.remCount = 0;
    }

    public OrderedPairlist(GenPolynomialRing<C> genPolynomialRing) {
        this(0, genPolynomialRing);
    }

    public OrderedPairlist(int n, GenPolynomialRing<C> genPolynomialRing) {
        this.moduleVars = n;
        this.ring = genPolynomialRing;
        this.P = new ArrayList<GenPolynomial<C>>();
        this.pairlist = new TreeMap<ExpVector, LinkedList<Pair<C>>>(this.ring.tord.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        if (!this.ring.isCommutative()) {
            this.useCriterion4 = false;
        }
        this.reduction = new ReductionSeq();
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedPairlist<C>(genPolynomialRing);
    }

    @Override
    public PairList<C> create(int n, GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedPairlist<C>(n, genPolynomialRing);
    }

    @Override
    public GenPolynomialRing<C> getRing() {
        return this.ring;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName() + "(");
        stringBuffer.append("#put=" + this.putCount);
        stringBuffer.append(", #rem=" + this.remCount);
        if (this.pairlist != null && this.pairlist.size() != 0) {
            stringBuffer.append(", size=" + this.pairlist.size());
        }
        if (this.moduleVars > 0) {
            stringBuffer.append(", modv=" + this.moduleVars);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public synchronized int put(GenPolynomial<C> genPolynomial) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        int n = this.P.size();
        for (int i = 0; i < n; ++i) {
            GenPolynomial<C> genPolynomial2 = this.P.get(i);
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, expVector, expVector2)) continue;
            ExpVector expVector3 = expVector.lcm(expVector2);
            Pair<C> pair = new Pair<C>(genPolynomial2, genPolynomial, i, n);
            LinkedList<Pair<C>> linkedList = (LinkedList<Pair<C>>)this.pairlist.get(expVector3);
            if (linkedList == null) {
                linkedList = new LinkedList<Pair<C>>();
            }
            linkedList.addFirst(pair);
            this.pairlist.put(expVector3, linkedList);
        }
        this.P.add(genPolynomial);
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        this.red.add(bitSet);
        return this.P.size() - 1;
    }

    @Override
    public int put(List<GenPolynomial<C>> list) {
        int n = 0;
        for (GenPolynomial<C> genPolynomial : list) {
            n = this.put(genPolynomial);
        }
        return n;
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<Pair<C>>>> iterator = this.pairlist.entrySet().iterator();
        Pair<C> pair = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            Map.Entry<ExpVector, LinkedList<Pair<C>>> entry = iterator.next();
            ExpVector expVector = entry.getKey();
            LinkedList<Pair<C>> linkedList = entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info("g  = {}", (Object)expVector);
            }
            pair = null;
            while (!bl && linkedList.size() > 0) {
                pair = linkedList.removeFirst();
                int n = pair.i;
                int n2 = pair.j;
                bl = this.useCriterion4 ? this.reduction.criterion4(pair.pi, pair.pj, expVector) : true;
                if (bl) {
                    bl = this.criterion3(n, n2, expVector);
                }
                this.red.get(n2).clear(n);
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
        if (!bl) {
            pair = null;
        } else {
            pair.maxIndex(this.P.size() - 1);
            ++this.remCount;
            if (logger.isDebugEnabled()) {
                logger.info("pair({},{})", (Object)pair.j, (Object)pair.i);
            }
        }
        return pair;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public List<GenPolynomial<C>> getList() {
        return this.P;
    }

    @Override
    public void setList(List<GenPolynomial<C>> list) {
        if (!this.P.isEmpty()) {
            throw new IllegalArgumentException("P not empty");
        }
        this.P.addAll(list);
        for (int i = 0; i < this.P.size(); ++i) {
            BitSet bitSet = new BitSet();
            this.red.add(bitSet);
        }
    }

    @Override
    public int size() {
        return this.P.size();
    }

    @Override
    public synchronized int putCount() {
        return this.putCount;
    }

    @Override
    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this.P.size() - 1;
        }
        if (!genPolynomial.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    @Override
    public synchronized int putOne() {
        ++this.putCount;
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((GenPolynomial<C>)this.ring.getONE());
        this.red.clear();
        logger.info("outOne {}", (Object)this);
        return this.P.size() - 1;
    }

    @Override
    public boolean criterion3(int n, int n2, ExpVector expVector) {
        boolean bl = this.red.get(n2).get(n);
        if (!bl) {
            logger.warn("c3.s false for j, i = {}, {}", (Object)n2, (Object)n);
            return bl;
        }
        for (int i = 0; i < this.P.size(); ++i) {
            GenPolynomial<C> genPolynomial;
            ExpVector expVector2;
            boolean bl2;
            if (n == i || n2 == i || !(bl2 = expVector.multipleOf(expVector2 = (genPolynomial = this.P.get(i)).leadingExpVector()))) continue;
            if (i < n) {
                bl = this.red.get(n).get(i) || this.red.get(n2).get(i);
            } else if (n < i && i < n2) {
                bl = this.red.get(i).get(n) || this.red.get(n2).get(i);
            } else if (n2 < i) {
                boolean bl3 = bl = this.red.get(i).get(n) || this.red.get(i).get(n2);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

