/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.EReductionSeq;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    ReductionSeq<BigRational> red;
    Reduction<BigRational> redpar;
    int rl = 4;
    int kl = 10;
    int ll = 11;
    int el = 5;
    float q = 0.6f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ReductionTest.suite());
    }

    public ReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
        this.red = new ReductionSeq();
        this.redpar = new ReductionPar<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.red = null;
        this.redpar = null;
    }

    public void testRatReduction0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReductionPar0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.e = this.red.SPolynomial(this.a, this.b);
        ExpVector expVector = this.a.leadingExpVector().lcm(this.b.leadingExpVector());
        ExpVector expVector2 = this.e.leadingExpVector();
        ReductionTest.assertTrue((String)("lcm(lt(a),lt(b)) > lt(e) " + expVector + " > " + expVector2), (this.fac.tord.getAscendComparator().compare(expVector, expVector2) > 0 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.red.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.red.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.red.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.red.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.red.isNormalform(this.L, this.e));
    }

    public void testRatReductionPar() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.redpar.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.redpar.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.redpar.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.redpar.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.redpar.isNormalform(this.L, this.e));
    }

    public void testComplexReduction() {
        GenPolynomialRing<BigComplex> genPolynomialRing = new GenPolynomialRing<BigComplex>(new BigComplex(0L), this.rl);
        ReductionSeq<BigComplex> reductionSeq = new ReductionSeq<BigComplex>();
        GenPolynomial<BigComplex> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigComplex> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigComplex> genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)reductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)reductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)reductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)reductionSeq.isReducible(arrayList, genPolynomial2));
        GenPolynomial<BigComplex> genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)reductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testRatReductionRecording() {
        BasicLinAlg<Object> basicLinAlg = new BasicLinAlg<Object>();
        List<Object> list = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        list = basicLinAlg.genVector(this.L.size(), null);
        this.e = this.red.normalform(list, this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(list, this.L, this.a, this.e));
        this.L.add(this.b);
        list = basicLinAlg.genVector(this.L.size(), null);
        this.e = this.red.normalform(list, this.L, this.b);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(list, this.L, this.b, this.e));
        this.L.add(this.c);
        list = basicLinAlg.genVector(this.L.size(), null);
        this.e = this.red.normalform(list, this.L, this.c);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(list, this.L, this.c, this.e));
        this.L.add(this.d);
        list = basicLinAlg.genVector(this.L.size(), null);
        this.e = this.red.normalform(list, this.L, this.d);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(list, this.L, this.d, this.e));
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.L.add(this.b);
        list = basicLinAlg.genVector(this.L.size(), null);
        this.e = this.red.SPolynomial(list, 0, this.a, 1, this.b);
        ExpVector expVector = this.a.leadingExpVector().lcm(this.b.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(this.e.leadingExpVector()));
        ReductionTest.assertTrue((String)("is Spol recording: " + this.e), (boolean)this.red.isReductionNF(list, this.L, (GenPolynomial<BigRational>)this.e.negate(), (GenPolynomial<BigRational>)this.fac.getZERO()));
    }

    public void testIntegerEReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        EReductionSeq<BigInteger> eReductionSeq = new EReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigInteger> genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial3.isONE());
        arrayList = new ArrayList();
        genPolynomial = genPolynomial4.multiply(bigInteger.fromInteger(4L));
        genPolynomial2 = genPolynomial4.multiply(bigInteger.fromInteger(5L));
        arrayList.add(genPolynomial);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)genPolynomial3.isONE());
        genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial4 = eReductionSeq.GPolynomial(genPolynomial, genPolynomial2);
        genPolynomial3 = eReductionSeq.SPolynomial(genPolynomial, genPolynomial2);
        BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient().gcd(genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, (Object)genPolynomial4.leadingBaseCoefficient());
        ExpVector expVector = genPolynomial.leadingExpVector().lcm(genPolynomial2.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial4.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial3.leadingExpVector()));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)eReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)eReductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)eReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)eReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)eReductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testIntegerEReductionRecording() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        EReductionSeq<Object> eReductionSeq = new EReductionSeq<Object>();
        BasicLinAlg<Object> basicLinAlg = new BasicLinAlg<Object>();
        List<Object> list = null;
        ArrayList arrayList = new ArrayList();
        AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        ReductionTest.assertTrue((String)"not isZERO( a )", (!((GenPolynomial)abelianGroupElem).isZERO() ? 1 : 0) != 0);
        arrayList.add(abelianGroupElem);
        list = basicLinAlg.genVector(arrayList.size(), null);
        GenPolynomial<Object> genPolynomial = eReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial.isZERO());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)eReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem, genPolynomial));
        list = basicLinAlg.genVector(arrayList.size(), null);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.getONE();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(genPolynomial2);
        genPolynomial = eReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial.isONE());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)eReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem, genPolynomial));
        list = basicLinAlg.genVector(arrayList.size(), null);
        arrayList = new ArrayList();
        abelianGroupElem = genPolynomial2.multiply(bigInteger.fromInteger(4L));
        AbelianGroupElem abelianGroupElem2 = genPolynomial2.multiply(bigInteger.fromInteger(5L));
        arrayList.add(abelianGroupElem);
        genPolynomial = eReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem2);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)genPolynomial.isONE());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)eReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem2, genPolynomial));
        abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll / 2, this.el / 2, this.q).abs();
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * 2, this.el * 2, this.q * 1.0f).abs();
        ReductionTest.assertTrue((String)"not isZERO( a )", (!((GenPolynomial)abelianGroupElem).isZERO() ? 1 : 0) != 0);
        arrayList = new ArrayList();
        arrayList.add(abelianGroupElem2);
        arrayList.add(abelianGroupElem);
        list = basicLinAlg.genVector(arrayList.size(), null);
        genPolynomial = eReductionSeq.normalform(list, arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)eReductionSeq.isReductionNF(list, arrayList, genPolynomial2, genPolynomial));
        arrayList = new ArrayList();
        arrayList.add(abelianGroupElem);
        arrayList.add(abelianGroupElem2);
        list = basicLinAlg.genVector(2, null);
        genPolynomial2 = eReductionSeq.GPolynomial((List<GenPolynomial<Object>>)list, 0, (GenPolynomial<Object>)abelianGroupElem, 1, (GenPolynomial<Object>)abelianGroupElem2);
        BigInteger bigInteger2 = ((BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).gcd((BigInteger)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, (Object)genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertTrue((String)("is eGpol recording: " + genPolynomial2), (boolean)eReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)genPolynomial2, (GenPolynomial<Object>)genPolynomialRing.getZERO()));
        list = basicLinAlg.genVector(2, null);
        genPolynomial = eReductionSeq.SPolynomial((List<GenPolynomial<Object>>)list, 0, (GenPolynomial<Object>)abelianGroupElem, 1, (GenPolynomial<Object>)abelianGroupElem2);
        ExpVector expVector = ((GenPolynomial)abelianGroupElem).leadingExpVector().lcm(((GenPolynomial)abelianGroupElem2).leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial2.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial.leadingExpVector()));
        ReductionTest.assertTrue((String)("is eSpol recording: " + genPolynomial), (boolean)eReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, genPolynomial, (GenPolynomial<Object>)genPolynomialRing.getZERO()));
    }

    public void testIntegerDReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        DReductionSeq<BigInteger> dReductionSeq = new DReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigInteger> genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial3.isONE());
        arrayList = new ArrayList();
        genPolynomial = genPolynomial4.multiply(bigInteger.fromInteger(5L));
        arrayList.add(genPolynomial);
        genPolynomial2 = genPolynomial4.multiply(bigInteger.fromInteger(4L));
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"nf(b) = b ", (boolean)genPolynomial3.equals(genPolynomial2));
        genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial4 = dReductionSeq.GPolynomial(genPolynomial, genPolynomial2);
        genPolynomial3 = dReductionSeq.SPolynomial(genPolynomial, genPolynomial2);
        BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient().gcd(genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, (Object)genPolynomial4.leadingBaseCoefficient());
        ExpVector expVector = genPolynomial.leadingExpVector().lcm(genPolynomial2.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial4.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial3.leadingExpVector()));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)dReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)dReductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)dReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)dReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)dReductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testIntegerDReductionRecording() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        DReductionSeq<Object> dReductionSeq = new DReductionSeq<Object>();
        BasicLinAlg<Object> basicLinAlg = new BasicLinAlg<Object>();
        List<Object> list = null;
        ArrayList arrayList = new ArrayList();
        AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        ReductionTest.assertTrue((String)"not isZERO( a )", (!((GenPolynomial)abelianGroupElem).isZERO() ? 1 : 0) != 0);
        arrayList.add(abelianGroupElem);
        list = basicLinAlg.genVector(arrayList.size(), null);
        GenPolynomial<Object> genPolynomial = dReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial.isZERO());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)dReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem, genPolynomial));
        list = basicLinAlg.genVector(arrayList.size(), null);
        GenPolynomial genPolynomial2 = genPolynomialRing.getONE();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(genPolynomial2);
        genPolynomial = dReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial.isONE());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)dReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem, genPolynomial));
        list = basicLinAlg.genVector(arrayList.size(), null);
        arrayList = new ArrayList();
        abelianGroupElem = genPolynomial2.multiply(bigInteger.fromInteger(4L));
        AbelianGroupElem abelianGroupElem2 = genPolynomial2.multiply(bigInteger.fromInteger(5L));
        arrayList.add(abelianGroupElem);
        genPolynomial = dReductionSeq.normalform((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem2);
        ReductionTest.assertEquals((String)"e == b", genPolynomial, abelianGroupElem2);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)dReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, (GenPolynomial<Object>)abelianGroupElem2, genPolynomial));
        abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q).abs();
        abelianGroupElem2 = genPolynomialRing.random(this.kl, this.ll / 2, this.el / 2, this.q).abs();
        genPolynomial2 = ((GenPolynomial)abelianGroupElem).multiply(abelianGroupElem2);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!((GenPolynomial)abelianGroupElem).isZERO() ? 1 : 0) != 0);
        arrayList = new ArrayList();
        arrayList.add(abelianGroupElem2);
        arrayList.add(abelianGroupElem);
        list = basicLinAlg.genVector(arrayList.size(), null);
        genPolynomial = dReductionSeq.normalform(list, arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial.isZERO());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)dReductionSeq.isReductionNF(list, arrayList, genPolynomial2, genPolynomial));
        arrayList = new ArrayList();
        arrayList.add(abelianGroupElem);
        arrayList.add(abelianGroupElem2);
        list = basicLinAlg.genVector(2, null);
        genPolynomial2 = dReductionSeq.GPolynomial((List<GenPolynomial<Object>>)list, 0, (GenPolynomial<Object>)abelianGroupElem, 1, (GenPolynomial<Object>)abelianGroupElem2);
        BigInteger bigInteger2 = ((BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).gcd((BigInteger)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertTrue((String)("is dGpol recording: " + genPolynomial2), (boolean)dReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, genPolynomial2, (GenPolynomial<Object>)genPolynomialRing.getZERO()));
        list = basicLinAlg.genVector(2, null);
        genPolynomial = dReductionSeq.SPolynomial((List<GenPolynomial<Object>>)list, 0, (GenPolynomial<Object>)abelianGroupElem, 1, (GenPolynomial<Object>)abelianGroupElem2);
        ExpVector expVector = ((GenPolynomial)abelianGroupElem).leadingExpVector().lcm(((GenPolynomial)abelianGroupElem2).leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial2.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial.leadingExpVector()));
        ReductionTest.assertTrue((String)("is dSpol recording: " + genPolynomial), (boolean)dReductionSeq.isReductionNF((List<GenPolynomial<Object>>)list, arrayList, genPolynomial, (GenPolynomial<Object>)genPolynomialRing.getZERO()));
    }
}

