/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBase;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.gb.WordReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Word;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WordGroebnerBaseAbstract<C extends RingElem<C>>
implements WordGroebnerBase<C> {
    private static final Logger logger = LogManager.getLogger(WordGroebnerBaseAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final WordReduction<C> red;
    public final WordPairList<C> strategy;

    public WordGroebnerBaseAbstract() {
        this(new WordReductionSeq());
    }

    public WordGroebnerBaseAbstract(WordReduction<C> wordReduction) {
        this(wordReduction, new OrderedWordPairlist());
    }

    public WordGroebnerBaseAbstract(WordReduction<C> wordReduction, WordPairList<C> wordPairList) {
        this.red = wordReduction;
        this.strategy = wordPairList;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public List<GenWordPolynomial<C>> normalizeZerosOnes(List<GenWordPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list.size());
        if (list.isEmpty()) {
            return arrayList;
        }
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            if (genWordPolynomial == null || genWordPolynomial.isZERO()) continue;
            if (genWordPolynomial.isUnit()) {
                arrayList.clear();
                arrayList.add((GenWordPolynomial<C>)genWordPolynomial.ring.getONE());
                return arrayList;
            }
            arrayList.add((GenWordPolynomial<C>)genWordPolynomial.abs());
        }
        return arrayList;
    }

    public int commonZeroTest(List<GenWordPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return 1;
        }
        GenWordPolynomialRing genWordPolynomialRing = list.get((int)0).ring;
        if (genWordPolynomialRing.alphabet.length() <= 0) {
            return -1;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            SortedMap<String, Integer> sortedMap;
            if (genWordPolynomial.isZERO()) continue;
            if (genWordPolynomial.isConstant()) {
                return -1;
            }
            Word word = genWordPolynomial.leadingWord();
            if (word == null || (sortedMap = word.dependencyOnVariables()) == null || sortedMap.size() != 1) continue;
            hashSet.add(sortedMap.firstKey());
        }
        if (genWordPolynomialRing.alphabet.length() == hashSet.size()) {
            return 0;
        }
        return 1;
    }

    public List<Long> univariateDegrees(List<GenWordPolynomial<C>> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        GenWordPolynomialRing genWordPolynomialRing = list.get((int)0).ring;
        if (genWordPolynomialRing.alphabet.length() <= 0) {
            return arrayList;
        }
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            Long l;
            SortedMap<String, Integer> sortedMap;
            Word word = genWordPolynomial.leadingWord();
            if (word == null || (sortedMap = word.dependencyOnVariables()) == null || sortedMap.size() != 1 || (l = (Long)treeMap.get(sortedMap.firstKey())) != null) continue;
            treeMap.put(sortedMap.firstKey(), Long.valueOf(((Integer)sortedMap.get(sortedMap.firstKey())).intValue()));
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    @Override
    public boolean isGB(List<GenWordPolynomial<C>> list) {
        if (list == null || list.size() <= 1) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenWordPolynomial<C> genWordPolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenWordPolynomial<C> genWordPolynomial2;
                GenWordPolynomial<C> genWordPolynomial3 = list.get(j);
                List<GenWordPolynomial<C>> list2 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial3);
                for (GenWordPolynomial<C> genWordPolynomial4 : list2) {
                    genWordPolynomial2 = this.red.normalform(list, genWordPolynomial4);
                    if (genWordPolynomial2.isZERO()) continue;
                    logger.info("no GB: pi = {}, pj = {}", genWordPolynomial, genWordPolynomial3);
                    logger.info("s  = {}, h = {}", genWordPolynomial4, genWordPolynomial2);
                    return false;
                }
                list2 = this.red.SPolynomials(genWordPolynomial3, genWordPolynomial);
                for (GenWordPolynomial<C> genWordPolynomial4 : list2) {
                    genWordPolynomial2 = this.red.normalform(list, genWordPolynomial4);
                    if (genWordPolynomial2.isZERO()) continue;
                    logger.info("no GB: pj = {}, pi = {}", genWordPolynomial3, genWordPolynomial);
                    logger.info("s  = {}, h = {}", genWordPolynomial4, genWordPolynomial2);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public abstract List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> var1);

    @Override
    public List<GenWordPolynomial<C>> minimalGB(List<GenWordPolynomial<C>> list) {
        GenWordPolynomial genWordPolynomial;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenWordPolynomial<C>> iterable2 = new ArrayList<GenWordPolynomial<C>>(list.size());
        for (GenWordPolynomial<C> iterable3 : list) {
            if (iterable3 == null || iterable3.isZERO()) continue;
            iterable2.add(iterable3);
        }
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        ArrayList arrayList = new ArrayList(iterable2.size());
        while (iterable2.size() > 0) {
            genWordPolynomial = (GenWordPolynomial)iterable2.remove(0);
            if (this.red.isTopReducible(iterable2, genWordPolynomial) || this.red.isTopReducible(arrayList, genWordPolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genWordPolynomial);
                ArrayList<GenWordPolynomial<C>> n = new ArrayList<GenWordPolynomial<C>>(iterable2);
                n.addAll(arrayList);
                if ((genWordPolynomial = this.red.normalform(n, genWordPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genWordPolynomial);
                continue;
            }
            arrayList.add(genWordPolynomial);
        }
        iterable2 = arrayList;
        if (iterable2.size() <= 1) {
            return iterable2;
        }
        Collections.reverse(iterable2);
        int n = iterable2.size();
        if (debug) {
            System.out.println("#G " + n);
            for (GenWordPolynomial genWordPolynomial2 : iterable2) {
                System.out.println("aa = " + genWordPolynomial2.length() + ", lt = " + genWordPolynomial2.getMap().keySet());
            }
        }
        for (int i = 0; i < n; ++i) {
            genWordPolynomial = (GenWordPolynomial)iterable2.remove(0);
            if (debug) {
                System.out.println("doing " + genWordPolynomial.length() + ", lt = " + genWordPolynomial.leadingWord());
            }
            genWordPolynomial = this.red.normalform(iterable2, genWordPolynomial);
            iterable2.add(genWordPolynomial);
        }
        return iterable2;
    }

    public boolean isMinimalGB(List<GenWordPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (GenWordPolynomial<C> iterable2 : list) {
            if (iterable2 != null && !iterable2.isZERO()) continue;
            if (debug) {
                logger.debug("zero polynomial {}", iterable2);
            }
            return false;
        }
        ArrayList iterable3 = new ArrayList<GenWordPolynomial<C>>(list);
        ArrayList arrayList = new ArrayList(iterable3.size());
        while (iterable3.size() > 0) {
            GenWordPolynomial n = (GenWordPolynomial)iterable3.remove(0);
            if (this.red.isTopReducible(iterable3, n) || this.red.isTopReducible(arrayList, n)) {
                if (debug) {
                    logger.debug("top reducible polynomial {}", (Object)n);
                }
                return false;
            }
            arrayList.add(n);
        }
        iterable3 = arrayList;
        if (iterable3.size() <= 1) {
            return true;
        }
        int n = iterable3.size();
        for (int i = 0; i < n; ++i) {
            GenWordPolynomial genWordPolynomial = (GenWordPolynomial)iterable3.remove(0);
            if (!this.red.isNormalform(iterable3, genWordPolynomial)) {
                if (debug) {
                    logger.debug("reducible polynomial {}", (Object)genWordPolynomial);
                }
                return false;
            }
            iterable3.add(genWordPolynomial);
        }
        return true;
    }

    public void terminate() {
        logger.info("terminate not implemented");
    }

    public int cancel() {
        logger.info("cancel not implemented");
        return 0;
    }
}

