/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.PairList;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseRational<C extends BigRational>
extends GroebnerBaseAbstract<BigRational> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseRational.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<BigInteger> bba;

    public GroebnerBaseRational() {
        this(new GroebnerBasePseudoSeq<BigInteger>(new BigInteger()));
    }

    public GroebnerBaseRational(int n) {
        this(new GroebnerBasePseudoParallel<BigInteger>(n, new BigInteger()));
    }

    public GroebnerBaseRational(PairList<BigInteger> pairList) {
        this(new GroebnerBasePseudoSeq<BigInteger>(new BigInteger(), pairList));
    }

    public GroebnerBaseRational(int n, PairList<BigInteger> pairList) {
        this(new GroebnerBasePseudoParallel<BigInteger>(n, new BigInteger(), pairList));
    }

    public GroebnerBaseRational(GroebnerBaseAbstract<BigInteger> groebnerBaseAbstract) {
        this.bba = groebnerBaseAbstract;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.bba.toString() + ")";
    }

    @Override
    public List<GenPolynomial<BigRational>> GB(int n, List<GenPolynomial<BigRational>> list) {
        List<GenPolynomial<BigRational>> list2 = list;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(bigInteger, genPolynomialRing);
        List list3 = PolyUtil.integerFromRationalCoefficients(genPolynomialRing2, list);
        logger.info("#Fi = {}", (Object)list3.size());
        List<GenPolynomial<BigInteger>> list4 = this.bba.GB(n, list3);
        logger.info("#Gi = {}", (Object)list4.size());
        list2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, list4);
        list2 = PolyUtil.monic(list2);
        return list2;
    }

    @Override
    public List<GenPolynomial<BigRational>> minimalGB(List<GenPolynomial<BigRational>> list) {
        Iterable iterable;
        if (list == null || list.size() <= 1) {
            return list;
        }
        List<GenPolynomial<RingElem<BigRational>>> iterable3 = new ArrayList<GenPolynomial<BigRational>>(list.size());
        for (GenPolynomial<BigRational> iterable22 : list) {
            if (iterable22 == null || iterable22.isZERO()) continue;
            iterable3.add(iterable22);
        }
        if (iterable3.size() <= 1) {
            return iterable3;
        }
        ArrayList<GenPolynomial<BigRational>> arrayList = new ArrayList<GenPolynomial<BigRational>>(iterable3.size());
        while (iterable3.size() > 0) {
            GenPolynomial genPolynomial = (GenPolynomial)iterable3.remove(0);
            if (this.red.isTopReducible(iterable3, genPolynomial) || this.red.isTopReducible(arrayList, genPolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genPolynomial);
                iterable = new ArrayList(iterable3);
                iterable.addAll(arrayList);
                if ((genPolynomial = this.red.normalform(iterable, genPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
        }
        iterable3 = arrayList;
        if (iterable3.size() <= 1) {
            return iterable3;
        }
        iterable = ((GenPolynomial)iterable3.get((int)0)).ring;
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>((RingFactory<BigInteger>)bigInteger, (GenPolynomialRing)iterable);
        List list2 = PolyUtil.integerFromRationalCoefficients(genPolynomialRing, arrayList);
        logger.info("#Fi = {}", (Object)list2.size());
        List<GenPolynomial<BigInteger>> list3 = this.bba.minimalGB(list2);
        logger.info("#Gi = {}", (Object)list3.size());
        iterable3 = PolyUtil.fromIntegerCoefficients(iterable, list3);
        iterable3 = PolyUtil.monic(iterable3);
        return iterable3;
    }

    @Override
    public void terminate() {
        this.bba.terminate();
    }

    @Override
    public int cancel() {
        return this.bba.cancel();
    }
}

