/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.gbufd.PseudoReductionEntry;
import edu.jas.gbufd.SolvablePseudoReduction;
import edu.jas.gbufd.SolvablePseudoReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvablePseudoReductionTest
extends TestCase {
    GenSolvablePolynomialRing<BigInteger> fac;
    RelationTable table;
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    GenSolvablePolynomial<BigInteger> f;
    GenSolvablePolynomial<BigInteger> g;
    GenSolvablePolynomial<BigInteger> h;
    List<GenSolvablePolynomial<BigInteger>> L;
    PolynomialList<BigInteger> F;
    PolynomialList<BigInteger> G;
    SolvablePseudoReduction<BigInteger> sred;
    int rl = 4;
    int kl = 10;
    int ll = 5;
    int el = 3;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvablePseudoReductionTest.suite());
        ComputerThreads.terminate();
    }

    public SolvablePseudoReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvablePseudoReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(0L), stringArray);
        this.sred = new SolvablePseudoReductionSeq<BigInteger>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.sred = null;
    }

    public void testIntReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.d);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testWeylIntReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.fac);
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.d);
        this.e = this.sred.leftNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.leftNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testIntReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testWeylIntReduction() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.fac);
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.leftNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testIntReductionRecording() {
        List<GenPolynomial> list = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        PseudoReductionEntry<BigInteger> pseudoReductionEntry = this.sred.leftNormalformFactor(this.L, this.a);
        this.f = this.a.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.leftNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.b);
        pseudoReductionEntry = this.sred.leftNormalformFactor(this.L, this.b);
        this.f = this.b.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.leftNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.c);
        pseudoReductionEntry = this.sred.leftNormalformFactor(this.L, this.c);
        this.f = this.c.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.leftNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.d);
        pseudoReductionEntry = this.sred.leftNormalformFactor(this.L, this.d);
        this.f = this.d.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.e = this.sred.leftNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is leftReduction ", (boolean)this.sred.isLeftReductionNF(list, this.L, this.f, this.e));
    }

    public void testIntRightReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.d);
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testWeylIntRightReduction0() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.fac);
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.d);
        this.e = this.sred.rightNormalform(this.L, this.c);
        SolvablePseudoReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.sred.rightNormalform(this.L, this.d);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testIntRightReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testWeylIntRightReduction() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.fac);
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.sred.rightNormalform(this.L, this.a);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
    }

    public void testIntRightReductionRecording() {
        List<GenPolynomial> list = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        SolvablePseudoReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        PseudoReductionEntry<BigInteger> pseudoReductionEntry = this.sred.rightNormalformFactor(this.L, this.a);
        this.f = this.a.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.rightNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvablePseudoReductionTest.assertTrue((String)"is rightReduction ", (boolean)this.sred.isRightReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.b);
        pseudoReductionEntry = this.sred.rightNormalformFactor(this.L, this.b);
        this.f = this.b.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.rightNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is rightReduction ", (boolean)this.sred.isRightReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.c);
        pseudoReductionEntry = this.sred.rightNormalformFactor(this.L, this.c);
        this.f = this.c.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.d = this.sred.rightNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is rightReduction ", (boolean)this.sred.isRightReductionNF(list, this.L, this.f, this.d));
        this.L.add(this.d);
        pseudoReductionEntry = this.sred.rightNormalformFactor(this.L, this.d);
        this.f = this.d.multiply((RingElem)((BigInteger)pseudoReductionEntry.multiplicator));
        list = ListUtil.fill(this.L.size(), this.fac.getZERO());
        this.e = this.sred.rightNormalform(list, this.L, this.f);
        SolvablePseudoReductionTest.assertTrue((String)"is rightReduction ", (boolean)this.sred.isRightReductionNF(list, this.L, this.f, this.e));
    }
}

