/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.Integral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.List;

public class Examples {
    public static void main(String[] stringArray) {
        Examples.example1();
        Examples.example2();
        Examples.example3();
    }

    public static void example1() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        ElementaryIntegration<BigRational> elementaryIntegration = new ElementaryIntegration<BigRational>(bigRational);
        Element element = genPolynomialRing.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        System.out.println("A: " + ((GenPolynomial)element).toString());
        Element element2 = genPolynomialRing.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        System.out.println("D: " + ((GenPolynomial)element2).toString());
        GenPolynomial genPolynomial = ((GenPolynomial)element).gcd(element2);
        System.out.println("GCD: " + genPolynomial.toString());
        List<GenPolynomial<BigRational>>[] listArray = elementaryIntegration.integrateHermite((GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        System.out.println("Result: " + listArray[0] + " , " + listArray[1]);
        System.out.println("-----");
        element = genPolynomialRing.parse("10 x^2 - 63 x + 29");
        System.out.println("A: " + ((GenPolynomial)element).toString());
        element2 = genPolynomialRing.parse("x^3 - 11 x^2 + 40 x -48");
        System.out.println("D: " + ((GenPolynomial)element2).toString());
        genPolynomial = ((GenPolynomial)element).gcd(element2);
        System.out.println("GCD: " + genPolynomial.toString());
        listArray = elementaryIntegration.integrateHermite((GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        System.out.println("Result: " + listArray[0] + " , " + listArray[1]);
        System.out.println("-----");
        element = genPolynomialRing.parse("x+3");
        System.out.println("A: " + ((GenPolynomial)element).toString());
        element2 = genPolynomialRing.parse("x^2 - 3 x - 40");
        System.out.println("D: " + ((GenPolynomial)element2).toString());
        genPolynomial = ((GenPolynomial)element).gcd(element2);
        System.out.println("GCD: " + genPolynomial.toString());
        listArray = elementaryIntegration.integrateHermite((GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        System.out.println("Result: " + listArray[0] + " , " + listArray[1]);
        System.out.println("-----");
        element = genPolynomialRing.parse("10 x^2+12 x + 20");
        System.out.println("A: " + ((GenPolynomial)element).toString());
        element2 = genPolynomialRing.parse("x^3 - 8");
        System.out.println("D: " + ((GenPolynomial)element2).toString());
        genPolynomial = ((GenPolynomial)element).gcd(element2);
        System.out.println("GCD: " + genPolynomial.toString());
        listArray = elementaryIntegration.integrateHermite((GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        System.out.println("Result: " + listArray[0] + " , " + listArray[1]);
        System.out.println("------------------------------------------------------\n");
        ComputerThreads.terminate();
    }

    public static void example2() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        ElementaryIntegration<BigRational> elementaryIntegration = new ElementaryIntegration<BigRational>(bigRational);
        GenPolynomial<Element> genPolynomial = genPolynomialRing.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        System.out.println("A: " + genPolynomial.toString());
        Element element = genPolynomialRing.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        System.out.println("D: " + ((GenPolynomial)element).toString());
        GenPolynomial<Object> genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        Integral<BigRational> integral = elementaryIntegration.integrate((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("10 x^2 - 63 x + 29");
        System.out.println("A: " + genPolynomial.toString());
        element = genPolynomialRing.parse("x^3 - 11 x^2 + 40 x -48");
        System.out.println("D: " + ((GenPolynomial)element).toString());
        genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        integral = elementaryIntegration.integrate((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("x+3");
        System.out.println("A: " + genPolynomial.toString());
        element = genPolynomialRing.parse("x^2 - 3 x - 40");
        System.out.println("D: " + ((GenPolynomial)element).toString());
        genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        integral = elementaryIntegration.integrate((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("10 x^2+12 x + 20");
        System.out.println("A: " + genPolynomial.toString());
        element = genPolynomialRing.parse("x^3 - 8");
        System.out.println("D: " + ((GenPolynomial)element).toString());
        genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        integral = elementaryIntegration.integrate((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("1");
        System.out.println("A: " + genPolynomial.toString());
        element = genPolynomialRing.parse("(x**5 + x - 7)");
        System.out.println("D: " + ((GenPolynomial)element).toString());
        genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        integral = elementaryIntegration.integrate((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("1");
        element = genPolynomialRing.parse("(x**5 + x - 7)");
        genPolynomial = genPolynomial.sum(element);
        System.out.println("A: " + genPolynomial.toString());
        System.out.println("D: " + ((GenPolynomial)element).toString());
        genPolynomial2 = genPolynomial.gcd((GenPolynomial<Element>)element);
        System.out.println("GCD: " + genPolynomial2.toString());
        integral = elementaryIntegration.integrate(genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("Result: " + integral);
        System.out.println("-----");
        ComputerThreads.terminate();
    }

    public static void example3() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegration<BigRational> elementaryIntegration = new ElementaryIntegration<BigRational>(bigRational);
        GenPolynomial<Element> genPolynomial = genPolynomialRing.parse("x^7 - 24 x^4 - 4 x^2 + 8 x - 8");
        Element element = genPolynomialRing.parse("x^8 + 6 x^6 + 12 x^4 + 8 x^2");
        Quotient<Element<BigRational>> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("q =  " + quotient);
        QuotIntegral<BigRational> quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("10 x^2 - 63 x + 29");
        element = genPolynomialRing.parse("x^3 - 11 x^2 + 40 x -48");
        quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("q =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("x+3");
        element = genPolynomialRing.parse("x^2 - 3 x - 40");
        quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("q =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("10 x^2+12 x + 20");
        element = genPolynomialRing.parse("x^3 - 8");
        quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("q =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("1");
        element = genPolynomialRing.parse("(x**5 + x - 7)");
        quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)element);
        System.out.println("q =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        genPolynomial = genPolynomialRing.parse("1");
        element = genPolynomialRing.parse("(x**5 + x - 7)");
        genPolynomial = genPolynomial.sum(element);
        quotient = new Quotient<Element>((QuotientRing<Element>)quotientRing, genPolynomial, (GenPolynomial<Element>)element);
        System.out.println("q =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        System.out.println("-----");
        Element element2 = quotientRing.random(7);
        quotient = elementaryIntegration.derivative((Quotient<BigRational>)element2);
        System.out.println("qi =  " + (Quotient)element2);
        System.out.println("q  =  " + quotient);
        quotIntegral = elementaryIntegration.integrate(quotient);
        System.out.println("Result: " + quotIntegral);
        boolean bl = elementaryIntegration.isIntegral(quotIntegral);
        System.out.println("isIntegral = " + bl);
        System.out.println("-----");
        ComputerThreads.terminate();
    }
}

