/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.TimeExceededException;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class LocalTimeStatus {
    private boolean allowTime = false;
    private long limitTime = Long.MAX_VALUE;
    private long startTime = System.currentTimeMillis();
    private Callable<Boolean> callBack = null;

    public LocalTimeStatus() {
        this(false, Long.MAX_VALUE, false);
    }

    public LocalTimeStatus(boolean bl, long l, boolean bl2) {
        this.allowTime = bl;
        this.limitTime = l;
        this.callBack = new TSCall(bl2);
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LocalTimeStatus(");
        stringBuffer.append("" + this.allowTime);
        stringBuffer.append(", " + this.limitTime);
        try {
            stringBuffer.append(", " + (Serializable)(this.callBack == null ? "null" : (Serializable)this.callBack.call()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(", " + this.startTime);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public synchronized boolean isActive() {
        return this.allowTime;
    }

    public synchronized void setActive() {
        this.allowTime = true;
    }

    public synchronized void setNotActive() {
        this.allowTime = false;
    }

    public synchronized void setLimit(long l) {
        this.limitTime = l;
    }

    public synchronized void restart() {
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void setCallBack(Callable<Boolean> callable) {
        this.callBack = callable;
    }

    public synchronized void checkTime(String object) {
        if (!this.allowTime) {
            return;
        }
        if (this.limitTime == Long.MAX_VALUE) {
            return;
        }
        long l = System.currentTimeMillis() - this.startTime - this.limitTime;
        if (l <= 0L) {
            return;
        }
        if (this.callBack != null) {
            try {
                boolean bl = this.callBack.call();
                if (bl) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object != null) {
            object = (String)object + ", ";
        }
        throw new TimeExceededException((String)object + "elapsed time >= " + (this.limitTime + l) + " ms");
    }

    public static class TSCall
    implements Callable<Boolean> {
        boolean flag = true;

        public TSCall(boolean bl) {
            this.flag = bl;
        }

        @Override
        public Boolean call() {
            return this.flag;
        }
    }
}

