/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVectorByte;
import edu.jas.poly.ExpVectorInteger;
import edu.jas.poly.ExpVectorLong;
import edu.jas.poly.ExpVectorShort;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AbelianGroupFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public abstract class ExpVector
implements AbelianGroupElem<ExpVector> {
    protected transient int hash = -1;
    protected transient long blen = -1L;
    private static final Random random = new Random();
    public static final StorUnit storunit = StorUnit.LONG;

    public static final ExpVector create(int n) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n);
            }
            case LONG: {
                return new ExpVectorLong(n);
            }
            case SHORT: {
                return new ExpVectorShort(n);
            }
            case BYTE: {
                return new ExpVectorByte(n);
            }
        }
        return new ExpVectorInteger(n);
    }

    public static final ExpVector create(int n, int n2, long l) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n, n2, l);
            }
            case LONG: {
                return new ExpVectorLong(n, n2, l);
            }
            case SHORT: {
                return new ExpVectorShort(n, n2, l);
            }
            case BYTE: {
                return new ExpVectorByte(n, n2, l);
            }
        }
        return new ExpVectorInteger(n, n2, l);
    }

    public static final ExpVector create(long[] lArray) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(lArray);
            }
            case LONG: {
                return new ExpVectorLong(lArray);
            }
            case SHORT: {
                return new ExpVectorShort(lArray);
            }
            case BYTE: {
                return new ExpVectorByte(lArray);
            }
        }
        return new ExpVectorInteger(lArray);
    }

    public static final ExpVector create(String string) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(string);
            }
            case LONG: {
                return new ExpVectorLong(string);
            }
            case SHORT: {
                return new ExpVectorShort(string);
            }
            case BYTE: {
                return new ExpVectorByte(string);
            }
        }
        return new ExpVectorInteger(string);
    }

    public static final ExpVector create(Collection<Long> collection) {
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (Long l : collection) {
            lArray[n++] = l;
        }
        return ExpVector.create(lArray);
    }

    @Override
    public AbelianGroupFactory<ExpVector> factory() {
        throw new UnsupportedOperationException("no factory implemented for ExpVector");
    }

    public boolean isFinite() {
        return true;
    }

    public static ExpVector valueOf(ExpVector expVector) {
        throw new UnsupportedOperationException("no general conversion");
    }

    @Override
    public abstract ExpVector copy();

    public abstract long[] getVal();

    public abstract long getVal(int var1);

    protected abstract long setVal(int var1, long var2);

    public abstract int length();

    public abstract ExpVector extend(int var1, int var2, long var3);

    public abstract ExpVector extendLower(int var1, int var2, long var3);

    public abstract ExpVector contract(int var1, int var2);

    public abstract ExpVector reverse();

    public abstract ExpVector reverse(int var1);

    public abstract ExpVector combine(ExpVector var1);

    public abstract ExpVector permutation(List<Integer> var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < this.length(); ++i) {
            stringBuffer.append(this.getVal(i));
            if (i >= this.length() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString(String[] stringArray) {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.length();
        if (n != stringArray.length) {
            return this.toString();
        }
        if (n == 0) {
            return stringBuffer.toString();
        }
        for (int i = n - 1; i > 0; --i) {
            l = this.getVal(i);
            if (l == 0L) continue;
            stringBuffer.append(stringArray[n - 1 - i]);
            if (l != 1L) {
                stringBuffer.append("^" + l);
            }
            boolean bl = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j) == 0L) continue;
                bl = true;
            }
            if (!bl) continue;
            stringBuffer.append(" * ");
        }
        l = this.getVal(0);
        if (l != 0L) {
            stringBuffer.append(stringArray[n - 1]);
            if (l != 1L) {
                stringBuffer.append("^" + l);
            }
        }
        return stringBuffer.toString();
    }

    public static final String varsToString(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return this.toScript(this.stdVars());
    }

    public String toScript(String[] stringArray) {
        long l;
        int n = this.length();
        if (n != stringArray.length) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n - 1; i > 0; --i) {
            l = this.getVal(i);
            if (l == 0L) continue;
            stringBuffer.append(stringArray[n - 1 - i]);
            if (l != 1L) {
                stringBuffer.append("**" + l);
            }
            boolean bl = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j) == 0L) continue;
                bl = true;
            }
            if (!bl) continue;
            stringBuffer.append(" * ");
        }
        l = this.getVal(0);
        if (l != 0L) {
            stringBuffer.append(stringArray[n - 1]);
            if (l != 1L) {
                stringBuffer.append("**" + l);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "ExpVector()";
    }

    public String indexVarName(int n, String ... stringArray) {
        return stringArray[this.length() - n - 1];
    }

    public int varIndex(int n) {
        return this.length() - n - 1;
    }

    public int indexVar(String string, String ... stringArray) {
        for (int i = 0; i < this.length(); ++i) {
            if (!string.equals(stringArray[i])) continue;
            return this.length() - i - 1;
        }
        return -1;
    }

    public <C extends RingElem<C>> C evaluate(RingFactory<C> ringFactory, List<C> list) {
        RingElem ringElem = (RingElem)ringFactory.getONE();
        for (int i = 0; i < this.length(); ++i) {
            long l = this.getVal(i);
            if (l == 0L) continue;
            RingElem ringElem2 = (RingElem)list.get(this.length() - 1 - i);
            if (ringElem2.isZERO()) {
                return (C)ringElem2;
            }
            RingElem ringElem3 = (RingElem)ringElem2.power(l);
            ringElem = ringElem.multiply(ringElem3);
        }
        return (C)ringElem;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExpVector)) {
            return false;
        }
        ExpVector expVector = (ExpVector)object;
        int n = this.invLexCompareTo(expVector);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        if (this.hash < 0) {
            int n = 0;
            int n2 = this.length();
            for (int i = 0; i < n2; ++i) {
                n = (n << 3) + (int)this.getVal(i);
            }
            this.hash = n;
        }
        return this.hash;
    }

    public long bitLength() {
        if (this.blen < 0L) {
            long l = 0L;
            for (int i = 0; i < this.length(); ++i) {
                l += BigInteger.bitLength(this.getVal(i));
            }
            this.blen = l;
        }
        return this.blen;
    }

    @Override
    public boolean isZERO() {
        return 0 == this.signum();
    }

    public String[] stdVars() {
        return ExpVector.STDVARS("x", this.length());
    }

    public String[] stdVars(String string) {
        return ExpVector.STDVARS(string, this.length());
    }

    public static final String[] STDVARS(int n) {
        return ExpVector.STDVARS("x", n);
    }

    public static final String[] STDVARS(String string, int n) {
        String[] stringArray = new String[n];
        if (string == null || string.length() == 0) {
            string = "x";
        }
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string + i;
        }
        return stringArray;
    }

    public static final ExpVector EVABS(ExpVector expVector) {
        return expVector.abs();
    }

    @Override
    public abstract ExpVector abs();

    public static final ExpVector EVNEG(ExpVector expVector) {
        return expVector.negate();
    }

    @Override
    public abstract ExpVector negate();

    public static final ExpVector EVSUM(ExpVector expVector, ExpVector expVector2) {
        return expVector.sum(expVector2);
    }

    @Override
    public abstract ExpVector sum(ExpVector var1);

    public static final ExpVector EVDIF(ExpVector expVector, ExpVector expVector2) {
        return expVector.subtract(expVector2);
    }

    @Override
    public abstract ExpVector subtract(ExpVector var1);

    public abstract ExpVector scalarMultiply(long var1);

    public static final ExpVector EVSU(ExpVector expVector, int n, long l) {
        return expVector.subst(n, l);
    }

    public ExpVector subst(int n, long l) {
        ExpVector expVector = this.copy();
        expVector.setVal(n, l);
        return expVector;
    }

    public static final ExpVector EVRAND(int n, long l, float f) {
        return ExpVector.random(n, l, f, random);
    }

    public static final ExpVector EVRAND(int n, long l, float f, Random random) {
        return ExpVector.random(n, l, f, random);
    }

    public static final ExpVector random(int n, long l, float f) {
        return ExpVector.random(n, l, f, random);
    }

    public static final ExpVector random(int n, long l, float f, Random random) {
        long[] lArray = new long[n];
        for (int i = 0; i < lArray.length; ++i) {
            long l2;
            float f2 = random.nextFloat();
            if (f2 > f) {
                l2 = 0L;
            } else {
                l2 = random.nextLong() % l;
                if (l2 < 0L) {
                    l2 = -l2;
                }
            }
            lArray[i] = l2;
        }
        return ExpVector.create(lArray);
    }

    public static final int EVSIGN(ExpVector expVector) {
        return expVector.signum();
    }

    @Override
    public abstract int signum();

    public static final long EVTDEG(ExpVector expVector) {
        return expVector.totalDeg();
    }

    public long degree() {
        return this.totalDeg();
    }

    public abstract long totalDeg();

    public static final long EVMDEG(ExpVector expVector) {
        return expVector.maxDeg();
    }

    public abstract long maxDeg();

    public static final long EVMINDEG(ExpVector expVector) {
        return expVector.minDeg();
    }

    public abstract long minDeg();

    public static final long EVWDEG(long[][] lArray, ExpVector expVector) {
        return expVector.weightDeg(lArray);
    }

    public abstract long weightDeg(long[][] var1);

    public abstract long weightDeg(long[] var1);

    public static final ExpVector EVLCM(ExpVector expVector, ExpVector expVector2) {
        return expVector.lcm(expVector2);
    }

    public abstract ExpVector lcm(ExpVector var1);

    public static final ExpVector EVGCD(ExpVector expVector, ExpVector expVector2) {
        return expVector.gcd(expVector2);
    }

    public abstract ExpVector gcd(ExpVector var1);

    public static final int[] EVDOV(ExpVector expVector) {
        return expVector.dependencyOnVariables();
    }

    public abstract int dependentVariables();

    public abstract int[] dependencyOnVariables();

    public static final boolean EVMT(ExpVector expVector, ExpVector expVector2) {
        return expVector.multipleOf(expVector2);
    }

    public abstract boolean multipleOf(ExpVector var1);

    public boolean divides(ExpVector expVector) {
        return expVector.multipleOf(this);
    }

    @Override
    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    public static final int EVILCP(ExpVector expVector, ExpVector expVector2) {
        return expVector.invLexCompareTo(expVector2);
    }

    public abstract int invLexCompareTo(ExpVector var1);

    public static final int EVILCP(ExpVector expVector, ExpVector expVector2, int n, int n2) {
        return expVector.invLexCompareTo(expVector2, n, n2);
    }

    public abstract int invLexCompareTo(ExpVector var1, int var2, int var3);

    public static final int EVIGLC(ExpVector expVector, ExpVector expVector2) {
        return expVector.invGradCompareTo(expVector2);
    }

    public abstract int invGradCompareTo(ExpVector var1);

    public static final int EVIGLC(ExpVector expVector, ExpVector expVector2, int n, int n2) {
        return expVector.invGradCompareTo(expVector2, n, n2);
    }

    public abstract int invGradCompareTo(ExpVector var1, int var2, int var3);

    public static final int EVRILCP(ExpVector expVector, ExpVector expVector2) {
        return expVector.revInvLexCompareTo(expVector2);
    }

    public abstract int revInvLexCompareTo(ExpVector var1);

    public static final int EVRILCP(ExpVector expVector, ExpVector expVector2, int n, int n2) {
        return expVector.revInvLexCompareTo(expVector2, n, n2);
    }

    public abstract int revInvLexCompareTo(ExpVector var1, int var2, int var3);

    public static final int EVRIGLC(ExpVector expVector, ExpVector expVector2) {
        return expVector.revInvGradCompareTo(expVector2);
    }

    public abstract int revInvGradCompareTo(ExpVector var1);

    public static final int EVRIGLC(ExpVector expVector, ExpVector expVector2, int n, int n2) {
        return expVector.revInvGradCompareTo(expVector2, n, n2);
    }

    public abstract int revInvGradCompareTo(ExpVector var1, int var2, int var3);

    public static final int EVITDEGLC(ExpVector expVector, ExpVector expVector2) {
        return expVector.invTdegCompareTo(expVector2);
    }

    public abstract int invTdegCompareTo(ExpVector var1);

    public static final int EVRLITDEGC(ExpVector expVector, ExpVector expVector2) {
        return expVector.revLexInvTdegCompareTo(expVector2);
    }

    public abstract int revLexInvTdegCompareTo(ExpVector var1);

    public static final int EVIWLC(long[][] lArray, ExpVector expVector, ExpVector expVector2) {
        return expVector.invWeightCompareTo(lArray, expVector2);
    }

    public abstract int invWeightCompareTo(long[][] var1, ExpVector var2);

    public static final int EVIWLC(long[][] lArray, ExpVector expVector, ExpVector expVector2, int n, int n2) {
        return expVector.invWeightCompareTo(lArray, expVector2, n, n2);
    }

    public abstract int invWeightCompareTo(long[][] var1, ExpVector var2, int var3, int var4);

    public static enum StorUnit {
        LONG,
        INT,
        SHORT,
        BYTE;

    }
}

