/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.Multiply;
import edu.jas.poly.PolySpliterator;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.util.ListUtil;
import edu.jas.util.MapEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenPolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 5;
    int ll = 7;
    int el = 4;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenPolynomialTest.suite());
    }

    public GenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2);
        Element element = genPolynomialRing.getONE();
        element = genPolynomialRing.random(9);
        element = genPolynomialRing.getZERO();
        RingElem ringElem = new GenPolynomial<BigRational>(genPolynomialRing);
        GenPolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenPolynomial)element).equals(ringElem));
        GenPolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenPolynomial)element).equals(element));
        ringElem = (RingElem)ringElem.sum(element);
        GenPolynomialTest.assertTrue((String)"pe.isZERO() = ", (boolean)ringElem.isZERO());
        element = genPolynomialRing.random(9);
        element = ((GenPolynomial)element).subtract(element);
        GenPolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)((GenPolynomial)element).isZERO());
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing, 3);
        Element element2 = genPolynomialRing2.getONE();
        element2 = genPolynomialRing2.random(2);
        element2 = genPolynomialRing2.getZERO();
        RingElem ringElem2 = new GenPolynomial<BigRational>(genPolynomialRing2);
        GenPolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)((GenPolynomial)element2).equals(ringElem2));
        GenPolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)((GenPolynomial)element2).equals(element2));
        ringElem2 = (RingElem)ringElem2.sum(element2);
        GenPolynomialTest.assertTrue((String)"ppe.isZERO() = ", (boolean)ringElem2.isZERO());
        element2 = genPolynomialRing2.random(2);
        element2 = ((GenPolynomial)element2).subtract(element2);
        GenPolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)((GenPolynomial)element2).isZERO());
        GenPolynomialRing<BigRational> genPolynomialRing3 = new GenPolynomialRing<BigRational>(genPolynomialRing2, 4);
        Element element3 = genPolynomialRing3.getONE();
        element3 = genPolynomialRing3.random(2);
        element3 = genPolynomialRing3.getZERO();
        RingElem ringElem3 = new GenPolynomial<BigRational>(genPolynomialRing3);
        GenPolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)((GenPolynomial)element3).equals(ringElem3));
        GenPolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)((GenPolynomial)element3).equals(element3));
        ringElem3 = (RingElem)ringElem3.sum(element3);
        GenPolynomialTest.assertTrue((String)"pppe.isZERO() = ", (boolean)ringElem3.isZERO());
        element3 = genPolynomialRing3.random(2);
        element3 = ((GenPolynomial)element3).subtract(element3);
        GenPolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)((GenPolynomial)element3).isZERO());
    }

    public void testExtendContract() {
        BigRational bigRational = new BigRational(99L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        int n = this.rl;
        GenPolynomialRing<BigRational> genPolynomialRing2 = genPolynomialRing.extend(n);
        GenPolynomialRing<BigRational> genPolynomialRing3 = genPolynomialRing2.contract(n);
        GenPolynomialTest.assertEquals((String)"pf == pfec", genPolynomialRing, genPolynomialRing3);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomial.extend(genPolynomialRing2, 0, 0L);
        Map<ExpVector, GenPolynomial<BigRational>> map = genPolynomial2.contract(genPolynomialRing3);
        ArrayList<GenPolynomial<BigRational>> arrayList = new ArrayList<GenPolynomial<BigRational>>(map.values());
        GenPolynomial genPolynomial3 = (GenPolynomial)arrayList.get(0);
        GenPolynomialTest.assertEquals((String)"a == aec", genPolynomial, (Object)genPolynomial3);
    }

    public void testReverse() {
        BigRational bigRational = new BigRational(99L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialRing<BigRational> genPolynomialRing2 = genPolynomialRing.reverse();
        GenPolynomialRing<BigRational> genPolynomialRing3 = genPolynomialRing2.reverse();
        GenPolynomialTest.assertEquals((String)"pf == pfrr", genPolynomialRing, genPolynomialRing3);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomial.reverse(genPolynomialRing2);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomial2.reverse(genPolynomialRing3);
        GenPolynomialTest.assertEquals((String)"a == arr", genPolynomial, genPolynomial3);
    }

    public void testAccessors() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        Element element = genPolynomialRing.getONE();
        ExpVector expVector = ((GenPolynomial)element).leadingExpVector();
        BigRational bigRational2 = (BigRational)((GenPolynomial)element).leadingBaseCoefficient();
        AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem = new GenPolynomial<BigRational>(genPolynomialRing, bigRational2, expVector);
        GenPolynomialTest.assertEquals((String)"1 == 1 ", (Object)element, abelianGroupElem);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial = ((GenPolynomial)element).reductum();
        GenPolynomialTest.assertTrue((String)"red(1) == 0 ", (boolean)genPolynomial.isZERO());
        element = genPolynomialRing.getZERO();
        expVector = ((GenPolynomial)element).leadingExpVector();
        bigRational2 = (BigRational)((GenPolynomial)element).leadingBaseCoefficient();
        abelianGroupElem = new GenPolynomial<BigRational>(genPolynomialRing, bigRational2, expVector);
        GenPolynomialTest.assertEquals((String)"0 == 0 ", element, abelianGroupElem);
        genPolynomial = ((GenPolynomial)element).reductum();
        GenPolynomialTest.assertTrue((String)"red(0) == 0 ", (boolean)genPolynomial.isZERO());
        element = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        expVector = ((GenPolynomial)element).leadingExpVector();
        bigRational2 = (BigRational)((GenPolynomial)element).leadingBaseCoefficient();
        genPolynomial = ((GenPolynomial)element).reductum();
        abelianGroupElem = new GenPolynomial<BigRational>(genPolynomialRing, bigRational2, expVector);
        abelianGroupElem = genPolynomial.sum((GenPolynomial<BigRational>)abelianGroupElem);
        GenPolynomialTest.assertEquals((String)"p == lm(f)+red(f) ", element, abelianGroupElem);
        Element element2 = element;
        abelianGroupElem = genPolynomialRing.getZERO();
        while (!((GenPolynomial)element2).isZERO()) {
            expVector = ((GenPolynomial)element2).leadingExpVector();
            bigRational2 = (BigRational)((GenPolynomial)element2).leadingBaseCoefficient();
            genPolynomial = ((GenPolynomial)element2).reductum();
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum((GenPolynomial<Object>)((Object)bigRational2), expVector);
            element2 = genPolynomial;
        }
        GenPolynomialTest.assertEquals((String)"p == lm(f)+lm(red(f))+... ", element, abelianGroupElem);
    }

    public void testHomogeneous() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 2);
        Element<BigRational> element = genPolynomialRing.getONE();
        GenPolynomialTest.assertTrue((String)("1 is homogeneous " + (GenPolynomial)element), (boolean)((GenPolynomial)element).isHomogeneous());
        element = genPolynomialRing.getZERO();
        GenPolynomialTest.assertTrue((String)("0 is homogeneous " + (GenPolynomial)element), (boolean)((GenPolynomial)element).isHomogeneous());
        element = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomialTest.assertFalse((String)("rnd is homogeneous " + element), (boolean)((GenPolynomial)element).isHomogeneous());
        GenPolynomialRing<BigRational> genPolynomialRing2 = genPolynomialRing.extend(1);
        TermOrder termOrder = new TermOrder(4);
        genPolynomialRing2 = new GenPolynomialRing<BigRational>(genPolynomialRing2, termOrder);
        GenPolynomial<BigRational> genPolynomial = ((GenPolynomial)element).homogenize(genPolynomialRing2);
        GenPolynomialTest.assertTrue((String)("ph is homogeneous " + genPolynomial), (boolean)genPolynomial.isHomogeneous());
        GenPolynomial<BigRational> genPolynomial2 = genPolynomial.deHomogenize(genPolynomialRing);
        GenPolynomialTest.assertEquals((String)"phs == p ", genPolynomial2, element);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomialTest.assertFalse((String)("rnd is homogeneous " + genPolynomial3), (genPolynomial3.isHomogeneous() && !genPolynomial3.isConstant() ? 1 : 0) != 0);
        GenPolynomial<BigRational> genPolynomial4 = genPolynomial3.homogenize(genPolynomialRing2);
        GenPolynomialTest.assertTrue((String)("sh is homogeneous " + genPolynomial4), (boolean)genPolynomial4.isHomogeneous());
        GenPolynomial<BigRational> genPolynomial5 = genPolynomial4.deHomogenize(genPolynomialRing);
        GenPolynomialTest.assertEquals((String)"ss = s ", genPolynomial5, genPolynomial3);
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial6 = genPolynomial.multiply((BigRational)((Object)genPolynomial4));
        GenPolynomialTest.assertTrue((String)("th is homogeneous " + genPolynomial6), (boolean)genPolynomial6.isHomogeneous());
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial7 = ((GenPolynomial)element).multiply((BigRational)((Object)genPolynomial3));
        GenPolynomial<BigRational> genPolynomial8 = genPolynomial6.deHomogenize(genPolynomialRing);
        GenPolynomialTest.assertEquals((String)"ts = t ", genPolynomial8, genPolynomial7);
    }

    public void testWeightHomogeneous() {
        BigRational bigRational = new BigRational();
        long[] lArray = new long[]{2L, 3L, 4L, 5L};
        TermOrder termOrder = TermOrderByName.weightOrder(lArray);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 4, termOrder);
        Element element = genPolynomialRing.getONE();
        GenPolynomialTest.assertTrue((String)("1 is weight homogeneous " + (GenPolynomial)element), (boolean)((GenPolynomial)element).isWeightHomogeneous());
        element = genPolynomialRing.getZERO();
        GenPolynomialTest.assertTrue((String)("0 is weight homogeneous " + (GenPolynomial)element), (boolean)((GenPolynomial)element).isWeightHomogeneous());
        element = genPolynomialRing.random(this.kl, 3 * this.ll, this.el, this.q);
        GenPolynomialTest.assertFalse((String)("rnd is weight homogeneous " + element), (boolean)((GenPolynomial)element).isWeightHomogeneous());
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial = ((GenPolynomial)element).leadingWeightPolynomial();
        GenPolynomialTest.assertTrue((String)("lw(rnd) is weight homogeneous " + genPolynomial), (boolean)genPolynomial.isWeightHomogeneous());
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl, 3 * this.ll, this.el, this.q);
        GenPolynomialTest.assertFalse((String)("rnd is weight homogeneous " + genPolynomial2), (boolean)genPolynomial2.isWeightHomogeneous());
        GenPolynomial<BigRational> genPolynomial3 = genPolynomial2.leadingWeightPolynomial();
        GenPolynomialTest.assertTrue((String)("lw(rnd) is weight homogeneous " + genPolynomial3), (boolean)genPolynomial3.isWeightHomogeneous());
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial4 = genPolynomial.multiply(genPolynomial3);
        GenPolynomialTest.assertTrue((String)("lw(rnd)*lw(rnd) is weight homogeneous " + genPolynomial4), (boolean)genPolynomial4.isWeightHomogeneous());
    }

    public void testUnivariate() {
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.univariate(genPolynomialRing.nvar - 1);
        GenPolynomialTest.assertTrue((String)"deg(a) = 1: ", (genPolynomial.degree() == 1L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)genPolynomialRing.vars[0], (String)genPolynomial.toString());
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.univariate(genPolynomialRing.vars[0]);
        GenPolynomialTest.assertTrue((String)"deg(b) = 1: ", (genPolynomial2.degree() == 1L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)genPolynomialRing.vars[0], (String)genPolynomial2.toString());
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.univariate(0);
        GenPolynomialTest.assertTrue((String)"deg(c) = 1: ", (genPolynomial3.degree() == 1L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)genPolynomialRing.vars[genPolynomialRing.nvar - 1], (String)genPolynomial3.toString());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.univariate(genPolynomialRing.vars[genPolynomialRing.nvar - 1]);
        GenPolynomialTest.assertTrue((String)"deg(c) = 1: ", (genPolynomial3.degree() == 1L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)genPolynomialRing.vars[genPolynomialRing.nvar - 1], (String)genPolynomial4.toString());
        genPolynomial = genPolynomialRing.univariate(genPolynomialRing.nvar - 1, 7L);
        GenPolynomialTest.assertTrue((String)"deg(a) = 7: ", (genPolynomial.degree() == 7L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)(genPolynomialRing.vars[0] + "^7"), (String)genPolynomial.toString());
        genPolynomial2 = genPolynomialRing.univariate(genPolynomialRing.vars[0], 7L);
        GenPolynomialTest.assertTrue((String)"deg(b) = 7: ", (genPolynomial2.degree() == 7L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)(genPolynomialRing.vars[0] + "^7"), (String)genPolynomial2.toString());
        genPolynomial3 = genPolynomialRing.univariate(0, 7L);
        GenPolynomialTest.assertTrue((String)"deg(c) = 7: ", (genPolynomial3.degree() == 7L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)(genPolynomialRing.vars[genPolynomialRing.nvar - 1] + "^7"), (String)genPolynomial3.toString());
        genPolynomial4 = genPolynomialRing.univariate(genPolynomialRing.vars[genPolynomialRing.nvar - 1], 7L);
        GenPolynomialTest.assertTrue((String)"deg(c) = 7: ", (genPolynomial3.degree() == 7L ? 1 : 0) != 0);
        GenPolynomialTest.assertEquals((String)"xi == xi: ", (String)(genPolynomialRing.vars[genPolynomialRing.nvar - 1] + "^7"), (String)genPolynomial4.toString());
    }

    public void testIterators() {
        Object object;
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        Monomial monomial = new Monomial(((GenPolynomial)genPolynomialRing.getONE()).leadingMonomial());
        for (Monomial<BigInteger> object22 : genPolynomial) {
            GenPolynomialTest.assertFalse((String)"m.c == 0 ", (boolean)object22.coefficient().isZERO());
            GenPolynomialTest.assertFalse((String)"m.e < (0) ", (object22.exponent().signum() < 0 ? 1 : 0) != 0);
            if (!object22.exponent().isZERO()) {
                GenPolynomialTest.assertFalse((String)"m != 1: ", (boolean)object22.equals(monomial));
            }
            GenPolynomialTest.assertTrue((String)"#s >= 2*rl + 5: ", (((String)(object = object22.toString() + ",  " + object22.toScript())).length() >= 2 * this.rl + 5 ? 1 : 0) != 0);
        }
        Iterator iterator = genPolynomial.exponentIterator();
        while (iterator.hasNext()) {
            ExpVector expVector = (ExpVector)iterator.next();
            GenPolynomialTest.assertFalse((String)"e < (0) ", (expVector.signum() < 0 ? 1 : 0) != 0);
        }
        Iterator<BigInteger> iterator2 = genPolynomial.coefficientIterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            GenPolynomialTest.assertFalse((String)"i == 0 ", (boolean)((BigInteger)object).isZERO());
        }
    }

    public void testSpliterators() {
        BigInteger bigInteger = new BigInteger();
        BigInteger bigInteger2 = bigInteger.fromInteger(1L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, 22 * this.ll, this.el, this.q);
        ArrayList arrayList = new ArrayList();
        PolySpliterator polySpliterator = new PolySpliterator(genPolynomial.val);
        polySpliterator.forEachRemaining(monomial -> arrayList.add(((BigInteger)monomial.c).multiply(bigInteger2)));
        GenPolynomialTest.assertTrue((String)"#coeffs == size: ", (genPolynomial.val.size() == arrayList.size() ? 1 : 0) != 0);
        arrayList.clear();
        Spliterator<Monomial<BigInteger>> spliterator = genPolynomial.spliterator();
        Spliterator<Monomial<BigInteger>> spliterator2 = spliterator.trySplit();
        spliterator2.forEachRemaining(monomial -> arrayList.add(((BigInteger)monomial.c).multiply(bigInteger2)));
        spliterator.forEachRemaining(monomial -> arrayList.add(((BigInteger)monomial.c).multiply(bigInteger2)));
        GenPolynomialTest.assertTrue((String)"#coeffs == size: ", (genPolynomial.val.size() == arrayList.size() ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"coeffs == p.coefficients: ", (boolean)ListUtil.equals(arrayList, genPolynomial.val.values()));
    }

    void printCharacteristic(Spliterator spliterator) {
        for (int i = 0; i < 16384; ++i) {
            if (!spliterator.hasCharacteristics(i)) continue;
            System.out.println(String.format("char: %3x", i));
        }
    }

    public void testMap() {
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomial.map(new Multiply<BigInteger>(bigInteger.getONE()));
        GenPolynomialTest.assertEquals((String)"p == q ", genPolynomial, genPolynomial2);
        genPolynomial2 = genPolynomial.map(new Multiply<BigInteger>(bigInteger.getZERO()));
        GenPolynomialTest.assertTrue((String)("q == 0: " + genPolynomial2), (boolean)genPolynomial2.isZERO());
        genPolynomial2 = genPolynomial.map(new Multiply<BigInteger>(bigInteger.getONE().negate()));
        GenPolynomialTest.assertEquals((String)"p == q ", (Object)genPolynomial.negate(), genPolynomial2);
    }

    public void testStreams() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(32003L);
        ModInteger modInteger = modIntegerRing.fromInteger(-1L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, 222 * this.ll, 2 + this.el, this.q);
        long l = System.nanoTime();
        GenPolynomial<ModInteger> genPolynomial2 = genPolynomial.negate();
        l = System.nanoTime() - l;
        GenPolynomialTest.assertTrue((String)"time >= 0 ", (l >= 0L ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"p+q == 0 ", (boolean)genPolynomial.sum((ModInteger)((Object)genPolynomial2)).isZERO());
        long l2 = System.nanoTime();
        genPolynomial2 = genPolynomial.map(modInteger2 -> modInteger2.multiply(modInteger));
        l2 = System.nanoTime() - l2;
        GenPolynomialTest.assertTrue((String)"time >= 0 ", (l2 >= 0L ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"p+q == 0 ", (boolean)genPolynomial.sum((ModInteger)((Object)genPolynomial2)).isZERO());
        long l3 = System.nanoTime();
        genPolynomial2 = genPolynomial.mapOnStream(entry -> new MapEntry<ExpVector, ModInteger>((ExpVector)entry.getKey(), ((ModInteger)entry.getValue()).multiply(modInteger)), false);
        l3 = System.nanoTime() - l3;
        GenPolynomialTest.assertTrue((String)"time >= 0 ", (l3 >= 0L ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"p+q == 0 ", (boolean)genPolynomial.sum((ModInteger)((Object)genPolynomial2)).isZERO());
        long l4 = System.nanoTime();
        genPolynomial2 = genPolynomial.mapOnStream(entry -> new MapEntry<ExpVector, ModInteger>((ExpVector)entry.getKey(), ((ModInteger)entry.getValue()).multiply(modInteger)), true);
        l4 = System.nanoTime() - l4;
        GenPolynomialTest.assertTrue((String)"time >= 0 ", (l4 >= 0L ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"p+q == 0 ", (boolean)genPolynomial.sum((ModInteger)((Object)genPolynomial2)).isZERO());
        System.out.println("map time: neg, old, seq, par, = " + l + ", " + l2 + ", " + l3 + ", " + l4);
    }

    public void testBitLength() {
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 5);
        Element<GenPolynomial<BigInteger>> element = genPolynomialRing.getZERO();
        GenPolynomialTest.assertEquals((String)"blen(0) = 0", (long)0L, (long)((GenPolynomial)element).bitLength());
        element = genPolynomialRing.getONE();
        GenPolynomialTest.assertEquals((String)"blen(1) = 7", (long)7L, (long)((GenPolynomial)element).bitLength());
        element = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomialTest.assertTrue((String)"blen(random) >= 0", (0L <= ((GenPolynomial)element).bitLength() ? 1 : 0) != 0);
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, 2 * this.ll, this.el, this.q);
        GenPolynomialTest.assertTrue((String)"blen(random) >= 0", (0L <= genPolynomial.bitLength() ? 1 : 0) != 0);
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2 = ((GenPolynomial)element).sum(genPolynomial);
        GenPolynomialTest.assertTrue((String)"blen(random) >= 0", (0L <= genPolynomial2.bitLength() ? 1 : 0) != 0);
        GenPolynomialTest.assertTrue((String)"blen(random)+blen(random) >= blen(random+random)", (((GenPolynomial)element).bitLength() + genPolynomial.bitLength() >= genPolynomial2.bitLength() ? 1 : 0) != 0);
    }
}

